/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.cleanup;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.steps.cleanup.Cleaner;
import net.sf.okapi.steps.cleanup.Parameters;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CleanerUnitTest {
    private final LocaleId locFR = LocaleId.FRENCH;
    private GenericContent fmt;

    @Before
    public void setup() {
        this.fmt = new GenericContent();
    }

    @Test
    @Ignore
    public void testCleanUnit() {
        TextFragment srcTf1 = new TextFragment("\u201ct1, \u201d t2 ,\u201c\u2018t3 ,\u2019 t4 :\u201d");
        TextFragment srcTf2 = new TextFragment("t1 \u201ct2\u201d ; . 352");
        TextFragment srcTf3 = new TextFragment("t1 \u2018t2 \u2019 \u201c\u201ct3 ! \u201d\u201d");
        TextFragment frTf1 = new TextFragment("\u00ab\u00a0t1\u00a0\u00bb ,l\u2019t2,\u00ab\u00a0t3 , t4\u00a0\u00bb :");
        TextFragment frTf2 = new TextFragment("t1 \u00ab\u00a0 t2\u00bb;0, 352");
        TextFragment frTf3 = new TextFragment("t1 \u2018t2\u2019 \u00ab\u00a0t3\u00a0!\u00a0\u00bb");
        TextUnit tu = new TextUnit("tu1");
        TextContainer srcTc = tu.getSource();
        srcTc.append((TextPart)new Segment("seg1", srcTf1));
        srcTc.append(new TextPart(" "));
        srcTc.append((TextPart)new Segment("seg2", srcTf2));
        srcTc.append(new TextPart(" "));
        srcTc.append((TextPart)new Segment("seg3", srcTf3));
        TextContainer trgTc = tu.createTarget(this.locFR, true, 0);
        trgTc.append((TextPart)new Segment("seg1", frTf1));
        trgTc.append(new TextPart(" "));
        trgTc.append((TextPart)new Segment("seg2", frTf2));
        trgTc.append(new TextPart(" "));
        trgTc.append((TextPart)new Segment("seg3", frTf3));
        Cleaner cleaner = new Cleaner();
        for (Segment srcSeg : tu.getSourceSegments()) {
            Segment trgSeg = tu.getTargetSegment(this.locFR, srcSeg.getId(), false);
            Assert.assertNotNull((Object)trgSeg);
            cleaner.normalizeQuotation((ITextUnit)tu, srcSeg, this.locFR);
            cleaner.normalizePunctuation(srcSeg.text, trgSeg.text);
        }
        Assert.assertEquals((Object)"[\"t1,\" t2, \"'t3,' t4:\"]", (Object)this.fmt.printSegmentedContent(tu.getSource(), true, false));
        Assert.assertEquals((Object)"[\"t1,\" t2, \"'t3,' t4:\"] [t1 \"t2\"; .352] [t1 't2 ' \"\"t3!\"\"]", (Object)this.fmt.printSegmentedContent(tu.getSource(), true, false));
        Assert.assertEquals((Object)"[\"t1,\" t2, \"'t3,' t4:\"] [t1 \"t2\"; .352] [t1 't2 ' \"\"t3!\"\"]", (Object)this.fmt.printSegmentedContent(tu.getSource(), true, true));
        Assert.assertEquals((Object)"[\"t1\", l't2, \"t3, t4\":] [t1 \"t2\"; 0,352] [t1 't2' \"t3!\"]", (Object)this.fmt.printSegmentedContent(tu.getTarget(this.locFR), true, false));
        Assert.assertEquals((Object)"[\"t1\", l't2, \"t3, t4\":] [t1 \"t2\"; 0,352] [t1 't2' \"t3!\"]", (Object)this.fmt.printSegmentedContent(tu.getTarget(this.locFR), true, true));
    }

    @Test
    public void testWhiteSpaces() {
        TextFragment srcTf1 = new TextFragment("Hello,      World!   Too\t\tmany    spaces   here!");
        TextFragment trgTf1 = new TextFragment("\u00a1Hola,     Mundo!    \u00a1Demaciados    espacios     aqu\u00ed!");
        TextUnit tu = new TextUnit("tu1");
        TextContainer srcTc = tu.getSource();
        srcTc.append((TextPart)new Segment("seg1", srcTf1));
        TextContainer trgTc = tu.createTarget(LocaleId.SPANISH, true, 0);
        trgTc.append((TextPart)new Segment("seg1", trgTf1));
        new Cleaner().run((ITextUnit)tu, LocaleId.SPANISH);
        Assert.assertEquals((Object)"[Hello, World! Too many spaces here!]", (Object)this.fmt.printSegmentedContent(srcTc, true, false));
        Assert.assertEquals((Object)"[\u00a1Hola, Mundo! \u00a1Demaciados espacios aqu\u00ed!]", (Object)this.fmt.printSegmentedContent(trgTc, true, false));
    }

    @Test
    public void testPunctuations() {
        TextUnit tu = new TextUnit("tu1");
        TextContainer srcTc = tu.getSource();
        srcTc.append((TextPart)new Segment("seg1", new TextFragment("There should not be a space before   ; like this.")));
        srcTc.append(new TextPart(" "));
        srcTc.append((TextPart)new Segment("seg2", new TextFragment("There should not be a space before   , either.")));
        TextContainer trgTc = tu.createTarget(LocaleId.SPANISH, true, 0);
        trgTc.append((TextPart)new Segment("seg1", new TextFragment("No deber\u00eda haber un espacio antes de  ;  como este.")));
        trgTc.append(new TextPart(" "));
        trgTc.append((TextPart)new Segment("seg2", new TextFragment("Debe haber un espacio antes de ,  tampoco.")));
        Parameters params = new Parameters();
        params.setNormalizePunctuations(true);
        new Cleaner(params).run((ITextUnit)tu, LocaleId.SPANISH);
        Assert.assertEquals((Object)"[There should not be a space before; like this.] [There should not be a space before, either.]", (Object)this.fmt.printSegmentedContent(srcTc, true, false));
        Assert.assertEquals((Object)"[No deber\u00eda haber un espacio antes de; como este.] [Debe haber un espacio antes de, tampoco.]", (Object)this.fmt.printSegmentedContent(trgTc, true, false));
    }

    @Test
    public void testKeepCrNlIntactSimple() {
        TextUnit tu = new TextUnit("tu1");
        TextContainer srcTc = tu.getSource();
        srcTc.append((TextPart)new Segment("seg1", new TextFragment("old pond\t\nfrog leaps in   \nwater's   sound")));
        TextContainer trgTc = tu.createTarget(LocaleId.JAPANESE, true, 0);
        trgTc.append((TextPart)new Segment("seg1", new TextFragment("\u53e4\u6c60\u3084 \n\u86d9\u98db\u3073\u3053\u3080  \n\u6c34\u306e\u97f3")));
        Parameters params = new Parameters();
        params.setKeepCrNlIntact(true);
        new Cleaner(params).run((ITextUnit)tu, LocaleId.JAPANESE);
        Assert.assertEquals((Object)"[old pond \nfrog leaps in \nwater's sound]", (Object)this.fmt.printSegmentedContent(srcTc, true, false));
        Assert.assertEquals((Object)"[\u53e4\u6c60\u3084 \n\u86d9\u98db\u3073\u3053\u3080 \n\u6c34\u306e\u97f3]", (Object)this.fmt.printSegmentedContent(trgTc, true, false));
    }
}

