/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.cleanup;

import java.util.regex.PatternSyntaxException;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.steps.cleanup.Cleaner;
import net.sf.okapi.steps.cleanup.Parameters;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RegexTest {
    private final LocaleId locFR = LocaleId.FRENCH;
    private final LocaleId locDE = LocaleId.GERMAN;
    private GenericContent fmt;
    private Cleaner cleaner;
    private Parameters params;

    @Before
    public void setup() {
        this.params = new Parameters();
        this.params.setMatchUserRegex(true);
        this.fmt = new GenericContent();
        this.cleaner = new Cleaner(this.params);
    }

    @Test
    public void testSimpleUserRegex() {
        TextFragment srcTf = new TextFragment("t1 &amp;gt; t2.");
        TextFragment trgTf = new TextFragment("t1 &gt; t2. ");
        TextUnit tu = new TextUnit("tu1");
        TextContainer srcTc = tu.getSource();
        srcTc.append((TextPart)new Segment("seg1", srcTf));
        TextContainer trgTc = tu.createTarget(this.locFR, true, 0);
        trgTc.append((TextPart)new Segment("seg1", trgTf));
        this.params.setUserRegex("(?:(&(?:amp;)?[a-zA-Z]{2,4};))");
        if (!tu.isEmpty()) {
            ISegments srcSegs = tu.getSourceSegments();
            for (Segment srcSeg : srcSegs) {
                Segment trgSeg = tu.getTargetSegment(this.locFR, srcSeg.getId(), false);
                if (trgSeg == null) continue;
                this.cleaner.matchRegexExpressions((ITextUnit)tu, srcSeg, this.locFR);
            }
        }
        Assert.assertEquals((Object)"[t1 &amp;gt; t2.]", (Object)this.fmt.printSegmentedContent(tu.getSource(), true, false));
        Assert.assertEquals((Object)"[t1 &amp;gt; t2.]", (Object)this.fmt.printSegmentedContent(tu.getSource(), true, true));
        Assert.assertEquals((Object)"[]", (Object)this.fmt.printSegmentedContent(tu.getTarget(this.locFR), true, false));
        Assert.assertEquals((Object)"[]", (Object)this.fmt.printSegmentedContent(tu.getTarget(this.locFR), true, true));
    }

    @Test
    public void testSimpleFailUserRegex() {
        ExpectedException thrown = ExpectedException.none();
        TextFragment srcTf = new TextFragment("t1 &amp;gt; t2.");
        TextFragment trgTf = new TextFragment("t1 &gt; t2. ");
        TextUnit tu = new TextUnit("tu1");
        TextContainer srcTc = tu.getSource();
        srcTc.append((TextPart)new Segment("seg1", srcTf));
        TextContainer trgTc = tu.createTarget(this.locFR, true, 0);
        trgTc.append((TextPart)new Segment("seg1", trgTf));
        this.params.setUserRegex("(?:(&(?:amp;)?[a-zA-Z}{2,4};))");
        if (!tu.isEmpty()) {
            ISegments srcSegs = tu.getSourceSegments();
            for (Segment srcSeg : srcSegs) {
                Segment trgSeg = tu.getTargetSegment(this.locFR, srcSeg.getId(), false);
                if (trgSeg == null) continue;
                this.cleaner.matchRegexExpressions((ITextUnit)tu, srcSeg, this.locFR);
            }
        }
        thrown.expect(PatternSyntaxException.class);
        thrown.expectMessage("The following error occured");
    }
}

