/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.cleanup;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.steps.cleanup.Cleaner;
import net.sf.okapi.steps.cleanup.Parameters;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PruneTest {
    private final LocaleId locFR = LocaleId.FRENCH;
    private final LocaleId locDE = LocaleId.GERMAN;
    private GenericContent fmt;
    private Cleaner cleaner;

    @Before
    public void setup() {
        Parameters params = new Parameters();
        this.fmt = new GenericContent();
        this.cleaner = new Cleaner(params);
    }

    @Test
    public void simpleMarkTest() {
        int numDelete = 1;
        int num = 0;
        TextFragment srcTf1 = new TextFragment("t1 t2");
        TextFragment srcTf2 = new TextFragment("t3 t4");
        TextFragment srcTf3 = new TextFragment("t5 t6");
        TextFragment frTf1 = new TextFragment("t1 t2");
        TextFragment frTf2 = new TextFragment("t3 t4");
        TextFragment frTf3 = new TextFragment("t5 t6");
        TextUnit tu = new TextUnit("tu1");
        TextContainer srcTc = tu.getSource();
        srcTc.append((TextPart)new Segment("seg1", srcTf1));
        srcTc.append(new TextPart(" "));
        srcTc.append((TextPart)new Segment("seg2", srcTf2));
        srcTc.append(new TextPart(" "));
        srcTc.append((TextPart)new Segment("seg3", srcTf3));
        TextContainer frTc = tu.createTarget(this.locFR, true, 0);
        frTc.append((TextPart)new Segment("seg1", frTf1));
        frTc.append(new TextPart(" "));
        frTc.append((TextPart)new Segment("seg2", frTf2));
        frTc.append(new TextPart(" "));
        frTc.append((TextPart)new Segment("seg3", frTf3));
        if (!tu.isEmpty()) {
            ISegments srcSegs = tu.getSourceSegments();
            for (Segment srcSeg : srcSegs) {
                if (num >= numDelete) {
                    this.cleaner.markSegmentForRemoval((ITextUnit)tu, srcSeg, this.locFR);
                }
                ++num;
            }
        }
        Assert.assertEquals((Object)"[t1 t2] [] []", (Object)this.fmt.printSegmentedContent(tu.getTarget(this.locFR), true, false));
        Assert.assertEquals((Object)"[t1 t2] [] []", (Object)this.fmt.printSegmentedContent(tu.getTarget(this.locFR), true, true));
    }

    @Test
    public void simplePruneSegmentsTest() {
        int numDelete = 1;
        int num = 0;
        TextFragment srcTf1 = new TextFragment("s1 s2");
        TextFragment srcTf2 = new TextFragment("s3 s4");
        TextFragment srcTf3 = new TextFragment("s5 s6");
        TextFragment frTf1 = new TextFragment("t1 t2");
        TextFragment frTf2 = new TextFragment("t3 t4");
        TextFragment frTf3 = new TextFragment("t5 t6");
        TextUnit tu = new TextUnit("tu1");
        TextContainer srcTc = tu.getSource();
        srcTc.append((TextPart)new Segment("seg1", srcTf1));
        srcTc.append(new TextPart(" "));
        srcTc.append((TextPart)new Segment("seg2", srcTf2));
        srcTc.append(new TextPart(" "));
        srcTc.append((TextPart)new Segment("seg3", srcTf3));
        TextContainer frTc = tu.createTarget(this.locFR, true, 0);
        frTc.append((TextPart)new Segment("seg1", frTf1));
        frTc.append(new TextPart(" "));
        frTc.append((TextPart)new Segment("seg2", frTf2));
        frTc.append(new TextPart(" "));
        frTc.append((TextPart)new Segment("seg3", frTf3));
        if (!tu.isEmpty()) {
            ISegments srcSegs = tu.getSourceSegments();
            for (Segment srcSeg : srcSegs) {
                if (num >= numDelete) {
                    this.cleaner.markSegmentForRemoval((ITextUnit)tu, srcSeg, this.locFR);
                }
                ++num;
            }
        }
        Assert.assertEquals((Object)"[t1 t2] [] []", (Object)this.fmt.printSegmentedContent(tu.getTarget(this.locFR), true, false));
        Assert.assertEquals((Object)"[t1 t2] [] []", (Object)this.fmt.printSegmentedContent(tu.getTarget(this.locFR), true, true));
    }

    @Test
    public void simplePruneUnitTest() {
        int numDelete = 0;
        int num = 0;
        TextFragment srcTf1 = new TextFragment("s1 s2");
        TextFragment srcTf2 = new TextFragment("s3 s4");
        TextFragment srcTf3 = new TextFragment("s5 s6");
        TextFragment frTf1 = new TextFragment("t1 t2");
        TextFragment frTf2 = new TextFragment("t3 t4");
        TextFragment frTf3 = new TextFragment("t5 t6");
        TextUnit tu = new TextUnit("tu1");
        TextContainer srcTc = tu.getSource();
        srcTc.append((TextPart)new Segment("seg1", srcTf1));
        srcTc.append(new TextPart(" "));
        srcTc.append((TextPart)new Segment("seg2", srcTf2));
        srcTc.append(new TextPart(" "));
        srcTc.append((TextPart)new Segment("seg3", srcTf3));
        TextContainer frTc = tu.createTarget(this.locFR, true, 0);
        frTc.append((TextPart)new Segment("seg1", frTf1));
        frTc.append(new TextPart(" "));
        frTc.append((TextPart)new Segment("seg2", frTf2));
        frTc.append(new TextPart(" "));
        frTc.append((TextPart)new Segment("seg3", frTf3));
        if (!tu.isEmpty()) {
            ISegments srcSegs = tu.getSourceSegments();
            for (Segment srcSeg : srcSegs) {
                if (num >= numDelete) {
                    this.cleaner.markSegmentForRemoval((ITextUnit)tu, srcSeg, this.locFR);
                }
                ++num;
            }
        }
        Assert.assertEquals((Object)true, (Object)this.cleaner.run((ITextUnit)tu, this.locFR));
    }
}

