/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.cleanup;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.steps.cleanup.Cleaner;
import net.sf.okapi.steps.cleanup.Parameters;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CharacterTest {
    private final LocaleId locFR = LocaleId.FRENCH;
    private final LocaleId locDE = LocaleId.GERMAN;
    private GenericContent fmt;
    private Cleaner cleaner;
    private Parameters params;

    @Before
    public void setup() {
        this.params = new Parameters();
        this.params.setCheckCharacters(true);
        this.fmt = new GenericContent();
        this.cleaner = new Cleaner();
    }

    @Test
    public void testSimpleCharacter() {
        TextFragment srcTf = new TextFragment("This is some normal text");
        TextFragment trgTf = new TextFragment("\u00cb\u00fe\u00e1\u00fb\u00e5 \u00e4\u00e2\u00e8\u00e6\u00e5\u00ed\u00e8\u00ff");
        TextUnit tu = new TextUnit("tu1");
        TextContainer srcTc = tu.getSource();
        srcTc.append((TextPart)new Segment("seg1", srcTf));
        TextContainer trgTc = tu.createTarget(this.locFR, true, 0);
        trgTc.append((TextPart)new Segment("seg1", trgTf));
        if (!tu.isEmpty()) {
            ISegments srcSegs = tu.getSourceSegments();
            for (Segment srcSeg : srcSegs) {
                Segment trgSeg = tu.getTargetSegment(this.locFR, srcSeg.getId(), false);
                if (trgSeg == null) continue;
                this.cleaner.checkCharacters((ITextUnit)tu, srcSeg, this.locFR);
            }
        }
        Assert.assertEquals((Object)"[This is some normal text]", (Object)this.fmt.printSegmentedContent(tu.getSource(), true, false));
        Assert.assertEquals((Object)"[This is some normal text]", (Object)this.fmt.printSegmentedContent(tu.getSource(), true, true));
        Assert.assertEquals((Object)"[]", (Object)this.fmt.printSegmentedContent(tu.getTarget(this.locFR), true, false));
        Assert.assertEquals((Object)"[]", (Object)this.fmt.printSegmentedContent(tu.getTarget(this.locFR), true, true));
    }
}

