/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.bomconversion;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.bomconversion.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class BOMConversionStep
extends BasePipelineStep {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final byte[] BOM_UTF8 = new byte[]{-17, -69, -65};
    private final byte[] BOM_UTF16BE = new byte[]{-2, -1};
    private final byte[] BOM_UTF16LE = new byte[]{-1, -2};
    private Parameters params = new Parameters();
    private byte[] buffer;
    private URI outputURI;

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_URI)
    public void setOutputURI(URI outputURI) {
        this.outputURI = outputURI;
    }

    public String getDescription() {
        return "Add or remove Unicode Byte-Order-Mark (BOM) in a text-based file. Expects: raw document. Sends back: raw document.";
    }

    public String getName() {
        return "BOM Conversion";
    }

    public IParameters getParameters() {
        return this.params;
    }

    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    protected Event handleStartBatchItem(Event event) {
        this.buffer = new byte[2048];
        return event;
    }

    protected Event handleEndBatchItem(Event event) {
        this.buffer = null;
        return event;
    }

    protected Event handleRawDocument(Event event) {
        InputStream input = null;
        FileOutputStream output = null;
        try {
            File outFile;
            RawDocument rawDoc = event.getRawDocument();
            input = rawDoc.getStream();
            if (this.isLastOutputStep()) {
                outFile = rawDoc.createOutputFile(this.outputURI);
            } else {
                try {
                    outFile = File.createTempFile("~okapi-37_okp-bom_", ".tmp");
                }
                catch (Throwable e) {
                    throw new OkapiIOException("Cannot create temporary output.", e);
                }
            }
            output = new FileOutputStream(outFile);
            for (int i = 0; i < 5; ++i) {
                this.buffer[i] = 0;
            }
            int len = input.read(this.buffer, 0, 4);
            if (len != -1) {
                if (len == 0) {
                    if (!this.params.getRemoveBOM()) {
                        output.write(this.BOM_UTF8);
                    }
                } else {
                    int n = this.hasBOM(this.buffer, len);
                    if (n > 0) {
                        if (this.params.getRemoveBOM()) {
                            if (n == 3 || this.params.getAlsoNonUTF8()) {
                                output.write(this.buffer, n, len - n);
                            } else {
                                output.write(this.buffer, 0, len);
                            }
                        } else {
                            output.write(this.buffer, 0, len);
                        }
                    } else {
                        if (!this.params.getRemoveBOM()) {
                            String enc = rawDoc.getEncoding().toLowerCase();
                            if (enc.equals("utf-16") || enc.equals("utf-16le")) {
                                output.write(this.BOM_UTF16LE);
                                this.logger.info("Added UTF-16LE BOM");
                            } else if (enc.equals("utf-16be")) {
                                output.write(this.BOM_UTF16BE);
                                this.logger.info("Added UTF-16BE BOM");
                            } else if (enc.equals("utf-8")) {
                                output.write(this.BOM_UTF8);
                                this.logger.info("Added UTF-8 BOM");
                            } else {
                                this.logger.warn("Cannot add a BOM to a document in {}.", (Object)enc);
                            }
                        }
                        output.write(this.buffer, 0, len);
                    }
                }
            }
            while ((len = input.read(this.buffer)) > 0) {
                output.write(this.buffer, 0, len);
            }
            input.close();
            input = null;
            output.close();
            output = null;
            rawDoc.finalizeOutput();
            event.setResource((IResource)new RawDocument(outFile.toURI(), rawDoc.getEncoding(), rawDoc.getSourceLocale(), rawDoc.getTargetLocale()));
        }
        catch (IOException e) {
            throw new OkapiIOException("IO error while converting.", (Throwable)e);
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                    output = null;
                }
                if (input != null) {
                    input.close();
                    input = null;
                }
            }
            catch (IOException e) {
                throw new OkapiIOException("IO error while closing.", (Throwable)e);
            }
        }
        return event;
    }

    private int hasBOM(byte[] buffer, int length) {
        if (length > 1) {
            if (buffer[0] == -2 && buffer[1] == -1) {
                this.logger.info("UTF-16BE detected");
                return 2;
            }
            if (buffer[0] == -1 && buffer[1] == -2) {
                this.logger.info("UTF-16LE detected");
                return 2;
            }
            if (length > 2) {
                if (buffer[0] == -17 && buffer[1] == -69 && buffer[2] == -65) {
                    this.logger.info("UTF-8 detected");
                    return 3;
                }
                if (length > 3) {
                    if (buffer[0] == -1 && buffer[1] == -2 && buffer[2] == 0 && buffer[3] == 0) {
                        this.logger.info("UTF-32LE detected");
                        return 4;
                    }
                    if (buffer[0] == 0 && buffer[1] == 0 && buffer[2] == -2 && buffer[3] == -1) {
                        this.logger.info("UTF-32BE detected");
                        return 4;
                    }
                }
            }
        }
        return 0;
    }
}

