/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.bomconversion.ui;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.IContext;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.ISWTEmbeddableParametersEditor;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.steps.bomconversion.Parameters;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

@EditorFor(value=Parameters.class)
public class ParametersEditor
implements IParametersEditor,
ISWTEmbeddableParametersEditor {
    private Shell shell;
    private boolean result = false;
    private OKCancelPanel pnlActions;
    private Parameters params;
    private Button rdAdd;
    private Label stAdd;
    private Button rdRemove;
    private Label stRemove;
    private Button chkAlsoNonUTF8;
    private IHelp help;
    private Composite mainComposite;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean edit(IParameters params, boolean readOnly, IContext context) {
        boolean bRes = false;
        try {
            this.shell = null;
            this.help = (IHelp)context.getObject("help");
            this.params = (Parameters)params;
            this.shell = new Shell((Shell)context.getObject("shell"), 65648);
            this.create((Shell)context.getObject("shell"), readOnly);
            boolean bl = this.showDialog();
            return bl;
        }
        catch (Exception e) {
            Dialogs.showError((Shell)this.shell, (String)e.getLocalizedMessage(), null);
            bRes = false;
        }
        finally {
            if (this.shell != null) {
                this.shell.dispose();
            }
        }
        return bRes;
    }

    public IParameters createParameters() {
        return new Parameters();
    }

    public Composite getComposite() {
        return this.mainComposite;
    }

    public void initializeEmbeddableEditor(Composite parent, IParameters paramsObject, IContext context) {
        this.params = (Parameters)paramsObject;
        this.shell = (Shell)context.getObject("shell");
        this.createComposite(parent);
        this.setData();
    }

    public String validateAndSaveParameters() {
        if (!this.saveData()) {
            return null;
        }
        return this.params.toString();
    }

    private void create(Shell parent, boolean readOnly) {
        this.shell.setText("Byte-Order-Mark Conversion");
        if (parent != null) {
            UIUtil.inheritIcon((Shell)this.shell, (Shell)parent);
        }
        GridLayout layTmp = new GridLayout();
        layTmp.marginBottom = 0;
        layTmp.verticalSpacing = 0;
        this.shell.setLayout((Layout)layTmp);
        this.createComposite((Composite)this.shell);
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.result = false;
                if (e.widget.getData().equals("h")) {
                    if (ParametersEditor.this.help != null) {
                        ParametersEditor.this.help.showTopic((Object)this, "index");
                    }
                    return;
                }
                if (e.widget.getData().equals("o")) {
                    ParametersEditor.this.saveData();
                }
                ParametersEditor.this.shell.close();
            }
        };
        this.pnlActions = new OKCancelPanel((Composite)this.shell, 0, OKCancelActions, true);
        this.pnlActions.setLayoutData((Object)new GridData(768));
        this.pnlActions.btOK.setEnabled(!readOnly);
        if (!readOnly) {
            this.shell.setDefaultButton(this.pnlActions.btOK);
        }
        this.setData();
        this.shell.pack();
        this.shell.setMinimumSize(this.shell.getSize());
        Dialogs.centerWindow((Shell)this.shell, (Shell)parent);
    }

    private void createComposite(Composite parent) {
        this.mainComposite = new Composite(parent, 2048);
        this.mainComposite.setLayoutData((Object)new GridData(1808));
        this.mainComposite.setLayout((Layout)new GridLayout());
        Group group = new Group(this.mainComposite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setText("Action on the Byte-Order-Mark");
        group.setLayoutData((Object)new GridData(768));
        int indent = 16;
        this.rdRemove = new Button((Composite)group, 16);
        this.rdRemove.setText("Remove the Byte-Order-Mark if it is present");
        this.stRemove = new Label((Composite)group, 0);
        this.stRemove.setText("By default, only UTF-8 files with BOM are modified.");
        GridData gdTmp = new GridData();
        gdTmp.horizontalIndent = indent;
        this.stRemove.setLayoutData((Object)gdTmp);
        this.chkAlsoNonUTF8 = new Button((Composite)group, 32);
        this.chkAlsoNonUTF8.setText("Remove also UTF-16 BOMs (Not recommended)");
        gdTmp = new GridData();
        gdTmp.horizontalIndent = indent;
        this.chkAlsoNonUTF8.setLayoutData((Object)gdTmp);
        this.rdAdd = new Button((Composite)group, 16);
        this.rdAdd.setText("Add the Byte-Order-Mark if it is not already present");
        this.stAdd = new Label((Composite)group, 0);
        this.stAdd.setText("IMPORTANT: The input files without BOM are assumed to be in UTF-8 or UTF-16.");
        gdTmp = new GridData();
        gdTmp.horizontalIndent = indent;
        this.stAdd.setLayoutData((Object)gdTmp);
        this.rdRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.updateNotes();
            }
        });
        this.rdRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.updateNotes();
            }
        });
    }

    private void updateNotes() {
        this.stRemove.setEnabled(this.rdRemove.getSelection());
        this.stAdd.setEnabled(this.rdAdd.getSelection());
        this.chkAlsoNonUTF8.setEnabled(this.rdRemove.getSelection());
    }

    private boolean showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    private void setData() {
        this.rdRemove.setSelection(this.params.getRemoveBOM());
        this.rdAdd.setSelection(!this.rdRemove.getSelection());
        this.chkAlsoNonUTF8.setSelection(this.params.getAlsoNonUTF8());
        this.updateNotes();
    }

    private boolean saveData() {
        this.params.setRemoveBOM(this.rdRemove.getSelection());
        this.params.setAlsoNonUTF8(this.chkAlsoNonUTF8.getSelection());
        this.result = true;
        return this.result;
    }
}

