/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.languagetool;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.AbstractPart;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.PathInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String ENABLEFALSEFRIENDS = "enableFalseFriends";
    private static final String CHECKSOURCE = "checkSource";
    private static final String CHECKSPELLING = "checkSpelling";
    private static final String CHECKGRAMMAR = "checkGrammar";
    private static final String TERMCHECK = "termCheck";
    private static final String BLACKLISTCHECK = "blacklistCheck";
    private static final String TERMCHECKPATH = "termCheckPath";
    private static final String BLACKLISTCHECKPATH = "blacklistCheckPath";

    public void reset() {
        super.reset();
        this.setCheckSource(true);
        this.setEnableFalseFriends(true);
        this.setCheckSpelling(true);
        this.setCheckGrammar(true);
        this.setTermCheck(false);
        this.setBlacklistCheck(false);
        this.setTermCheckPath(null);
        this.setBlacklistCheckPath(null);
    }

    public boolean getCheckSource() {
        return this.getBoolean(CHECKSOURCE);
    }

    public void setCheckSource(boolean checkSource) {
        this.setBoolean(CHECKSOURCE, checkSource);
    }

    public boolean getEnableFalseFriends() {
        return this.getBoolean(ENABLEFALSEFRIENDS);
    }

    public void setEnableFalseFriends(boolean enableFalseFriends) {
        this.setBoolean(ENABLEFALSEFRIENDS, enableFalseFriends);
    }

    public boolean getCheckSpelling() {
        return this.getBoolean(CHECKSPELLING);
    }

    public void setCheckSpelling(boolean checkSpelling) {
        this.setBoolean(CHECKSPELLING, checkSpelling);
    }

    public boolean getCheckGrammar() {
        return this.getBoolean(CHECKGRAMMAR);
    }

    public void setCheckGrammar(boolean checkGrammer) {
        this.setBoolean(CHECKGRAMMAR, checkGrammer);
    }

    public boolean getTermCheck() {
        return this.getBoolean(TERMCHECK);
    }

    public void setTermCheck(boolean termCheck) {
        this.setBoolean(TERMCHECK, termCheck);
    }

    public boolean getBlacklistCheck() {
        return this.getBoolean(BLACKLISTCHECK);
    }

    public void setBlacklistCheck(boolean blacklistCheck) {
        this.setBoolean(BLACKLISTCHECK, blacklistCheck);
    }

    public String getBlacklistCheckPath() {
        return this.getString(BLACKLISTCHECKPATH);
    }

    public void setBlacklistCheckPath(String blacklistPath) {
        this.setString(BLACKLISTCHECKPATH, blacklistPath);
    }

    public String getTermCheckPath() {
        return this.getString(TERMCHECKPATH);
    }

    public void setTermCheckPath(String termPath) {
        this.setString(TERMCHECKPATH, termPath);
    }

    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription((Object)this);
        desc.add(CHECKSOURCE, "Check also the source text (in addition to the target)", null);
        desc.add(ENABLEFALSEFRIENDS, "Check for false friends", null);
        desc.add(CHECKSPELLING, "Check for spelling mistakes", null);
        desc.add(CHECKGRAMMAR, "Check for Grammar/Style mistakes", null);
        desc.add(TERMCHECK, "Check for term consistency errors", null);
        desc.add(BLACKLISTCHECK, "Check for black listed terms", null);
        desc.add(TERMCHECKPATH, "Path to terminology file (tbx|csv|tsv)", null);
        desc.add(BLACKLISTCHECKPATH, "Path to black list file", null);
        return desc;
    }

    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("LanguageTool", true, false);
        desc.addTextLabelPart("Spelling/Grammar Checks");
        desc.addCheckboxPart(paramDesc.get(CHECKSOURCE));
        desc.addCheckboxPart(paramDesc.get(ENABLEFALSEFRIENDS));
        desc.addCheckboxPart(paramDesc.get(CHECKSPELLING));
        desc.addCheckboxPart(paramDesc.get(CHECKGRAMMAR));
        desc.addSeparatorPart();
        desc.addTextLabelPart("Terminology Checks");
        CheckboxPart cb = desc.addCheckboxPart(paramDesc.get(TERMCHECK));
        PathInputPart p = desc.addPathInputPart(paramDesc.get(TERMCHECKPATH), "Select Terminology File...", false);
        p.setAllowEmpty(true);
        p.setBrowseFilters("TBX (*.tbx)\tTable (*.csv;*.tsv)\tAll Files (*.*)", "*.tbx\t*.csv;*.tsv\t*.*");
        p.setMasterPart((AbstractPart)cb, true);
        cb = desc.addCheckboxPart(paramDesc.get(BLACKLISTCHECK));
        p = desc.addPathInputPart(paramDesc.get(BLACKLISTCHECKPATH), "Select Black List File...", false);
        p.setAllowEmpty(true);
        p.setBrowseFilters("Tab Delimited (*.tsv;*.txt)\tAll Files (*.*)", "*.tsv;*.txt\t*.*");
        p.setMasterPart((AbstractPart)cb, true);
        return desc;
    }
}

