/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.languagetool;

import java.io.IOException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.steps.languagetool.LanguageTool;
import net.sf.okapi.steps.languagetool.Parameters;

@UsingParameters(value=Parameters.class)
public class LanguageToolStep
extends BasePipelineStep {
    private Parameters params = new Parameters();
    private LanguageTool langTool;
    private LocaleId sourceLocale;
    private LocaleId targetLocale;

    public String getName() {
        return "LanguageTool";
    }

    public String getDescription() {
        return "Invokes the LanguageTool checker to verify style, grammar, spelling or bilingual terminology errors. Expects: filter events. Sends back: filter events.";
    }

    public IParameters getParameters() {
        return this.params;
    }

    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourceLocale(LocaleId sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    protected Event handleTextUnit(Event event) {
        if (this.langTool == null || !this.langTool.isInitialized()) {
            try {
                this.langTool = new LanguageTool(this.params, this.sourceLocale, this.targetLocale);
            }
            catch (IOException e) {
                throw new OkapiIOException("Error creating LanguageTool rules.", (Throwable)e);
            }
        }
        ITextUnit tu = event.getTextUnit();
        this.langTool.run(tu);
        return event;
    }

    public void destroy() {
        if (this.langTool != null) {
            this.langTool.shutDown();
        }
    }

    public void setLanguageTool(LanguageTool lt) {
        this.langTool = lt;
    }
}

