/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.languagetool;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.ITSLQIAnnotations;
import net.sf.okapi.common.annotation.IssueAnnotation;
import net.sf.okapi.common.annotation.IssueType;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.lib.languagetool.LanguageToolUtil;
import net.sf.okapi.lib.languagetool.rules.AbstractLanguageToolRuleGenerator;
import net.sf.okapi.lib.languagetool.rules.BlackListRule;
import net.sf.okapi.lib.languagetool.rules.Blacklist2BlacklistRules;
import net.sf.okapi.lib.languagetool.rules.ConceptEntry2TermCheckRules;
import net.sf.okapi.lib.languagetool.rules.TermCheckRule;
import net.sf.okapi.lib.terminology.ConceptEntry;
import net.sf.okapi.lib.terminology.IGlossaryReader;
import net.sf.okapi.lib.terminology.csv.CSVReader;
import net.sf.okapi.lib.terminology.tbx.TBXReader;
import net.sf.okapi.lib.terminology.tsv.TSVReader;
import net.sf.okapi.lib.verification.BlackTerm;
import net.sf.okapi.lib.verification.BlacklistReader;
import net.sf.okapi.steps.languagetool.Parameters;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.MultiThreadedJLanguageTool;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.bitext.BitextRule;
import org.languagetool.tools.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanguageTool {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final Parameters params;
    private final LocaleId srcLoc;
    private final LocaleId trgLoc;
    private MultiThreadedJLanguageTool srcLt;
    private MultiThreadedJLanguageTool trgLt;
    private List<BitextRule> bitextRules;
    private List<Rule> nonBitextRules;
    private List<TermCheckRule> termCheckRules;
    private List<BlackListRule> blackListRules;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LanguageTool(Parameters params, LocaleId sourceLocale, LocaleId targetLocale) throws IOException {
        BlacklistReader reader;
        File file;
        AbstractLanguageToolRuleGenerator converter;
        this.params = params == null ? new Parameters() : params;
        this.bitextRules = new ArrayList<BitextRule>();
        this.srcLoc = sourceLocale;
        this.trgLoc = targetLocale;
        this.srcLt = this.startInstance(sourceLocale);
        this.trgLt = this.startInstance(this.trgLoc);
        this.termCheckRules = new ArrayList<TermCheckRule>();
        this.blackListRules = new ArrayList<BlackListRule>();
        try {
            this.bitextRules = Tools.getBitextRules((Language)this.srcLt.getLanguage(), (Language)this.trgLt.getLanguage());
        }
        catch (Throwable e) {
            this.LOGGER.warn("Cannot load bi-text rules ({}).\nNo bi-lingual rules for the target will be checked.", (Object)e.getMessage());
        }
        this.nonBitextRules = this.trgLt.getAllRules();
        for (Rule rule : this.nonBitextRules) {
            if (!this.params.getCheckSpelling() && rule.isDictionaryBasedSpellingRule()) {
                rule.setDefaultOff();
            }
            if (this.params.getCheckGrammar() || rule.isDictionaryBasedSpellingRule()) continue;
            rule.setDefaultOff();
        }
        if (!Util.isEmpty((String)this.params.getTermCheckPath())) {
            converter = new ConceptEntry2TermCheckRules(this.srcLoc, this.trgLoc);
            file = new File(this.params.getTermCheckPath());
            reader = this.createGloassaryReader(file, this.srcLoc, this.trgLoc);
            try {
                reader.open(file);
                this.termCheckRules = ((ConceptEntry2TermCheckRules)converter).convert((IGlossaryReader)reader);
            }
            finally {
                reader.close();
            }
        }
        if (!Util.isEmpty((String)this.params.getBlacklistCheckPath())) {
            converter = new Blacklist2BlacklistRules(this.trgLoc);
            file = new File(this.params.getBlacklistCheckPath());
            reader = new BlacklistReader();
            try {
                reader.open(file);
                this.blackListRules = ((Blacklist2BlacklistRules)converter).convert(reader);
            }
            finally {
                reader.close();
            }
        }
        this.LOGGER.debug("LT Languages available: " + Languages.get().toString());
    }

    public LanguageTool(Parameters params, LocaleId sourceLocale, LocaleId targetLocale, List<ConceptEntry> terms, List<BlackTerm> blackTerms) throws IOException {
        this(params, sourceLocale, targetLocale);
        this.setTerms(terms, blackTerms);
    }

    public void setTerms(List<ConceptEntry> terms, List<BlackTerm> blackTerms) throws IOException {
        this.termCheckRules = new ConceptEntry2TermCheckRules(this.srcLoc, this.trgLoc).convert(terms);
        this.blackListRules = new Blacklist2BlacklistRules(this.trgLoc).convert(blackTerms);
    }

    public boolean isInitialized() {
        return this.srcLt != null && this.trgLt != null;
    }

    public void shutDown() {
        if (this.srcLt != null) {
            this.srcLt.shutdown();
            this.srcLt = null;
        }
        if (this.trgLt != null) {
            this.trgLt.shutdown();
            this.trgLt = null;
        }
    }

    private MultiThreadedJLanguageTool startInstance(LocaleId locId) {
        try {
            MultiThreadedJLanguageTool lt = new MultiThreadedJLanguageTool(LanguageToolUtil.getCachedLanguage(locId), 2);
            this.LOGGER.warn("Using LT language '{}' ('{}') for locale '{}'", new Object[]{lt.getLanguage().getShortCodeWithCountryAndVariant(), lt.getLanguage().getName(), locId.toString()});
            return lt;
        }
        catch (Throwable e) {
            throw new OkapiIOException("Cannot create or initialize the LanguageTool object.\n" + e.getMessage());
        }
    }

    public void run(ITextUnit tu) {
        if (!tu.isTranslatable()) {
            return;
        }
        if (tu.isEmpty()) {
            return;
        }
        try {
            TextContainer srcTc = tu.getSource();
            TextContainer trgTc = tu.getTarget(this.trgLoc);
            ISegments srcSegs = srcTc.getSegments();
            ISegments trgSegs = null;
            if (trgTc != null) {
                trgSegs = trgTc.getSegments();
            }
            List srcMatches = null;
            List<RuleMatch> trgMatches = null;
            for (Segment srcSeg : srcSegs) {
                Segment trgSeg;
                TextFragment srcTf = null;
                TextFragment trgTf = null;
                if (trgSegs != null && (trgSeg = trgSegs.get(srcSeg.getId())) != null && !trgSeg.text.isEmpty()) {
                    trgTf = trgSeg.getContent();
                    trgMatches = this.check(srcSeg.getContent().getText(), trgTf.getText());
                }
                if (this.params.getCheckSource() && srcSeg != null && !srcSeg.text.isEmpty()) {
                    srcTf = srcSeg.getContent();
                    srcMatches = this.srcLt.check(srcTf.getText(), true, JLanguageTool.ParagraphHandling.ONLYNONPARA);
                }
                if (trgMatches != null) {
                    for (RuleMatch match : trgMatches) {
                        ITSLQIAnnotations.addAnnotations((TextContainer)trgTc, (GenericAnnotation)this.createAnnotation(match, trgTf, true, srcSeg.getId()));
                    }
                }
                if (srcMatches == null) continue;
                for (RuleMatch match : srcMatches) {
                    ITSLQIAnnotations.addAnnotations((TextContainer)srcTc, (GenericAnnotation)this.createAnnotation(match, srcTf, false, srcSeg.getId()));
                }
            }
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error while checking. " + e.getMessage());
        }
    }

    private List<RuleMatch> check(String src, String trg) throws IOException {
        AnalyzedSentence srcText = this.srcLt.getAnalyzedSentence(src);
        AnalyzedSentence trgText = this.trgLt.getAnalyzedSentence(trg);
        LinkedList<RuleMatch> ruleMatches = new LinkedList<RuleMatch>();
        if (this.params.getCheckSpelling() || this.params.getCheckGrammar()) {
            ruleMatches.addAll(this.trgLt.check(trg, true, JLanguageTool.ParagraphHandling.ONLYNONPARA));
        }
        ruleMatches.addAll(this.applyBiTextRules(srcText, trgText, trg));
        if (this.params.getTermCheck()) {
            ruleMatches.addAll(this.applyTermCheckRules(srcText, trgText, trg));
        }
        if (this.params.getBlacklistCheck()) {
            ruleMatches.addAll(this.applyBlacklistRules(trgText, trg));
        }
        return ruleMatches;
    }

    private List<RuleMatch> applyBiTextRules(AnalyzedSentence srcText, AnalyzedSentence trgText, String trg) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        for (BitextRule bRule : this.bitextRules) {
            RuleMatch[] curMatch;
            if (bRule.getLocQualityIssueType() == ITSIssueType.Length || bRule.getLocQualityIssueType() == ITSIssueType.Untranslated || (curMatch = bRule.match(srcText, trgText)) == null || curMatch.length <= 0) continue;
            for (RuleMatch match : curMatch) {
                ruleMatches.add(match);
            }
        }
        return ruleMatches;
    }

    private IGlossaryReader createGloassaryReader(File file, LocaleId srcLoc, LocaleId trgLoc) {
        String ext = Util.getExtension((String)file.getPath());
        if (ext.equalsIgnoreCase(".tbx")) {
            return new TBXReader();
        }
        if (ext.equalsIgnoreCase(".csv")) {
            return new CSVReader(srcLoc, trgLoc);
        }
        return new TSVReader(srcLoc, trgLoc);
    }

    private List<RuleMatch> applyTermCheckRules(AnalyzedSentence srcText, AnalyzedSentence trgText, String trg) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        for (TermCheckRule tcr : this.termCheckRules) {
            RuleMatch[] curMatch = tcr.match(srcText, trgText);
            if (curMatch == null || curMatch.length <= 0) continue;
            for (RuleMatch match : curMatch) {
                ruleMatches.add(match);
            }
        }
        return ruleMatches;
    }

    private List<RuleMatch> applyBlacklistRules(AnalyzedSentence trgText, String trg) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        for (BlackListRule blr : this.blackListRules) {
            RuleMatch[] curMatch = blr.match(trgText);
            if (curMatch == null || curMatch.length <= 0) continue;
            for (RuleMatch match : curMatch) {
                ruleMatches.add(match);
            }
        }
        return ruleMatches;
    }

    private GenericAnnotation createAnnotation(RuleMatch match, TextFragment tf, boolean onTarget, String segId) {
        List suggs;
        if (!tf.hasText()) {
            return null;
        }
        Object msg = match.getMessage();
        if (((String)msg).indexOf(38) > -1) {
            msg = ((String)msg).replace("&lt;suggestion>", "\"");
            msg = ((String)msg).replace("&lt;/suggestion>", "\"");
            msg = ((String)msg).replace("&amp;", "&");
        }
        if (((String)msg).indexOf("<suggestion>") > -1) {
            msg = ((String)msg).replace("<suggestion>", "\"");
            msg = ((String)msg).replace("</suggestion>", "\"");
            msg = ((String)msg).replace("&amp;", "&");
        }
        if (!Util.isEmpty((List)(suggs = match.getSuggestedReplacements()))) {
            StringBuilder sb = new StringBuilder(" [Suggestions: ");
            boolean first = true;
            for (String sugg : suggs) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append("\"" + sugg + "\"");
            }
            sb.append("]");
            msg = (String)msg + sb.toString();
        }
        IssueAnnotation ia = new IssueAnnotation(IssueType.LANGUAGETOOL_ERROR, (String)msg, 2.0, segId, onTarget ? -1 : match.getFromPos(), onTarget ? -1 : match.getToPos(), onTarget ? match.getFromPos() : -1, onTarget ? match.getToPos() : -1, null);
        ia.setITSType(match.getRule().getLocQualityIssueType().toString());
        return ia;
    }
}

