/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.lib.languagetool.LanguageToolUtil;
import net.sf.okapi.lib.languagetool.rules.AbstractLanguageToolRuleGenerator;
import net.sf.okapi.lib.languagetool.rules.TermCheckRule;
import net.sf.okapi.lib.terminology.ConceptEntry;
import net.sf.okapi.lib.terminology.IGlossaryReader;
import net.sf.okapi.lib.terminology.LangEntry;
import org.languagetool.Language;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternToken;

public class ConceptEntry2TermCheckRules
extends AbstractLanguageToolRuleGenerator {
    private static final String DESCRIPTION = "Term Consistency Check";
    private static final String MESSAGE = "The source term \"%s\" is not translated with the recommended target term. <suggestion>%s</suggestion>";
    private static final String SHORT_MESSAGE = "Check Term Translation";
    private LocaleId srcLocale;
    private LocaleId trgLocale;
    private Language srcLang;
    private Language trgLang;
    private List<TermCheckRule> rules;

    public ConceptEntry2TermCheckRules(LocaleId srcLocale, LocaleId trgLocale) {
        this.srcLocale = srcLocale;
        this.trgLocale = trgLocale;
        this.srcLang = LanguageToolUtil.getCachedLanguage(srcLocale);
        this.trgLang = LanguageToolUtil.getCachedLanguage(trgLocale);
        this.rules = new ArrayList<TermCheckRule>();
    }

    public List<TermCheckRule> convert(List<ConceptEntry> concepts) throws IOException {
        if (concepts == null) {
            throw new OkapiException("ConceptEntry list is null.");
        }
        this.rules.clear();
        for (ConceptEntry ce : concepts) {
            this.addRule(ce, this.srcLocale, this.trgLocale);
        }
        return this.rules;
    }

    public List<TermCheckRule> convert(IGlossaryReader reader) throws IOException {
        if (reader == null) {
            throw new OkapiException("Glossary Reader is null.");
        }
        this.rules.clear();
        try {
            while (reader.hasNext()) {
                ConceptEntry ce = reader.next();
                this.addRule(ce, this.srcLocale, this.trgLocale);
            }
        }
        finally {
            reader.close();
        }
        return this.rules;
    }

    private void addRule(ConceptEntry ce, LocaleId srcLocale, LocaleId trgLocale) throws IOException {
        if (ce.hasLocale(srcLocale) && ce.hasLocale(trgLocale)) {
            LangEntry srcLent = ce.getEntries(srcLocale);
            LangEntry trgLent = ce.getEntries(trgLocale);
            if (srcLent.hasTerm() && trgLent.hasTerm()) {
                this.rules.add(this.convertToBitextPatternRule(srcLent.getTerm(0).getText(), trgLent.getTerm(0).getText()));
            }
        }
    }

    private TermCheckRule convertToBitextPatternRule(String srcTerm, String trgTerm) throws IOException {
        List<PatternToken> srcTokens = this.getPatternTokens(srcTerm, this.srcLang);
        List<PatternToken> trgTokens = this.getPatternTokens(trgTerm, this.trgLang);
        PatternRule srcPattern = new PatternRule(srcTerm, this.srcLang, srcTokens, DESCRIPTION, String.format(MESSAGE, srcTerm, trgTerm), SHORT_MESSAGE);
        srcPattern.setLocQualityIssueType(ITSIssueType.Terminology);
        PatternRule trgPattern = new PatternRule(trgTerm, this.trgLang, trgTokens, DESCRIPTION, String.format(MESSAGE, srcTerm, trgTerm), SHORT_MESSAGE);
        TermCheckRule r = new TermCheckRule(srcPattern, trgPattern);
        r.setLocQualityIssueType(ITSIssueType.Terminology);
        return r;
    }

    public Language getSrcLang() {
        return this.srcLang;
    }

    public Language getTrgLang() {
        return this.trgLang;
    }
}

