/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.lib.languagetool.LanguageToolUtil;
import net.sf.okapi.lib.languagetool.rules.AbstractLanguageToolRuleGenerator;
import net.sf.okapi.lib.languagetool.rules.BlackListRule;
import net.sf.okapi.lib.verification.BlackTerm;
import net.sf.okapi.lib.verification.BlacklistReader;
import org.languagetool.Language;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternToken;

public class Blacklist2BlacklistRules
extends AbstractLanguageToolRuleGenerator {
    private static final String DESCRIPTION = "Target Blackterm Check";
    private static final String MESSAGE = "Target contains a blackterm: \"%s\".%s";
    private static final String SHORT_MESSAGE = "Blackterm Check";
    private Language trgLang;
    private List<BlackListRule> rules;

    public Blacklist2BlacklistRules(LocaleId trgLocale) {
        this.trgLang = LanguageToolUtil.getCachedLanguage(trgLocale);
        this.rules = new ArrayList<BlackListRule>();
    }

    public List<BlackListRule> convert(List<BlackTerm> blackTerms) throws IOException {
        if (blackTerms == null) {
            throw new OkapiException("BlackTerm list is null.");
        }
        this.rules.clear();
        for (BlackTerm bt : blackTerms) {
            this.rules.add(this.convertToBitextPatternRule(bt.text, bt.suggestion));
        }
        return this.rules;
    }

    public List<BlackListRule> convert(BlacklistReader reader) throws IOException {
        if (reader == null) {
            throw new OkapiException("Blacklist Reader is null.");
        }
        this.rules.clear();
        try {
            while (reader.hasNext()) {
                BlackTerm bt = reader.next();
                this.rules.add(this.convertToBitextPatternRule(bt.text, bt.suggestion));
            }
        }
        finally {
            reader.close();
        }
        return this.rules;
    }

    private BlackListRule convertToBitextPatternRule(String blackTerm, String suggestion) throws IOException {
        List<PatternToken> trgTokens = this.getPatternTokens(blackTerm, this.trgLang);
        PatternRule trgPattern = new PatternRule(blackTerm, this.trgLang, trgTokens, DESCRIPTION, String.format(MESSAGE, blackTerm, Util.isEmpty((String)suggestion) ? "" : String.format(" A suggested replacement is: <suggestion>%s</suggestion>", suggestion)), SHORT_MESSAGE);
        BlackListRule r = new BlackListRule(trgPattern, SHORT_MESSAGE);
        r.setLocQualityIssueType(ITSIssueType.Terminology);
        return r;
    }

    public Language getTrgLang() {
        return this.trgLang;
    }
}

