/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.lib.languagetool.LanguageToolUtil;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.patterns.PatternToken;

public abstract class AbstractLanguageToolRuleGenerator {
    protected List<PatternToken> getPatternTokens(String term, Language lang) throws IOException {
        ArrayList<PatternToken> patterns = new ArrayList<PatternToken>();
        List<AnalyzedTokenReadings> tokens = LanguageToolUtil.tokenize(term, lang);
        for (AnalyzedTokenReadings readings : tokens) {
            if (readings.isWhitespace() || readings.isLinebreak() || readings.isSentenceEnd() || readings.isSentenceStart()) continue;
            if (readings.hasSameLemmas()) {
                patterns.add(this.createPatternToken((AnalyzedToken)readings.getReadings().get(0)));
                continue;
            }
            PatternToken pt = new PatternToken(readings.getToken(), false, false, false);
            pt.setPhraseName("term");
            patterns.add(pt);
        }
        return patterns;
    }

    protected PatternToken createPatternToken(AnalyzedToken at) {
        boolean isLemma = true;
        String lemmaOrToken = at.getLemma();
        if (at.getLemma() == null) {
            isLemma = false;
            lemmaOrToken = at.getToken();
        }
        PatternToken pt = new PatternToken(lemmaOrToken, false, false, isLemma);
        pt.setPhraseName("term");
        return pt;
    }
}

