/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.languagetool;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.lib.languagetool.DefaultLanguage;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.language.AmericanEnglish;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanguageToolUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(LanguageToolUtil.class);
    private static ConcurrentMap<String, Language> languageCache = new ConcurrentHashMap<String, Language>();

    public static Language getCachedLanguage(LocaleId locale) {
        Language language = (Language)languageCache.get(locale.toBCP47());
        if (language == null) {
            language = LanguageToolUtil.getLanguage(locale);
            Language race = languageCache.putIfAbsent(locale.toBCP47(), language);
            if (race != null) {
                if (language instanceof Closeable) {
                    try {
                        ((Closeable)language).close();
                        language = null;
                    }
                    catch (Exception e) {
                        LOGGER.error("Language couldn't be closed. Possible memory leak.", (Object)locale.toBCP47(), (Object)e);
                    }
                }
                return race;
            }
        }
        LOGGER.debug("LanguageTool Language cache hit for {}", (Object)locale.toBCP47());
        return language;
    }

    public static final Language getLanguage(LocaleId locale) {
        if (locale == LocaleId.ENGLISH) {
            return new AmericanEnglish();
        }
        if (Languages.isLanguageSupported((String)locale.toBCP47())) {
            return Languages.getLanguageForLocale((Locale)locale.toJavaLocale());
        }
        if (Languages.isLanguageSupported((String)locale.getLanguage())) {
            return Languages.getLanguageForLocale((Locale)Locale.forLanguageTag(locale.getLanguage()));
        }
        return new DefaultLanguage();
    }

    public static final List<AnalyzedTokenReadings> tokenize(String text, Language lang) throws IOException {
        List tokens = lang.getWordTokenizer().tokenize(text);
        List aTokens = lang.getTagger().tag(tokens);
        return aTokens;
    }
}

