/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.languagetool;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Locale;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.ITSLQIAnnotations;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.steps.languagetool.LanguageTool;
import net.sf.okapi.steps.languagetool.Parameters;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.languagetool.Languages;

@RunWith(value=JUnit4.class)
public class LanguageToolTest {
    private LanguageTool lt;
    private final LocaleId srcLoc = new LocaleId("en", "us");
    private final LocaleId trgLoc = new LocaleId("fr", "fr");

    @Before
    public void setUp() throws IOException {
        this.lt = new LanguageTool(null, this.srcLoc, this.trgLoc);
    }

    @After
    public void tearDown() {
        this.lt.shutDown();
    }

    @Test
    public void simpleTest1() {
        TextUnit tu = new TextUnit("id", "original teext");
        tu.setTargetContent(this.trgLoc, new TextFragment("texte original"));
        this.lt.run((ITextUnit)tu);
        ITSLQIAnnotations anns = (ITSLQIAnnotations)tu.getSource().getAnnotation(ITSLQIAnnotations.class);
        Assert.assertNotNull((Object)anns);
        Assert.assertEquals((long)1L, (long)anns.getAllAnnotations().size());
        Assert.assertEquals((Object)"misspelling", (Object)anns.getFirstAnnotation("its-lqi").getString("lqiType"));
        anns = (ITSLQIAnnotations)tu.getTarget(this.trgLoc).getAnnotation(ITSLQIAnnotations.class);
        Assert.assertNull((Object)anns);
    }

    @Test
    public void testLTLanguages() {
        Assert.assertEquals((Object)"en-US", (Object)Languages.getLanguageForLocale((Locale)new Locale("en", "US")).getShortCodeWithCountryAndVariant());
        Assert.assertEquals((Object)"en-US", (Object)Languages.getLanguageForShortCode((String)"en-US").getShortCodeWithCountryAndVariant());
        Assert.assertEquals((Object)"en-US", (Object)Languages.getLanguageForLocale((Locale)new Locale("en", "us")).getShortCodeWithCountryAndVariant());
        Assert.assertEquals((Object)"en-US", (Object)Languages.getLanguageForShortCode((String)"en-us").getShortCodeWithCountryAndVariant());
    }

    @Test
    public void simpleTest2() {
        TextUnit tu = new TextUnit("id", "File not found: %1");
        tu.setTargetContent(this.trgLoc, new TextFragment("Fichier non trouv\u00e9: %1"));
        this.lt.run((ITextUnit)tu);
        ITSLQIAnnotations anns = (ITSLQIAnnotations)tu.getSource().getAnnotation(ITSLQIAnnotations.class);
        Assert.assertNull((Object)anns);
        anns = (ITSLQIAnnotations)tu.getTarget(this.trgLoc).getAnnotation(ITSLQIAnnotations.class);
        Assert.assertNotNull((Object)anns);
        Assert.assertEquals((long)1L, (long)anns.getAllAnnotations().size());
    }

    @Test
    public void testWithCodes() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("This is a short sentence.");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        TextUnit tu = new TextUnit("id");
        tu.setSourceContent(tf);
        tu.setTargetContent(this.trgLoc, tf.clone());
        this.lt.run((ITextUnit)tu);
        ITSLQIAnnotations anns = (ITSLQIAnnotations)tu.getTarget(this.trgLoc).getAnnotation(ITSLQIAnnotations.class);
        Assert.assertNotNull((Object)anns);
        GenericAnnotation ann = (GenericAnnotation)anns.getAnnotations("its-lqi").get(0);
        Assert.assertEquals((long)0L, (long)ann.getInteger("lqiXTrgStart").intValue());
        Assert.assertEquals((long)4L, (long)ann.getInteger("lqiXTrgEnd").intValue());
    }

    @Test
    public void termCheckTbxWithEmptyLists() throws IOException {
        Parameters p = new Parameters();
        p.setTermCheck(true);
        p.setBlacklistCheck(true);
        p.setCheckGrammar(false);
        p.setCheckSpelling(false);
        p.setTermCheckPath(null);
        p.setBlacklistCheckPath(null);
        LanguageTool langTool = new LanguageTool(p, LocaleId.ENGLISH, LocaleId.fromString((String)"hu"), new LinkedList(), new LinkedList());
        TextUnit tu = new TextUnit("id", "Alpha smoothing factor");
        tu.setTargetContent(LocaleId.fromString((String)"hu"), new TextFragment("t\u00e9nyez\u0151 sim\u00edt\u00e1si Alfax"));
        langTool.run((ITextUnit)tu);
        ITSLQIAnnotations anns = (ITSLQIAnnotations)tu.getTarget(LocaleId.fromString((String)"hu")).getAnnotation(ITSLQIAnnotations.class);
        Assert.assertNull((Object)anns);
    }

    @Test
    public void termCheckTbx() throws IOException {
        Parameters p = new Parameters();
        p.setTermCheck(true);
        p.setCheckGrammar(false);
        p.setCheckSpelling(false);
        p.setTermCheckPath(FileLocation.fromClass(this.getClass()).in("/test01.tbx").asPath().toAbsolutePath().toString());
        LanguageTool langTool = new LanguageTool(p, LocaleId.ENGLISH, LocaleId.fromString((String)"hu"));
        TextUnit tu = new TextUnit("id", "Alpha smoothing factor");
        tu.setTargetContent(LocaleId.fromString((String)"hu"), new TextFragment("t\u00e9nyez\u0151 sim\u00edt\u00e1si Alfax"));
        langTool.run((ITextUnit)tu);
        ITSLQIAnnotations anns = (ITSLQIAnnotations)tu.getTarget(LocaleId.fromString((String)"hu")).getAnnotation(ITSLQIAnnotations.class);
        Assert.assertNotNull((Object)anns);
        Assert.assertEquals((long)1L, (long)anns.getAllAnnotations().size());
        TextUnit tu2 = new TextUnit("id2", "Alpha smoothing factor");
        tu2.setTargetContent(LocaleId.fromString((String)"hu"), new TextFragment("Alfa sim\u00edt\u00e1si t\u00e9nyez\u0151"));
        langTool.run((ITextUnit)tu2);
        anns = (ITSLQIAnnotations)tu2.getTarget(LocaleId.fromString((String)"hu")).getAnnotation(ITSLQIAnnotations.class);
        Assert.assertNull((Object)anns);
        TextUnit tu3 = new TextUnit("id3", "Alpha smooth factors");
        tu3.setTargetContent(LocaleId.fromString((String)"hu"), new TextFragment("Alfa sim\u00edt\u00e1si t\u00e9nyez\u0151"));
        langTool.run((ITextUnit)tu3);
        anns = (ITSLQIAnnotations)tu3.getTarget(LocaleId.fromString((String)"hu")).getAnnotation(ITSLQIAnnotations.class);
        Assert.assertNull((Object)anns);
    }

    @Test
    public void termCheckIATETbx() throws IOException {
        Parameters p = new Parameters();
        p.setTermCheck(true);
        p.setCheckGrammar(false);
        p.setCheckSpelling(false);
        p.setTermCheckPath(FileLocation.fromClass(this.getClass()).in("/IATE_export_11112016_language(cs_en_es).tbx").asPath().toAbsolutePath().toString());
        LanguageTool langTool = new LanguageTool(p, LocaleId.ENGLISH, LocaleId.fromString((String)"es"));
        TextUnit tu = new TextUnit("id", "The byproducts are waste from mineral dressing");
        tu.setTargetContent(LocaleId.fromString((String)"es"), new TextFragment("Los subproductos son residuos de la disposici\u00f3n de minerales"));
        langTool.run((ITextUnit)tu);
        ITSLQIAnnotations anns = (ITSLQIAnnotations)tu.getTarget(LocaleId.fromString((String)"es")).getAnnotation(ITSLQIAnnotations.class);
        Assert.assertNotNull((Object)anns);
        Assert.assertEquals((long)1L, (long)anns.getAllAnnotations().size());
        TextUnit tu2 = new TextUnit("id2", "The byproducts are waste from mineral dressing");
        tu2.setTargetContent(LocaleId.fromString((String)"es"), new TextFragment("Los subproductos son residuos de la preparaci\u00f3n de minerales"));
        langTool.run((ITextUnit)tu2);
        anns = (ITSLQIAnnotations)tu2.getTarget(LocaleId.fromString((String)"es")).getAnnotation(ITSLQIAnnotations.class);
        Assert.assertNull((Object)anns);
        tu2.setTargetContent(LocaleId.fromString((String)"es"), new TextFragment("Los subproductos son resixduos de la preparaci\u00f3n de minerales"));
        langTool.run((ITextUnit)tu2);
        anns = (ITSLQIAnnotations)tu2.getTarget(LocaleId.fromString((String)"es")).getAnnotation(ITSLQIAnnotations.class);
        Assert.assertNotNull((Object)anns);
        Assert.assertEquals((long)2L, (long)anns.getAllAnnotations().size());
        TextUnit tu2a = new TextUnit("id2a", "The byproducts are metallic minerals");
        tu2a.setTargetContent(LocaleId.fromString((String)"es"), new TextFragment("Los subproductos son minerales met\u00e1licos"));
        langTool.run((ITextUnit)tu2a);
        anns = (ITSLQIAnnotations)tu2a.getTarget(LocaleId.fromString((String)"es")).getAnnotation(ITSLQIAnnotations.class);
        Assert.assertNull((Object)anns);
        tu2a.setTargetContent(LocaleId.fromString((String)"es"), new TextFragment("Los subproductos son met\u00e1licos"));
        langTool.run((ITextUnit)tu2a);
        anns = (ITSLQIAnnotations)tu2a.getTarget(LocaleId.fromString((String)"es")).getAnnotation(ITSLQIAnnotations.class);
        Assert.assertNotNull((Object)anns);
        Assert.assertEquals((long)2L, (long)anns.getAllAnnotations().size());
        TextUnit tu3 = new TextUnit("id3", "The byproducts are waste from mineral dressing");
        tu3.setTargetContent(LocaleId.fromString((String)"es"), new TextFragment("El subproducto es residuo de la preparaci\u00f3n de minerales"));
        langTool.run((ITextUnit)tu3);
        anns = (ITSLQIAnnotations)tu3.getTarget(LocaleId.fromString((String)"es")).getAnnotation(ITSLQIAnnotations.class);
        Assert.assertNull((Object)anns);
        tu3.setTargetContent(LocaleId.fromString((String)"es"), new TextFragment("El subproducto es residuo grandes de la preparaci\u00f3n de minerales"));
        langTool.run((ITextUnit)tu3);
        anns = (ITSLQIAnnotations)tu3.getTarget(LocaleId.fromString((String)"es")).getAnnotation(ITSLQIAnnotations.class);
        Assert.assertNotNull((Object)anns);
        Assert.assertEquals((long)1L, (long)anns.getAllAnnotations().size());
        TextUnit tu4 = new TextUnit("id4", "The competence of the Member States");
        tu4.setTargetContent(LocaleId.fromString((String)"es"), new TextFragment("Las competencias de los Estados miembros"));
        langTool.run((ITextUnit)tu4);
        anns = (ITSLQIAnnotations)tu4.getTarget(LocaleId.fromString((String)"es")).getAnnotation(ITSLQIAnnotations.class);
        Assert.assertNull((Object)anns);
    }

    @Test
    public void termCheckSdlTbx() throws IOException {
        Parameters p = new Parameters();
        p.setTermCheck(true);
        p.setCheckGrammar(false);
        p.setCheckSpelling(false);
        p.setTermCheckPath(FileLocation.fromClass(this.getClass()).in("/sdl_tbx.tbx").asPath().toAbsolutePath().toString());
        LanguageTool langTool = new LanguageTool(p, LocaleId.ENGLISH, LocaleId.GERMAN);
        TextUnit tu = new TextUnit("id", "The typeface families define all fonts.");
        tu.setTargetContent(LocaleId.GERMAN, new TextFragment("Die Schriftfamilien definieren alle Schriften."));
        langTool.run((ITextUnit)tu);
        ITSLQIAnnotations anns = (ITSLQIAnnotations)tu.getTarget(LocaleId.GERMAN).getAnnotation(ITSLQIAnnotations.class);
        Assert.assertNull((Object)anns);
        TextUnit tu2 = new TextUnit("id", "The typeface families define all fonts.");
        tu2.setTargetContent(LocaleId.GERMAN, new TextFragment("Die Schriftgruppen definieren alle Schriften."));
        langTool.run((ITextUnit)tu2);
        anns = (ITSLQIAnnotations)tu2.getTarget(LocaleId.GERMAN).getAnnotation(ITSLQIAnnotations.class);
        Assert.assertNotNull((Object)anns);
        Assert.assertEquals((long)1L, (long)anns.getAllAnnotations().size());
    }

    @Test
    public void termCheckCsv() throws IOException {
        Parameters p = new Parameters();
        p.setTermCheck(true);
        p.setCheckGrammar(false);
        p.setCheckSpelling(false);
        p.setTermCheckPath(FileLocation.fromClass(this.getClass()).in("/test01.csv").asPath().toAbsolutePath().toString());
        LanguageTool langTool = new LanguageTool(p, LocaleId.ENGLISH, LocaleId.FRENCH);
        TextUnit tu = new TextUnit("id", "This is a sentence with source 1.");
        tu.setTargetContent(LocaleId.FRENCH, new TextFragment("This is a sentence without the target term."));
        langTool.run((ITextUnit)tu);
        ITSLQIAnnotations anns = (ITSLQIAnnotations)tu.getTarget(LocaleId.FRENCH).getAnnotation(ITSLQIAnnotations.class);
        Assert.assertNotNull((Object)anns);
        Assert.assertEquals((long)1L, (long)anns.getAllAnnotations().size());
        TextUnit tu2 = new TextUnit("id2", "This is a sentence with source 1.");
        tu2.setTargetContent(LocaleId.FRENCH, new TextFragment("This is a sentence with target 1."));
        langTool.run((ITextUnit)tu2);
        anns = (ITSLQIAnnotations)tu2.getTarget(LocaleId.FRENCH).getAnnotation(ITSLQIAnnotations.class);
        Assert.assertNull((Object)anns);
        TextUnit tu3 = new TextUnit("id3", "This is a sentence with source 3.");
        tu3.setTargetContent(LocaleId.FRENCH, new TextFragment("This is a sentence with target 3."));
        langTool.run((ITextUnit)tu3);
        anns = (ITSLQIAnnotations)tu3.getTarget(LocaleId.FRENCH).getAnnotation(ITSLQIAnnotations.class);
        Assert.assertNull((Object)anns);
    }

    @Test
    public void termCheckBlacklist() throws IOException {
        Parameters p = new Parameters();
        p.setTermCheck(false);
        p.setBlacklistCheck(true);
        p.setCheckGrammar(false);
        p.setCheckSpelling(false);
        p.setBlacklistCheckPath(FileLocation.fromClass(this.getClass()).in("/black_tsv_simple.txt").asPath().toAbsolutePath().toString());
        LanguageTool langTool = new LanguageTool(p, LocaleId.ENGLISH, LocaleId.FRENCH);
        TextUnit tu = new TextUnit("id", "This is a sentence with the blackterm.");
        tu.setTargetContent(LocaleId.FRENCH, new TextFragment("This is a sentence with the blackterm1."));
        langTool.run((ITextUnit)tu);
        ITSLQIAnnotations anns = (ITSLQIAnnotations)tu.getTarget(LocaleId.FRENCH).getAnnotation(ITSLQIAnnotations.class);
        Assert.assertNotNull((Object)anns);
        Assert.assertEquals((long)1L, (long)anns.getAllAnnotations().size());
        TextUnit tu2 = new TextUnit("id2", "This is a sentence with source 1.");
        tu2.setTargetContent(LocaleId.FRENCH, new TextFragment("This is a sentence with target 1."));
        langTool.run((ITextUnit)tu2);
        anns = (ITSLQIAnnotations)tu2.getTarget(LocaleId.FRENCH).getAnnotation(ITSLQIAnnotations.class);
        Assert.assertNull((Object)anns);
        tu = new TextUnit("id", "This is a sentence with another blackterm.");
        tu.setTargetContent(LocaleId.FRENCH, new TextFragment("This is a sentence with the blackterm4."));
        langTool.run((ITextUnit)tu);
        anns = (ITSLQIAnnotations)tu.getTarget(LocaleId.FRENCH).getAnnotation(ITSLQIAnnotations.class);
        Assert.assertNotNull((Object)anns);
        Assert.assertEquals((long)1L, (long)anns.getAllAnnotations().size());
    }

    @Test
    public void termCheckBlacklistJapanese() throws IOException {
        Parameters p = new Parameters();
        p.setTermCheck(false);
        p.setBlacklistCheck(true);
        p.setCheckGrammar(false);
        p.setCheckSpelling(false);
        p.setBlacklistCheckPath(FileLocation.fromClass(this.getClass()).in("/black_tsv_simple_JA.txt").asPath().toAbsolutePath().toString());
        LanguageTool langTool = new LanguageTool(p, LocaleId.ENGLISH, LocaleId.JAPANESE);
        TextUnit tu = new TextUnit("id", "Srcwrd Srcwrd Srcwrd Srcwrd. ");
        tu.setTargetContent(LocaleId.JAPANESE, new TextFragment("\u79c1\u306f\u3042\u306a\u305f\u3060\u3051\u3092\u611b\u3057\u3066\u3044\u307e\u3059\u3002"));
        langTool.run((ITextUnit)tu);
        ITSLQIAnnotations anns = (ITSLQIAnnotations)tu.getTarget(LocaleId.JAPANESE).getAnnotation(ITSLQIAnnotations.class);
        Assert.assertNotNull((Object)anns);
        Assert.assertEquals((long)1L, (long)anns.getAllAnnotations().size());
    }

    @Test
    public void termCheckJapanese() throws IOException {
        Parameters p = new Parameters();
        p.setTermCheck(true);
        p.setBlacklistCheck(false);
        p.setCheckGrammar(false);
        p.setCheckSpelling(false);
        p.setTermCheckPath(FileLocation.fromClass(this.getClass()).in("/test_JA.csv").asPath().toAbsolutePath().toString());
        LanguageTool langTool = new LanguageTool(p, LocaleId.ENGLISH, LocaleId.JAPANESE);
        TextUnit tu = new TextUnit("id", "This is only a test. ");
        tu.setTargetContent(LocaleId.JAPANESE, new TextFragment("\u79c1\u306f\u3042\u306a\u305f\u3060\u3051\u3092\u611b\u3057\u3066\u3044\u307e\u3059\u3002"));
        langTool.run((ITextUnit)tu);
        ITSLQIAnnotations anns = (ITSLQIAnnotations)tu.getTarget(LocaleId.JAPANESE).getAnnotation(ITSLQIAnnotations.class);
        Assert.assertNull((Object)anns);
        TextUnit tu2 = new TextUnit("id", "This is only a test. ");
        tu2.setTargetContent(LocaleId.JAPANESE, new TextFragment("\u79c1\u306f\u3042\u306a\u305f\u3092\u611b\u3057\u3066\u3044\u307e\u3059\u3002"));
        langTool.run((ITextUnit)tu2);
        anns = (ITSLQIAnnotations)tu2.getTarget(LocaleId.JAPANESE).getAnnotation(ITSLQIAnnotations.class);
        Assert.assertNotNull((Object)anns);
        Assert.assertEquals((long)1L, (long)anns.getAllAnnotations().size());
        TextUnit tu3 = new TextUnit("id", "This is xxxx a test. ");
        tu3.setTargetContent(LocaleId.JAPANESE, new TextFragment("\u79c1\u306f\u3042\u306a\u305f\u3060\u3051\u3092\u611b\u3057\u3066\u3044\u307e\u3059\u3002"));
        langTool.run((ITextUnit)tu3);
        anns = (ITSLQIAnnotations)tu3.getTarget(LocaleId.JAPANESE).getAnnotation(ITSLQIAnnotations.class);
        Assert.assertNull((Object)anns);
        TextUnit tu4 = new TextUnit("id", "And now, as people return to the office and hybrid work becomes more permanent, video communications and virtual events remain critical for business productivity. ");
        tu4.setTargetContent(LocaleId.JAPANESE, new TextFragment("\u305d\u3057\u3066\u4eca\u3001\u4eba\u3005\u304c\u793e\u5185\u30aa\u30d5\u30a3\u30b9\u306b\u623b\u308a\u3064\u3064\u3082\u30cf\u30a4\u30d6\u30ea\u30c3\u30c9 \u30ef\u30fc\u30af\u304c\u3088\u308a\u6c38\u7d9a\u7684\u306a\u50cd\u304d\u65b9\u306b\u5909\u308f\u3063\u3066\u3044\u304f\u4e2d\u3067\u3001\u30d3\u30c7\u30aa \u30b3\u30df\u30e5\u30cb\u30b1\u30fc\u30b7\u30e7\u30f3\u3068\u30d0\u30fc\u30c1\u30e3\u30eb \u30a4\u30d9\u30f3\u30c8\u306f\u5f15\u304d\u7d9a\u304d\u30d3\u30b8\u30cd\u30b9\u306e\u751f\u7523\u6027\u306e\u8981\u3067\u3059\u3002"));
        langTool.run((ITextUnit)tu4);
        anns = (ITSLQIAnnotations)tu4.getTarget(LocaleId.JAPANESE).getAnnotation(ITSLQIAnnotations.class);
        Assert.assertNull((Object)anns);
        TextUnit tu5 = new TextUnit("id", "And now, as people return to the office and hybrid work becomes more permanent, video communications and virtual events remain critical for business productivity. ");
        tu5.setTargetContent(LocaleId.JAPANESE, new TextFragment("\u305d\u3057\u3066\u4eca\u3001\u4eba\u3005\u304c\u793e\u5185\u30aa\u30d5\u30a3\u30b9\u306b\u623b\u308a\u3064\u3064\u3082\u30cf\u30a4\u30d6\u30ea\u30c3\u30c9 \u30ef\u30fc\u30af\u304c\u3088\u308a\u6c38\u7d9a\u7684\u306a\u50cd\u304d\u65b9\u306b\u5909\u308f\u3063\u3066\u3044\u304f\u4e2d\u3067\u3001\u30d3\u30c7\u30aa \u30b3\u30df\u30e5\u30cb\u30b1\u30fc\u30b7\u30e7\u30f3\u3068\u30d0\u30fc\u30c1\u30e3\u30eb \u30a4\u30d9\u30f3\u30c8\u306f\u5f15\u304d\u7d9a\u304d\u306e\u751f\u7523\u6027\u306e\u8981\u3067\u3059\u3002"));
        langTool.run((ITextUnit)tu5);
        anns = (ITSLQIAnnotations)tu5.getTarget(LocaleId.JAPANESE).getAnnotation(ITSLQIAnnotations.class);
        Assert.assertNotNull((Object)anns);
        Assert.assertEquals((long)1L, (long)anns.getAllAnnotations().size());
    }

    @Test
    public void termCheckOnSpellCheckOff() throws IOException {
        Parameters p = new Parameters();
        p.setTermCheck(true);
        p.setBlacklistCheck(false);
        p.setCheckGrammar(false);
        p.setCheckSpelling(false);
        p.setTermCheckPath(null);
        p.setBlacklistCheckPath(null);
        LanguageTool langTool = new LanguageTool(p, LocaleId.ENGLISH, LocaleId.fromString((String)"es"));
        TextUnit tu = new TextUnit("id", "abcdef");
        tu.setTargetContent(LocaleId.fromString((String)"es"), new TextFragment("abcdefg"));
        langTool.setTerms(new LinkedList(), new LinkedList());
        langTool.run((ITextUnit)tu);
        ITSLQIAnnotations anns = (ITSLQIAnnotations)tu.getTarget(LocaleId.fromString((String)"es")).getAnnotation(ITSLQIAnnotations.class);
        Assert.assertNull((Object)anns);
    }

    @Test
    public void termCheckBasicTbx() throws IOException {
        Parameters p = new Parameters();
        p.setTermCheck(true);
        p.setCheckGrammar(false);
        p.setCheckSpelling(false);
        p.setTermCheckPath(FileLocation.fromClass(this.getClass()).in("/en_es.tbx").asPath().toAbsolutePath().toString());
        LanguageTool langTool = new LanguageTool(p, LocaleId.US_ENGLISH, LocaleId.fromString((String)"es-ES"));
        TextUnit tu = new TextUnit("id", "I'll be back before you know it!");
        tu.setTargetContent(LocaleId.fromString((String)"es-ES"), new TextFragment("Voy a estar de vuelta antes de que usted lo sepa!"));
        langTool.run((ITextUnit)tu);
        ITSLQIAnnotations anns = (ITSLQIAnnotations)tu.getTarget(LocaleId.fromString((String)"es-ES")).getAnnotation(ITSLQIAnnotations.class);
        Assert.assertNotNull((Object)anns);
        Assert.assertEquals((long)6L, (long)anns.getAllAnnotations().size());
    }
}

