/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.languagetool.rules;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.lib.languagetool.rules.ConceptEntry2TermCheckRules;
import net.sf.okapi.lib.languagetool.rules.TermCheckRule;
import net.sf.okapi.lib.terminology.ConceptEntry;
import net.sf.okapi.lib.terminology.IGlossaryReader;
import net.sf.okapi.lib.terminology.csv.CSVReader;
import net.sf.okapi.lib.terminology.tbx.TBXReader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.languagetool.rules.patterns.PatternToken;

@RunWith(value=JUnit4.class)
public class ConceptEntry2TermCheckRulesTest {
    private static final LocaleId ENGLISH_US = new LocaleId("en", "US");
    private static final LocaleId SPANISH = new LocaleId("es", "ES");
    private ConceptEntry2TermCheckRules converter;
    private ConceptEntry2TermCheckRules converter2;
    private List<ConceptEntry> singleConcept;
    private List<ConceptEntry> multipleConcepts;

    @Before
    public void setUp() throws Exception {
        this.converter = new ConceptEntry2TermCheckRules(ENGLISH_US, SPANISH);
        this.converter2 = new ConceptEntry2TermCheckRules(ENGLISH_US, LocaleId.KOREAN);
        ConceptEntry sc = new ConceptEntry();
        sc.addTerm(ENGLISH_US, "term1 term2");
        sc.addTerm(SPANISH, "sterm1 sterm2");
        sc.addTerm(LocaleId.KOREAN, "kterm1 kterm2");
        this.singleConcept = new ArrayList<ConceptEntry>();
        this.singleConcept.add(sc);
        ConceptEntry mc1 = new ConceptEntry();
        ConceptEntry mc2 = new ConceptEntry();
        mc1.addTerm(ENGLISH_US, "term1 term2");
        mc1.addTerm(SPANISH, "sterm1 sterm2");
        mc2.addTerm(ENGLISH_US, "newterm1 newterm2");
        mc2.addTerm(SPANISH, "snewterm1 snewterm2");
        this.multipleConcepts = new ArrayList<ConceptEntry>();
        this.multipleConcepts.add(mc1);
        this.multipleConcepts.add(mc2);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void LanguageToolLocales() {
        Assert.assertEquals((Object)"English (US)", (Object)this.converter.getSrcLang().toString());
        Assert.assertEquals((Object)"Spanish", (Object)this.converter.getTrgLang().toString());
        Assert.assertEquals((Object)"Default", (Object)this.converter2.getTrgLang().toString());
    }

    @Test
    public void singleTermToBitext() throws IOException {
        List rules = this.converter.convert(this.singleConcept);
        Assert.assertTrue((!rules.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((rules.size() == 1 ? 1 : 0) != 0);
        TermCheckRule r = (TermCheckRule)rules.get(0);
        Assert.assertEquals((Object)"term1", (Object)((PatternToken)r.getSrcRule().getPatternTokens().get(0)).getString());
        Assert.assertEquals((Object)"term2", (Object)((PatternToken)r.getSrcRule().getPatternTokens().get(1)).getString());
        Assert.assertEquals((Object)"sterm1", (Object)((PatternToken)r.getTrgRule().getPatternTokens().get(0)).getString());
        Assert.assertEquals((Object)"sterm2", (Object)((PatternToken)r.getTrgRule().getPatternTokens().get(1)).getString());
        rules = this.converter2.convert(this.singleConcept);
        Assert.assertTrue((!rules.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((rules.size() == 1 ? 1 : 0) != 0);
        r = (TermCheckRule)rules.get(0);
        Assert.assertEquals((Object)"term1", (Object)((PatternToken)r.getSrcRule().getPatternTokens().get(0)).getString());
        Assert.assertEquals((Object)"term2", (Object)((PatternToken)r.getSrcRule().getPatternTokens().get(1)).getString());
        Assert.assertEquals((Object)"kterm1", (Object)((PatternToken)r.getTrgRule().getPatternTokens().get(0)).getString());
        Assert.assertEquals((Object)"kterm2", (Object)((PatternToken)r.getTrgRule().getPatternTokens().get(1)).getString());
    }

    @Test
    public void multiTermToBitext() throws IOException {
        List rules = this.converter.convert(this.multipleConcepts);
        Assert.assertTrue((!rules.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((rules.size() == 2 ? 1 : 0) != 0);
        TermCheckRule r = (TermCheckRule)rules.get(0);
        Assert.assertEquals((Object)"term1", (Object)((PatternToken)r.getSrcRule().getPatternTokens().get(0)).getString());
        Assert.assertEquals((Object)"term2", (Object)((PatternToken)r.getSrcRule().getPatternTokens().get(1)).getString());
        Assert.assertEquals((Object)"sterm1", (Object)((PatternToken)r.getTrgRule().getPatternTokens().get(0)).getString());
        Assert.assertEquals((Object)"sterm2", (Object)((PatternToken)r.getTrgRule().getPatternTokens().get(1)).getString());
        r = (TermCheckRule)rules.get(1);
        Assert.assertEquals((Object)"newterm1", (Object)((PatternToken)r.getSrcRule().getPatternTokens().get(0)).getString());
        Assert.assertEquals((Object)"newterm2", (Object)((PatternToken)r.getSrcRule().getPatternTokens().get(1)).getString());
        Assert.assertEquals((Object)"snewterm1", (Object)((PatternToken)r.getTrgRule().getPatternTokens().get(0)).getString());
        Assert.assertEquals((Object)"snewterm2", (Object)((PatternToken)r.getTrgRule().getPatternTokens().get(1)).getString());
    }

    @Test
    public void tbxFile() throws IOException {
        ConceptEntry2TermCheckRules c = new ConceptEntry2TermCheckRules(LocaleId.ENGLISH, LocaleId.fromString((String)"hu"));
        try (InputStream is = FileLocation.fromClass(this.getClass()).in("/test01.tbx").asInputStream();){
            TBXReader reader = new TBXReader();
            reader.open(is);
            List rules = c.convert((IGlossaryReader)reader);
            Assert.assertTrue((!rules.isEmpty() ? 1 : 0) != 0);
            Assert.assertTrue((rules.size() == 1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void csvFile() throws IOException {
        try (InputStream is = FileLocation.fromClass(this.getClass()).in("/test01.csv").asInputStream();){
            CSVReader reader = new CSVReader(ENGLISH_US, SPANISH);
            reader.open(is);
            List rules = this.converter.convert((IGlossaryReader)reader);
            Assert.assertTrue((!rules.isEmpty() ? 1 : 0) != 0);
            Assert.assertTrue((rules.size() == 4 ? 1 : 0) != 0);
        }
    }
}

