/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.languagetool.rules;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.lib.languagetool.rules.BlackListRule;
import net.sf.okapi.lib.languagetool.rules.Blacklist2BlacklistRules;
import net.sf.okapi.lib.verification.BlackTerm;
import net.sf.okapi.lib.verification.BlacklistReader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.languagetool.rules.patterns.PatternToken;

@RunWith(value=JUnit4.class)
public class Blacklist2BlacklistRulesTest {
    private static final LocaleId SPANISH = new LocaleId("es", "ES");
    private Blacklist2BlacklistRules converter;
    private Blacklist2BlacklistRules converter2;
    private List<BlackTerm> singleBlackTerm;
    private List<BlackTerm> multipleBlackTerms;

    @Before
    public void setUp() throws Exception {
        this.converter = new Blacklist2BlacklistRules(SPANISH);
        this.converter2 = new Blacklist2BlacklistRules(LocaleId.KOREAN);
        BlackTerm sbt = new BlackTerm();
        sbt.text = "term1 term2";
        sbt.suggestion = "suggest1 suggest2";
        this.singleBlackTerm = new ArrayList<BlackTerm>();
        this.singleBlackTerm.add(sbt);
        BlackTerm mbt1 = new BlackTerm();
        mbt1.text = "term1 term2";
        mbt1.suggestion = "suggest1 suggest2";
        BlackTerm mbt2 = new BlackTerm();
        mbt2.text = "s_term1 s_term2";
        mbt2.suggestion = "s_suggest1 s_suggest2";
        this.multipleBlackTerms = new ArrayList<BlackTerm>();
        this.multipleBlackTerms.add(mbt1);
        this.multipleBlackTerms.add(mbt2);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void LanguageToolLocales() {
        Assert.assertEquals((Object)"Spanish", (Object)this.converter.getTrgLang().toString());
        Assert.assertEquals((Object)"Default", (Object)this.converter2.getTrgLang().toString());
    }

    @Test
    public void singleTermToBitext() throws IOException {
        List rules = this.converter.convert(this.singleBlackTerm);
        Assert.assertTrue((!rules.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((rules.size() == 1 ? 1 : 0) != 0);
        BlackListRule r = (BlackListRule)rules.get(0);
        Assert.assertEquals((Object)"term1", (Object)((PatternToken)r.getPatternTokens().get(0)).getString());
        Assert.assertEquals((Object)"term2", (Object)((PatternToken)r.getPatternTokens().get(1)).getString());
        rules = this.converter2.convert(this.singleBlackTerm);
        Assert.assertTrue((!rules.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((rules.size() == 1 ? 1 : 0) != 0);
        r = (BlackListRule)rules.get(0);
        Assert.assertEquals((Object)"term1", (Object)((PatternToken)r.getPatternTokens().get(0)).getString());
        Assert.assertEquals((Object)"term2", (Object)((PatternToken)r.getPatternTokens().get(1)).getString());
    }

    @Test
    public void multiTermToBitext() throws IOException {
        List rules = this.converter.convert(this.multipleBlackTerms);
        Assert.assertTrue((!rules.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((rules.size() == 2 ? 1 : 0) != 0);
        BlackListRule r = (BlackListRule)rules.get(0);
        Assert.assertEquals((Object)"term1", (Object)((PatternToken)r.getPatternTokens().get(0)).getString());
        Assert.assertEquals((Object)"term2", (Object)((PatternToken)r.getPatternTokens().get(1)).getString());
        r = (BlackListRule)rules.get(1);
        Assert.assertEquals((Object)"s_term1", (Object)((PatternToken)r.getPatternTokens().get(0)).getString());
        Assert.assertEquals((Object)"s_term2", (Object)((PatternToken)r.getPatternTokens().get(1)).getString());
    }

    @Test
    public void blacklistFile() throws IOException {
        try (InputStream is = FileLocation.fromClass(this.getClass()).in("/black_tsv_simple.txt").asInputStream();){
            BlacklistReader reader = new BlacklistReader();
            reader.open(is);
            List rules = this.converter.convert(reader);
            Assert.assertTrue((!rules.isEmpty() ? 1 : 0) != 0);
            Assert.assertTrue((rules.size() == 4 ? 1 : 0) != 0);
        }
    }
}

