/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.walker.selector;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.lib.xliff2.core.Segment;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.document.FileNode;
import net.sf.okapi.lib.xliff2.document.UnitNode;
import net.sf.okapi.lib.xliff2.document.XLIFFDocument;
import net.sf.okapi.lib.xliff2.walker.selector.XliffWalkerPathSelector;

public class PathSelectorUtils {
    public static boolean containsFile(XliffWalkerPathSelector pathSelector, String fileId) {
        return PathSelectorUtils.containsNode(pathSelector, XliffWalkerPathSelector.NodeType.FILE, fileId);
    }

    public static boolean containsUnit(XliffWalkerPathSelector pathSelector, String fileId, String unitId) {
        boolean containsFile = PathSelectorUtils.containsNode(pathSelector, XliffWalkerPathSelector.NodeType.FILE, fileId);
        if (containsFile) {
            for (XliffWalkerPathSelector unitPathSelector : pathSelector.getChildrenNodes()) {
                boolean containsUnit = PathSelectorUtils.containsNode(unitPathSelector, XliffWalkerPathSelector.NodeType.UNIT, unitId);
                if (!containsUnit) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsSegment(XliffWalkerPathSelector pathSelector, String fileId, String unitId, int segmentIndex) {
        boolean containsFile = PathSelectorUtils.containsNode(pathSelector, XliffWalkerPathSelector.NodeType.FILE, fileId);
        if (containsFile) {
            for (XliffWalkerPathSelector unitPathSelector : pathSelector.getChildrenNodes()) {
                boolean containsUnit = PathSelectorUtils.containsNode(unitPathSelector, XliffWalkerPathSelector.NodeType.UNIT, unitId);
                if (!containsUnit) continue;
                for (XliffWalkerPathSelector segmentPathSelector : unitPathSelector.getChildrenNodes()) {
                    boolean containsSegment = PathSelectorUtils.containsNode(segmentPathSelector, XliffWalkerPathSelector.NodeType.SEGMENT, String.valueOf(segmentIndex));
                    if (!containsSegment) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String[] resolveFileNodeIds(XLIFFDocument doc, XliffWalkerPathSelector pathSelector) {
        String[] fileNodeIds;
        if (pathSelector.getNodeType() != XliffWalkerPathSelector.NodeType.FILE) {
            throw new IllegalStateException("Expected path selector of NodeType " + XliffWalkerPathSelector.NodeType.FILE);
        }
        if (pathSelector.getNodeId().equals("*")) {
            List<String> fileNodeIdsList = doc.getFileNodeIds();
            fileNodeIds = fileNodeIdsList.toArray(new String[0]);
        } else {
            fileNodeIds = new String[]{pathSelector.getNodeId()};
        }
        return fileNodeIds;
    }

    public static UnitNode[] resolveUnitNodes(FileNode fileNode, XliffWalkerPathSelector pathSelector) {
        UnitNode[] unitNodes;
        if (pathSelector.getNodeType() != XliffWalkerPathSelector.NodeType.UNIT) {
            throw new IllegalStateException("Expected path selector of NodeType " + XliffWalkerPathSelector.NodeType.UNIT);
        }
        if (pathSelector.getNodeId().equals("*")) {
            List<UnitNode> unitNodesList = fileNode.getUnitNodes();
            unitNodes = unitNodesList.toArray(new UnitNode[0]);
        } else {
            unitNodes = new UnitNode[]{fileNode.getUnitNode(pathSelector.getNodeId())};
        }
        return unitNodes;
    }

    public static Pair<Integer, Segment>[] resolveSegments(UnitNode unitNode, XliffWalkerPathSelector pathSelector) {
        Pair[] indexedSegments;
        if (pathSelector.getNodeType() != XliffWalkerPathSelector.NodeType.SEGMENT) {
            throw new IllegalStateException("Expected path selector of NodeType " + XliffWalkerPathSelector.NodeType.SEGMENT);
        }
        Unit unit = unitNode.get();
        if (pathSelector.getNodeId().equals("*")) {
            int segmentIndex = 0;
            ArrayList<Pair<Integer, Segment>> indexedSegmentsList = new ArrayList<Pair<Integer, Segment>>();
            for (Segment segment : unit.getSegments()) {
                indexedSegmentsList.add(new Pair<Integer, Segment>(segmentIndex, segment));
                ++segmentIndex;
            }
            indexedSegments = indexedSegmentsList.toArray(new Pair[0]);
        } else {
            int segmentIndex = Integer.parseInt(pathSelector.getNodeId());
            Pair<Integer, Segment> pair = new Pair<Integer, Segment>(segmentIndex, unit.getSegment(segmentIndex));
            indexedSegments = new Pair[]{pair};
        }
        return indexedSegments;
    }

    private static boolean containsNode(XliffWalkerPathSelector pathSelector, XliffWalkerPathSelector.NodeType nodeType, String nodeId) {
        if (pathSelector == null || nodeType == null || nodeId == null) {
            throw new IllegalArgumentException("Method arguments can not be NULL");
        }
        return pathSelector.getNodeType() == nodeType && ("*".equals(pathSelector.getNodeId()) || nodeId.equals(pathSelector.getNodeId()));
    }

    public static class Pair<L, R> {
        private L left;
        private R right;

        Pair(L left, R right) {
            this.left = left;
            this.right = right;
        }

        public L getLeft() {
            return this.left;
        }

        public R getRight() {
            return this.right;
        }
    }
}

