/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.XLIFFException;
import net.sf.okapi.lib.xliff2.core.CTag;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.MTag;
import net.sf.okapi.lib.xliff2.core.PCont;
import net.sf.okapi.lib.xliff2.core.Store;
import net.sf.okapi.lib.xliff2.core.Tag;
import net.sf.okapi.lib.xliff2.core.TagType;

public class Tags
implements Iterable<Tag> {
    private final Store store;
    private LinkedHashMap<Integer, Tag> tags;
    private LinkedHashMap<Integer, PCont> pspans;
    private LinkedHashMap<Character, Integer> lastValues;

    public Tags(Store store) {
        if (store == null) {
            throw new InvalidParameterException("The store parameter cannot be null.");
        }
        this.store = store;
        this.lastValues = new LinkedHashMap();
        this.resetLastValues();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lastValues == null ? 0 : this.lastValues.hashCode());
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        result = 31 * result + (this.pspans == null ? 0 : this.pspans.hashCode());
        return result;
    }

    private void resetLastValues() {
        this.lastValues.put(Character.valueOf('\ue101'), -1);
        this.lastValues.put(Character.valueOf('\ue102'), -1);
        this.lastValues.put(Character.valueOf('\ue103'), -1);
        this.lastValues.put(Character.valueOf('\ue104'), -1);
        this.lastValues.put(Character.valueOf('\ue105'), -1);
        this.lastValues.put(Character.valueOf('\ue106'), -1);
    }

    protected void resetPContLastValue() {
        this.lastValues.put(Character.valueOf('\ue106'), -1);
    }

    public boolean hasCTagWithData() {
        if (this.tags != null) {
            for (Tag tag : this.tags.values()) {
                if (tag.isMarker() || !((CTag)tag).hasData()) continue;
                return true;
            }
        }
        return false;
    }

    public Tag getClosingTag(Tag openingTag) {
        return this.getClosingTag(openingTag.getId());
    }

    public Tag getClosingTag(String id) {
        if (this.tags == null) {
            return null;
        }
        for (Tag tag : this.tags.values()) {
            if (!tag.getId().equals(id) || tag.getTagType() != TagType.CLOSING) continue;
            return tag;
        }
        return null;
    }

    public Tag getOpeningTag(Tag closingTag) {
        return this.getOpeningTag(closingTag.getId());
    }

    public Tag getOpeningTag(String id) {
        if (this.tags == null) {
            return null;
        }
        for (Tag tag : this.tags.values()) {
            if (!tag.getId().equals(id) || tag.getTagType() != TagType.OPENING) continue;
            return tag;
        }
        return null;
    }

    public CTag getOpeningCTag(String id) {
        if (this.tags == null) {
            return null;
        }
        for (Tag tag : this.tags.values()) {
            if (!tag.getId().equals(id) || tag.getTagType() != TagType.OPENING) continue;
            if (!(tag instanceof CTag)) {
                throw new InvalidParameterException(String.format("The tag id='%s' exists but is not a CTag.", id));
            }
            return (CTag)tag;
        }
        return null;
    }

    public MTag getOpeningMTag(String id) {
        if (this.tags == null) {
            return null;
        }
        for (Tag tag : this.tags.values()) {
            if (!tag.getId().equals(id) || tag.getTagType() != TagType.OPENING) continue;
            if (!(tag instanceof MTag)) {
                throw new InvalidParameterException(String.format("The tag id='%s' exists but is not a MTag.", id));
            }
            return (MTag)tag;
        }
        return null;
    }

    public int size() {
        if (this.tags == null) {
            return 0;
        }
        return this.tags.size();
    }

    public boolean isEmpty() {
        if (this.tags == null) {
            return true;
        }
        return this.tags.isEmpty();
    }

    public int getPContCount() {
        if (this.pspans == null) {
            return 0;
        }
        return this.pspans.size();
    }

    public Store getStore() {
        return this.store;
    }

    public Tag get(int key) {
        if (this.tags != null) {
            return this.tags.get(key);
        }
        return null;
    }

    public Tag get(CharSequence ctext, int pos) {
        return this.get(Fragment.toKey(ctext.charAt(pos), ctext.charAt(pos + 1)));
    }

    public CTag getCTag(int key) {
        if (this.tags != null) {
            return (CTag)this.tags.get(key);
        }
        return null;
    }

    public CTag getCTag(CharSequence ctext, int pos) {
        return this.getCTag(Fragment.toKey(ctext.charAt(pos), ctext.charAt(pos + 1)));
    }

    public MTag getMTag(int key) {
        if (this.tags != null) {
            return (MTag)this.tags.get(key);
        }
        return null;
    }

    public MTag getMTag(CharSequence ctext, int pos) {
        return this.getMTag(Fragment.toKey(ctext.charAt(pos), ctext.charAt(pos + 1)));
    }

    public Tag get(String id, TagType tagType) {
        if (this.tags == null) {
            return null;
        }
        for (Tag tag : this.tags.values()) {
            if (!tag.getId().equals(id) || !tag.getTagType().equals((Object)tagType)) continue;
            return tag;
        }
        return null;
    }

    public PCont getPCont(int key) {
        if (this.pspans != null) {
            return this.pspans.get(key);
        }
        return null;
    }

    public PCont getPCont(CharSequence ctext, int pos) {
        return this.getPCont(Fragment.toKey(ctext.charAt(pos), ctext.charAt(pos + 1)));
    }

    public int getKey(Tag tag) {
        if (this.tags != null) {
            for (Map.Entry<Integer, Tag> entry : this.tags.entrySet()) {
                if (entry.getValue() != tag) continue;
                return entry.getKey();
            }
        }
        return -1;
    }

    int add(char mtype, Tag tag) {
        if (this.tags == null) {
            this.tags = new LinkedHashMap(3);
        }
        int value = this.lastValues.get(Character.valueOf(mtype));
        this.lastValues.put(Character.valueOf(mtype), ++value);
        int key = Fragment.toKey(mtype, 57616 + value);
        if (this.tags.containsKey(key)) {
            throw new XLIFFException("The key auto-selected to add this tag exists already.");
        }
        this.tags.put(key, tag);
        return key;
    }

    public int add(Tag tag) {
        boolean isCode = tag instanceof CTag;
        switch (tag.getTagType()) {
            case OPENING: {
                return this.add(isCode ? (char)'\ue101' : '\ue104', tag);
            }
            case CLOSING: {
                return this.add(isCode ? (char)'\ue102' : '\ue105', tag);
            }
        }
        return this.add('\ue103', tag);
    }

    public int add(PCont tag) {
        if (this.pspans == null) {
            this.pspans = new LinkedHashMap();
        }
        int value = this.lastValues.get(Character.valueOf('\ue106'));
        this.lastValues.put(Character.valueOf('\ue106'), ++value);
        int key = Fragment.toKey(57606, 57616 + value);
        if (this.pspans.containsKey(key)) {
            throw new XLIFFException("The key auto-selected to add this tag exists already.");
        }
        this.pspans.put(key, tag);
        return key;
    }

    @Override
    public Iterator<Tag> iterator() {
        if (this.tags == null) {
            this.tags = new LinkedHashMap(3);
        }
        return this.tags.values().iterator();
    }

    public Iterator<PCont> iteratorPCont() {
        if (this.pspans == null) {
            this.pspans = new LinkedHashMap();
        }
        return this.pspans.values().iterator();
    }

    public void remove(int key) {
        if (this.tags == null) {
            return;
        }
        Tag t = (Tag)this.tags.remove(key);
        if (t == null) {
            throw new IndexOutOfBoundsException("There is no code or marker tag in the list.");
        }
    }

    public void removePCont(int key) {
        if (this.pspans != null) {
            this.pspans.remove(key);
            return;
        }
        throw new IndexOutOfBoundsException("There is no protected content tag in the list.");
    }
}

