/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import java.util.Objects;
import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.core.MTagCommon;
import net.sf.okapi.lib.xliff2.core.Tag;
import net.sf.okapi.lib.xliff2.core.TagType;
import net.sf.okapi.lib.xliff2.its.ITSItems;
import net.sf.okapi.lib.xliff2.its.IWithITSAttributes;

public class MTag
extends Tag
implements IWithITSAttributes {
    public static final String TYPE_DEFAULT = "generic";
    protected MTagCommon mc;

    MTag(boolean opening, String id, String type) {
        this.tagType = opening ? TagType.OPENING : TagType.CLOSING;
        this.mc = new MTagCommon(id, type);
    }

    public MTag(String id, String type) {
        this(true, id, type);
    }

    public MTag(MTag opposite) {
        this.mc = opposite.mc;
        this.tagType = opposite.tagType == TagType.OPENING ? TagType.CLOSING : TagType.OPENING;
    }

    public MTag(MTag original, MTag opposite) {
        super(original);
        this.mc = opposite == null ? new MTagCommon(original.mc) : opposite.mc;
    }

    @Override
    public void setTagType(TagType markerType) {
        if (markerType == TagType.STANDALONE) {
            throw new InvalidParameterException("The marker type of an annotation cannot be placeholder.");
        }
        this.tagType = markerType;
    }

    @Override
    public String getId() {
        return this.mc.getId();
    }

    @Override
    public String getType() {
        return this.mc.getType();
    }

    @Override
    public void setType(String type) {
        this.mc.setType(type);
    }

    public String getRef() {
        return this.mc.getRef();
    }

    public void setRef(String ref) {
        this.mc.setRef(ref);
    }

    public String getValue() {
        return this.mc.getValue();
    }

    public void setValue(String value) {
        this.mc.setValue(value);
    }

    public Boolean getTranslate() {
        return this.mc.getTranslate();
    }

    public void setTranslate(Boolean translate) {
        this.mc.setTranslate(translate);
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof MTag)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        MTag mTag = (MTag)other;
        return Objects.equals(this.mc, mTag.mc);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mc);
    }

    @Override
    public boolean isMarker() {
        return true;
    }

    @Override
    public boolean isCode() {
        return false;
    }

    @Override
    public boolean hasITSItem() {
        return this.mc.hasITSItem();
    }

    @Override
    public ITSItems getITSItems() {
        return this.mc.getITSItems();
    }

    @Override
    public void setITSItems(ITSItems itsItems) {
        this.mc.setITSItems(itsItems);
    }
}

