/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import java.util.Objects;
import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.Util;
import net.sf.okapi.lib.xliff2.core.Directionality;

class CTagCommon {
    private static final int CANCOPY = 1;
    private static final int CANDELETE = 2;
    private String id;
    private String type;
    private int hints = 3;
    private boolean canOverlap;
    private String subType;
    private String copyOf;
    private Directionality dir = Directionality.INHERITED;

    CTagCommon(String id) {
        if (id == null) {
            throw new InvalidParameterException("The id parameter cannot be null.");
        }
        this.id = id;
    }

    CTagCommon(CTagCommon original) {
        this.canOverlap = original.canOverlap;
        this.copyOf = original.copyOf;
        this.dir = original.dir;
        this.hints = original.hints;
        this.id = original.id;
        this.subType = original.subType;
        this.type = original.type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        Util.checkValueList("fmt;ui;quote;link;image;other", type, "type");
        this.type = type;
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        if (subType != null) {
            int n = subType.indexOf(58);
            if (n == -1 || n == 0 || n == subType.length() - 1) {
                throw new InvalidParameterException(String.format("Invalid value '%s' for subType.", subType));
            }
            if (subType.startsWith("xlf:")) {
                Util.checkValueList("xlf:lb;xlf:pb;xlf:b;xlf:i;xlf:u;xlf:var", subType, "subType");
            }
        }
        this.subType = subType;
    }

    public boolean getCanCopy() {
        return (this.hints & 1) == 1;
    }

    public void setCanCopy(boolean canCopy) {
        this.hints = canCopy ? (this.hints |= 1) : (this.hints &= 0xFFFFFFFE);
    }

    public boolean getCanDelete() {
        return (this.hints & 2) == 2;
    }

    public void setCanDelete(boolean canDelete) {
        this.hints = canDelete ? (this.hints |= 2) : (this.hints &= 0xFFFFFFFD);
    }

    public boolean getCanOverlap() {
        return this.canOverlap;
    }

    public void setCanOverlap(boolean canOverlap) {
        this.canOverlap = canOverlap;
    }

    public String getCopyOf() {
        return this.copyOf;
    }

    public void setCopyOf(String copyOf) {
        this.copyOf = copyOf;
    }

    public Directionality getDir() {
        return this.dir;
    }

    public void setDir(Directionality dir) {
        this.dir = dir;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof CTagCommon)) {
            return false;
        }
        CTagCommon that = (CTagCommon)other;
        return this.hints == that.hints && this.canOverlap == that.canOverlap && Objects.equals(this.id, that.id) && Objects.equals(this.type, that.type) && Objects.equals(this.subType, that.subType) && Objects.equals(this.copyOf, that.copyOf) && this.dir == that.dir;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.hints, this.canOverlap, this.subType, this.copyOf, this.dir});
    }
}

