/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.validation;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.reader.Event;
import net.sf.okapi.lib.xliff2.reader.XLIFFReader;
import net.sf.okapi.lib.xliff2.test.U;
import net.sf.okapi.lib.xliff2.validation.Rule;
import net.sf.okapi.lib.xliff2.validation.Validation;
import net.sf.okapi.lib.xliff2.writer.XLIFFWriter;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ValidationTest {
    @Test
    public void testSimple() {
        Validation val = new Validation();
        Rule rule = (Rule)val.add((Object)new Rule("isPresent", "abc"));
        Assert.assertSame((Object)rule, (Object)val.get(0));
        Assert.assertEquals((long)1L, (long)val.size());
        val.remove((Object)rule);
        Assert.assertTrue((boolean)val.isEmpty());
    }

    @Test
    public void testWriter() {
        try (XLIFFWriter writer = new XLIFFWriter();){
            StringWriter sr = new StringWriter();
            writer.setLineBreak("\n");
            writer.create((Writer)sr, "en");
            Unit unit = new Unit("u1");
            unit.appendSegment().getSource().append((CharSequence)"source");
            Validation val = unit.getValidation();
            val.add((Object)new Rule(Rule.Type.ISPRESENT.toString(), "abc"));
            Rule r = (Rule)val.add((Object)new Rule(Rule.Type.ISPRESENT.toString(), "XYZ"));
            r.setCaseSensitive(false);
            r.setNormalization(Rule.Normalization.NONE);
            r.setOccurs(2);
            r.setEnabled(false);
            r.setExistsInSource(true);
            writer.writeUnit(unit);
            writer.close();
            String expected = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\">\n<file id=\"f1\">\n<unit id=\"u1\">\n<val:validation xmlns:val=\"urn:oasis:names:tc:xliff:validation:2.0\">\n<val:rule isPresent=\"abc\"/>\n<val:rule isPresent=\"XYZ\" disabled=\"yes\" caseSensitive=\"no\" normalization=\"none\" occurs=\"2\" existsInSource=\"yes\"/>\n</val:validation>\n<segment>\n<source>source</source>\n</segment>\n</unit>\n</file>\n</xliff>\n";
            Assert.assertEquals((Object)expected, (Object)sr.toString());
            XLIFFReader.validate((String)sr.toString(), null);
        }
    }

    @Test
    public void testReadWrite() {
        String snippet = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" xmlns:val=\"urn:oasis:names:tc:xliff:validation:2.0\">\n<file id=\"f1\">\n<unit id=\"u1\">\n<val:validation>\n<val:rule isPresent=\"ABC\"/>\n<val:rule isPresent=\"XYZ\" disabled=\"yes\" caseSensitive=\"no\" normalization=\"none\" occurs=\"2\" existsInSource=\"yes\"/>\n</val:validation>\n<segment>\n<source>source</source>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        List<Event> events = U.getEvents(snippet);
        Unit unit = U.getUnit(events);
        Assert.assertTrue((boolean)unit.hasValidation());
        Validation val = unit.getValidation();
        Rule r = (Rule)val.get(0);
        Assert.assertEquals((Object)"ABC", (Object)r.getData());
        Assert.assertEquals((Object)"ABC", (Object)r.getEffectiveData());
        String output = U.writeEvents(events);
        XLIFFReader.validate((String)output, null);
    }

    @Test
    public void testInheritance1() {
        String snippet = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" xmlns:val=\"urn:oasis:names:tc:xliff:validation:2.0\">\n<file id=\"f1\">\n<val:validation>\n<val:rule isPresent=\"rule1\"/>\n<val:rule isPresent=\"rule2\"/>\n</val:validation>\n<group id=\"g1\">\n<unit id=\"u1\">\n<val:validation>\n<val:rule isPresent=\"rule3\"/>\n<val:rule isPresent=\"rule2\" caseSensitive=\"no\"/>\n<val:rule isPresent=\"rule1\" occurs=\"10\"/>\n</val:validation>\n<segment>\n<source>source</source>\n</segment>\n</unit>\n</group>\n</file>\n</xliff>\n";
        List<Event> events = U.getEvents(snippet);
        for (Event event : events) {
            switch (event.getType()) {
                case MID_FILE: {
                    Validation val1 = event.getMidFileData().getValidation();
                    Assert.assertEquals((long)2L, (long)val1.size());
                    Assert.assertEquals((Object)"rule1", (Object)((Rule)val1.get(0)).getData());
                    Assert.assertTrue((boolean)((Rule)val1.get(0)).isCaseSensitive());
                    Assert.assertFalse((boolean)((Rule)val1.get(0)).isInherited());
                    Assert.assertEquals((Object)"rule2", (Object)((Rule)val1.get(1)).getData());
                    Assert.assertFalse((boolean)((Rule)val1.get(1)).isInherited());
                    Assert.assertEquals((long)0L, (long)((Rule)val1.get(1)).getOccurs());
                    break;
                }
                case START_GROUP: {
                    Validation val2 = event.getStartGroupData().getValidation();
                    Assert.assertEquals((long)2L, (long)val2.size());
                    Assert.assertEquals((Object)"rule1", (Object)((Rule)val2.get(0)).getData());
                    Assert.assertTrue((boolean)((Rule)val2.get(0)).isCaseSensitive());
                    Assert.assertTrue((boolean)((Rule)val2.get(0)).isInherited());
                    Assert.assertEquals((Object)"rule2", (Object)((Rule)val2.get(1)).getData());
                    Assert.assertTrue((boolean)((Rule)val2.get(1)).isInherited());
                    Assert.assertEquals((long)0L, (long)((Rule)val2.get(1)).getOccurs());
                    break;
                }
                case TEXT_UNIT: {
                    Validation val3 = event.getUnit().getValidation();
                    Assert.assertEquals((long)3L, (long)val3.size());
                    Assert.assertEquals((Object)"rule1", (Object)((Rule)val3.get(0)).getData());
                    Assert.assertEquals((long)10L, (long)((Rule)val3.get(0)).getOccurs());
                    Assert.assertFalse((boolean)((Rule)val3.get(0)).isInherited());
                    Assert.assertEquals((Object)"rule2", (Object)((Rule)val3.get(1)).getData());
                    Assert.assertFalse((boolean)((Rule)val3.get(1)).isCaseSensitive());
                    Assert.assertFalse((boolean)((Rule)val3.get(1)).isInherited());
                    Assert.assertEquals((Object)"rule3", (Object)((Rule)val3.get(2)).getData());
                    break;
                }
            }
        }
        String expected = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" xmlns:val=\"urn:oasis:names:tc:xliff:validation:2.0\">\n<file id=\"f1\">\n<val:validation>\n<val:rule isPresent=\"rule1\"/>\n<val:rule isPresent=\"rule2\"/>\n</val:validation>\n<group id=\"g1\">\n<unit id=\"u1\">\n<val:validation>\n<val:rule isPresent=\"rule1\" occurs=\"10\"/>\n<val:rule isPresent=\"rule2\" caseSensitive=\"no\"/>\n<val:rule isPresent=\"rule3\"/>\n</val:validation>\n<segment>\n<source>source</source>\n</segment>\n</unit>\n</group>\n</file>\n</xliff>\n";
        Assert.assertEquals((Object)expected, (Object)U.writeEvents(events));
    }

    @Test
    public void testInheritance2() {
        String snippet = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:val=\"urn:oasis:names:tc:xliff:validation:2.0\">\n<file id=\"f1\">\n<val:validation>\n<val:rule startsWith=\"*T\"/>\n</val:validation>\n<group id=\"g1\">\n<unit id=\"u1\">\n<segment>\n<source>*source</source>\n<target>*target</target>\n</segment>\n</unit>\n</group>\n</file>\n</xliff>\n";
        List<Event> events = U.getEvents(snippet);
        for (Event event : events) {
            switch (event.getType()) {
                case MID_FILE: {
                    Validation val1 = event.getMidFileData().getValidation();
                    Assert.assertEquals((long)1L, (long)val1.size());
                    Assert.assertEquals((Object)"*T", (Object)((Rule)val1.get(0)).getData());
                    Assert.assertTrue((boolean)((Rule)val1.get(0)).isCaseSensitive());
                    Assert.assertFalse((boolean)((Rule)val1.get(0)).isInherited());
                    break;
                }
                case START_GROUP: {
                    Validation val2 = event.getStartGroupData().getValidation();
                    Assert.assertEquals((long)1L, (long)val2.size());
                    Assert.assertEquals((Object)"*T", (Object)((Rule)val2.get(0)).getData());
                    Assert.assertTrue((boolean)((Rule)val2.get(0)).isCaseSensitive());
                    Assert.assertTrue((boolean)((Rule)val2.get(0)).isInherited());
                    break;
                }
                case TEXT_UNIT: {
                    Unit unit = event.getUnit();
                    Validation val3 = unit.getValidation();
                    Assert.assertEquals((long)1L, (long)val3.size());
                    Assert.assertEquals((Object)"*T", (Object)((Rule)val3.get(0)).getData());
                    Assert.assertTrue((boolean)((Rule)val3.get(0)).isCaseSensitive());
                    Assert.assertTrue((boolean)((Rule)val3.get(0)).isInherited());
                    List list = val3.processRules(unit, "f1");
                    Assert.assertEquals((long)1L, (long)list.size());
                    break;
                }
            }
        }
        String expected = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:val=\"urn:oasis:names:tc:xliff:validation:2.0\">\n<file id=\"f1\">\n<val:validation>\n<val:rule startsWith=\"*T\"/>\n</val:validation>\n<group id=\"g1\">\n<unit id=\"u1\">\n<segment>\n<source>*source</source>\n<target>*target</target>\n</segment>\n</unit>\n</group>\n</file>\n</xliff>\n";
        Assert.assertEquals((Object)expected, (Object)U.writeEvents(events));
    }
}

