/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.validation;

import java.util.List;
import net.sf.okapi.lib.xliff2.core.Part;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.test.U;
import net.sf.okapi.lib.xliff2.validation.Issue;
import net.sf.okapi.lib.xliff2.validation.Rule;
import net.sf.okapi.lib.xliff2.validation.Validation;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RulesProcessingTest {
    @Test
    public void testIsPresent() {
        Unit unit = this.create();
        Validation val = unit.getValidation();
        val.add((Object)new Rule("isPresent", "xyz"));
        val.prepare();
        Assert.assertEquals((long)0L, (long)val.processRules(unit, null).size());
    }

    @Test
    public void testIsPresentWrongCount() {
        Unit unit = this.create();
        Validation val = unit.getValidation();
        Rule rule = (Rule)val.add((Object)new Rule("isPresent", "xyz"));
        rule.setOccurs(2);
        rule.prepare();
        List res = val.processRules(unit, null);
        Assert.assertEquals((Object)"isPresent-WrongCount", (Object)((Issue)res.get(0)).getCode());
    }

    @Test
    public void testIsPresentNotInSource() {
        Unit unit = this.create();
        Validation val = unit.getValidation();
        Rule rule = (Rule)val.add((Object)new Rule("isPresent", "qwerty"));
        rule.setExistsInSource(true);
        rule.prepare();
        List res = val.processRules(unit, null);
        Assert.assertEquals((Object)"isPresent-NotInSource", (Object)((Issue)res.get(0)).getCode());
    }

    @Test
    public void testIsPresentNotInTarget() {
        Unit unit = this.create();
        Validation val = unit.getValidation();
        Rule rule = (Rule)val.add((Object)new Rule("isPresent", "def"));
        rule.setExistsInSource(true);
        rule.prepare();
        List res = val.processRules(unit, null);
        Assert.assertEquals((Object)"isPresent-NotInTarget", (Object)((Issue)res.get(0)).getCode());
    }

    @Test
    public void testStartsWithNotInTarget() {
        Unit unit = this.create();
        Validation val = unit.getValidation();
        Rule rule = (Rule)val.add((Object)new Rule("startsWith", "abc"));
        rule.prepare();
        List res = val.processRules(unit, null);
        Assert.assertEquals((Object)"startsWith", (Object)((Issue)res.get(0)).getCode());
    }

    private Unit create() {
        Unit unit = new Unit("u1");
        unit.appendSegment().getSource().append((CharSequence)"abc def xyz");
        unit.getSegment(0).getTarget(Part.GetTarget.CREATE_EMPTY).append((CharSequence)"ABC iop xyz");
        return unit;
    }

    @Test
    public void testTargetOrder() {
        String snippet = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:val=\"urn:oasis:names:tc:xliff:validation:2.0\">\n<file id=\"f1\">\n<unit id=\"u1\">\n<val:validation>\n<val:rule startsWith=\"-\"/>\n</val:validation>\n<segment>\n<source>- AAA-1. </source>\n<target order='2'>- AAA-2. </target>\n</segment>\n<segment>\n<source>BBB-2. </source>\n<target order='1'>BBB-1. </target>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        Unit unit = U.getUnit(snippet);
        List issues = unit.getValidation().processRules(unit, null);
        Assert.assertEquals((long)1L, (long)issues.size());
        Assert.assertEquals((Object)"startsWith", (Object)((Issue)issues.get(0)).getCode());
    }

    @Test
    public void testFoundInIgnorable() {
        String snippet = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:val=\"urn:oasis:names:tc:xliff:validation:2.0\">\n<file id=\"f1\">\n<unit id=\"u1\">\n<val:validation>\n<val:rule isPresent=\"zzz\"/>\n</val:validation>\n<segment>\n<source>before </source>\n<target>before-trg </target>\n</segment>\n<ignorable>\n<source>zzz </source>\n<target>zzz </target>\n</ignorable>\n<segment>\n<source>after </source>\n<target>after-trg </target>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        Unit unit = U.getUnit(snippet);
        List issues = unit.getValidation().processRules(unit, null);
        Assert.assertEquals((long)0L, (long)issues.size());
    }
}

