/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.test;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.Part;
import net.sf.okapi.lib.xliff2.core.StartXliffData;
import net.sf.okapi.lib.xliff2.core.Tag;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.its.ITSWriter;
import net.sf.okapi.lib.xliff2.reader.Event;
import net.sf.okapi.lib.xliff2.reader.XLIFFReader;
import net.sf.okapi.lib.xliff2.writer.XLIFFWriter;

public class U {
    public static final String STARTDOCWITHITS = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n";
    public static final String STARTDOC = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\">\n";

    public static String fmtMarkers(String codedText) {
        StringBuilder tmp = new StringBuilder();
        for (int i = 0; i < codedText.length(); ++i) {
            if (Fragment.isChar1((char)codedText.charAt(i))) {
                switch (codedText.charAt(i)) {
                    case '\ue104': {
                        tmp.append("{oA");
                        break;
                    }
                    case '\ue105': {
                        tmp.append("{cA");
                        break;
                    }
                    case '\ue101': {
                        tmp.append("{oC");
                        break;
                    }
                    case '\ue102': {
                        tmp.append("{cC");
                        break;
                    }
                    case '\ue103': {
                        tmp.append("{hC");
                        break;
                    }
                    case '\ue106': {
                        tmp.append("{$");
                    }
                }
                tmp.append("}");
                ++i;
                continue;
            }
            tmp.append(codedText.charAt(i));
        }
        return tmp.toString();
    }

    public static String fmtWithIDs(Fragment frag) {
        StringBuilder tmp = new StringBuilder();
        String ct = frag.getCodedText();
        for (int i = 0; i < ct.length(); ++i) {
            if (Fragment.isChar1((char)ct.charAt(i))) {
                Tag tag = frag.getTags().get((CharSequence)ct, i);
                switch (ct.charAt(i)) {
                    case '\ue104': {
                        tmp.append("{om:" + tag.getId());
                        break;
                    }
                    case '\ue105': {
                        tmp.append("{cm:" + tag.getId());
                        break;
                    }
                    case '\ue101': {
                        tmp.append("{oc:" + tag.getId());
                        break;
                    }
                    case '\ue102': {
                        tmp.append("{cc:" + tag.getId());
                        break;
                    }
                    case '\ue103': {
                        tmp.append("{hc:" + tag.getId());
                        break;
                    }
                    case '\ue106': {
                        tmp.append("{$");
                    }
                }
                tmp.append("}");
                ++i;
                continue;
            }
            tmp.append(ct.charAt(i));
        }
        return tmp.toString();
    }

    public static List<Event> getEvents(String text) {
        ArrayList<Event> events = new ArrayList<Event>();
        try (XLIFFReader reader = new XLIFFReader();){
            reader.open(text);
            while (reader.hasNext()) {
                events.add(reader.next());
            }
        }
        return events;
    }

    public static Unit getUnit(List<Event> list) {
        for (Event event : list) {
            if (!event.isUnit()) continue;
            return event.getUnit();
        }
        return null;
    }

    public static Unit getUnit(String text) {
        return U.getUnit(U.getEvents(text));
    }

    public static String writeEvents(List<Event> events) {
        StringWriter sw = new StringWriter();
        try (XLIFFWriter writer = new XLIFFWriter();){
            writer.setLineBreak("\n");
            writer.create((Writer)sw, null);
            for (Event event : events) {
                writer.writeEvent(event);
            }
        }
        return sw.toString();
    }

    public static String writeUnit(Unit unit, String sourceLang, String targetLang) {
        StringWriter sw = new StringWriter();
        try (XLIFFWriter writer = new XLIFFWriter();){
            writer.setLineBreak("\n");
            writer.create((Writer)sw, sourceLang, targetLang);
            StartXliffData sxd = new StartXliffData("2.0");
            ITSWriter.addDeclaration((StartXliffData)sxd);
            writer.writeStartDocument(sxd, null);
            writer.writeUnit(unit);
        }
        return sw.toString();
    }

    public static int kOC(int value) {
        return Fragment.toKey((int)57601, (int)(57616 + value));
    }

    public static int kCC(int value) {
        return Fragment.toKey((int)57602, (int)(57616 + value));
    }

    public static int kSC(int value) {
        return Fragment.toKey((int)57603, (int)(57616 + value));
    }

    public static int kOA(int value) {
        return Fragment.toKey((int)57604, (int)(57616 + value));
    }

    public static int kCA(int value) {
        return Fragment.toKey((int)57605, (int)(57616 + value));
    }

    public static int kSP(int value) {
        return Fragment.toKey((int)57606, (int)(57616 + value));
    }

    public static Fragment getTargetOrSource(Part part) {
        if (!part.hasTarget()) {
            return part.getSource();
        }
        return part.getTarget();
    }
}

