/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.processor;

import java.io.File;
import java.io.Writer;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.document.XLIFFDocument;
import net.sf.okapi.lib.xliff2.processor.DefaultEventHandler;
import net.sf.okapi.lib.xliff2.processor.IEventHandler;
import net.sf.okapi.lib.xliff2.processor.XLIFFProcessor;
import net.sf.okapi.lib.xliff2.reader.Event;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class XLIFFProcessorTest {
    private FileLocation root = FileLocation.fromClass(this.getClass());

    @Test(expected=InvalidParameterException.class)
    public void testSameInputOutput() {
        XLIFFProcessor processor = new XLIFFProcessor();
        File outFile = this.root.out("example.out1.xlf").asFile();
        processor.run(outFile, outFile);
    }

    @Test
    public void testNoOutput() {
        XLIFFProcessor processor = new XLIFFProcessor();
        processor.setHandler((IEventHandler)new SetCanResegment());
        File inputFile = this.root.in("/example.xlf").asFile();
        processor.run(inputFile, null);
        processor.setInput(inputFile);
        processor.setOutput((Writer)null);
        processor.run();
    }

    @Test
    public void testSingleHandler() {
        XLIFFProcessor processor = new XLIFFProcessor();
        processor.setHandler((IEventHandler)new SetCanResegment());
        File outFile = this.root.out("/example.out1.xlf").asFile();
        outFile.delete();
        processor.run(this.root.in("/example.xlf").asFile(), outFile);
        XLIFFDocument doc = new XLIFFDocument();
        doc.load(outFile, 255);
        Unit unit = doc.getUnitNode("f1", "1").get();
        Assert.assertFalse((boolean)unit.getCanResegment());
    }

    @Test
    public void testTwoHandlers() {
        XLIFFProcessor processor = new XLIFFProcessor();
        processor.setHandler((IEventHandler)new SetCanResegment());
        processor.add((IEventHandler)new AddText());
        File outFile = this.root.out("/example.out2.xlf").asFile();
        outFile.delete();
        processor.run(this.root.in("/example.xlf").asFile(), outFile);
        XLIFFDocument doc = new XLIFFDocument();
        doc.load(outFile, 255);
        Unit unit = doc.getUnitNode("f1", "1").get();
        Assert.assertFalse((boolean)unit.getCanResegment());
    }

    static class AddText
    extends DefaultEventHandler {
        AddText() {
        }

        public Event handleUnit(Event event) {
            Unit unit = event.getUnit();
            Fragment fragment = unit.getPart(unit.getPartCount() - 1).getSource();
            fragment.setCodedText(fragment.getCodedText() + "_NEW");
            return event;
        }
    }

    static class SetCanResegment
    extends DefaultEventHandler {
        SetCanResegment() {
        }

        public Event handleUnit(Event event) {
            Unit unit = event.getUnit();
            unit.setCanResegment(false);
            return event;
        }
    }
}

