/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.metadata;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import net.sf.okapi.lib.xliff2.core.MidFileData;
import net.sf.okapi.lib.xliff2.core.StartGroupData;
import net.sf.okapi.lib.xliff2.core.StartXliffData;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.metadata.Meta;
import net.sf.okapi.lib.xliff2.metadata.MetaGroup;
import net.sf.okapi.lib.xliff2.metadata.Metadata;
import net.sf.okapi.lib.xliff2.reader.Event;
import net.sf.okapi.lib.xliff2.reader.XLIFFReader;
import net.sf.okapi.lib.xliff2.test.U;
import net.sf.okapi.lib.xliff2.writer.XLIFFWriter;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MetadataTest {
    @Test
    public void testSimple() {
        Metadata md = new Metadata();
        MetaGroup mg = (MetaGroup)md.add((Object)new MetaGroup("cat1"));
        mg.add((Object)new Meta("t1", "d1"));
        mg.add((Object)new MetaGroup("cat2"));
        mg = (MetaGroup)md.get(0);
        mg = (MetaGroup)md.get(0);
        Assert.assertEquals((Object)"cat1", (Object)mg.getCategory());
        Meta m1 = (Meta)mg.get(0);
        Assert.assertEquals((Object)"t1", (Object)m1.getType());
        Assert.assertEquals((Object)"d1", (Object)m1.getData());
    }

    @Test
    public void testWriter1() {
        try (XLIFFWriter writer = new XLIFFWriter();){
            StringWriter sr = new StringWriter();
            writer.setLineBreak("\n");
            writer.create((Writer)sr, "en", "fr");
            MidFileData mfd = new MidFileData();
            mfd.setMetadata(this.createMetadata("F"));
            writer.writeMidFile(mfd);
            StartGroupData sgd = new StartGroupData("g1");
            sgd.setMetadata(this.createMetadata("g"));
            writer.writeStartGroup(sgd);
            Unit unit = new Unit("u1");
            unit.setMetadata(this.createMetadata("u"));
            unit.appendSegment().getSource().append((CharSequence)"source");
            writer.writeUnit(unit);
            writer.close();
            String expected = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\">\n<file id=\"f1\">\n<mda:metadata xmlns:mda=\"urn:oasis:names:tc:xliff:metadata:2.0\">\n<mda:metaGroup id=\"Fmg1\" category=\"Fcat1\" appliesTo=\"source\">\n<mda:meta type=\"Ft1\">Fd1</mda:meta>\n<mda:metaGroup category=\"Fcat2\" appliesTo=\"target\">\n<mda:meta type=\"Ft11\">Fd11</mda:meta>\n</mda:metaGroup>\n<mda:meta type=\"Ft2\">Fd2</mda:meta>\n</mda:metaGroup>\n</mda:metadata>\n<group id=\"g1\">\n<mda:metadata xmlns:mda=\"urn:oasis:names:tc:xliff:metadata:2.0\">\n<mda:metaGroup id=\"gmg1\" category=\"gcat1\" appliesTo=\"source\">\n<mda:meta type=\"gt1\">gd1</mda:meta>\n<mda:metaGroup category=\"gcat2\" appliesTo=\"target\">\n<mda:meta type=\"gt11\">gd11</mda:meta>\n</mda:metaGroup>\n<mda:meta type=\"gt2\">gd2</mda:meta>\n</mda:metaGroup>\n</mda:metadata>\n<unit id=\"u1\">\n<mda:metadata xmlns:mda=\"urn:oasis:names:tc:xliff:metadata:2.0\">\n<mda:metaGroup id=\"umg1\" category=\"ucat1\" appliesTo=\"source\">\n<mda:meta type=\"ut1\">ud1</mda:meta>\n<mda:metaGroup category=\"ucat2\" appliesTo=\"target\">\n<mda:meta type=\"ut11\">ud11</mda:meta>\n</mda:metaGroup>\n<mda:meta type=\"ut2\">ud2</mda:meta>\n</mda:metaGroup>\n</mda:metadata>\n<segment>\n<source>source</source>\n</segment>\n</unit>\n</group>\n</file>\n</xliff>\n";
            Assert.assertEquals((Object)expected, (Object)sr.toString());
            XLIFFReader.validate((String)sr.toString(), null);
        }
    }

    @Test
    public void testWriter2() {
        try (XLIFFWriter writer = new XLIFFWriter();){
            StringWriter sr = new StringWriter();
            writer.setLineBreak("\n");
            writer.create((Writer)sr, "en");
            StartXliffData sxd = new StartXliffData(null);
            sxd.setNamespace("mda", "urn:oasis:names:tc:xliff:metadata:2.0");
            writer.writeStartDocument(sxd, null);
            Unit unit = new Unit("u1");
            unit.setMetadata(this.createMetadata("U"));
            unit.appendSegment().getSource().append((CharSequence)"source");
            writer.writeUnit(unit);
            writer.close();
            String expected = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" xmlns:mda=\"urn:oasis:names:tc:xliff:metadata:2.0\">\n<file id=\"f1\">\n<unit id=\"u1\">\n<mda:metadata>\n<mda:metaGroup id=\"Umg1\" category=\"Ucat1\" appliesTo=\"source\">\n<mda:meta type=\"Ut1\">Ud1</mda:meta>\n<mda:metaGroup category=\"Ucat2\" appliesTo=\"target\">\n<mda:meta type=\"Ut11\">Ud11</mda:meta>\n</mda:metaGroup>\n<mda:meta type=\"Ut2\">Ud2</mda:meta>\n</mda:metaGroup>\n</mda:metadata>\n<segment>\n<source>source</source>\n</segment>\n</unit>\n</file>\n</xliff>\n";
            Assert.assertEquals((Object)expected, (Object)sr.toString());
            XLIFFReader.validate((String)sr.toString(), null);
        }
    }

    @Test
    public void testReaderWriter() {
        String snippet = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\">\n<file id=\"f1\">\n<mda:metadata xmlns:mda=\"urn:oasis:names:tc:xliff:metadata:2.0\">\n<mda:metaGroup id=\"Fmg1\" category=\"Fcat1\" appliesTo=\"source\">\n<mda:meta type=\"Ft1\">Fd1</mda:meta>\n<mda:metaGroup category=\"Fcat2\" appliesTo=\"target\">\n<mda:meta type=\"Ft11\">Fd11</mda:meta>\n</mda:metaGroup>\n<mda:meta type=\"Ft2\">Fd2</mda:meta>\n</mda:metaGroup>\n</mda:metadata>\n<group id=\"g1\" xmlns:p=\"urn:oasis:names:tc:xliff:metadata:2.0\">\n<p:metadata>\n<p:metaGroup id=\"Gmg1\" category=\"Gcat1\" appliesTo=\"source\">\n<p:meta type=\"Gt1\">Gd1</p:meta>\n<p:metaGroup category=\"Gcat2\" appliesTo=\"target\">\n<p:meta type=\"Gt11\">Gd11</p:meta>\n</p:metaGroup>\n<p:meta type=\"Gt2\">Gd2</p:meta>\n</p:metaGroup>\n</p:metadata>\n<unit id=\"u1\">\n<p:metadata>\n<p:metaGroup id=\"Umg1\" category=\"Ucat1\" appliesTo=\"source\">\n<p:meta type=\"Ut1\">Ud1</p:meta>\n<p:metaGroup category=\"Ucat2\" appliesTo=\"target\">\n<p:meta type=\"Ut11\">Ud11</p:meta>\n</p:metaGroup>\n<p:meta type=\"Ut2\">Ud2</p:meta>\n</p:metaGroup>\n</p:metadata>\n<segment>\n<source>source</source>\n</segment>\n</unit>\n</group>\n</file>\n</xliff>\n";
        List<Event> events = U.getEvents(snippet);
        for (Event event : events) {
            switch (event.getType()) {
                case MID_FILE: {
                    MidFileData mfd = event.getMidFileData();
                    Assert.assertTrue((boolean)mfd.hasMetadata());
                    Metadata md = mfd.getMetadata();
                    MetaGroup mg1 = (MetaGroup)md.get(0);
                    Assert.assertEquals((Object)"Fmg1", (Object)mg1.getId());
                    Meta m = (Meta)mg1.get(0);
                    Assert.assertEquals((Object)"Ft1", (Object)m.getType());
                    Assert.assertEquals((Object)"Fd1", (Object)m.getData());
                    break;
                }
                case START_GROUP: {
                    StartGroupData sgd = event.getStartGroupData();
                    Assert.assertTrue((boolean)sgd.hasMetadata());
                    Metadata md = sgd.getMetadata();
                    MetaGroup mg1 = (MetaGroup)md.get(0);
                    Assert.assertEquals((Object)"Gmg1", (Object)mg1.getId());
                    Meta m = (Meta)mg1.get(0);
                    Assert.assertEquals((Object)"Gt1", (Object)m.getType());
                    Assert.assertEquals((Object)"Gd1", (Object)m.getData());
                    break;
                }
                case TEXT_UNIT: {
                    Unit unit = event.getUnit();
                    Assert.assertTrue((boolean)unit.hasMetadata());
                    Metadata md = unit.getMetadata();
                    MetaGroup mg1 = (MetaGroup)md.get(0);
                    Assert.assertEquals((Object)"Umg1", (Object)mg1.getId());
                    Meta m = (Meta)mg1.get(0);
                    Assert.assertEquals((Object)"Ut1", (Object)m.getType());
                    Assert.assertEquals((Object)"Ud1", (Object)m.getData());
                    break;
                }
            }
        }
        String output = U.writeEvents(events);
        Assert.assertEquals((Object)snippet, (Object)output);
    }

    private Metadata createMetadata(String prefix) {
        Metadata md = new Metadata();
        MetaGroup mg1 = (MetaGroup)md.add((Object)new MetaGroup(prefix + "cat1"));
        mg1.setId(prefix + "mg1");
        mg1.setAppliesTo(MetaGroup.AppliesTo.SOURCE);
        mg1.add((Object)new Meta(prefix + "t1", prefix + "d1"));
        MetaGroup mg2 = (MetaGroup)mg1.add((Object)new MetaGroup(prefix + "cat2"));
        mg2.setAppliesTo(MetaGroup.AppliesTo.TARGET);
        mg2.add((Object)new Meta(prefix + "t11", prefix + "d11"));
        mg1.add((Object)new Meta(prefix + "t2", prefix + "d2"));
        return md;
    }
}

