/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.metadata;

import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.metadata.Meta;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MetaTest {
    @Test
    public void testSetGetMeta() {
        Meta meta = new Meta("myType");
        Assert.assertEquals((Object)"myType", (Object)meta.getType());
        Assert.assertNull((Object)meta.getData());
        meta.setData("data");
        meta.setType("newType");
        Assert.assertEquals((Object)"newType", (Object)meta.getType());
        Assert.assertEquals((Object)"data", (Object)meta.getData());
        meta = new Meta("t", "d");
        Assert.assertEquals((Object)"t", (Object)meta.getType());
        Assert.assertEquals((Object)"d", (Object)meta.getData());
    }

    @Test(expected=InvalidParameterException.class)
    public void testNullType1() {
        new Meta((String)null);
    }

    @Test(expected=InvalidParameterException.class)
    public void testNullType2() {
        new Meta(null, "data");
    }

    @Test(expected=InvalidParameterException.class)
    public void testNullType3() {
        Meta meta = new Meta("t", "d");
        meta.setType(null);
    }

    public void testEmptyType() {
        Meta meta = new Meta("", "data");
        Assert.assertEquals((Object)"", (Object)meta.getType());
        Assert.assertEquals((Object)"data", (Object)meta.getData());
        meta = new Meta("");
        Assert.assertEquals((Object)"", (Object)meta.getType());
        meta.setType("");
        Assert.assertEquals((Object)"", (Object)meta.getType());
    }

    @Test
    public void testCopyConstruct() {
        Meta m1 = new Meta("t1", "d1");
        Meta m2 = new Meta(m1);
        Assert.assertNotSame((Object)m1, (Object)m2);
        Assert.assertEquals((Object)m1.getType(), (Object)m2.getType());
        Assert.assertEquals((Object)m1.getData(), (Object)m2.getData());
    }
}

