/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.matches;

import java.util.List;
import net.sf.okapi.lib.xliff2.URIParser;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.document.XLIFFDocument;
import net.sf.okapi.lib.xliff2.matches.Match;
import net.sf.okapi.lib.xliff2.matches.Matches;
import net.sf.okapi.lib.xliff2.metadata.Meta;
import net.sf.okapi.lib.xliff2.metadata.MetaGroup;
import net.sf.okapi.lib.xliff2.reader.Event;
import net.sf.okapi.lib.xliff2.test.U;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MatchTest {
    @Test
    public void testDefaults() {
        Match m = new Match();
        Assert.assertEquals((Object)"tm", (Object)m.getType());
        Assert.assertNull((Object)m.getId());
        Assert.assertNull((Object)m.getMatchQuality());
        Assert.assertNull((Object)m.getMatchSuitability());
        Assert.assertNull((Object)m.getRef());
        Assert.assertNull((Object)m.getSimilarity());
        Assert.assertNull((Object)m.getSource());
        Assert.assertNull((Object)m.getTarget());
        Assert.assertFalse((boolean)m.isReference());
    }

    @Test
    public void testSetGet() {
        Match m = new Match();
        m.setType("mt");
        Assert.assertEquals((Object)"mt", (Object)m.getType());
        m.setId("mtc1");
        Assert.assertEquals((Object)"mtc1", (Object)m.getId());
        m.setMatchQuality(Double.valueOf(12.34));
        Assert.assertEquals((double)12.34, (double)m.getMatchQuality(), (double)0.0);
        m.setMatchSuitability(Double.valueOf(23.45));
        Assert.assertEquals((double)23.45, (double)m.getMatchSuitability(), (double)0.0);
        m.setRef("#m1");
        Assert.assertEquals((Object)"#m1", (Object)m.getRef());
        m.setSimilarity(Double.valueOf(99.9));
        Assert.assertEquals((double)99.9, (double)m.getSimilarity(), (double)0.0);
        m.setReference(true);
        Assert.assertTrue((boolean)m.isReference());
        Fragment frag = new Fragment(m.getStore(), false);
        frag.append((CharSequence)"src");
        m.setSource(frag);
        Assert.assertEquals((Object)"src", (Object)m.getSource().toString());
        frag = new Fragment(m.getStore(), true);
        frag.append((CharSequence)"trg");
        m.setTarget(frag);
        Assert.assertEquals((Object)"trg", (Object)m.getTarget().toString());
    }

    @Test
    public void testReadReferenceMatch() {
        String text = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file id=\"f1\">\n<unit id=\"id\">\n<mtc:matches xmlns:mtc=\"urn:oasis:names:tc:xliff:matches:2.0\">\n<mtc:match ref=\"#2\" reference=\"yes\" similarity=\"100.0\" matchQuality=\"88.0\">\n<source>source<ph id=\"1\"/></source>\n<target xml:lang=\"fr-CA\">target-Canadian</target>\n</mtc:match>\n</mtc:matches>\n<segment>\n<source><mrk id=\"2\" type=\"mtc:match\">source<ph id=\"1\"/></mrk></source>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        List<Event> events = U.getEvents(text);
        Unit unit = U.getUnit(events);
        Match match = (Match)unit.getMatches().get(0);
        Assert.assertTrue((boolean)match.isReference());
    }

    @Test
    public void testAddMatches() {
        String text = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file id=\"f1\">\n<unit id=\"id\">\n<originalData>\n<data id=\"d1\">[br]</data>\n</originalData>\n<segment>\n<source>source<ph id=\"1\" dataRef=\"d1\"/></source>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        List<Event> events = U.getEvents(text);
        Unit unit = U.getUnit(events);
        Fragment frag = unit.getPart(0).getSource();
        Match match = new Match();
        match.setSource(new Fragment(frag, match.getStore(), false));
        Match.annotate((Fragment)frag, (int)0, (int)-1, (Match)match);
        match.setTarget(new Fragment(match.getStore(), true, "target"));
        match.setSimilarity(Double.valueOf(100.0));
        match.setMatchQuality(Double.valueOf(88.0));
        match.setType("mt");
        match.setSubType("acme:test");
        match = new Match(match);
        match.setMatchQuality(Double.valueOf(77.0));
        match.setType("tm");
        match.setSubType("acme:test2");
        unit.getMatches().add((Object)match);
        for (Match m : unit.getMatches()) {
            if (m.getType().equals("mt")) {
                Assert.assertEquals((Object)"acme:test", (Object)m.getSubType());
                continue;
            }
            if (!m.getType().equals("tm")) continue;
            Assert.assertEquals((Object)"acme:test2", (Object)m.getSubType());
        }
        String expected = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file id=\"f1\">\n<unit id=\"id\">\n<mtc:matches xmlns:mtc=\"urn:oasis:names:tc:xliff:matches:2.0\">\n<mtc:match ref=\"#2\" type=\"mt\" subType=\"acme:test\" similarity=\"100.0\" matchQuality=\"88.0\">\n<originalData>\n<data id=\"d1\">[br]</data>\n</originalData>\n<source>source<ph id=\"1\" dataRef=\"d1\"/></source>\n<target>target</target>\n</mtc:match>\n<mtc:match ref=\"#2\" type=\"tm\" subType=\"acme:test2\" similarity=\"100.0\" matchQuality=\"77.0\">\n<originalData>\n<data id=\"d1\">[br]</data>\n</originalData>\n<source>source<ph id=\"1\" dataRef=\"d1\"/></source>\n<target>target</target>\n</mtc:match>\n</mtc:matches>\n<originalData>\n<data id=\"d1\">[br]</data>\n</originalData>\n<segment>\n<source><mrk id=\"2\" type=\"mtc:match\">source<ph id=\"1\" dataRef=\"d1\"/></mrk></source>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        Assert.assertEquals((Object)expected, (Object)U.writeEvents(events));
        U.getEvents(expected);
    }

    @Test
    public void testReadMatchesThenWrite() {
        String text = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file id=\"f1\">\n<unit id=\"id\">\n<mtc:matches xmlns:mtc=\"urn:oasis:names:tc:xliff:matches:2.0\">\n<mtc:match ref=\"#2\" type=\"mt\" subType=\"acme:test\" similarity=\"100.0\" matchQuality=\"88.0\">\n<mda:metadata xmlns:mda=\"urn:oasis:names:tc:xliff:metadata:2.0\">\n<mda:metaGroup id=\"mg1\">\n<mda:meta type=\"blah\">data</mda:meta>\n</mda:metaGroup>\n</mda:metadata>\n<originalData>\n<data id=\"d1\">[br]</data>\n</originalData>\n<source>source<ph id=\"1\" dataRef=\"d1\"/></source>\n<target>target</target>\n</mtc:match>\n</mtc:matches>\n<originalData>\n<data id=\"d1\">[br]</data>\n</originalData>\n<segment>\n<source><mrk id=\"2\" type=\"mtc:match\">source<ph id=\"1\" dataRef=\"d1\"/></mrk></source>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        List<Event> events = U.getEvents(text);
        Unit unit = U.getUnit(events);
        Assert.assertTrue((boolean)unit.hasMatch());
        Matches matches = unit.getMatches();
        Match match = (Match)matches.get(0);
        Assert.assertEquals((Object)"mt", (Object)match.getType());
        Assert.assertEquals((Object)"acme:test", (Object)match.getSubType());
        Assert.assertEquals((Object)"#2", (Object)match.getRef());
        Assert.assertEquals((double)100.0, (double)match.getSimilarity(), (double)0.0);
        Assert.assertEquals((double)88.0, (double)match.getMatchQuality(), (double)0.0);
        Assert.assertEquals((Object)"source{hC}", (Object)U.fmtMarkers(match.getSource().getCodedText()));
        Assert.assertEquals((Object)"target", (Object)U.fmtMarkers(match.getTarget().getCodedText()));
        Assert.assertTrue((boolean)match.hasMetadata());
        Assert.assertEquals((Object)"mg1", (Object)((MetaGroup)match.getMetadata().get(0)).getId());
        Assert.assertEquals((Object)"blah", (Object)((Meta)((MetaGroup)match.getMetadata().get(0)).get(0)).getType());
        Assert.assertEquals((Object)text, (Object)U.writeEvents(events));
        U.getEvents(text);
    }

    @Test
    public void testFetchMatchInDocument() {
        String text = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file id=\"f1\">\n<unit id=\"id\">\n<mtc:matches xmlns:mtc=\"urn:oasis:names:tc:xliff:matches:2.0\">\n<mtc:match id=\"r1\" ref=\"#2\" type=\"mt\" subType=\"acme:test\" similarity=\"100.0\" matchQuality=\"88.0\">\n<mda:metadata xmlns:mda=\"urn:oasis:names:tc:xliff:metadata:2.0\">\n<mda:metaGroup>\n<mda:meta type=\"blah\">data</mda:meta>\n</mda:metaGroup>\n</mda:metadata>\n<originalData>\n<data id=\"d1\">[br]</data>\n</originalData>\n<source>source<ph id=\"1\" dataRef=\"d1\"/></source>\n<target>target</target>\n</mtc:match>\n</mtc:matches>\n<originalData>\n<data id=\"d1\">[br]</data>\n</originalData>\n<segment>\n<source><mrk id=\"2\" type=\"mtc:match\">source<ph id=\"1\" dataRef=\"d1\"/></mrk></source>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        XLIFFDocument doc = new XLIFFDocument();
        doc.load(text, 255);
        URIParser up = new URIParser("#/f=f1/u=id/mtc=r1");
        Object obj = doc.fetchReference(up);
        Assert.assertNotNull((Object)obj);
        Assert.assertEquals((Object)"r1", (Object)((Match)obj).getId());
    }
}

