/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.lang;

import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.lang.Language;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class LanguageTest {
    private static Language language = Language.THE_INSTANCE;

    @Test
    public void testCheckValid() {
        language.checkValid("sr");
        language.checkValid("sr-Latn");
        language.checkValid("sr-RS");
        language.checkValid("sr-Latn-RS");
        language.checkValid("es-419");
    }

    @Test(expected=InvalidParameterException.class)
    public void testCheckInvalidLanguageId() {
        language.checkValid("dummy");
    }

    @Test(expected=InvalidParameterException.class)
    public void testCheckInvalidStartWithMinus() {
        language.checkValid("-sr");
    }

    @Test(expected=InvalidParameterException.class)
    public void testCheckInvalidOmitDefaultScript() {
        language.checkValid("es-Latn");
    }

    @Test(expected=InvalidParameterException.class)
    public void testCheckInvalidEmptyString() {
        language.checkValid("");
    }

    @Test(expected=InvalidParameterException.class)
    public void testCheckInvalidDeprecated() {
        language.checkValid("zh-cmn");
    }
}

