/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.lang;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import net.sf.okapi.lib.xliff2.lang.LanguageData;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class LanguageDataTest {
    private static LanguageData langData;

    @BeforeClass
    public static void onlyOnce() {
        try {
            langData = new LanguageData();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testGetLanguages() {
        Object[] data = langData.getLanguages();
        Assert.assertNotNull((Object)data);
        Assert.assertNotEquals((long)0L, (long)data.length);
        Assert.assertTrue((0 <= Arrays.binarySearch(data, "fr") ? 1 : 0) != 0);
    }

    @Test
    public void testGetExtlangs() {
        Object[] data = langData.getExtlangs();
        Assert.assertNotNull((Object)data);
        Assert.assertNotEquals((long)0L, (long)data.length);
        Assert.assertTrue((0 <= Arrays.binarySearch(data, "yue") ? 1 : 0) != 0);
    }

    @Test
    public void testGetPrefixesByVariant() {
        Object[] sr = new String[]{"sr"};
        Object[] srLatn = new String[]{"sr", "latn"};
        Object[] srCyrl = new String[]{"sr", "cyrl"};
        String[][][] data = langData.getPrefixesByVariant();
        Assert.assertNotNull((Object)data);
        Assert.assertNotEquals((long)0L, (long)data.length);
        int found = 0;
        for (int i = 0; i < data.length; ++i) {
            String[][] data1 = data[i];
            for (int j = 0; j < data1.length; ++j) {
                Object[] data2 = data1[j];
                if (Arrays.equals(sr, data2)) {
                    found |= 1;
                }
                if (Arrays.equals(srCyrl, data2)) {
                    found |= 2;
                }
                if (!Arrays.equals(srLatn, data2)) continue;
                found |= 4;
            }
        }
        Assert.assertEquals((long)7L, (long)found);
    }

    @Test
    public void testGetPrefixByExtlang() {
        int[] data = langData.getPrefixByExtlang();
        Assert.assertNotNull((Object)data);
        Assert.assertNotEquals((long)0L, (long)data.length);
    }

    @Test
    public void testGetRegions() {
        Object[] data = langData.getRegions();
        Assert.assertNotNull((Object)data);
        Assert.assertNotEquals((long)0L, (long)data.length);
        Assert.assertTrue((0 <= Arrays.binarySearch(data, "419") ? 1 : 0) != 0);
        Assert.assertTrue((0 <= Arrays.binarySearch(data, "de") ? 1 : 0) != 0);
    }

    @Test
    public void testGetScripts() {
        Object[] data = langData.getScripts();
        Assert.assertNotNull((Object)data);
        Assert.assertNotEquals((long)0L, (long)data.length);
        Assert.assertTrue((0 <= Arrays.binarySearch(data, "hant") ? 1 : 0) != 0);
    }

    @Test
    public void testGetSuppressedScriptByLanguage() {
        int[] data = langData.getSuppressedScriptByLanguage();
        Assert.assertNotNull((Object)data);
        Assert.assertNotEquals((long)0L, (long)data.length);
    }

    @Test
    public void testGetVariants() {
        Object[] data = langData.getVariants();
        Assert.assertNotNull((Object)data);
        Assert.assertNotEquals((long)0L, (long)data.length);
        Assert.assertTrue((0 <= Arrays.binarySearch(data, "rozaj") ? 1 : 0) != 0);
    }

    @Test
    public void testGetDeprecated() {
        Object[] data = langData.getDeprecated();
        Assert.assertNotNull((Object)data);
        Assert.assertNotEquals((long)0L, (long)data.length);
        Assert.assertTrue((0 <= Arrays.binarySearch(data, "i-klingon") ? 1 : 0) != 0);
        Assert.assertTrue((0 <= Arrays.binarySearch(data, "no-bok") ? 1 : 0) != 0);
        Assert.assertTrue((0 <= Arrays.binarySearch(data, "zh-cmn") ? 1 : 0) != 0);
    }

    @Test
    public void testGetPreferredValueByLanguageMap() {
        Map data = langData.getPreferredValueByLanguageMap();
        Assert.assertNotNull((Object)data);
        Assert.assertNotEquals((long)0L, (long)data.size());
        Assert.assertEquals((Object)"tlh", data.get("i-klingon"));
        Assert.assertEquals((Object)"nb", data.get("no-bok"));
        Assert.assertEquals((Object)"yue", data.get("zh-yue"));
        Assert.assertEquals((Object)"he", data.get("iw"));
        Assert.assertEquals((Object)"id", data.get("in"));
    }

    @Test
    public void testGetGrandfathered() {
        Object[] data = langData.getGrandfathered();
        Assert.assertNotNull((Object)data);
        Assert.assertNotEquals((long)0L, (long)data.length);
        Assert.assertTrue((0 <= Arrays.binarySearch(data, "i-klingon") ? 1 : 0) != 0);
        Assert.assertTrue((0 <= Arrays.binarySearch(data, "no-bok") ? 1 : 0) != 0);
    }

    @Test
    public void testGetRedundant() {
        Object[] data = langData.getRedundant();
        Assert.assertNotNull((Object)data);
        Assert.assertNotEquals((long)0L, (long)data.length);
        Assert.assertTrue((0 <= Arrays.binarySearch(data, "sr-latn") ? 1 : 0) != 0);
        Assert.assertTrue((0 <= Arrays.binarySearch(data, "zh-hans") ? 1 : 0) != 0);
    }

    @Test
    public void testGetDeprecatedLang() {
        Object[] data = langData.getDeprecatedLang();
        Assert.assertNotNull((Object)data);
        Assert.assertNotEquals((long)0L, (long)data.length);
        Assert.assertTrue((0 <= Arrays.binarySearch(data, "iw") ? 1 : 0) != 0);
        Assert.assertTrue((0 <= Arrays.binarySearch(data, "in") ? 1 : 0) != 0);
        Assert.assertTrue((0 <= Arrays.binarySearch(data, "mo") ? 1 : 0) != 0);
    }
}

