/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.its;

import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.XLIFFException;
import net.sf.okapi.lib.xliff2.its.TextAnalysis;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TextAnalysisTest {
    @Test(expected=XLIFFException.class)
    public void testTextAnalysisMissingIdent() {
        TextAnalysis ta = new TextAnalysis();
        ta.setTaSource("source");
        ta.validate();
    }

    @Test(expected=XLIFFException.class)
    public void testTextAnalysisMissingSource() {
        TextAnalysis ta = new TextAnalysis();
        ta.setTaClassRef("classref");
        ta.setTaIdent("ident");
        ta.validate();
    }

    @Test(expected=XLIFFException.class)
    public void testTextAnalysisIdentRefNotAllowed() {
        TextAnalysis ta = new TextAnalysis();
        ta.setTaSource("source");
        ta.setTaIdent("ident");
        ta.setTaIdentRef("identref");
        ta.validate();
    }

    @Test(expected=XLIFFException.class)
    public void testTextAnalysisMissingAnnotatorRef() {
        TextAnalysis ta = new TextAnalysis();
        ta.setTaClassRef("classref");
        ta.setTaConfidence(Double.valueOf(0.5));
        ta.validate();
    }

    @Test(expected=InvalidParameterException.class)
    public void testTextAnalysisInvalidConfidence() {
        TextAnalysis ta = new TextAnalysis();
        ta.setTaClassRef("classref");
        ta.setTaConfidence(Double.valueOf(50.5));
    }

    @Test
    public void testTextAnalysisOK() {
        TextAnalysis ta = new TextAnalysis();
        ta.setTaClassRef("classref");
        ta.validate();
        ta.setTaSource("source");
        ta.setTaIdent("ident");
        ta.validate();
        ta.setTaConfidence(Double.valueOf(0.6));
        ta.setAnnotatorRef("myTool");
        ta.validate();
    }

    @Test
    public void testTextAnalysisCanNullifyConfidence() {
        TextAnalysis ta = new TextAnalysis();
        ta.setTaConfidence(Double.valueOf(0.6));
        ta.setTaConfidence(null);
    }
}

