/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.its;

import java.util.List;
import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.XLIFFException;
import net.sf.okapi.lib.xliff2.core.MTag;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.its.TermTag;
import net.sf.okapi.lib.xliff2.reader.Event;
import net.sf.okapi.lib.xliff2.reader.XLIFFReaderException;
import net.sf.okapi.lib.xliff2.test.U;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TermMarkerTest {
    @Test(expected=XLIFFException.class)
    public void testMissingAnnotatorRef() {
        TermTag tm = new TermTag("1");
        tm.setTermConfidence(Double.valueOf(0.5));
        tm.validate();
    }

    @Test(expected=InvalidParameterException.class)
    public void testInvalidType() {
        TermTag tm = new TermTag("1");
        tm.setType("abc");
    }

    @Test
    public void testValidType() {
        TermTag tm = new TermTag("1");
        tm.setType("its:term-no");
        Assert.assertEquals((Object)"its:term-no", (Object)tm.getType());
        tm.setType("term");
        Assert.assertEquals((Object)"term", (Object)tm.getType());
    }

    @Test(expected=InvalidParameterException.class)
    public void testInvalidConfidence() {
        TermTag tm = new TermTag("1");
        tm.setTermConfidence(Double.valueOf(1.234));
    }

    @Test
    public void testMTConfidenceCanNullifyConfidence() {
        TermTag tm = new TermTag("1");
        tm.setTermConfidence(Double.valueOf(0.5));
        tm.setTermConfidence(null);
        tm.validate();
    }

    @Test
    public void testNormalCreation() {
        TermTag tm = new TermTag("1");
        Assert.assertEquals((Object)"term", (Object)tm.getType());
    }

    @Test
    public void testTermInfoAndTermInfoRef() {
        TermTag tm = new TermTag("1");
        Assert.assertNull((Object)tm.getTermInfo());
        Assert.assertNull((Object)tm.getTermInfoRef());
        tm.setRef("tref");
        Assert.assertEquals((Object)"tref", (Object)tm.getTermInfoRef());
        Assert.assertEquals((Object)"tref", (Object)tm.getRef());
        Assert.assertNull((Object)tm.getTermInfo());
        Assert.assertNull((Object)tm.getValue());
        tm.setTermInfo("tinfo");
        Assert.assertNull((Object)tm.getTermInfoRef());
        Assert.assertNull((Object)tm.getRef());
        Assert.assertEquals((Object)"tinfo", (Object)tm.getTermInfo());
        Assert.assertEquals((Object)"tinfo", (Object)tm.getValue());
        tm.setTermInfoRef("trefagain");
        Assert.assertEquals((Object)"trefagain", (Object)tm.getTermInfoRef());
        Assert.assertEquals((Object)"trefagain", (Object)tm.getRef());
        Assert.assertNull((Object)tm.getTermInfo());
        Assert.assertNull((Object)tm.getValue());
        tm.setValue("value");
        Assert.assertEquals((Object)"trefagain", (Object)tm.getTermInfoRef());
        Assert.assertEquals((Object)"trefagain", (Object)tm.getRef());
        Assert.assertEquals((Object)"value", (Object)tm.getTermInfo());
        Assert.assertEquals((Object)"value", (Object)tm.getValue());
        tm.setRef("ref");
        Assert.assertEquals((Object)"ref", (Object)tm.getTermInfoRef());
        Assert.assertEquals((Object)"ref", (Object)tm.getRef());
        Assert.assertEquals((Object)"value", (Object)tm.getTermInfo());
        Assert.assertEquals((Object)"value", (Object)tm.getValue());
    }

    @Test
    public void testNormalTermMarker() {
        String text = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file id=\"f1\">\n<unit id=\"id\">\n<segment>\n<source><mrk id=\"1\" type=\"term\" value=\"val\" ref=\"ref\">source</mrk></source>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        List<Event> events = U.getEvents(text);
        Unit unit = U.getUnit(events);
        MTag am = (MTag)unit.getPart(0).getSourceTags().get(U.kOA(0));
        Assert.assertEquals((Object)"term", (Object)am.getType());
        Assert.assertEquals((Object)"val", (Object)am.getValue());
        Assert.assertEquals((Object)"ref", (Object)am.getRef());
        Assert.assertTrue((boolean)(am instanceof TermTag));
        Assert.assertEquals((Object)text, (Object)U.writeEvents(events));
    }

    @Test
    public void testITSTermMarker() {
        String text = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file id=\"f1\" its:annotatorsRef=\"terminology|abc\">\n<unit id=\"id\">\n<segment>\n<source><mrk id=\"1\" type=\"term\" itsxlf:termConfidence=\"0.123\" value=\"val\" ref=\"ref\">source</mrk></source>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        List<Event> events = U.getEvents(text);
        Unit unit = U.getUnit(events);
        MTag am = (MTag)unit.getPart(0).getSourceTags().get(U.kOA(0));
        Assert.assertEquals((Object)"term", (Object)am.getType());
        Assert.assertEquals((Object)"val", (Object)am.getValue());
        Assert.assertEquals((Object)"ref", (Object)am.getRef());
        Assert.assertTrue((boolean)(am instanceof TermTag));
        Assert.assertEquals((double)0.123, (double)((TermTag)am).getTermConfidence(), (double)0.0);
        Assert.assertEquals((Object)"abc", (Object)((TermTag)am).getAnnotatorRef());
        TermTag tm = (TermTag)am;
        tm.setTermConfidence(Double.valueOf(0.987));
        tm.setAnnotatorRef("acme");
        String expected = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file id=\"f1\" its:annotatorsRef=\"terminology|abc\">\n<unit id=\"id\">\n<segment>\n<source><mrk id=\"1\" type=\"term\" value=\"val\" ref=\"ref\" itsxlf:termConfidence=\"0.987\" its:annotatorsRef=\"terminology|acme\">source</mrk></source>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        Assert.assertEquals((Object)expected, (Object)U.writeEvents(events));
        U.getEvents(expected);
    }

    @Test(expected=XLIFFReaderException.class)
    public void testHalfTermMarker() {
        String text = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file id=\"f1\">\n<unit id=\"id\">\n<segment>\n<source>text and <sm id=\"1\" type=\"term\" value=\"val\" ref=\"ref\"/>term</source>\n</segment>\n<segment>\n<source> after.</source>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        U.getEvents(text);
    }

    @Test(expected=XLIFFException.class)
    public void testLoneEndTermMarker() {
        String text = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file id=\"f1\">\n<unit id=\"id\">\n<segment>\n<source>text <em startRef=\"1\"/></source>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        U.getEvents(text);
    }
}

