/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.its;

import java.util.List;
import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.XLIFFException;
import net.sf.okapi.lib.xliff2.core.MTag;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.its.MTConfidence;
import net.sf.okapi.lib.xliff2.reader.Event;
import net.sf.okapi.lib.xliff2.test.U;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MTConfidenceTest {
    @Test(expected=XLIFFException.class)
    public void testMTConfidenceMissingAnnotatorRef() {
        MTConfidence mtc = new MTConfidence();
        mtc.setMtConfidence(Double.valueOf(0.5));
        mtc.validate();
    }

    @Test(expected=InvalidParameterException.class)
    public void testMTConfidenceInvalidConfidence() {
        MTConfidence mtc = new MTConfidence();
        mtc.setMtConfidence(Double.valueOf(1.234));
    }

    @Test
    public void testMTConfidenceCanNullifyConfidence() {
        MTConfidence mtc = new MTConfidence();
        mtc.setMtConfidence(Double.valueOf(0.5));
        mtc.setMtConfidence(null);
    }

    @Test
    public void testNormalCreation() {
        MTConfidence mtc = new MTConfidence("anno", 0.5);
        Assert.assertEquals((Object)"anno", (Object)mtc.getAnnotatorRef());
        Assert.assertEquals((double)0.5, (double)mtc.getMtConfidence(), (double)0.0);
    }

    @Test
    public void testMTConfidence() {
        String text = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file id=\"f1\">\n<unit id=\"id\" its:annotatorsRef=\"mt-confidence|myTool\">\n<segment>\n<source>source</source>\n<target><mrk id=\"1\" type=\"its:any\" its:mtConfidence=\"0.321\">source</mrk></target>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        List<Event> events = U.getEvents(text);
        Unit unit = U.getUnit(events);
        MTag am = (MTag)unit.getPart(0).getTargetTags().get(U.kOA(0));
        Assert.assertEquals((double)0.321, (double)((MTConfidence)am.getITSItems().get(MTConfidence.class)).getMtConfidence(), (double)0.0);
        Assert.assertEquals((Object)text, (Object)U.writeEvents(events));
    }
}

