/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.its;

import java.util.List;
import net.sf.okapi.lib.xliff2.XLIFFException;
import net.sf.okapi.lib.xliff2.core.MTag;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.its.IITSItem;
import net.sf.okapi.lib.xliff2.its.ITSItems;
import net.sf.okapi.lib.xliff2.its.LocQualityIssue;
import net.sf.okapi.lib.xliff2.its.LocQualityIssues;
import net.sf.okapi.lib.xliff2.reader.Event;
import net.sf.okapi.lib.xliff2.test.U;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class LocQualityIssueTest {
    @Test
    public void testSimplestValid() {
        LocQualityIssue lqi = new LocQualityIssue();
        lqi.setType("grammar");
        lqi.validate();
        lqi = new LocQualityIssue();
        lqi.setComment("some comment");
        lqi.validate();
    }

    @Test(expected=XLIFFException.class)
    public void testInvalid() {
        LocQualityIssue lqi = new LocQualityIssue();
        lqi.validate();
    }

    @Test
    public void testLQIReference() {
        String text = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file id=\"f1\">\n<unit id=\"id\">\n<its:locQualityIssues xml:id=\"lq1\">\n <its:locQualityIssue locQualityIssueComment=\"comment1\"/>\n <its:locQualityIssue locQualityIssueComment=\"comment2\"/>\n</its:locQualityIssues>\n<segment>\n<source><mrk id=\"1\" type=\"its:any\" its:locQualityIssuesRef=\"#its=lq1\">source</mrk></source>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        List<Event> events = U.getEvents(text);
        Unit unit = U.getUnit(events);
        MTag am = (MTag)unit.getPart(0).getSourceTags().get(U.kOA(0));
        ITSItems items = am.getITSItems();
        IITSItem item = items.get(LocQualityIssue.class);
        Assert.assertTrue((boolean)item.isGroup());
        LocQualityIssues issues = (LocQualityIssues)item;
        LocQualityIssue lqi = (LocQualityIssue)issues.getList().get(1);
        Assert.assertEquals((Object)"comment2", (Object)lqi.getComment());
        Assert.assertEquals((Object)text, (Object)U.writeEvents(events));
    }

    @Test
    public void testInlineLQI() {
        String text = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file id=\"f1\">\n<unit id=\"id\">\n<segment>\n<source><mrk id=\"1\" type=\"its:any\" its:locQualityIssueType=\"other\" its:locQualityIssueComment=\"comment\" its:locQualityIssueEnabled=\"no\" its:locQualityIssueSeverity=\"12.345678\" its:locQualityIssueProfileRef=\"profile\">source</mrk></source>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        List<Event> events = U.getEvents(text);
        Unit unit = U.getUnit(events);
        MTag am = (MTag)unit.getPart(0).getSourceTags().get(U.kOA(0));
        LocQualityIssue lqi = (LocQualityIssue)am.getITSItems().get(LocQualityIssue.class);
        Assert.assertEquals((Object)"other", (Object)lqi.getType());
        Assert.assertEquals((Object)"comment", (Object)lqi.getComment());
        Assert.assertFalse((boolean)lqi.isEnabled());
        Assert.assertEquals((double)12.345678, (double)lqi.getSeverity(), (double)0.0);
        Assert.assertEquals((Object)"profile", (Object)lqi.getProfileRef());
        Assert.assertEquals((Object)text, (Object)U.writeEvents(events));
    }

    @Test
    public void testAddition() {
        String text = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file id=\"f1\">\n<unit id=\"id\">\n<segment>\n<source><mrk id=\"1\" type=\"its:any\" its:locQualityIssueType=\"other\" its:locQualityIssueComment=\"comment\" its:locQualityIssueEnabled=\"no\" its:locQualityIssueSeverity=\"12.345678\" its:locQualityIssueProfileRef=\"profile\">source</mrk></source>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        List<Event> events = U.getEvents(text);
        Unit unit = U.getUnit(events);
        MTag am = (MTag)unit.getPart(0).getSourceTags().get(U.kOA(0));
        ITSItems items = am.getITSItems();
        LocQualityIssue lqi1 = (LocQualityIssue)items.get(LocQualityIssue.class);
        Assert.assertEquals((Object)"other", (Object)lqi1.getType());
        LocQualityIssue lqi2 = new LocQualityIssue();
        lqi2.setType("grammar");
        lqi2.setComment("new item");
        items.add((IITSItem)lqi2);
        LocQualityIssues issues = (LocQualityIssues)items.get(LocQualityIssue.class);
        Assert.assertNotNull((Object)issues.getGroupId());
        issues.setGroupId("newLqi");
        Assert.assertEquals((long)1L, (long)items.size());
        Assert.assertEquals((long)2L, (long)issues.getList().size());
        LocQualityIssue lqi1new = (LocQualityIssue)issues.getList().get(0);
        Assert.assertTrue((lqi1 == lqi1new ? 1 : 0) != 0);
        LocQualityIssue lqi2new = (LocQualityIssue)issues.getList().get(1);
        Assert.assertTrue((lqi2 == lqi2new ? 1 : 0) != 0);
        LocQualityIssue lqi3 = new LocQualityIssue();
        lqi3.setType("mistranslation");
        lqi3.setSeverity(99.99);
        items.add((IITSItem)lqi3);
        Assert.assertEquals((long)1L, (long)items.size());
        Assert.assertEquals((long)3L, (long)issues.getList().size());
        lqi1new = (LocQualityIssue)issues.getList().get(0);
        Assert.assertTrue((lqi1 == lqi1new ? 1 : 0) != 0);
        lqi2new = (LocQualityIssue)issues.getList().get(1);
        Assert.assertTrue((lqi2 == lqi2new ? 1 : 0) != 0);
        LocQualityIssue lqi3new = (LocQualityIssue)issues.getList().get(2);
        Assert.assertTrue((lqi3 == lqi3new ? 1 : 0) != 0);
        String expected = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file id=\"f1\">\n<unit id=\"id\">\n<its:locQualityIssues xml:id=\"newLqi\">\n <its:locQualityIssue locQualityIssueType=\"other\" locQualityIssueComment=\"comment\" locQualityIssueEnabled=\"no\" locQualityIssueSeverity=\"12.345678\" locQualityIssueProfileRef=\"profile\"/>\n <its:locQualityIssue locQualityIssueType=\"grammar\" locQualityIssueComment=\"new item\"/>\n <its:locQualityIssue locQualityIssueType=\"mistranslation\" locQualityIssueSeverity=\"99.99\"/>\n</its:locQualityIssues>\n<segment>\n<source><mrk id=\"1\" type=\"its:any\" its:locQualityIssuesRef=\"#its=newLqi\">source</mrk></source>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        Assert.assertEquals((Object)expected, (Object)U.writeEvents(events));
    }

    @Test
    public void testRemove() {
        ITSItems items = new ITSItems();
        LocQualityIssue lqi1 = new LocQualityIssue("c1");
        items.add((IITSItem)lqi1);
        LocQualityIssue lqi2 = new LocQualityIssue("c2");
        items.add((IITSItem)lqi2);
        LocQualityIssue lqi3 = new LocQualityIssue("c3");
        items.add((IITSItem)lqi3);
        LocQualityIssues issues = (LocQualityIssues)items.get(LocQualityIssue.class);
        Assert.assertEquals((long)3L, (long)issues.getList().size());
        Assert.assertEquals((long)1L, (long)items.size());
        items.remove((IITSItem)lqi2);
        Assert.assertEquals((long)2L, (long)issues.getList().size());
        Assert.assertEquals((long)1L, (long)items.size());
        Assert.assertEquals((Object)"c1", (Object)((LocQualityIssue)issues.getList().get(0)).getComment());
        Assert.assertEquals((Object)"c3", (Object)((LocQualityIssue)issues.getList().get(1)).getComment());
        items.remove((IITSItem)issues);
        Assert.assertTrue((boolean)items.isEmpty());
    }
}

