/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.its;

import java.util.List;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.MTag;
import net.sf.okapi.lib.xliff2.core.Part;
import net.sf.okapi.lib.xliff2.core.Segment;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.its.Domain;
import net.sf.okapi.lib.xliff2.its.IITSItem;
import net.sf.okapi.lib.xliff2.its.ITSWriter;
import net.sf.okapi.lib.xliff2.its.LocQualityIssue;
import net.sf.okapi.lib.xliff2.its.MTConfidence;
import net.sf.okapi.lib.xliff2.its.Provenance;
import net.sf.okapi.lib.xliff2.reader.Event;
import net.sf.okapi.lib.xliff2.test.U;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ITSWriterTest {
    @Test
    public void testAnnotate() {
        Unit unit = new Unit("id");
        unit.appendSegment();
        Fragment frag = unit.getPart(0).getSource();
        frag.append((CharSequence)"Some text");
        IITSItem item = ITSWriter.annotate((Fragment)frag, (int)0, (int)-1, (IITSItem)new LocQualityIssue("comment"));
        Assert.assertNotNull((Object)item);
        MTag am = (MTag)frag.getStore().getSourceTags().get(U.kOA(0));
        Assert.assertNotNull((Object)am);
        IITSItem res = am.getITSItems().get(LocQualityIssue.class);
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((Object)"comment", (Object)((LocQualityIssue)res).getComment());
        Assert.assertEquals((Object)"{oA}Some text{cA}", (Object)U.fmtMarkers(frag.getCodedText()));
    }

    @Test
    public void testAnnotateTwice() {
        Unit unit = new Unit("id");
        unit.appendSegment().setSource("some text");
        Fragment frag = unit.getPart(0).getTarget(Part.GetTarget.CLONE_SOURCE);
        Provenance prov = new Provenance();
        prov.setPerson("John Dow");
        prov.setRevPerson("John Smith");
        ITSWriter.annotate((Fragment)frag, (int)0, (int)-1, (IITSItem)prov);
        ITSWriter.annotate((Fragment)frag, (int)0, (int)-1, (IITSItem)new LocQualityIssue("bad spelling"), (String)"its:any");
        String xliff = frag.toXLIFF();
        Assert.assertTrue((boolean)xliff.contains("type=\"its:any\""));
        Assert.assertTrue((boolean)xliff.contains("its:locQualityIssueComment=\"bad spelling\""));
        Assert.assertTrue((boolean)xliff.contains("its:person=\"John Dow\""));
        Assert.assertTrue((boolean)xliff.contains("its:revPerson=\"John Smith\""));
        Assert.assertTrue((boolean)xliff.contains(">some text</"));
    }

    @Test
    public void testAnnotateOverlapping() {
        Unit unit = new Unit("id");
        unit.appendSegment().setSource("some shared text");
        Fragment frag = unit.getPart(0).getTarget(Part.GetTarget.CLONE_SOURCE);
        ITSWriter.annotate((Fragment)frag, (int)0, (int)11, (IITSItem)new LocQualityIssue("Issue 1"));
        ITSWriter.annotate((Fragment)frag, (int)7, (int)-1, (IITSItem)new LocQualityIssue("Issue 2"), (String)"its:any");
        Assert.assertEquals((Object)"<sm id=\"1\" type=\"its:any\" its:locQualityIssueComment=\"Issue 1\"/>some <sm id=\"2\" type=\"its:any\" its:locQualityIssueComment=\"Issue 2\"/>shared<em startRef=\"1\"/> text<em startRef=\"2\"/>", (Object)frag.toXLIFF());
    }

    @Test
    public void testAnnotateAll() {
        Unit unit = new Unit("id");
        unit.appendSegment();
        Fragment frag = unit.getPart(0).getSource();
        frag.append((CharSequence)"Some text");
        for (Segment seg : unit.getSegments()) {
            seg.setTarget("DU TEXTE");
            ITSWriter.annotate((Fragment)seg.getTarget(), (int)0, (int)-1, (IITSItem)new MTConfidence("myAnnotator", 0.5), (String)"its:any");
            Assert.assertEquals((Object)"{oA}DU TEXTE{cA}", (Object)U.fmtMarkers(seg.getTarget().getCodedText()));
        }
    }

    @Test
    public void testWriteVariousDC() {
        String text = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file id=\"f1\">\n<unit id=\"id\" its:annotatorsRef=\"mt-confidence|myTool\" itsxlf:domains=\"dom1\">\n<segment>\n<source>source</source>\n<target><mrk id=\"1\" type=\"its:any\" its:mtConfidence=\"0.321\">source</mrk></target>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        List<Event> events = U.getEvents(text);
        Unit unit = U.getUnit(events);
        Domain dom = (Domain)unit.getITSItems().get(Domain.class);
        Assert.assertEquals((Object)"dom1", (Object)dom.getDomain());
        dom.setDomain("newDom");
        MTag am = (MTag)unit.getPart(0).getTargetTags().get(U.kOA(0));
        Assert.assertEquals((double)0.321, (double)((MTConfidence)am.getITSItems().get(MTConfidence.class)).getMtConfidence(), (double)0.0);
        String expected = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file id=\"f1\">\n<unit id=\"id\" itsxlf:domains=\"newDom\" its:annotatorsRef=\"mt-confidence|myTool\">\n<segment>\n<source>source</source>\n<target><mrk id=\"1\" type=\"its:any\" its:mtConfidence=\"0.321\">source</mrk></target>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        Assert.assertEquals((Object)expected, (Object)U.writeEvents(events));
    }
}

