/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.its;

import java.io.File;
import java.util.List;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.lib.xliff2.core.AnnotatedSpan;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.document.XLIFFDocument;
import net.sf.okapi.lib.xliff2.its.Domain;
import net.sf.okapi.lib.xliff2.its.IITSItem;
import net.sf.okapi.lib.xliff2.its.ITSWriter;
import net.sf.okapi.lib.xliff2.its.LocQualityIssue;
import net.sf.okapi.lib.xliff2.its.LocQualityIssues;
import net.sf.okapi.lib.xliff2.its.MTConfidence;
import net.sf.okapi.lib.xliff2.its.Provenance;
import net.sf.okapi.lib.xliff2.its.Provenances;
import net.sf.okapi.lib.xliff2.its.TermTag;
import net.sf.okapi.lib.xliff2.its.TextAnalysis;
import net.sf.okapi.lib.xliff2.matches.Match;
import net.sf.okapi.lib.xliff2.matches.Matches;
import net.sf.okapi.lib.xliff2.test.U;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GeneralTest {
    private FileLocation root = FileLocation.fromClass(GeneralTest.class);

    @Test
    public void testTranslate() {
        XLIFFDocument doc = this.load("translate.xlf");
        Unit unit = doc.getUnitNode("f1", "u1").get();
        Assert.assertFalse((boolean)unit.getTranslate());
        unit.setTranslate(true);
        unit = doc.getUnitNode("f1", "u2").get();
        Assert.assertTrue((boolean)unit.getTranslate());
        Fragment frag = unit.getSegment(0).getSource();
        Assert.assertEquals((Object)"Text {oA}DATA {oA}text {cA}DATA {cA} text.", (Object)U.fmtMarkers(frag.getCodedText()));
        unit.hideProtectedContent();
        Assert.assertEquals((Object)"Text {$}{oA}text {cA}{$} text.", (Object)U.fmtMarkers(frag.getCodedText()));
        unit.showProtectedContent();
        Assert.assertEquals((Object)"Text {oA}DATA {oA}text {cA}DATA {cA} text.", (Object)U.fmtMarkers(frag.getCodedText()));
        doc = this.saveAndReload(doc);
        unit = doc.getUnitNode("f1", "u1").get();
        Assert.assertTrue((boolean)unit.getTranslate());
    }

    @Test
    public void testTerminology() {
        XLIFFDocument doc = this.load("terminology.xlf");
        Unit unit = doc.getUnitNode("f1", "u1").get();
        Assert.assertEquals((Object)"myTool", (Object)unit.getAnnotatorsRef().get("terminology"));
        List spans = unit.getAnnotatedSpans(false);
        Assert.assertEquals((long)5L, (long)spans.size());
        TermTag tm = (TermTag)((AnnotatedSpan)spans.get(0)).getMarker();
        Assert.assertEquals((Object)"m1", (Object)tm.getId());
        Assert.assertTrue((boolean)tm.isTerm());
        Assert.assertEquals((Object)"myTool", (Object)tm.getAnnotatorRef());
        tm = (TermTag)((AnnotatedSpan)spans.get(1)).getMarker();
        Assert.assertEquals((Object)"m2", (Object)tm.getId());
        Assert.assertFalse((boolean)tm.isTerm());
        Assert.assertEquals((Object)"myTool", (Object)tm.getAnnotatorRef());
        tm = (TermTag)((AnnotatedSpan)spans.get(2)).getMarker();
        Assert.assertEquals((Object)"m3", (Object)tm.getId());
        Assert.assertEquals((Object)"http://en.wikipedia.org/wiki/Bilberry", (Object)tm.getRef());
        Assert.assertEquals((Object)"myTool", (Object)tm.getAnnotatorRef());
        tm = (TermTag)((AnnotatedSpan)spans.get(3)).getMarker();
        Assert.assertEquals((Object)"m4", (Object)tm.getId());
        Assert.assertEquals((double)0.9, (double)tm.getTermConfidence(), (double)0.0);
        Assert.assertEquals((Object)"anotherTool", (Object)tm.getAnnotatorRef());
        Assert.assertEquals((Object)"squashberry", (Object)((AnnotatedSpan)spans.get(3)).getPlainText());
        tm = (TermTag)((AnnotatedSpan)spans.get(4)).getMarker();
        Assert.assertEquals((Object)"m5", (Object)tm.getId());
        Assert.assertEquals((Object)"The exact kind of man needed for a specific purpose", (Object)tm.getValue());
        Assert.assertEquals((Object)"myTool", (Object)tm.getAnnotatorRef());
        Assert.assertEquals((Object)"huckleberry", (Object)((AnnotatedSpan)spans.get(4)).getPlainText());
        tm.setRef("http://dbpedia.org/page/Huckleberry");
        tm.setValue(null);
        tm.setAnnotatorRef("newTool");
        doc = this.saveAndReload(doc);
        unit = doc.getUnitNode("f1", "u1").get();
        spans = unit.getAnnotatedSpans(false);
        tm = (TermTag)((AnnotatedSpan)spans.get(4)).getMarker();
        Assert.assertEquals((Object)"m5", (Object)tm.getId());
        Assert.assertNull((Object)tm.getValue());
        Assert.assertEquals((Object)"newTool", (Object)tm.getAnnotatorRef());
        Assert.assertEquals((Object)"http://dbpedia.org/page/Huckleberry", (Object)tm.getRef());
    }

    @Test
    public void testDomain() {
        XLIFFDocument doc = this.load("domain.xlf");
        Unit unit = doc.getUnitNode("f1", "u1").get();
        Domain dc1 = (Domain)unit.getITSItems().get("domain");
        Assert.assertEquals((Object)"travel", (Object)dc1.getDomain());
        Assert.assertEquals((Object)"myTool", (Object)dc1.getAnnotatorRef());
        List list = unit.getAnnotatedSpans(false);
        Domain dc2 = (Domain)((AnnotatedSpan)list.get(0)).getMarker().getITSItems().get(Domain.class);
        Assert.assertEquals((Object)"software", (Object)dc2.getDomain());
        Assert.assertEquals((Object)"myTool", (Object)dc2.getAnnotatorRef());
        dc1.setDomain("newDomain");
        dc1.setAnnotatorRef("newTool");
        dc2.setDomain("newDomainMrk");
        dc2.setAnnotatorRef("newToolMrk");
        doc = this.saveAndReload(doc);
        unit = doc.getUnitNode("f1", "u1").get();
        dc1 = (Domain)unit.getITSItems().get("domain");
        Assert.assertEquals((Object)"newDomain", (Object)dc1.getDomain());
        Assert.assertEquals((Object)"newTool", (Object)dc1.getAnnotatorRef());
        list = unit.getAnnotatedSpans(false);
        dc2 = (Domain)((AnnotatedSpan)list.get(0)).getMarker().getITSItems().get(Domain.class);
        Assert.assertEquals((Object)"newDomainMrk", (Object)dc2.getDomain());
        Assert.assertEquals((Object)"newToolMrk", (Object)dc2.getAnnotatorRef());
    }

    @Test
    public void testTextAnalysis() {
        XLIFFDocument doc = this.load("text-analysis.xlf");
        Unit unit = doc.getUnitNode("f1", "u1").get();
        List spans = unit.getAnnotatedSpans(false);
        TextAnalysis ta = (TextAnalysis)((AnnotatedSpan)spans.get(0)).getMarker().getITSItems().get(TextAnalysis.class);
        Assert.assertEquals((Object)"myTool", (Object)ta.getAnnotatorRef());
        Assert.assertEquals((Object)"http://nerd.eurecom.fr/ontology#Place", (Object)ta.getTaClassRef());
        Assert.assertEquals((Object)"http://dbpedia.org/resource/Arizona", (Object)ta.getTaIdentRef());
        Assert.assertEquals((double)0.8, (double)ta.getTaConfidence(), (double)0.0);
        ta.setTaIdentRef("http://www.wikidata.org/wiki/Q816");
        ta.setAnnotatorRef("newTool");
        Fragment frag = unit.getSegment(0).getSource();
        ta = (TextAnalysis)ITSWriter.annotate((Fragment)frag, (int)22, (int)29, (IITSItem)new TextAnalysis());
        ta.setAnnotatorRef("newTool");
        ta.setTaIdent("301467919");
        ta.setTaSource("Wordnet3.0");
        ta.setTaConfidence(Double.valueOf(0.7));
        doc = this.saveAndReload(doc);
        unit = doc.getUnitNode("f1", "u1").get();
        spans = unit.getAnnotatedSpans(false);
        ta = (TextAnalysis)((AnnotatedSpan)spans.get(0)).getMarker().getITSItems().get(TextAnalysis.class);
        Assert.assertEquals((Object)"newTool", (Object)ta.getAnnotatorRef());
        Assert.assertEquals((Object)"http://www.wikidata.org/wiki/Q816", (Object)ta.getTaIdentRef());
        ta = (TextAnalysis)((AnnotatedSpan)spans.get(1)).getMarker().getITSItems().get(TextAnalysis.class);
        Assert.assertEquals((Object)"newTool", (Object)ta.getAnnotatorRef());
        Assert.assertEquals((Object)"301467919", (Object)ta.getTaIdent());
        Assert.assertEquals((Object)"Wordnet3.0", (Object)ta.getTaSource());
        Assert.assertEquals((double)0.7, (double)ta.getTaConfidence(), (double)0.0);
    }

    @Test
    public void testProvenance() {
        XLIFFDocument doc = this.load("provenance.xlf");
        Unit unit = doc.getUnitNode("f1", "u1").get();
        Provenance prov = (Provenance)unit.getITSItems().get("provenance");
        Assert.assertEquals((Object)"Gladys Overwith", (Object)prov.getPerson());
        Assert.assertEquals((Object)"Kent B. Goode", (Object)prov.getRevPerson());
        Assert.assertEquals((Object)"myTool", (Object)prov.getAnnotatorRef());
        unit = doc.getUnitNode("f1", "u2").get();
        Provenances provs = (Provenances)unit.getITSItems().get("provenance");
        Assert.assertEquals((Object)"prov1", (Object)provs.getGroupId());
        prov = (Provenance)provs.getList().get(0);
        Assert.assertEquals((Object)"Justin Kase", (Object)prov.getPerson());
        Assert.assertEquals((Object)"someTool", (Object)prov.getTool());
        Assert.assertEquals((Object)"someAnnotator", (Object)prov.getAnnotatorRef());
        prov = (Provenance)provs.getList().get(1);
        Assert.assertEquals((Object)"Dusty Rhodes", (Object)prov.getRevPerson());
        Assert.assertEquals((Object)"anotherTool", (Object)prov.getRevTool());
        Assert.assertEquals((Object)"anotherAnnotator", (Object)prov.getAnnotatorRef());
        unit = doc.getUnitNode("f1", "u3").get();
        List spans = unit.getAnnotatedSpans(true);
        prov = (Provenance)((AnnotatedSpan)spans.get(0)).getMarker().getITSItems().get(Provenance.class);
        Assert.assertEquals((Object)"someOrg", (Object)prov.getOrg());
        Assert.assertEquals((Object)"someRevOrg", (Object)prov.getRevOrg());
        Assert.assertEquals((Object)"anAnnotator", (Object)prov.getAnnotatorRef());
        provs = (Provenances)((AnnotatedSpan)spans.get(1)).getMarker().getITSItems().get(Provenance.class);
        Assert.assertEquals((Object)"prov2", (Object)provs.getGroupId());
        prov = (Provenance)provs.getList().get(0);
        Assert.assertEquals((Object)"Turner Luce", (Object)prov.getPerson());
        Assert.assertEquals((Object)"http://www.omegat.org/", (Object)prov.getToolRef());
        prov = (Provenance)provs.getList().get(1);
        Assert.assertEquals((Object)"Hugo First", (Object)prov.getRevPerson());
        Assert.assertEquals((Object)"http://virtaal.translatehouse.org/", (Object)prov.getRevToolRef());
        Assert.assertEquals((Object)"anAnnotator", (Object)prov.getAnnotatorRef());
        doc = this.saveAndReload(doc);
        unit = doc.getUnitNode("f1", "u1").get();
    }

    @Test
    public void testLocalizationQualityIssue() {
        XLIFFDocument doc = this.load("localization-quality-issue.xlf");
        Unit unit = doc.getUnitNode("f1", "u1").get();
        List spans = unit.getAnnotatedSpans(true);
        LocQualityIssue lqi = (LocQualityIssue)((AnnotatedSpan)spans.get(0)).getMarker().getITSItems().get("localization-quality-issue");
        Assert.assertEquals((Object)"misspelling", (Object)lqi.getType());
        Assert.assertEquals((Object)"'c'es' is unknown. Could be 'c'est'", (Object)lqi.getComment());
        Assert.assertEquals((double)50.0, (double)lqi.getSeverity(), (double)0.0);
        Assert.assertEquals((Object)"someAnnotator", (Object)lqi.getAnnotatorRef());
        unit = doc.getUnitNode("f1", "u2").get();
        spans = unit.getAnnotatedSpans(true);
        LocQualityIssues lqis = (LocQualityIssues)((AnnotatedSpan)spans.get(0)).getMarker().getITSItems().get("localization-quality-issue");
        Assert.assertEquals((Object)"lqi1", (Object)lqis.getGroupId());
        lqi = (LocQualityIssue)lqis.getList().get(0);
        Assert.assertEquals((Object)"misspelling", (Object)lqi.getType());
        Assert.assertEquals((Object)"'c'es' is unknown. Could be 'c'est'", (Object)lqi.getComment());
        Assert.assertEquals((double)50.0, (double)lqi.getSeverity(), (double)0.0);
        Assert.assertNull((Object)lqi.getAnnotatorRef());
        lqi = (LocQualityIssue)lqis.getList().get(1);
        Assert.assertEquals((Object)"grammar", (Object)lqi.getType());
        Assert.assertEquals((Object)"Sentence is not capitalized", (Object)lqi.getComment());
        Assert.assertEquals((double)20.0, (double)lqi.getSeverity(), (double)0.0);
        Assert.assertNull((Object)lqi.getAnnotatorRef());
        lqis.getList().remove(0);
        lqi.setAnnotatorRef("newTool");
        doc = this.saveAndReload(doc);
        unit = doc.getUnitNode("f1", "u2").get();
        spans = unit.getAnnotatedSpans(true);
        lqis = (LocQualityIssues)((AnnotatedSpan)spans.get(0)).getMarker().getITSItems().get("localization-quality-issue");
        lqi = (LocQualityIssue)lqis.getList().get(0);
        Assert.assertEquals((long)1L, (long)lqis.getList().size());
        Assert.assertEquals((Object)"grammar", (Object)lqi.getType());
        Assert.assertEquals((Object)"Sentence is not capitalized", (Object)lqi.getComment());
        Assert.assertEquals((double)20.0, (double)lqi.getSeverity(), (double)0.0);
    }

    @Test
    public void testMTConfidence() {
        XLIFFDocument doc = this.load("mt-confidence.xlf");
        Unit unit = doc.getUnitNode("f1", "u1").get();
        Matches matches = unit.getMatches();
        Match match = (Match)matches.get(0);
        Assert.assertEquals((double)89.82, (double)match.getMatchQuality(), (double)0.0);
        Assert.assertEquals((Object)"MTServices-XYZ", (Object)match.getAnnotatorRef());
        match = (Match)matches.get(1);
        Assert.assertEquals((double)67.8, (double)match.getMatchQuality(), (double)0.0);
        Assert.assertEquals((Object)"MTProvider-ABC", (Object)match.getAnnotatorRef());
        match = (Match)matches.get(2);
        Assert.assertEquals((double)65.0, (double)match.getMatchQuality(), (double)0.0);
        Assert.assertEquals((Object)"MTProvider-JKL", (Object)match.getAnnotatorRef());
        match = (Match)matches.get(3);
        Assert.assertEquals((double)89.82, (double)match.getMatchQuality(), (double)0.0);
        Assert.assertEquals((Object)"MTServices-XYZ", (Object)match.getAnnotatorRef());
        unit = doc.getUnitNode("f1", "u2").get();
        List spans = unit.getAnnotatedSpans(true);
        MTConfidence mtc = (MTConfidence)((AnnotatedSpan)spans.get(0)).getMarker().getITSItems().get("mt-confidence");
        Assert.assertEquals((Object)"MTServices-XYZ", (Object)mtc.getAnnotatorRef());
        Assert.assertEquals((double)0.8982, (double)mtc.getMtConfidence(), (double)0.0);
        match = new Match();
        match.setSource(new Fragment(match.getStore(), false, "source"));
        match.setTarget(new Fragment(match.getStore(), true, "target"));
        match.setAnnoatorRef("newTool");
        match.setMTConfidence(Double.valueOf(0.9));
        Match.annotate((Fragment)unit.getSegment(0).getSource(), (int)0, (int)-1, (Match)match);
        mtc.setAnnotatorRef("newTool");
        mtc.setMtConfidence(Double.valueOf(1.0));
        doc = this.saveAndReload(doc);
        unit = doc.getUnitNode("f1", "u2").get();
        spans = unit.getAnnotatedSpans(true);
        mtc = (MTConfidence)((AnnotatedSpan)spans.get(0)).getMarker().getITSItems().get("mt-confidence");
        Assert.assertEquals((double)1.0, (double)mtc.getMtConfidence(), (double)0.0);
        Assert.assertEquals((Object)"newTool", (Object)mtc.getAnnotatorRef());
        match = (Match)unit.getMatches().get(0);
        Assert.assertEquals((Object)"newTool", (Object)match.getAnnotatorRef());
        Assert.assertEquals((double)0.9, (double)match.getMTConfidence(), (double)0.0);
        Assert.assertEquals((double)90.0, (double)match.getMatchQuality(), (double)0.0);
    }

    private XLIFFDocument load(String filename) {
        File file = this.root.in("/valid/its/" + filename).asFile();
        XLIFFDocument doc = new XLIFFDocument();
        doc.load(file);
        return doc;
    }

    private XLIFFDocument saveAndReload(XLIFFDocument doc) {
        File out = this.root.out(doc.getFile().getName()).asFile();
        doc.saveAs(out);
        XLIFFDocument newDoc = new XLIFFDocument();
        newDoc.load(out);
        return newDoc;
    }
}

