/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.Part;
import net.sf.okapi.lib.xliff2.core.Segment;
import net.sf.okapi.lib.xliff2.core.TagType;
import net.sf.okapi.lib.xliff2.core.Unit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PartTest {
    @Test
    public void testRemoveAnnotations() {
        Unit unit = new Unit("u1");
        Part part = unit.appendIgnorable();
        Fragment srcFrag = part.getSource();
        srcFrag.openMarkerSpan("m1", "comment").setValue("sc1");
        srcFrag.append((CharSequence)"s1");
        srcFrag.closeMarkerSpan("m1");
        Fragment trgFrag = part.getTarget(Part.GetTarget.CREATE_EMPTY);
        trgFrag.openMarkerSpan("m2", "comment").setValue("tc1");
        trgFrag.append((CharSequence)"s1");
        trgFrag.closeMarkerSpan("m2");
        trgFrag.annotate(0, -1, "my:type", "value", null);
        part.removeMarkers(false, null);
        Assert.assertFalse((boolean)part.getSource().hasTag());
        part.removeMarkers(true, "my:type");
        Assert.assertEquals((long)2L, (long)part.getSource().getStore().getTargetTags().size());
    }

    @Test
    public void testCreateTargetClone() {
        Unit unit = new Unit("u1");
        Segment part = unit.appendSegment();
        Fragment frag = part.getSource();
        frag.append((CharSequence)"t1");
        frag.append(TagType.OPENING, "c1", "[z]", true);
        frag.append((CharSequence)"t2");
        frag.append(TagType.CLOSING, "c1", "[/z]", true);
        part = unit.appendSegment();
        frag = part.getSource();
        frag.append((CharSequence)"t3");
        frag.append(TagType.OPENING, "c2", "[x]", false);
        frag.append((CharSequence)"t4");
        frag.append(TagType.CLOSING, "c2", "[/x]", false);
        Fragment trgFrag = part.getTarget(Part.GetTarget.CLONE_SOURCE);
        Assert.assertEquals((Object)"t3<pc id=\"c2\">t4</pc>", (Object)trgFrag.toXLIFF());
    }

    @Test
    public void testGetId() {
        Unit unit = new Unit("u1");
        unit.appendSegment().setId("s1");
        unit.appendSegment().setId("s3");
        Segment part = unit.appendSegment();
        Assert.assertNull((Object)part.getId());
        Assert.assertNull((Object)part.getId(false));
        Assert.assertEquals((Object)"s2", (Object)part.getId(true));
        part = unit.appendSegment();
        Assert.assertEquals((Object)"s4", (Object)part.getId(true));
    }
}

