/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.core.Directionality;
import net.sf.okapi.lib.xliff2.core.StartGroupData;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GroupDataTest {
    @Test
    public void testDefaults() {
        StartGroupData sgd = new StartGroupData("id1");
        Assert.assertEquals((Object)"id1", (Object)sgd.getId());
        Assert.assertTrue((boolean)sgd.getCanResegment());
        Assert.assertTrue((boolean)sgd.getTranslate());
        Assert.assertNull((Object)sgd.getName());
        Assert.assertNull((Object)sgd.getType());
        Assert.assertEquals((Object)Directionality.AUTO, (Object)sgd.getSourceDir());
        Assert.assertEquals((Object)Directionality.AUTO, (Object)sgd.getTargetDir());
        Assert.assertTrue((boolean)sgd.getExtAttributes().isEmpty());
        Assert.assertEquals((long)0L, (long)sgd.getNoteCount());
        Assert.assertTrue((boolean)sgd.getExtElements().isEmpty());
    }

    @Test
    public void testChanges() {
        StartGroupData sgd = new StartGroupData("id1");
        sgd.setId("newId");
        Assert.assertEquals((Object)"newId", (Object)sgd.getId());
        sgd.setCanResegment(false);
        Assert.assertFalse((boolean)sgd.getCanResegment());
        sgd.setTranslate(false);
        Assert.assertFalse((boolean)sgd.getTranslate());
        sgd.setName("name");
        Assert.assertEquals((Object)"name", (Object)sgd.getName());
        sgd.setType("my:type");
        Assert.assertEquals((Object)"my:type", (Object)sgd.getType());
        sgd.setSourceDir(Directionality.RTL);
        Assert.assertEquals((Object)Directionality.RTL, (Object)sgd.getSourceDir());
        sgd.setTargetDir(Directionality.LTR);
        Assert.assertEquals((Object)Directionality.LTR, (Object)sgd.getTargetDir());
    }

    @Test(expected=InvalidParameterException.class)
    public void testInvalidTypeValue() {
        StartGroupData sgd = new StartGroupData("id");
        sgd.setType("badValue");
    }
}

