/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import java.lang.invoke.StringConcatFactory;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.okapi.lib.xliff2.Util;
import net.sf.okapi.lib.xliff2.core.AnnotatedSpan;
import net.sf.okapi.lib.xliff2.core.CTag;
import net.sf.okapi.lib.xliff2.core.CanReorder;
import net.sf.okapi.lib.xliff2.core.ExtAttribute;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.MTag;
import net.sf.okapi.lib.xliff2.core.Note;
import net.sf.okapi.lib.xliff2.core.PCont;
import net.sf.okapi.lib.xliff2.core.Part;
import net.sf.okapi.lib.xliff2.core.Tag;
import net.sf.okapi.lib.xliff2.core.TagType;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.its.AnnotatorsRef;
import net.sf.okapi.lib.xliff2.its.IITSItem;
import net.sf.okapi.lib.xliff2.its.ITSWriter;
import net.sf.okapi.lib.xliff2.its.MTConfidence;
import net.sf.okapi.lib.xliff2.its.TermTag;
import net.sf.okapi.lib.xliff2.reader.Event;
import net.sf.okapi.lib.xliff2.test.U;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
public class FragmentTest {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Test
    public void testSimpleFragment() {
        Fragment frag = new Fragment(new Unit("id").getStore(), false, "text");
        Assert.assertEquals((Object)"text", (Object)frag.toString());
        Assert.assertFalse((boolean)frag.isTarget());
    }

    @Test
    public void testSimpleTargetFragment() {
        Fragment frag = new Fragment(new Unit("id").getStore(), true);
        Assert.assertEquals((Object)"", (Object)frag.toString());
        Assert.assertTrue((boolean)frag.isTarget());
    }

    @Test
    public void testInterFragmentCopy() {
        Fragment frag1 = new Fragment(new Unit("u1").getStore(), false);
        frag1.appendCode("c1", "[A1/]");
        frag1.append((CharSequence)" aaa");
        Unit unit = new Unit("u2");
        Fragment frag2 = new Fragment(unit.getStore(), false);
        frag2.appendCode("c2", "[B1/]");
        frag2.append((CharSequence)" bbb ");
        Assert.assertEquals((long)1L, (long)frag2.getStore().getSourceTags().size());
        frag2.append(frag1);
        Assert.assertEquals((Object)"<ph id=\"c2\"/> bbb <ph id=\"c1\"/> aaa", (Object)frag2.toXLIFF());
        Assert.assertEquals((long)2L, (long)frag2.getStore().getSourceTags().size());
    }

    @Test
    public void testAppend() {
        Fragment frag = new Fragment(new Unit("id").getStore(), false, "text1");
        Assert.assertEquals((Object)"text1", (Object)frag.toString());
        frag.append((CharSequence)"text2");
        Assert.assertEquals((Object)"text1text2", (Object)frag.toString());
        frag.append('3');
        Assert.assertEquals((Object)"text1text23", (Object)frag.toString());
    }

    @Test
    public void testCloseAnnotation() {
        Fragment frag = new Fragment(new Unit("id").getStore(), false, "text1");
        MTag am = frag.openMarkerSpan("m1", "abc:ann");
        am.setRef("ref");
        am.setTranslate(Boolean.valueOf(false));
        am.setValue("val");
        frag.append((CharSequence)"tex");
        am = frag.closeMarkerSpan("m1");
        Assert.assertEquals((Object)"abc:ann", (Object)am.getType());
        Assert.assertEquals((Object)"ref", (Object)am.getRef());
        Assert.assertEquals((Object)"val", (Object)am.getValue());
        Assert.assertFalse((boolean)am.getTranslate());
    }

    @Test
    public void testCodesNoData() {
        Fragment frag = new Fragment(new Unit("id").getStore(), false);
        frag.append(TagType.OPENING, "1", "<elem atrr='&amp;'>", false);
        frag.append((CharSequence)"text");
        frag.append(TagType.CLOSING, "1", "</elem>", false);
        frag.appendCode("2", "<br/>");
        Assert.assertEquals((Object)"<pc id=\"1\">text</pc><ph id=\"2\"/>", (Object)frag.toXLIFF());
    }

    @Test
    public void testCodesNoDataNotWellFormed1() {
        Fragment frag = new Fragment(new Unit("id").getStore(), false);
        frag.append(TagType.OPENING, "1", "[o1]", true);
        frag.append((CharSequence)"t1");
        frag.append(TagType.OPENING, "2", "[o2]", true);
        frag.append((CharSequence)"t2");
        frag.append(TagType.CLOSING, "1", "[c1]", true);
        frag.appendCode("3", "<br/>");
        frag.append((CharSequence)"t3");
        frag.append(TagType.CLOSING, "2", "[c2]", true);
        Assert.assertEquals((Object)"<sc id=\"1\"/>t1<sc id=\"2\"/>t2<ec startRef=\"1\"/><ph id=\"3\"/>t3<ec startRef=\"2\"/>", (Object)frag.toXLIFF());
    }

    @Test
    public void testCodesNoDataNotWellFormed2() {
        Fragment frag = new Fragment(new Unit("id").getStore(), false);
        frag.append(TagType.OPENING, "1", "[o1]", true);
        frag.append((CharSequence)"t1");
        frag.append(TagType.OPENING, "2", "[o2]", true);
        frag.append((CharSequence)"t2");
        frag.append(TagType.OPENING, "3", "[o3]", true);
        frag.append((CharSequence)"t3");
        frag.append(TagType.CLOSING, "2", "[c2]", true);
        frag.append((CharSequence)"t4");
        frag.append(TagType.CLOSING, "3", "[c3]", true);
        frag.append((CharSequence)"t5");
        frag.append(TagType.CLOSING, "1", "[c1]", true);
        Assert.assertEquals((Object)"<pc id=\"1\" canOverlap=\"yes\">t1<sc id=\"2\"/>t2<sc id=\"3\"/>t3<ec startRef=\"2\"/>t4<ec startRef=\"3\"/>t5</pc>", (Object)frag.toXLIFF());
    }

    @Test
    public void testSimpleMarkers() {
        Fragment frag = new Fragment(new Unit("id").getStore(), false);
        MTag ann = frag.openMarkerSpan("a1", "comment");
        ann.setValue("my comment");
        frag.append((CharSequence)"t1 ");
        frag.closeMarkerSpan(ann.getId());
        frag.append((CharSequence)"t2.");
        Assert.assertEquals((Object)"<mrk id=\"a1\" type=\"comment\" value=\"my comment\">t1 </mrk>t2.", (Object)frag.toXLIFF());
    }

    @Test
    public void testAnnotate() {
        Fragment frag = new Fragment(new Unit("id").getStore(), false, "Word word.");
        frag.annotate(5, 9, "abc:type", "myValue", "myRef");
        Assert.assertEquals((Object)"Word <mrk id=\"1\" type=\"abc:type\" value=\"myValue\" ref=\"myRef\">word</mrk>.", (Object)frag.toXLIFF());
    }

    @Test
    public void testAnnotateUsingANote() {
        Unit unit = new Unit("id");
        Fragment frag = new Fragment(unit.getStore(), false, "Word ");
        frag.append(TagType.OPENING, "1", "<b>", false);
        frag.append((CharSequence)"word");
        frag.append(TagType.CLOSING, "1", "</b>", false);
        frag.append((CharSequence)".");
        Note note = frag.annotateWithNote(0, -1, "Text of the note");
        Assert.assertEquals((Object)"Text of the note", (Object)note.getText());
        Assert.assertEquals((Object)("<mrk id=\"2\" type=\"comment\" ref=\"#n=" + note.getId() + "\">Word <pc id=\"1\">word</pc>.</mrk>"), (Object)frag.toXLIFF());
        Assert.assertSame((Object)unit.getNotes().get(0), (Object)note);
    }

    @Test
    public void testAnnotateTerm() {
        Fragment frag = new Fragment(new Unit("id").getStore(), false, "Word word.");
        frag.annotate(5, 9, "term", "myValue", "myRef");
        MTag ann = (MTag)frag.getStore().getSourceTags().get(U.kOA(0));
        Assert.assertTrue((boolean)(ann instanceof TermTag));
        frag.annotate(7, 11, "its:term-no", null, null);
        ann = (MTag)frag.getStore().getSourceTags().get(U.kOA(1));
        Assert.assertEquals((Object)"2", (Object)ann.getId());
        Assert.assertTrue((boolean)(ann instanceof TermTag));
        Assert.assertEquals((Object)"Word <mrk id=\"1\" type=\"term\" value=\"myValue\" ref=\"myRef\"><mrk id=\"2\" type=\"its:term-no\">word</mrk></mrk>.", (Object)frag.toXLIFF());
    }

    @Test
    public void testAnnotateFindExisting() {
        Fragment frag = new Fragment(new Unit("id").getStore(), false, "Word word.");
        MTag first = new MTag("m1", "my:first");
        frag.annotate(5, 9, first);
        int len = frag.getCodedText().length();
        MTag am1 = frag.getOrCreateMarker(7, 11, null, "my:type");
        am1.getExtAttributes().setAttribute("myNS", "a1", "v1");
        Assert.assertSame((Object)first, (Object)am1);
        Assert.assertEquals((long)len, (long)frag.getCodedText().length());
        MTag am2 = frag.getOrCreateMarker(7, 13, null, "my:type");
        am2.getExtAttributes().setAttribute("myNS", "a2", "v2");
        Assert.assertSame((Object)first, (Object)am2);
        MTag am3 = frag.getOrCreateMarker(5, 11, null, "my:type");
        am3.getExtAttributes().setAttribute("myNS", "a3", "v3");
        Assert.assertSame((Object)first, (Object)am3);
        MTag am4 = frag.getOrCreateMarker(5, 13, null, "my:type");
        am4.getExtAttributes().setAttribute("myNS", "a4", "v4");
        Assert.assertSame((Object)first, (Object)am4);
        Assert.assertEquals((Object)"Word <mrk id=\"m1\" type=\"my:first\" xmlns:x1=\"myNS\" x1:a1=\"v1\" x1:a2=\"v2\" x1:a3=\"v3\" x1:a4=\"v4\">word</mrk>.", (Object)frag.toXLIFF());
    }

    @Test
    public void testAnnotateAllFindExisting() {
        Fragment frag = new Fragment(new Unit("id").getStore(), false, "Word word.");
        MTag first = new MTag("m1", "my:first");
        frag.annotate(0, -1, first);
        int len = frag.getCodedText().length();
        MTag am1 = frag.getOrCreateMarker(0, -1, null, "my:type");
        am1.getExtAttributes().setAttribute("myNS", "a1", "v1");
        Assert.assertSame((Object)first, (Object)am1);
        Assert.assertEquals((long)len, (long)frag.getCodedText().length());
        Assert.assertEquals((Object)"<mrk id=\"m1\" type=\"my:first\" xmlns:x1=\"myNS\" x1:a1=\"v1\">Word word.</mrk>", (Object)frag.toXLIFF());
    }

    @Test
    public void testAnnotateNoExisting() {
        Fragment frag = new Fragment(new Unit("id").getStore(), false, "Word word.");
        MTag first = new MTag("m1", "my:first");
        frag.annotate(5, 9, first);
        int len = frag.getCodedText().length();
        MTag am1 = frag.getOrCreateMarker(7, 10, null, "my:type");
        am1.getExtAttributes().setAttribute("myNS", "a1", "v1");
        Assert.assertNotSame((Object)first, (Object)am1);
        Assert.assertEquals((long)(len + 4), (long)frag.getCodedText().length());
        Assert.assertEquals((Object)"Word <mrk id=\"m1\" type=\"my:first\"><mrk id=\"1\" type=\"my:type\" xmlns:x1=\"myNS\" x1:a1=\"v1\">wor</mrk>d</mrk>.", (Object)frag.toXLIFF());
    }

    @Test
    public void testAnnotateWithInlineCodes() {
        Fragment frag = new Fragment(new Unit("id").getStore(), false, "Word ");
        frag.append(TagType.OPENING, "1", "<b>", false);
        frag.append((CharSequence)"word");
        frag.append(TagType.CLOSING, "1", "</b>", false);
        frag.append((CharSequence)".");
        frag.annotate(7, 7 + "word".length(), "abc:type", "myValue", "myRef");
        Assert.assertEquals((Object)"Word <pc id=\"1\"><mrk id=\"2\" type=\"abc:type\" value=\"myValue\" ref=\"myRef\">word</mrk></pc>.", (Object)frag.toXLIFF());
    }

    @Test
    public void testMarkersNotWellFormed1() {
        Fragment frag = new Fragment(new Unit("id").getStore(), false);
        frag.openMarkerSpan("1", "term");
        frag.append((CharSequence)"t1");
        frag.append(TagType.OPENING, "2", "[c2]", false);
        frag.closeMarkerSpan("1");
        frag.append(TagType.CLOSING, "2", "[/c2]", false);
        Assert.assertEquals((Object)"<sm id=\"1\" type=\"term\"/>t1<sc id=\"2\" canOverlap=\"no\"/><em startRef=\"1\"/><ec startRef=\"2\" canOverlap=\"no\"/>", (Object)frag.toXLIFF());
    }

    @Test
    public void testCodesDataOutside() {
        Fragment frag = new Fragment(new Unit("id").getStore(), false);
        frag.append(TagType.OPENING, "1", "<elem atrr='&amp;'>", false);
        frag.append((CharSequence)"text");
        frag.append(TagType.CLOSING, "1", "</elem>", false);
        frag.appendCode("2", "<br/>");
        Assert.assertEquals((Object)"<pc id=\"1\" dataRefEnd=\"d2\" dataRefStart=\"d1\">text</pc><ph id=\"2\" dataRef=\"d3\"/>", (Object)frag.toXLIFF(null, null, true, false));
    }

    @Test
    public void testOpeningIsolatedCodes() {
        Fragment frag = new Fragment(new Unit("id").getStore(), false);
        frag.append(TagType.OPENING, "1", "[o1]", true);
        frag.append((CharSequence)"t1");
        Assert.assertEquals((Object)"<sc id=\"1\" isolated=\"yes\"/>t1", (Object)frag.toXLIFF());
        Assert.assertEquals((Object)"<sc id=\"1\" isolated=\"yes\" dataRef=\"d1\"/>t1", (Object)frag.toXLIFF(null, null, true, false));
    }

    @Test
    public void testclosingIsolatedCodes() {
        Fragment frag = new Fragment(new Unit("id").getStore(), false);
        frag.append(TagType.CLOSING, "1", "[c1]", true);
        frag.append((CharSequence)"t1");
        Assert.assertEquals((Object)"<ec id=\"1\" isolated=\"yes\"/>t1", (Object)frag.toXLIFF());
        Assert.assertEquals((Object)"<ec id=\"1\" isolated=\"yes\" dataRef=\"d1\"/>t1", (Object)frag.toXLIFF(null, null, true, false));
    }

    @Test
    public void testInvalidChars() {
        char[] chars = Character.toChars(65537);
        Fragment frag = new Fragment(new Unit("id").getStore(), false);
        frag.append(TagType.OPENING, "1", (String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0002\u0001\u0001\uffff]", "[\u0002"}, (char)chars[0], (char)chars[1])), true);
        frag.append((CharSequence)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0002\u0001\u0001\uffff", "\u001a\u0002\t\n \ud7ff\u0019"}, (char)chars[0], (char)chars[1])));
        frag.append(TagType.CLOSING, "1", (String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0002\u0001\u0001\uffff]", "[/\u0002"}, (char)chars[0], (char)chars[1])), true);
        Assert.assertEquals((Object)("<pc id=\"1\" canOverlap=\"yes\" dataRefEnd=\"d2\" dataRefStart=\"d1\"><cp hex=\"001A\"/><cp hex=\"0002\"/>\t\n \ud7ff<cp hex=\"0019\"/>" + chars[0] + chars[1] + "<cp hex=\"FFFF\"/></pc>"), (Object)frag.toXLIFF(null, null, true, false));
    }

    @Test
    public void testCodesDataOutsideWithReuse() {
        Fragment frag = new Fragment(new Unit("id").getStore(), false);
        frag.append(TagType.OPENING, "1", "<elem atrr='&amp;'>", false);
        frag.append((CharSequence)"t1");
        frag.append(TagType.CLOSING, "1", "</elem>", false);
        frag.appendCode("2", "<br/>");
        frag.append(TagType.OPENING, "3", "<elem atrr='&amp;'>", false);
        frag.append((CharSequence)"t2");
        frag.append(TagType.CLOSING, "3", "</elem>", false);
        frag.appendCode("4", "<br/>");
        Assert.assertEquals((Object)"<pc id=\"1\" dataRefEnd=\"d2\" dataRefStart=\"d1\">t1</pc><ph id=\"2\" dataRef=\"d3\"/><pc id=\"3\" dataRefEnd=\"d2\" dataRefStart=\"d1\">t2</pc><ph id=\"4\" dataRef=\"d3\"/>", (Object)frag.toXLIFF(null, null, true, false));
    }

    @Test
    public void testEquals1() {
        Fragment frag1 = new Fragment(new Unit("id1").getStore(), false);
        frag1.append(TagType.OPENING, "1", "[1]", true);
        frag1.append((CharSequence)"text with \u0305");
        frag1.append(TagType.CLOSING, "1", "[/1]", true);
        frag1.appendCode("2", "[2/]");
        Fragment frag2 = new Fragment(new Unit("id2").getStore(), true);
        frag2.append(TagType.OPENING, "1", "[1]", true);
        frag2.append((CharSequence)"text with \u0305");
        frag2.append(TagType.CLOSING, "1", "[/1]", true);
        frag2.appendCode("2", "[2/]");
        Assert.assertTrue((boolean)frag1.equals((Object)frag2));
    }

    @Test
    public void testEquals2() {
        Fragment frag1 = new Fragment(new Unit("id1").getStore(), false);
        Fragment frag2 = new Fragment(new Unit("id2").getStore(), false);
        Assert.assertTrue((boolean)frag1.equals((Object)frag2));
    }

    @Test
    public void testEquals3() {
        Fragment frag1 = new Fragment(new Unit("id1").getStore(), false, "text");
        Fragment frag2 = new Fragment(new Unit("id2").getStore(), false, "text");
        Assert.assertTrue((boolean)frag1.equals((Object)frag2));
    }

    @Test
    public void testEquals4() {
        Fragment frag1 = new Fragment(new Unit("id1").getStore(), false);
        frag1.append(TagType.OPENING, "c1", "<b>", true);
        Fragment frag2 = new Fragment(new Unit("id2").getStore(), false);
        frag2.append(TagType.OPENING, "c2", "<b>", true);
        Assert.assertFalse((boolean)frag1.equals((Object)frag2));
    }

    @Test
    public void testEquals5() {
        Fragment frag1 = new Fragment(new Unit("id1").getStore(), false);
        frag1.append(TagType.OPENING, "c1", "<b>", true);
        Fragment frag2 = new Fragment(new Unit("id2").getStore(), false);
        frag2.openMarkerSpan("c1", null);
        Assert.assertFalse((boolean)frag1.equals((Object)frag2));
    }

    @Test
    public void testIterator1() {
        Fragment frag = new Fragment(new Unit("id").getStore(), false);
        frag.append((CharSequence)"abc");
        frag.append(TagType.OPENING, "1", "[1]", true);
        frag.append((CharSequence)"d");
        frag.append(TagType.CLOSING, "1", "[/1]", true);
        frag.appendCode("2", "[2/]");
        frag.append((CharSequence)"ef");
        frag.annotate(11, 12, "generic", "val", null);
        int i = 0;
        for (Object obj : frag) {
            switch (i) {
                case 0: {
                    Assert.assertEquals((Object)"abc", obj);
                    break;
                }
                case 1: {
                    Assert.assertEquals((Object)"[1]", (Object)((CTag)obj).getData());
                    break;
                }
                case 2: {
                    Assert.assertEquals((Object)"d", obj);
                    break;
                }
                case 3: {
                    Assert.assertEquals((Object)"[/1]", (Object)((CTag)obj).getData());
                    break;
                }
                case 4: {
                    Assert.assertEquals((Object)"[2/]", (Object)((CTag)obj).getData());
                    break;
                }
                case 5: {
                    Assert.assertEquals((Object)"e", obj);
                    break;
                }
                case 6: {
                    Assert.assertEquals((Object)"val", (Object)((MTag)obj).getValue());
                    break;
                }
                case 7: {
                    Assert.assertEquals((Object)"f", obj);
                    break;
                }
                case 8: {
                    Assert.assertEquals((Object)TagType.CLOSING, (Object)((MTag)obj).getTagType());
                    Assert.assertEquals((Object)"val", (Object)((MTag)obj).getValue());
                    break;
                }
                default: {
                    Assert.fail();
                }
            }
            ++i;
        }
    }

    @Test
    public void testIterator2() {
        Fragment frag = new Fragment(new Unit("id").getStore(), false);
        frag.append(TagType.OPENING, "1", "[1]", true);
        frag.append(TagType.CLOSING, "1", "[/1]", true);
        int i = 0;
        for (Object obj : frag) {
            switch (i) {
                case 0: {
                    CTag cm = (CTag)obj;
                    Assert.assertEquals((Object)"[1]", (Object)cm.getData());
                    break;
                }
                case 1: {
                    CTag cm = (CTag)obj;
                    Assert.assertEquals((Object)"[/1]", (Object)cm.getData());
                    break;
                }
                default: {
                    Assert.assertNull((Object)"done");
                }
            }
            ++i;
        }
    }

    @Test
    public void testIterator3() {
        Fragment frag = new Fragment(new Unit("id").getStore(), false);
        frag.append((CharSequence)"");
        for (Object obj : frag) {
            Assert.assertNull(obj);
        }
    }

    @Test
    public void testIteratorForTag1() {
        Fragment frag = new Fragment(new Unit("id").getStore(), false);
        Iterator iter = frag.getIterable(Tag.class).iterator();
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testIteratorForTag2() {
        Fragment frag = this.createFragment();
        int i = 0;
        for (Tag tag : frag.getIterable(Tag.class)) {
            switch (i) {
                case 0: {
                    Assert.assertEquals((Object)"1", (Object)tag.getId());
                    Assert.assertEquals((Object)"<b>", (Object)((CTag)tag).getData());
                    break;
                }
                case 1: {
                    Assert.assertEquals((Object)"3", (Object)tag.getId());
                    Assert.assertEquals((Object)"comment", (Object)tag.getType());
                    break;
                }
                case 2: {
                    Assert.assertEquals((Object)"3", (Object)tag.getId());
                    Assert.assertEquals((Object)"comment", (Object)tag.getType());
                    break;
                }
                case 3: {
                    Assert.assertEquals((Object)"1", (Object)tag.getId());
                    Assert.assertEquals((Object)"</b>", (Object)((CTag)tag).getData());
                    break;
                }
                case 4: {
                    Assert.assertEquals((Object)"m1", (Object)tag.getId());
                    Assert.assertEquals((Object)false, (Object)((MTag)tag).getTranslate());
                    break;
                }
                case 5: {
                    Assert.assertEquals((Object)"2", (Object)tag.getId());
                    Assert.assertEquals((Object)"<br>", (Object)((CTag)tag).getData());
                    break;
                }
                case 6: {
                    Assert.assertEquals((Object)"m1", (Object)tag.getId());
                    Assert.assertEquals((Object)false, (Object)((MTag)tag).getTranslate());
                }
            }
            ++i;
        }
        Assert.assertEquals((long)7L, (long)i);
    }

    @Test
    public void testIteratorForCTag1() {
        Fragment frag = new Fragment(new Unit("id").getStore(), false);
        Iterator iter = frag.getIterable(CTag.class).iterator();
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testIteratorForCTag2() {
        Fragment frag = this.createFragment();
        int i = 0;
        for (CTag tag : frag.getIterable(CTag.class)) {
            switch (i) {
                case 0: {
                    Assert.assertEquals((Object)"1", (Object)tag.getId());
                    Assert.assertEquals((Object)"<b>", (Object)tag.getData());
                    break;
                }
                case 1: {
                    Assert.assertEquals((Object)"1", (Object)tag.getId());
                    Assert.assertEquals((Object)"</b>", (Object)tag.getData());
                    break;
                }
                case 2: {
                    Assert.assertEquals((Object)"2", (Object)tag.getId());
                    Assert.assertEquals((Object)"<br>", (Object)tag.getData());
                }
            }
            ++i;
        }
        Assert.assertEquals((long)3L, (long)i);
    }

    @Test
    public void testIteratorForMTag1() {
        Fragment frag = new Fragment(new Unit("id").getStore(), false);
        Iterator iter = frag.getIterable(MTag.class).iterator();
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testIteratorForMTag2() {
        Fragment frag = this.createFragment();
        int i = 0;
        for (MTag tag : frag.getIterable(MTag.class)) {
            switch (i) {
                case 0: {
                    Assert.assertEquals((Object)"3", (Object)tag.getId());
                    Assert.assertEquals((Object)"comment", (Object)tag.getType());
                    break;
                }
                case 1: {
                    Assert.assertEquals((Object)"3", (Object)tag.getId());
                    Assert.assertEquals((Object)"comment", (Object)tag.getType());
                    break;
                }
                case 2: {
                    Assert.assertEquals((Object)"m1", (Object)tag.getId());
                    Assert.assertEquals((Object)false, (Object)tag.getTranslate());
                    break;
                }
                case 3: {
                    Assert.assertEquals((Object)"m1", (Object)tag.getId());
                    Assert.assertEquals((Object)false, (Object)tag.getTranslate());
                }
            }
            ++i;
        }
        Assert.assertEquals((long)4L, (long)i);
    }

    @Test
    public void testIteratorForObject1() {
        Fragment frag = new Fragment(new Unit("id").getStore(), false);
        Iterator iter = frag.getIterable(Object.class).iterator();
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testIteratorForObject2() {
        Fragment frag = this.createFragment();
        int i = 0;
        for (Object obj : frag.getIterable(Object.class)) {
            switch (i) {
                case 0: {
                    Assert.assertEquals((Object)"Text ", obj);
                    break;
                }
                case 1: {
                    Assert.assertEquals((Object)"<b>", (Object)((CTag)obj).getData());
                    break;
                }
                case 2: {
                    Assert.assertEquals((Object)"in ", obj);
                    break;
                }
                case 3: {
                    Assert.assertEquals((Object)"comment", (Object)((MTag)obj).getType());
                    break;
                }
                case 4: {
                    Assert.assertEquals((Object)"bold", obj);
                    break;
                }
                case 5: {
                    Assert.assertEquals((Object)"comment", (Object)((MTag)obj).getType());
                    break;
                }
                case 6: {
                    Assert.assertEquals((Object)"</b>", (Object)((CTag)obj).getData());
                    break;
                }
                case 7: {
                    Assert.assertEquals((Object)" ", obj);
                    break;
                }
                case 8: {
                    Assert.assertEquals((Object)false, (Object)((MTag)obj).getTranslate());
                    break;
                }
                case 9: {
                    Assert.assertEquals((Object)"<br>", (Object)((CTag)obj).getData());
                    break;
                }
                case 10: {
                    Assert.assertEquals((Object)false, (Object)((MTag)obj).getTranslate());
                    break;
                }
                case 11: {
                    Assert.assertEquals((Object)".", obj);
                }
            }
            ++i;
        }
        Assert.assertEquals((long)12L, (long)i);
    }

    @Test
    public void testIteratorForString1() {
        Fragment frag = new Fragment(new Unit("id").getStore(), false);
        Iterator iter = frag.getIterable(String.class).iterator();
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testIteratorForString2() {
        Fragment frag = new Fragment(new Unit("id").getStore(), false);
        frag.append((CharSequence)"abc");
        int i = 0;
        for (String str : frag.getIterable(String.class)) {
            Assert.assertEquals((Object)"abc", (Object)str);
            ++i;
        }
        Assert.assertEquals((long)1L, (long)i);
    }

    @Test
    public void testIteratorForString3() {
        Fragment frag = this.createFragment();
        int i = 0;
        for (String str : frag.getIterable(String.class)) {
            switch (i) {
                case 0: {
                    Assert.assertEquals((Object)"Text ", (Object)str);
                    break;
                }
                case 1: {
                    Assert.assertEquals((Object)"in ", (Object)str);
                    break;
                }
                case 2: {
                    Assert.assertEquals((Object)"bold", (Object)str);
                    break;
                }
                case 3: {
                    Assert.assertEquals((Object)" ", (Object)str);
                    break;
                }
                case 4: {
                    Assert.assertEquals((Object)".", (Object)str);
                }
            }
            ++i;
        }
        Assert.assertEquals((long)5L, (long)i);
    }

    @Test
    public void testIteratorForPTag1() {
        Fragment frag = new Fragment(new Unit("id").getStore(), false);
        Iterator iter = frag.getIterable(PCont.class).iterator();
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testIteratorForPTag2() {
        Unit unit = new Unit("id");
        Fragment frag = unit.appendSegment().getSource();
        frag.append((CharSequence)"Text code text code text");
        frag.getOrCreateMarker(5, 19, null, "generic").setTranslate(Boolean.valueOf(false));
        frag.getOrCreateMarker(12, 16, null, "generic").setTranslate(Boolean.valueOf(true));
        Assert.assertEquals((Object)"Text {om:1}code {om:2}text{cm:2} code{cm:1} text", (Object)U.fmtWithIDs(frag));
        unit.hideProtectedContent();
        int i = 0;
        for (PCont ptag : frag.getIterable(PCont.class)) {
            if (i == 0) {
                Assert.assertEquals((Object)"{oA}code ", (Object)U.fmtMarkers(ptag.getCodedText()));
            } else {
                Assert.assertEquals((Object)" code{cA}", (Object)U.fmtMarkers(ptag.getCodedText()));
            }
            ++i;
        }
    }

    @Test
    public void testCopyConstructor() {
        Fragment frag1 = new Fragment(new Unit("id1").getStore(), false);
        CTag cm1 = frag1.append(TagType.OPENING, "1", "[1]", true);
        frag1.append((CharSequence)"text");
        frag1.append(TagType.CLOSING, "1", "[/1]", true);
        cm1.setType("fmt");
        ExtAttribute at1 = cm1.getExtAttributes().setAttribute("myNS", "attr", "val1");
        Unit unit2 = new Unit("id2");
        Fragment frag2 = new Fragment(frag1, unit2.getStore(), true);
        Assert.assertEquals((Object)frag2, (Object)frag1);
        Assert.assertNotSame((Object)frag1, (Object)frag2);
        Assert.assertEquals((Object)frag1.getStore().getSourceTags().get(U.kOC(0)), (Object)frag2.getStore().getTargetTags().get(U.kOC(0)));
        Assert.assertNotSame((Object)frag1.getStore().getSourceTags().get(U.kOC(0)), (Object)frag2.getStore().getTargetTags().get(U.kOC(0)));
        Assert.assertFalse((boolean)frag1.isTarget());
        Assert.assertTrue((boolean)frag2.isTarget());
        Assert.assertSame((Object)frag2.getStore(), (Object)unit2.getStore());
        CTag cm2 = (CTag)frag2.getTag(U.kOC(0));
        Assert.assertEquals((Object)cm1.getType(), (Object)cm2.getType());
        Assert.assertNotSame((Object)cm1, (Object)cm2);
        ExtAttribute at2 = cm2.getExtAttributes().getAttribute("myNS", "attr");
        Assert.assertEquals((Object)at1.getValue(), (Object)at2.getValue());
        Assert.assertNotSame((Object)at1, (Object)at2);
    }

    @Test
    public void testCopyConstructorWithCollapsedSpan() {
        Unit unit = new Unit("id1");
        Fragment frag1 = unit.appendSegment().getSource();
        frag1.append(TagType.OPENING, "1", "[1]", true);
        frag1.openMarkerSpan("a1", "generic").setTranslate(Boolean.valueOf(false));
        frag1.append((CharSequence)"no-trans");
        frag1.append(TagType.CLOSING, "1", "[/1]", true);
        frag1.closeMarkerSpan("a1");
        frag1.append((CharSequence)"text");
        unit.hideProtectedContent();
        Assert.assertEquals((Object)"<sc id=\"1\"/><WARNING:HIDDEN-PROTECTED-CONTENT/>text", (Object)frag1.toXLIFF());
        Fragment frag2 = unit.getPart(0).getTarget(Part.GetTarget.CLONE_SOURCE);
        unit.showProtectedContent();
        Assert.assertEquals((Object)"<sc id=\"1\"/><sm id=\"a1\" translate=\"no\"/>no-trans<ec startRef=\"1\"/><em startRef=\"a1\"/>text", (Object)frag2.toXLIFF());
    }

    @Test
    public void testReplaceFragment() {
        Unit unit = new Unit("id1");
        Fragment frag1 = unit.appendSegment().getSource();
        frag1.append(TagType.OPENING, "1", "[1]", true);
        frag1.append((CharSequence)"text");
        frag1.append(TagType.CLOSING, "1", "[/1]", true);
        Assert.assertEquals((long)2L, (long)unit.getStore().getSourceTags().size());
        unit.getPart(0).setSource(new Fragment(unit.getStore(), false, "plain text"));
        Assert.assertEquals((Object)"plain text", (Object)unit.getPart(0).getSource().toString());
        Assert.assertEquals((long)2L, (long)unit.getStore().getSourceTags().size());
    }

    @Test
    public void testGetClosingPosition() {
        Unit unit = new Unit("id");
        Fragment frag = unit.appendSegment().getSource();
        frag.append(TagType.OPENING, "1", "[1]", true);
        frag.append(TagType.OPENING, "2", "[2]", true);
        frag.append((CharSequence)"inside");
        frag.append(TagType.CLOSING, "1", "[/1]", true);
        frag.append((CharSequence)" outside.");
        Tag opening = frag.getTag(U.kOC(0));
        Assert.assertEquals((long)10L, (long)frag.getClosingPosition(opening));
        opening = frag.getTag(U.kOC(1));
        Assert.assertEquals((long)-1L, (long)frag.getClosingPosition(opening));
    }

    @Test
    public void testRemoveMarker() {
        Unit unit = new Unit("id1");
        Fragment frag1 = unit.appendSegment().getSource();
        CTag cmo1 = frag1.append(TagType.OPENING, "1", "[1]", true);
        frag1.append((CharSequence)"text1");
        CTag cmc1 = frag1.append(TagType.CLOSING, "1", "[/1]", true);
        CTag cmo2 = frag1.append(TagType.OPENING, "2", "[2]", true);
        Fragment frag2 = unit.appendSegment().getSource();
        frag2.append((CharSequence)"text2");
        CTag cmc2 = frag2.append(TagType.CLOSING, "2", "[/2]", true);
        frag2.openMarkerSpan("m1", null).setTranslate(Boolean.valueOf(false));
        CTag ph = frag2.appendCode("ph1", "[ph1/]");
        frag2.append((CharSequence)"protected");
        frag2.closeMarkerSpan("m1");
        Assert.assertEquals((Object)"text2{cc:2}{om:m1}{hc:ph1}protected{cm:m1}", (Object)U.fmtWithIDs(frag2));
        unit.hideProtectedContent();
        Assert.assertSame((Object)cmo1, (Object)frag1.getTag(U.kOC(0)));
        frag1.remove((Tag)cmo1);
        Assert.assertSame((Object)cmc1, (Object)frag1.getTag(U.kCC(0)));
        Assert.assertSame((Object)cmo2, (Object)frag1.getTag(U.kOC(1)));
        Assert.assertSame((Object)cmc2, (Object)frag2.getTag(U.kCC(1)));
        String ct = frag1.getCodedText();
        char ch1 = ct.charAt("text1".length());
        Assert.assertTrue((boolean)Fragment.isChar1((char)ch1));
        char ch2 = ct.charAt("text1".length() + 1);
        CTag cm = (CTag)frag1.getTag(Fragment.toKey((int)ch1, (int)ch2));
        Assert.assertSame((Object)cmc1, (Object)cm);
        Assert.assertEquals((Object)"text2{cc:2}{$}", (Object)U.fmtWithIDs(frag2));
        frag2.remove((Tag)ph);
        frag2.showProtectedContent();
        Assert.assertEquals((Object)"text2{cc:2}{om:m1}protected{cm:m1}", (Object)U.fmtWithIDs(frag2));
    }

    @Test
    public void testClear() {
        Unit unit = new Unit("id1");
        Fragment frag = unit.appendSegment().getSource();
        frag.append(TagType.OPENING, "1", "[1]", true);
        frag.append((CharSequence)"t1");
        MTag sm = frag.openMarkerSpan("m1", "generic");
        sm.setTranslate(Boolean.valueOf(false));
        frag.append(TagType.CLOSING, "1", "[/1]", true);
        frag.append((CharSequence)"t2");
        frag.append(TagType.OPENING, "2", "[2]", true);
        frag.closeMarkerSpan(sm.getId());
        frag.append(TagType.STANDALONE, "3", "[3/]", true);
        frag.append((CharSequence)"t3");
        Assert.assertEquals((long)6L, (long)frag.getTags().size());
        Assert.assertEquals((Object)"{oC}t1{oA}{cC}t2{oC}{cA}{hC}t3", (Object)U.fmtMarkers(frag.getCodedText()));
        unit.hideProtectedContent();
        Assert.assertEquals((long)6L, (long)frag.getTags().size());
        Assert.assertEquals((Object)"{oC}t1{$}{hC}t3", (Object)U.fmtMarkers(frag.getCodedText()));
        Assert.assertFalse((boolean)frag.isEmpty());
        frag.clear();
        Assert.assertTrue((boolean)frag.isEmpty());
        Assert.assertEquals((long)0L, (long)frag.getTags().size());
        Assert.assertEquals((Object)"", (Object)frag.getCodedText());
    }

    @Test
    public void testPlainTextPositionConversion() {
        Unit unit = new Unit("id1");
        Fragment frag = unit.appendSegment().getSource();
        frag.append(TagType.OPENING, "1", "[1]", true);
        frag.append((CharSequence)"abc");
        frag.append(TagType.CLOSING, "1", "[/1]", true);
        frag.append((CharSequence)"d");
        frag.appendCode("2", "[2/]");
        Assert.assertEquals((long)0L, (long)frag.getCodedTextPosition(0, true));
        Assert.assertEquals((long)2L, (long)frag.getCodedTextPosition(0, false));
        Assert.assertEquals((long)3L, (long)frag.getCodedTextPosition(1, true));
        Assert.assertEquals((long)3L, (long)frag.getCodedTextPosition(1, false));
        Assert.assertEquals((long)4L, (long)frag.getCodedTextPosition(2, true));
        Assert.assertEquals((long)4L, (long)frag.getCodedTextPosition(2, false));
        Assert.assertEquals((long)5L, (long)frag.getCodedTextPosition(3, true));
        Assert.assertEquals((long)7L, (long)frag.getCodedTextPosition(3, false));
        Assert.assertEquals((long)8L, (long)frag.getCodedTextPosition(4, true));
        Assert.assertEquals((long)10L, (long)frag.getCodedTextPosition(4, false));
        Assert.assertEquals((long)10L, (long)frag.getCodedTextPosition(5, true));
        Assert.assertEquals((long)10L, (long)frag.getCodedTextPosition(5, false));
    }

    @Test
    public void testPlainTextSpanConversion() {
        Unit unit = new Unit("id1");
        Fragment frag = unit.appendSegment().getSource();
        frag.append(TagType.OPENING, "1", "[1]", true);
        frag.append((CharSequence)"abc");
        frag.append(TagType.CLOSING, "1", "[/1]", true);
        frag.append((CharSequence)"d");
        frag.appendCode("2", "[2/]");
        String ct = frag.getCodedText();
        String pt = frag.getPlainText();
        int start = frag.getCodedTextPosition(0, false);
        int end = frag.getCodedTextPosition(3, true);
        Assert.assertEquals((Object)ct.substring(start, end), (Object)pt.substring(0, 3));
        start = frag.getCodedTextPosition(0, true);
        end = frag.getCodedTextPosition(3, false);
        Assert.assertEquals((Object)"{oC}abc{cC}", (Object)U.fmtMarkers(ct.substring(start, end)));
    }

    @Test
    public void testUnitWithNestedAnnotatorsRef() {
        Unit unit = new Unit("1");
        AnnotatorsRef unitAR = new AnnotatorsRef();
        unitAR.set("mt-confidence", "uLevel");
        unit.setAnnotatorsRef(unitAR);
        Fragment frag = unit.appendSegment().getSource();
        frag.append((CharSequence)"part1 part2 part3 part4");
        ITSWriter.annotate((Fragment)frag, (int)0, (int)5, (IITSItem)new MTConfidence("p1", 0.1));
        ITSWriter.annotate((Fragment)frag, (int)0, (int)15, (IITSItem)new MTConfidence("p1p2", 0.2));
        ITSWriter.annotate((Fragment)frag, (int)12, (int)25, (IITSItem)new MTConfidence("p2p3", 0.3));
        ITSWriter.annotate((Fragment)frag, (int)30, (int)-1, (IITSItem)new MTConfidence(null, 0.4));
        String expected = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file id=\"f1\">\n<unit id=\"1\" its:annotatorsRef=\"mt-confidence|uLevel\">\n<segment>\n<source><sm id=\"2\" type=\"its:any\" its:mtConfidence=\"0.2\" its:annotatorsRef=\"mt-confidence|p1p2\"/><mrk id=\"1\" type=\"its:any\" its:mtConfidence=\"0.1\" its:annotatorsRef=\"mt-confidence|p1\">part1</mrk> <sm id=\"3\" type=\"its:any\" its:mtConfidence=\"0.3\" its:annotatorsRef=\"mt-confidence|p2p3\"/>part2<em startRef=\"2\"/> part3<em startRef=\"3\"/> <mrk id=\"4\" type=\"its:any\" its:mtConfidence=\"0.4\">part4</mrk></source>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        Assert.assertEquals((Object)expected, (Object)U.writeUnit(unit, "en", "fr"));
        List<Event> events = U.getEvents(expected);
        unit = U.getUnit(events);
        List spans = unit.getAnnotatedSpans(false);
        Assert.assertEquals((long)4L, (long)spans.size());
        Assert.assertEquals((Object)"2", (Object)((AnnotatedSpan)spans.get(0)).getId());
        Assert.assertEquals((Object)"p1p2", (Object)((AnnotatedSpan)spans.get(0)).getMarker().getITSItems().get("mt-confidence").getAnnotatorRef());
        Assert.assertEquals((Object)"1", (Object)((AnnotatedSpan)spans.get(1)).getId());
        Assert.assertEquals((Object)"p1", (Object)((AnnotatedSpan)spans.get(1)).getMarker().getITSItems().get("mt-confidence").getAnnotatorRef());
        Assert.assertEquals((Object)"3", (Object)((AnnotatedSpan)spans.get(2)).getId());
        Assert.assertEquals((Object)"p2p3", (Object)((AnnotatedSpan)spans.get(2)).getMarker().getITSItems().get("mt-confidence").getAnnotatorRef());
        Assert.assertEquals((Object)"4", (Object)((AnnotatedSpan)spans.get(3)).getId());
        Assert.assertEquals((Object)"uLevel", (Object)((AnnotatedSpan)spans.get(3)).getMarker().getITSItems().get("mt-confidence").getAnnotatorRef());
    }

    @Test
    public void testHasContentAfter() {
        Unit unit = new Unit("1");
        Fragment frag = unit.appendSegment().getSource();
        frag.append((CharSequence)"abc");
        frag.appendCode("1", "<br/>");
        frag.openMarkerSpan("2", "comment");
        frag.closeMarkerSpan("2");
        Assert.assertTrue((boolean)Fragment.hasContentAfter((String)frag.getCodedText(), (int)0));
        Assert.assertTrue((boolean)Fragment.hasContentAfter((String)frag.getCodedText(), (int)3));
        Assert.assertFalse((boolean)Fragment.hasContentAfter((String)frag.getCodedText(), (int)5));
        Assert.assertFalse((boolean)Fragment.hasContentAfter((String)frag.getCodedText(), (int)7));
    }

    @Test
    public void testUnitWithOverlappingAnnotatorsRef() {
        Unit unit = new Unit("1");
        AnnotatorsRef unitAR = new AnnotatorsRef();
        unitAR.set("mt-confidence", "uLevel");
        unit.setAnnotatorsRef(unitAR);
        Fragment frag = unit.appendSegment().getSource();
        frag.append((CharSequence)"part1 part2 part3 part4");
        ITSWriter.annotate((Fragment)frag, (int)0, (int)17, (IITSItem)new MTConfidence("p1p2p3", 0.1));
        ITSWriter.annotate((Fragment)frag, (int)8, (int)-1, (IITSItem)new MTConfidence("uLevel", 0.2));
        String expected = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file id=\"f1\">\n<unit id=\"1\" its:annotatorsRef=\"mt-confidence|uLevel\">\n<segment>\n<source><sm id=\"1\" type=\"its:any\" its:mtConfidence=\"0.1\" its:annotatorsRef=\"mt-confidence|p1p2p3\"/>part1 <sm id=\"2\" type=\"its:any\" its:mtConfidence=\"0.2\" its:annotatorsRef=\"mt-confidence|uLevel\"/>part2 part3<em startRef=\"1\"/> part4<em startRef=\"2\"/></source>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        Assert.assertEquals((Object)expected, (Object)U.writeUnit(unit, "en", "fr"));
    }

    @Test
    public void testAppends() {
        Fragment frag = new Unit("id").appendSegment().getSource();
        CTag ct1 = frag.openCodeSpan("b1", "<b>");
        ct1.setCanReorder(CanReorder.FIRSTNO);
        frag.append((CharSequence)"bold");
        CTag ct2 = frag.closeCodeSpan("b1", "</b>");
        CTag ct3 = frag.appendCode("br1", "<br/>");
        Assert.assertEquals((Object)ct1.getId(), (Object)ct2.getId());
        Assert.assertEquals((Object)"<b>", (Object)ct1.getData());
        Assert.assertFalse((boolean)ct1.getCanDelete());
        Assert.assertEquals((Object)"</b>", (Object)ct2.getData());
        Assert.assertEquals((Object)CanReorder.NO, (Object)ct2.getCanReorder());
        Assert.assertSame((Object)ct1, (Object)frag.getOpeningTag((Tag)ct2));
        Assert.assertEquals((Object)"br1", (Object)ct3.getId());
        Assert.assertEquals((Object)"<br/>", (Object)ct3.getData());
    }

    @Test
    public void testDelete() {
        Fragment frag = this.createFragment();
        frag.delete(0, 0);
        Assert.assertEquals((Object)"Text {oc:1}in {om:3}bold{cm:3}{cc:1} {om:m1}{hc:2}{cm:m1}.", (Object)U.fmtWithIDs(frag));
        frag.delete(18, 20);
        Assert.assertEquals((Object)"Text {oc:1}in {om:3}bold{cm:3} {om:m1}{hc:2}{cm:m1}.", (Object)U.fmtWithIDs(frag));
        frag.delete(5, 7);
        Assert.assertEquals((Object)"Text in {om:3}bold{cm:3} {om:m1}{hc:2}{cm:m1}.", (Object)U.fmtWithIDs(frag));
        Assert.assertEquals((long)5L, (long)frag.getTags().size());
        frag = this.createFragment();
        frag.delete(0, 28);
        Assert.assertTrue((boolean)frag.isEmpty());
        Assert.assertFalse((boolean)frag.hasTag());
        frag = this.createFragment();
        Unit unit = (Unit)frag.getStore().getParent();
        unit.hideProtectedContent();
        Assert.assertEquals((Object)"Text {oc:1}in {om:3}bold{cm:3}{cc:1} {$}.", (Object)U.fmtWithIDs(frag));
        frag.delete(14, 23);
        frag.showProtectedContent();
        Assert.assertEquals((Object)"Text {oc:1}in {om:3}bo.", (Object)U.fmtWithIDs(frag));
        Assert.assertEquals((long)2L, (long)frag.getTags().size());
    }

    @Test
    public void testOwnTagsStatus() {
        Fragment cont = new Fragment(new Unit("id").getStore(), true);
        CTag t1o = cont.openCodeSpan("1", "<1>");
        CTag t1c = cont.closeCodeSpan("1", "</1>");
        cont.appendCode("2", "<2/>");
        CTag t3o = cont.openCodeSpan("3", "<3>");
        CTag t4o = cont.openCodeSpan("4", "<4>");
        CTag t3c = cont.closeCodeSpan("3", "</3>");
        CTag t5o = cont.openCodeSpan("5", "<5>");
        cont.openCodeSpan("6", "<6>");
        CTag t6c = cont.closeCodeSpan("6", "</6>");
        CTag t5c = cont.closeCodeSpan("5", "</5>");
        CTag t4c = cont.closeCodeSpan("4", "</4>");
        CTag t7o = cont.openCodeSpan("7", "<7>");
        cont.delete(14, 16);
        Map map = cont.getOwnTagsStatus();
        Assert.assertEquals((long)2L, (long)((Integer)map.get(t1o)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)map.get(t1c)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)map.get(t3o)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)map.get(t4o)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)map.get(t3c)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)map.get(t5o)).intValue());
        Assert.assertEquals((long)0L, (long)((Integer)map.get(t6c)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)map.get(t5c)).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)map.get(t4c)).intValue());
        Assert.assertEquals((long)0L, (long)((Integer)map.get(t7o)).intValue());
    }

    @Test
    public void testForceUniqueIdsStripsSegmentPrefixOnWrite() {
        Fragment frag = new Fragment(new Unit("id").getStore(), true);
        frag.append((CharSequence)"A");
        frag.openCodeSpan("s1-1", "<1>");
        frag.append((CharSequence)"B");
        frag.closeCodeSpan("s1-1", "</1>");
        frag.append((CharSequence)"C");
        String xliff = frag.toXLIFF(null, null, false, true);
        Assert.assertEquals((Object)"A<pc id=\"1\">B</pc>C", (Object)xliff);
    }

    @Test
    public void generalDescription() {
        int i;
        Unit unit = new Unit("id");
        Fragment frag = unit.appendSegment().getSource();
        frag.append((CharSequence)"Text").append(' ').append((CharSequence)"Just abc ", 5, 9);
        Assert.assertEquals((Object)"Text abc ", (Object)frag.toString());
        frag.insert((CharSequence)"with ", 5);
        Assert.assertEquals((Object)"Text with abc ", (Object)frag.toString());
        CTag opening = frag.openCodeSpan("c1", "<b>");
        frag.append((CharSequence)"and bold");
        CTag closing = frag.closeCodeSpan("c1", "</b>");
        frag.append((CharSequence)". ");
        Assert.assertNull((Object)opening.getType());
        Assert.assertNull((Object)closing.getType());
        opening.setType("fmt");
        Assert.assertEquals((Object)"fmt", (Object)opening.getType());
        Assert.assertEquals((Object)"fmt", (Object)closing.getType());
        closing.setType("ui");
        Assert.assertEquals((Object)"ui", (Object)opening.getType());
        Assert.assertEquals((Object)"ui", (Object)closing.getType());
        Fragment frag2 = unit.appendSegment().getSource();
        frag2.append((CharSequence)" And more...");
        frag2.insert(TagType.CLOSING, "fmt", "c2", "</i>", -1, true, true);
        Assert.assertEquals((Object)" And more...{cc:c2}", (Object)U.fmtWithIDs(frag2));
        frag.insert(TagType.OPENING, "fmt", "c2", "<i>", 10, true, false);
        Assert.assertEquals((Object)"Text with {oc:c2}abc {oc:c1}and bold{cc:c1}. ", (Object)U.fmtWithIDs(frag));
        frag.delete(10, 16);
        frag.delete(12, 16);
        Assert.assertEquals((Object)"Text with {oc:c1}bold{cc:c1}. ", (Object)U.fmtWithIDs(frag));
        Assert.assertEquals((long)3L, (long)frag.getTags().size());
        Assert.assertEquals((long)2L, (long)frag.getOwnTags().size());
        frag2.clear();
        frag2.append((CharSequence)"Second ");
        frag2.openMarkerSpan("m1", "generic");
        frag2.append((CharSequence)"Fragment");
        frag2.closeMarkerSpan("m1");
        frag2.append('.');
        Assert.assertEquals((Object)"Second {om:m1}Fragment{cm:m1}.", (Object)U.fmtWithIDs(frag2));
        frag2.annotate(0, -1, "my:annotation", "myData", "someURL");
        Assert.assertEquals((Object)"{om:1}Second {om:m1}Fragment{cm:m1}.{cm:1}", (Object)U.fmtWithIDs(frag2));
        MTag mt = frag2.getOrCreateMarker(9, 19, "generic", "term");
        mt.setType("term");
        mt.setRef("http://en.wikipedia.org/wiki/Fragment");
        Assert.assertEquals((Object)"{om:1}Second {om:m1}Fragment{cm:m1}.{cm:1}", (Object)U.fmtWithIDs(frag2));
        MTag mt2 = frag2.getTags().getOpeningMTag("m1");
        Assert.assertSame((Object)mt, (Object)mt2);
        frag.annotate(12, 16, "term", "Has a strong appearance", "http://www.thefreedictionary.com/bold");
        this.logger.info("-- way 1:");
        String ct = frag.getCodedText();
        for (i = 0; i < ct.length(); ++i) {
            if (!Fragment.isChar1((char)ct.charAt(i))) continue;
            Tag tag = frag.getTags().get((CharSequence)ct, i);
            this.logger.info("tag-type:{}, type:{}, id:{}", new Object[]{tag.getTagType(), tag.getType(), tag.getId()});
            if (tag.isCode()) {
                this.logger.info(" It is a code.");
            }
            if (tag.isMarker()) {
                this.logger.info(" It is a marker.");
            }
            int key = Fragment.toKey((int)ct.charAt(i), (int)ct.charAt(i + 1));
            tag = frag.getTag(key);
            String tagref = Fragment.toRef((int)key);
            Assert.assertEquals((long)tagref.charAt(0), (long)ct.charAt(i));
            Assert.assertEquals((long)tagref.charAt(1), (long)ct.charAt(i + 1));
            ++i;
        }
        this.logger.info("-- way 2:");
        block6: for (i = 0; i < ct.length(); ++i) {
            switch (ct.charAt(i)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    CTag ctag = frag.getCTag((CharSequence)ct, i++);
                    this.logger.info("CTag id:{}, data:{}", (Object)ctag.getId(), (Object)ctag.getData());
                    continue block6;
                }
                case '\ue104': 
                case '\ue105': {
                    MTag mtag = frag.getMTag((CharSequence)ct, i++);
                    this.logger.info("MTag id:{}, type:{}", (Object)mtag.getId(), (Object)mtag.getType());
                    continue block6;
                }
                case '\ue106': {
                    ++i;
                }
            }
        }
        this.logger.info("-- way 3:");
        for (Object obj : frag) {
            if (obj instanceof CTag) {
                CTag ctag = (CTag)obj;
                this.logger.info("CTag id:{}, data:{}", (Object)ctag.getId(), (Object)ctag.getData());
                continue;
            }
            if (obj instanceof MTag) {
                MTag mtag = (MTag)obj;
                this.logger.info("MTag id:{} , type:{}", (Object)mtag.getId(), (Object)mtag.getType());
                continue;
            }
            if (!(obj instanceof String)) continue;
            this.logger.info("Text:'{}'", obj);
        }
        frag2.clear();
        frag2.insert(TagType.CLOSING, null, "alone", "</B>", -1, false, true);
        Tag tag = frag2.getTags().get("alone", TagType.CLOSING);
        Assert.assertNull((Object)frag2.getOpeningTag(tag));
        unit = new Unit("id");
        frag = unit.appendSegment().getSource();
        frag.append((CharSequence)"Text code text code text");
        frag.getOrCreateMarker(5, 19, null, "generic").setTranslate(Boolean.valueOf(false));
        frag.getOrCreateMarker(12, 16, null, "generic").setTranslate(Boolean.valueOf(true));
        Assert.assertEquals((Object)"Text {om:1}code {om:2}text{cm:2} code{cm:1} text", (Object)U.fmtWithIDs(frag));
        unit.hideProtectedContent();
        Assert.assertEquals((Object)"Text {$}{om:2}text{cm:2}{$} text", (Object)U.fmtWithIDs(frag));
        frag.setCodedText(frag.getCodedText().toUpperCase());
        frag.showProtectedContent();
        Assert.assertEquals((Object)"TEXT {om:1}code {om:2}TEXT{cm:2} code{cm:1} TEXT", (Object)U.fmtWithIDs(frag));
        frag = new Unit("id").appendSegment().getSource();
        opening = frag.openCodeSpan(null, "<s>");
        Assert.assertEquals((Object)"1", (Object)opening.getId());
        closing = frag.closeCodeSpan("1", "</s>");
        Assert.assertEquals((Object)"1", (Object)closing.getId());
        int myId = 1;
        while (frag.getStore().isIdUsed("" + myId)) {
            ++myId;
        }
        CTag standalone = frag.appendCode("" + myId, "<br/>");
        Assert.assertEquals((Object)"2", (Object)standalone.getId());
        standalone = frag.appendCode(frag.getStore().suggestId(false), "<br/>");
        Assert.assertEquals((Object)"3", (Object)standalone.getId());
        Assert.assertFalse((boolean)Util.isValidNmtoken((String)"ab][cd"));
        Assert.assertTrue((boolean)Util.isValidNmtoken((String)"ab-12"));
        Assert.assertTrue((boolean)Util.isValidNmtoken((String)"123"));
        frag2 = new Fragment(frag, frag2.getStore(), false);
        Assert.assertEquals((Object)frag2, (Object)frag);
        CTag oc1 = (CTag)frag.getTags().get("1", TagType.OPENING);
        CTag cc1 = (CTag)frag.getClosingTag((Tag)oc1);
        CTag oc2 = (CTag)frag2.getTags().get("1", TagType.OPENING);
        CTag cc2 = (CTag)frag2.getClosingTag((Tag)oc2);
        Assert.assertEquals((Object)oc2, (Object)oc1);
        Assert.assertNotSame((Object)oc2, (Object)oc1);
        Assert.assertEquals((Object)cc2, (Object)cc1);
        Assert.assertNotSame((Object)cc2, (Object)cc1);
    }

    private Fragment createFragment() {
        Fragment frag = new Unit("id").appendSegment().getSource();
        frag.append((CharSequence)"Text ");
        frag.openCodeSpan("1", "<b>");
        frag.append((CharSequence)"in bold");
        frag.closeCodeSpan("1", "</b>");
        frag.append(' ');
        frag.appendCode("2", "<br>");
        frag.append('.');
        frag.annotate(10, 14, "comment", "My comment", null);
        MTag mtag = new MTag("m1", null);
        mtag.setTranslate(Boolean.valueOf(false));
        frag.annotate(21, 23, mtag);
        Assert.assertEquals((Object)"Text {oc:1}in {om:3}bold{cm:3}{cc:1} {om:m1}{hc:2}{cm:m1}.", (Object)U.fmtWithIDs(frag));
        return frag;
    }
}

