/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import java.util.List;
import net.sf.okapi.lib.xliff2.core.Directionality;
import net.sf.okapi.lib.xliff2.core.MidFileData;
import net.sf.okapi.lib.xliff2.core.StartFileData;
import net.sf.okapi.lib.xliff2.reader.Event;
import net.sf.okapi.lib.xliff2.test.U;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FileDataTest {
    @Test
    public void testDefaults() {
        StartFileData sfd = new StartFileData("id1");
        Assert.assertEquals((Object)"id1", (Object)sfd.getId());
        Assert.assertTrue((boolean)sfd.getCanResegment());
        Assert.assertTrue((boolean)sfd.getTranslate());
        Assert.assertEquals((Object)Directionality.AUTO, (Object)sfd.getSourceDir());
        Assert.assertEquals((Object)Directionality.AUTO, (Object)sfd.getTargetDir());
        Assert.assertNull((Object)sfd.getOriginal());
        Assert.assertTrue((boolean)sfd.getExtAttributes().isEmpty());
        MidFileData mfd = new MidFileData();
        Assert.assertTrue((boolean)mfd.getExtElements().isEmpty());
        Assert.assertEquals((long)0L, (long)mfd.getNoteCount());
        Assert.assertTrue((boolean)mfd.getExtElements().isEmpty());
    }

    @Test
    public void testMidFileAlwaysGenerated() {
        String text = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file id=\"f1\">\n<unit id=\"id\">\n<segment>\n<source>source</source>\n<target>source</target>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        List<Event> events = U.getEvents(text);
        boolean hasEmptyMidFile = false;
        for (Event event : events) {
            if (!event.isMidFile()) continue;
            MidFileData mfd = event.getMidFileData();
            Assert.assertFalse((boolean)mfd.hasExtElements());
            Assert.assertEquals((long)0L, (long)mfd.getNoteCount());
            hasEmptyMidFile = true;
            break;
        }
        Assert.assertTrue((boolean)hasEmptyMidFile);
    }
}

