/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import net.sf.okapi.lib.xliff2.core.CTag;
import net.sf.okapi.lib.xliff2.core.Directionality;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.Part;
import net.sf.okapi.lib.xliff2.core.Segment;
import net.sf.okapi.lib.xliff2.core.TagType;
import net.sf.okapi.lib.xliff2.core.Unit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DirectionalityTest {
    @Test
    public void testDefaultValues() {
        Unit unit = new Unit("id");
        Assert.assertEquals((Object)Directionality.AUTO, (Object)unit.getSourceDir());
        Assert.assertEquals((Object)Directionality.AUTO, (Object)unit.getTargetDir());
        Segment seg = unit.appendSegment();
        Assert.assertEquals((Object)Directionality.INHERITED, (Object)seg.getSource().getDir(false));
        Assert.assertEquals((Object)Directionality.INHERITED, (Object)seg.getTarget(Part.GetTarget.CREATE_EMPTY).getDir(false));
        Assert.assertEquals((Object)Directionality.AUTO, (Object)seg.getSource().getDir(true));
        Assert.assertEquals((Object)Directionality.AUTO, (Object)seg.getTarget(Part.GetTarget.CREATE_EMPTY).getDir(true));
        Part ign = unit.appendIgnorable();
        Assert.assertEquals((Object)Directionality.INHERITED, (Object)ign.getSource().getDir(false));
        Assert.assertEquals((Object)Directionality.INHERITED, (Object)ign.getTarget(Part.GetTarget.CREATE_EMPTY).getDir(false));
        Assert.assertEquals((Object)Directionality.AUTO, (Object)ign.getSource().getDir(true));
        Assert.assertEquals((Object)Directionality.AUTO, (Object)ign.getTarget(Part.GetTarget.CREATE_EMPTY).getDir(true));
    }

    @Test
    public void testAccess() {
        Unit unit = new Unit("id");
        unit.setSourceDir(Directionality.RTL);
        unit.setTargetDir(unit.getSourceDir());
        Assert.assertEquals((Object)Directionality.RTL, (Object)unit.getSourceDir());
        Assert.assertEquals((Object)Directionality.RTL, (Object)unit.getTargetDir());
        Segment seg = unit.appendSegment();
        Assert.assertEquals((Object)Directionality.RTL, (Object)seg.getSource().getDir(true));
        Assert.assertEquals((Object)Directionality.RTL, (Object)seg.getTarget(Part.GetTarget.CREATE_EMPTY).getDir(true));
        seg.getSource().setDir(Directionality.LTR);
        seg.getTarget(Part.GetTarget.CREATE_EMPTY).setDir(seg.getSource().getDir(true));
        Assert.assertEquals((Object)Directionality.LTR, (Object)seg.getSource().getDir(true));
        Assert.assertEquals((Object)Directionality.LTR, (Object)seg.getTarget().getDir(true));
        Part ign = unit.appendIgnorable();
        Assert.assertEquals((Object)Directionality.RTL, (Object)ign.getSource().getDir(true));
        Assert.assertEquals((Object)Directionality.RTL, (Object)ign.getTarget(Part.GetTarget.CREATE_EMPTY).getDir(true));
        ign.getSource().setDir(Directionality.LTR);
        ign.getTarget(Part.GetTarget.CREATE_EMPTY).setDir(seg.getSource().getDir(true));
        Assert.assertEquals((Object)Directionality.LTR, (Object)ign.getSource().getDir(true));
        Assert.assertEquals((Object)Directionality.LTR, (Object)ign.getTarget().getDir(true));
    }

    @Test
    public void testNesting() {
        Unit unit = new Unit("id");
        unit.setSourceDir(Directionality.RTL);
        Segment seg = unit.appendSegment();
        Fragment srcFrag = seg.getSource();
        srcFrag.append((CharSequence)"a ");
        CTag cm1 = srcFrag.append(TagType.OPENING, "1", "[rtl]", false);
        cm1.setDir(Directionality.RTL);
        srcFrag.append((CharSequence)"B ");
        CTag cm2 = srcFrag.append(TagType.OPENING, "2", "[ltr]", false);
        cm2.setDir(Directionality.LTR);
        srcFrag.append((CharSequence)"c ");
        srcFrag.append(TagType.CLOSING, "2", "[/ltr]", false);
        srcFrag.append((CharSequence)"D ");
        srcFrag.append(TagType.CLOSING, "1", "[/rtl]", false);
        srcFrag.append((CharSequence)"e");
        Assert.assertEquals((Object)"a <pc id=\"1\">B <pc id=\"2\">c </pc>D </pc>e", (Object)srcFrag.toXLIFF());
    }
}

