/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.core.CTag;
import net.sf.okapi.lib.xliff2.core.CanReorder;
import net.sf.okapi.lib.xliff2.core.CloneFactory;
import net.sf.okapi.lib.xliff2.core.Directionality;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.MTag;
import net.sf.okapi.lib.xliff2.core.Tag;
import net.sf.okapi.lib.xliff2.core.TagType;
import net.sf.okapi.lib.xliff2.core.Unit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CTagTest {
    @Test
    public void testSimple() {
        CTag code = new CTag(null, TagType.OPENING, "1", null);
        Assert.assertEquals((Object)TagType.OPENING, (Object)code.getTagType());
        Assert.assertEquals((Object)"1", (Object)code.getId());
        Assert.assertNull((Object)code.getData());
    }

    @Test
    public void testOriginalData() {
        CTag code = new CTag(null, TagType.STANDALONE, "1", null);
        Assert.assertNull((Object)code.getData());
        Assert.assertFalse((boolean)code.hasData());
        code = new CTag(null, TagType.STANDALONE, "1", "");
        Assert.assertEquals((Object)"", (Object)code.getData());
        Assert.assertFalse((boolean)code.hasData());
        code = new CTag(null, TagType.STANDALONE, "1", "z");
        Assert.assertEquals((Object)"z", (Object)code.getData());
        Assert.assertTrue((boolean)code.hasData());
    }

    @Test
    public void testHintsDefaults() {
        CTag code = new CTag(null, TagType.STANDALONE, "1", null);
        Assert.assertTrue((boolean)code.getCanDelete());
        Assert.assertTrue((boolean)code.getCanCopy());
        Assert.assertEquals((Object)CanReorder.YES, (Object)code.getCanReorder());
    }

    @Test
    public void testHintsCanDelete() {
        CTag code = new CTag(null, TagType.STANDALONE, "1", null);
        code.setCanDelete(false);
        Assert.assertFalse((boolean)code.getCanDelete());
        Assert.assertTrue((boolean)code.getCanCopy());
        Assert.assertEquals((Object)CanReorder.YES, (Object)code.getCanReorder());
        code.setCanDelete(true);
        Assert.assertTrue((boolean)code.getCanDelete());
        Assert.assertTrue((boolean)code.getCanCopy());
        Assert.assertEquals((Object)CanReorder.YES, (Object)code.getCanReorder());
    }

    @Test
    public void testHintsCanReplicate() {
        CTag code = new CTag(null, TagType.STANDALONE, "1", null);
        code.setCanCopy(false);
        Assert.assertTrue((boolean)code.getCanDelete());
        Assert.assertFalse((boolean)code.getCanCopy());
        Assert.assertEquals((Object)CanReorder.YES, (Object)code.getCanReorder());
        code.setCanCopy(true);
        Assert.assertTrue((boolean)code.getCanDelete());
        Assert.assertTrue((boolean)code.getCanCopy());
        Assert.assertEquals((Object)CanReorder.YES, (Object)code.getCanReorder());
    }

    @Test
    public void testHintsCanReorder() {
        CTag code = new CTag(null, TagType.STANDALONE, "1", null);
        Assert.assertTrue((boolean)code.getCanDelete());
        Assert.assertTrue((boolean)code.getCanCopy());
        code.setCanReorder(CanReorder.FIRSTNO);
        Assert.assertFalse((boolean)code.getCanDelete());
        Assert.assertFalse((boolean)code.getCanCopy());
        Assert.assertEquals((Object)CanReorder.FIRSTNO, (Object)code.getCanReorder());
        code.setCanReorder(CanReorder.NO);
        Assert.assertFalse((boolean)code.getCanDelete());
        Assert.assertFalse((boolean)code.getCanCopy());
        Assert.assertEquals((Object)CanReorder.NO, (Object)code.getCanReorder());
    }

    @Test
    public void testOtherDefaults() {
        CTag code = new CTag(null, TagType.STANDALONE, "1", null);
        Assert.assertEquals((Object)"", (Object)code.getEquiv());
        Assert.assertNull((Object)code.getCopyOf());
        Assert.assertEquals((Object)Directionality.AUTO, (Object)code.getDataDir());
        Assert.assertNull((Object)code.getDataRef());
        Assert.assertNull((Object)code.getDisp());
    }

    @Test
    public void testEquals() {
        Assert.assertEquals((Object)new CTag(TagType.STANDALONE, "1", null), (Object)new CTag(TagType.STANDALONE, "1", null));
        Assert.assertNotEquals((Object)new CTag(TagType.STANDALONE, "1", null), (Object)new CTag(TagType.STANDALONE, "2", null));
        Assert.assertNotEquals((Object)new CTag(TagType.STANDALONE, "1", null), (Object)new CTag(TagType.OPENING, "1", null));
        Assert.assertNotEquals((Object)new CTag(TagType.STANDALONE, "1", null), (Object)new CTag(TagType.STANDALONE, "1", "data"));
        CTag code1 = new CTag(TagType.STANDALONE, "1", "d1");
        code1.setDisp("di1");
        code1.setEquiv("eq1");
        code1.setSubFlows("sf1");
        code1.setCanDelete(false);
        code1.setType("ui");
        CTag code2 = new CTag(TagType.STANDALONE, "1", "d1");
        code2.setDisp("di1");
        code2.setEquiv("eq1");
        code2.setSubFlows("sf1");
        code2.setCanDelete(false);
        code2.setType("ui");
        Assert.assertEquals((Object)code1, (Object)code2);
        code2.setType("fmt");
        Assert.assertNotEquals((Object)code1, (Object)code2);
        code2.setType("ui");
        Assert.assertEquals((Object)code1, (Object)code2);
        code2.setEquiv("eq2");
        Assert.assertNotEquals((Object)code1, (Object)code2);
        code2.setEquiv("eq1");
        Assert.assertEquals((Object)code1, (Object)code2);
        code2.setDisp("di2");
        Assert.assertNotEquals((Object)code1, (Object)code2);
        code2.setDisp("di1");
        Assert.assertEquals((Object)code1, (Object)code2);
        code2.setSubFlows("sf2");
        Assert.assertNotEquals((Object)code1, (Object)code2);
        code2.setSubFlows("sf1");
        Assert.assertEquals((Object)code1, (Object)code2);
        code2.setCanCopy(false);
        Assert.assertNotEquals((Object)code1, (Object)code2);
        code2.setCanCopy(true);
        Assert.assertEquals((Object)code1, (Object)code2);
    }

    @Test
    public void testSubFlows() {
        CTag cm = new CTag(TagType.STANDALONE, "1", null);
        cm.setSubFlows(" 1 \t 2\t3  4\n5\t");
        Assert.assertEquals((Object)"1 2 3 4 5", (Object)cm.getSubFlows());
        int i = 1;
        for (String id : cm.getSubFlowsIds()) {
            Assert.assertEquals((Object)("" + i), (Object)id);
            ++i;
        }
        cm.setSubFlows(null);
        Assert.assertNull((Object)cm.getSubFlows());
        Assert.assertEquals((long)0L, (long)cm.getSubFlowsIds().length);
    }

    @Test
    public void testTypes() {
        CTag cm = new CTag(TagType.STANDALONE, "1", null);
        cm.setType("fmt");
        Assert.assertEquals((Object)"fmt", (Object)cm.getType());
        cm.setType("ui");
        Assert.assertEquals((Object)"ui", (Object)cm.getType());
        cm.setType("quote");
        Assert.assertEquals((Object)"quote", (Object)cm.getType());
        cm.setType("link");
        Assert.assertEquals((Object)"link", (Object)cm.getType());
        cm.setType("image");
        Assert.assertEquals((Object)"image", (Object)cm.getType());
        cm.setType("other");
        Assert.assertEquals((Object)"other", (Object)cm.getType());
    }

    @Test
    public void testTypeAndSubType() {
        CTag cm = new CTag(TagType.STANDALONE, "1", null);
        cm.setType("fmt");
        cm.setSubType("scPrefix:scValue");
        Assert.assertEquals((Object)"fmt", (Object)cm.getType());
        Assert.assertEquals((Object)"scPrefix:scValue", (Object)cm.getSubType());
    }

    @Test(expected=InvalidParameterException.class)
    public void testBadSubTypeValues1() {
        CTag cm = new CTag(TagType.STANDALONE, "1", null);
        cm.setType("fmt");
        cm.setSubType(":value");
    }

    @Test(expected=InvalidParameterException.class)
    public void testBadSubTypeValues2() {
        CTag cm = new CTag(TagType.STANDALONE, "1", null);
        cm.setType("fmt");
        cm.setSubType("my:");
    }

    @Test(expected=InvalidParameterException.class)
    public void testBadSubTypeValues3() {
        CTag cm = new CTag(TagType.STANDALONE, "1", null);
        cm.setType("fmt");
        cm.setSubType(":");
    }

    @Test(expected=InvalidParameterException.class)
    public void testBadSubTypeValues4() {
        CTag cm = new CTag(TagType.STANDALONE, "1", null);
        cm.setType("fmt");
        cm.setSubType("");
    }

    @Test(expected=InvalidParameterException.class)
    public void testBadSubTypeValues5() {
        CTag cm = new CTag(TagType.STANDALONE, "1", null);
        cm.setType("fmt");
        cm.setSubType("xlf:_badvalue_");
    }

    @Test(expected=InvalidParameterException.class)
    public void testBadTypeValue() {
        CTag cm = new CTag(TagType.STANDALONE, "1", null);
        cm.setType("fmt");
        cm.setSubType("xlf:var");
        cm.verifyTypeSubTypeValues();
    }

    public void testTypeSubTypeValues() {
        CTag cm = new CTag(TagType.STANDALONE, "1", null);
        cm.setType("ui");
        cm.setSubType("xlf:var");
        cm.verifyTypeSubTypeValues();
        cm.setType("fmt");
        cm.setSubType("xlf:lb");
        cm.verifyTypeSubTypeValues();
        cm.setSubType("xlf:pb");
        cm.verifyTypeSubTypeValues();
        cm.setSubType("xlf:b");
        cm.verifyTypeSubTypeValues();
        cm.setSubType("xlf:i");
        cm.verifyTypeSubTypeValues();
        cm.setSubType("xlf:u");
        cm.verifyTypeSubTypeValues();
        cm.setSubType("abc:xyz");
        cm.verifyTypeSubTypeValues();
        cm.setType("fmt");
        cm.verifyTypeSubTypeValues();
    }

    @Test
    public void testCopyConstructor() {
        CTag cm1 = new CTag(TagType.STANDALONE, "1", "data");
        cm1.setCanCopy(false);
        cm1.setCanDelete(false);
        cm1.setCanOverlap(true);
        cm1.setCanReorder(CanReorder.NO);
        cm1.setDisp("disp");
        cm1.setEquiv("equiv");
        cm1.setDataRef("dataRef");
        cm1.setSubFlows("sf1");
        CTag cm2 = new CTag(cm1, (CTag)null);
        Assert.assertEquals((Object)cm2, (Object)cm1);
        Assert.assertNotSame((Object)cm2, (Object)cm1);
        Tag bm1 = CloneFactory.create((Tag)cm1, null);
        Assert.assertEquals((Object)bm1, (Object)cm1);
        Assert.assertNotSame((Object)bm1, (Object)cm1);
    }

    @Test
    public void testClonefactory() {
        Unit unit1 = new Unit("id1");
        Fragment frag1 = unit1.appendSegment().getSource();
        CTag co1 = frag1.openCodeSpan("c1", "[c1]");
        MTag mo1 = frag1.openMarkerSpan("m1", "x:m1");
        frag1.closeCodeSpan("c1", "[/c1]");
        frag1.closeMarkerSpan("m1");
        Unit unit2 = new Unit("id2");
        Fragment frag2 = unit2.appendSegment().getSource();
        frag2.append(frag1);
        Assert.assertNotSame((Object)frag1.getTags(), (Object)frag2.getTags());
        CTag co2 = (CTag)frag2.getTags().get("c1", TagType.OPENING);
        CTag cc2 = (CTag)frag2.getTags().get("c1", TagType.CLOSING);
        Assert.assertSame((Object)co2.cc, (Object)cc2.cc);
        Assert.assertEquals((Object)co1, (Object)co2);
        Assert.assertNotSame((Object)co1, (Object)co2);
        Assert.assertNotSame((Object)co1.cc, (Object)co2.cc);
        Assert.assertEquals((Object)co1.getCanDelete(), (Object)co2.getCanDelete());
        co2.setCanDelete(false);
        Assert.assertNotEquals((Object)co1.getCanDelete(), (Object)co2.getCanDelete());
        MTag mo2 = (MTag)frag2.getTags().get("m1", TagType.OPENING);
        MTag mc2 = (MTag)frag2.getTags().get("m1", TagType.CLOSING);
        Assert.assertSame((Object)mo2.mc, (Object)mc2.mc);
        Assert.assertEquals((Object)mo1, (Object)mo2);
        Assert.assertNotSame((Object)mo1, (Object)mo2);
        Assert.assertNotSame((Object)mo1.mc, (Object)mo2.mc);
        Assert.assertSame((Object)mo1.getTranslate(), (Object)mo2.getTranslate());
        mo2.setTranslate(Boolean.valueOf(false));
        Assert.assertNotSame((Object)mo1.getTranslate(), (Object)mo2.getTranslate());
    }
}

