/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.changeTracking;

import java.util.List;
import net.sf.okapi.lib.xliff2.changeTracking.ChangeTrack;
import net.sf.okapi.lib.xliff2.changeTracking.Item;
import net.sf.okapi.lib.xliff2.changeTracking.Revision;
import net.sf.okapi.lib.xliff2.changeTracking.Revisions;
import net.sf.okapi.lib.xliff2.core.MidFileData;
import net.sf.okapi.lib.xliff2.core.StartGroupData;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.reader.Event;
import net.sf.okapi.lib.xliff2.test.U;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ChangeTrackTest {
    @Test
    public void testCreationByGet() {
        Unit unit = new Unit("id1");
        Assert.assertEquals((long)0L, (long)unit.getChangeTrack().size());
        StartGroupData sgd = new StartGroupData("id2");
        Assert.assertEquals((long)0L, (long)sgd.getChangeTrack().size());
        MidFileData mfd = new MidFileData();
        Assert.assertEquals((long)0L, (long)mfd.getChangeTrack().size());
    }

    @Test
    public void testDefaults() {
        ChangeTrack c = new ChangeTrack();
        Assert.assertTrue((boolean)c.isEmpty());
        Revisions revs = new Revisions();
        Assert.assertTrue((boolean)revs.isEmpty());
        revs.setAppliesTo("note");
        revs.setCurrentVersion("v1");
        Revision rev = new Revision();
        Assert.assertTrue((boolean)rev.isEmpty());
        rev.setAuthor("a");
        rev.setVersion("v1");
        String dt = "1994-11-05T08:15:30-05:00";
        rev.setDatetime("1994-11-05T08:15:30-05:00");
        Item item = new Item("prop");
        item.setText("text");
        rev.add((Object)item);
        revs.add((Object)rev);
        c.add((Object)revs);
        Assert.assertFalse((boolean)c.isEmpty());
        revs = (Revisions)c.get(0);
        Assert.assertFalse((boolean)revs.isEmpty());
        Assert.assertEquals((Object)"note", (Object)revs.getAppliesTo());
        rev = (Revision)revs.get(0);
        Assert.assertFalse((boolean)rev.isEmpty());
        Assert.assertEquals((Object)"a", (Object)rev.getAuthor());
        Assert.assertEquals((Object)"1994-11-05T08:15:30-05:00", (Object)rev.getDatetime());
        Assert.assertEquals((Object)"v1", (Object)rev.getVersion());
        Assert.assertEquals((Object)"text", (Object)((Item)rev.get(0)).getText());
        Assert.assertEquals((Object)"prop", (Object)((Item)rev.get(0)).getProperty());
    }

    @Test
    public void testReadRevision() {
        String text = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file id=\"f1\">\n<unit id=\"id\">\n<ctr:changeTrack xmlns:ctr=\"urn:oasis:names:tc:xliff:changetracking:2.0\" xmlns:myNS=\"mine\">\n<ctr:revisions appliesTo=\"target\" myNS:myAttr=\"someData1\">\n<ctr:revision myNS:myAttr=\"someData2\">\n<ctr:item property=\"content\" myNS:myAttr=\"someData3\">source</ctr:item>\n</ctr:revision>\n</ctr:revisions>\n</ctr:changeTrack>\n<segment>\n<source>source</source>\n<target>translation</target>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        List<Event> events = U.getEvents(text);
        Unit unit = U.getUnit(events);
        ChangeTrack ct = unit.getChangeTrack();
        Revisions revs = (Revisions)ct.get(0);
        Assert.assertEquals((Object)"someData1", (Object)revs.getExtAttributeValue("mine", "myAttr"));
        Assert.assertEquals((Object)"target", (Object)revs.getAppliesTo());
        Revision rev = (Revision)revs.get(0);
        Assert.assertEquals((Object)"someData2", (Object)rev.getExtAttributeValue("mine", "myAttr"));
        Item item = (Item)rev.get(0);
        Assert.assertEquals((Object)"content", (Object)item.getProperty());
        Assert.assertEquals((Object)"source", (Object)item.getText());
        Assert.assertEquals((Object)"someData3", (Object)item.getExtAttributeValue("mine", "myAttr"));
    }

    @Test
    public void testAdd() {
        String text = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file id=\"f1\">\n<unit id=\"id\">\n<originalData>\n<data id=\"d1\">[br]</data>\n</originalData>\n<segment>\n<source>source<ph id=\"1\" dataRef=\"d1\"/></source>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        List<Event> events = U.getEvents(text);
        Unit unit = U.getUnit(events);
        Revisions revs = new Revisions();
        unit.getChangeTrack().add((Object)revs);
        revs.setAppliesTo("source");
        Revision rev = new Revision();
        ((Item)rev.add((Object)new Item("content"))).setText("t");
        revs.add((Object)rev);
        String expected = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\" xmlns:its=\"http://www.w3.org/2005/11/its\" xmlns:itsxlf=\"http://www.w3.org/ns/its-xliff/\" its:version=\"2.0\">\n<file id=\"f1\">\n<unit id=\"id\">\n<ctr:changeTrack xmlns:ctr=\"urn:oasis:names:tc:xliff:changetracking:2.0\">\n<ctr:revisions appliesTo=\"source\">\n<ctr:revision>\n<ctr:item property=\"content\">t</ctr:item>\n</ctr:revision>\n</ctr:revisions>\n</ctr:changeTrack>\n<originalData>\n<data id=\"d1\">[br]</data>\n</originalData>\n<segment>\n<source>source<ph id=\"1\" dataRef=\"d1\"/></source>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        Assert.assertEquals((Object)expected, (Object)U.writeEvents(events));
        U.getEvents(expected);
    }
}

