/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2;

import javax.xml.namespace.QName;
import net.sf.okapi.lib.xliff2.Util;
import net.sf.okapi.lib.xliff2.core.ExtElement;
import net.sf.okapi.lib.xliff2.core.Segment;
import net.sf.okapi.lib.xliff2.core.Unit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class UtilTest {
    @Test
    public void testIsValidNmtoken() {
        String supChar = new StringBuilder().appendCodePoint(134047).toString();
        Assert.assertTrue((boolean)Util.isValidNmtoken((String)"123"));
        Assert.assertTrue((boolean)Util.isValidNmtoken((String)"abc"));
        Assert.assertTrue((boolean)Util.isValidNmtoken((String)"\u0100etc"));
        Assert.assertTrue((boolean)Util.isValidNmtoken((String)".id"));
        Assert.assertTrue((boolean)Util.isValidNmtoken((String)("id" + supChar)));
        Assert.assertFalse((boolean)Util.isValidNmtoken((String)"#id"));
        Assert.assertFalse((boolean)Util.isValidNmtoken((String)"val/"));
        Assert.assertFalse((boolean)Util.isValidNmtoken((String)"id&"));
        Assert.assertFalse((boolean)Util.isValidNmtoken((String)"~ab"));
        Assert.assertFalse((boolean)Util.isValidNmtoken((String)"a=b"));
        Assert.assertFalse((boolean)Util.isValidNmtoken((String)"id$"));
        Assert.assertFalse((boolean)Util.isValidNmtoken((String)(supChar + "@")));
        Assert.assertFalse((boolean)Util.isValidNmtoken((String)"id|"));
    }

    @Test
    public void testRemoveExtensions() {
        Unit unit = new Unit("u1");
        Segment seg = unit.appendSegment();
        seg.setSource("text");
        unit.getExtAttributes().setAttribute("myNS", "attr1", "val1");
        unit.getExtAttributes().setAttribute("urn:oasis:names:tc:xliff:fs:2.0", "fs", "p");
        unit.getExtAttributes().setAttribute("myNS", "attr3", "val3");
        unit.getExtAttributes().setAttribute("myNS", "attr4", "val4");
        unit.getExtElements().add(new ExtElement(new QName("myNS", "elem1")));
        unit.getExtElements().add(new ExtElement(new QName("myNS", "elem2")));
        unit.getExtElements().add(new ExtElement(new QName("urn:oasis:names:tc:xliff:glossary:2.0", "gloss")));
        unit.getExtElements().add(new ExtElement(new QName("myNS", "elem4")));
        Assert.assertTrue((boolean)unit.hasExtAttribute());
        Assert.assertEquals((long)4L, (long)unit.getExtAttributes().size());
        Assert.assertTrue((boolean)unit.hasExtElements());
        Assert.assertEquals((long)4L, (long)unit.getExtElements().size());
        Util.removeExtensions((Object)unit);
        Assert.assertEquals((long)1L, (long)unit.getExtAttributes().size());
        Assert.assertEquals((Object)"p", (Object)unit.getExtAttributeValue("urn:oasis:names:tc:xliff:fs:2.0", "fs"));
        Assert.assertEquals((long)1L, (long)unit.getExtElements().size());
        Assert.assertEquals((Object)"gloss", (Object)unit.getExtElements().get(0).getQName().getLocalPart());
    }

    @Test
    public void testLang() {
        Assert.assertNull((Object)Util.validateLang((String)"en"));
        Assert.assertNull((Object)Util.validateLang((String)"en-us"));
        Assert.assertNull((Object)Util.validateLang((String)"i-klingon"));
        Assert.assertNull((Object)Util.validateLang((String)"mN-cYrL-Mn"));
        Assert.assertNull((Object)Util.validateLang((String)"en-x-US"));
        Assert.assertNull((Object)Util.validateLang((String)"es-419"));
        Assert.assertNull((Object)Util.validateLang((String)"az-Arab-x-AZE-derbend"));
        Assert.assertNull((Object)Util.validateLang((String)"sl-Latn-IT-rozaj"));
        Assert.assertNull((Object)Util.validateLang((String)"zh-cmn-Hant-HK"));
        Assert.assertNull((Object)Util.validateLang((String)"en-Latn-GB-boont-r-extended-sequence-x-private"));
        Assert.assertNotNull((Object)Util.validateLang(null));
        Assert.assertNotNull((Object)Util.validateLang((String)""));
        Assert.assertNotNull((Object)Util.validateLang((String)"f-Latn"));
        Assert.assertNotNull((Object)Util.validateLang((String)"fra-FX"));
        Assert.assertNotNull((Object)Util.validateLang((String)"zh-Latm-CN"));
        Assert.assertNotNull((Object)Util.validateLang((String)"de-DE-1902"));
        Assert.assertNotNull((Object)Util.validateLang((String)"fr-shadok"));
    }

    @Test
    public void testSupports() {
        Assert.assertTrue((boolean)Util.supports((String)"urn:oasis:names:tc:xliff:matches:2.0"));
        Assert.assertTrue((boolean)Util.supports((String)"urn:oasis:names:tc:xliff:metadata:2.0"));
        Assert.assertTrue((boolean)Util.supports((String)"urn:oasis:names:tc:xliff:glossary:2.0"));
        Assert.assertTrue((boolean)Util.supports((String)"urn:oasis:names:tc:xliff:validation:2.0"));
        Assert.assertTrue((boolean)Util.supports((String)"urn:oasis:names:tc:xliff:changetracking:2.0"));
        Assert.assertFalse((boolean)Util.supports((String)"urn:oasis:names:tc:xliff:fs:2.0"));
        Assert.assertFalse((boolean)Util.supports((String)"urn:oasis:names:tc:xliff:resourcedata:2.0"));
        Assert.assertFalse((boolean)Util.supports((String)"urn:oasis:names:tc:xliff:sizerestriction:2.0"));
    }

    @Test
    public void testIsValidXML() {
        Assert.assertTrue((boolean)Util.isValidInXML((int)99));
        Assert.assertTrue((boolean)Util.isValidInXML((int)0x10FFFF));
        Assert.assertFalse((boolean)Util.isValidInXML((int)Integer.MAX_VALUE));
        Assert.assertFalse((boolean)Util.isValidInXML((int)-1879048193));
        Assert.assertFalse((boolean)Util.isValidInXML((int)0x110000));
        Assert.assertFalse((boolean)Util.isValidInXML((int)12));
    }
}

