/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.writer;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.namespace.QName;
import net.sf.okapi.lib.xliff2.changeTracking.ChangeTrack;
import net.sf.okapi.lib.xliff2.changeTracking.Item;
import net.sf.okapi.lib.xliff2.changeTracking.Revision;
import net.sf.okapi.lib.xliff2.changeTracking.Revisions;
import net.sf.okapi.lib.xliff2.core.CTag;
import net.sf.okapi.lib.xliff2.core.Directionality;
import net.sf.okapi.lib.xliff2.core.ExtContent;
import net.sf.okapi.lib.xliff2.core.ExtElement;
import net.sf.okapi.lib.xliff2.core.ExtElements;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.IExtChild;
import net.sf.okapi.lib.xliff2.core.MTag;
import net.sf.okapi.lib.xliff2.core.MidFileData;
import net.sf.okapi.lib.xliff2.core.Note;
import net.sf.okapi.lib.xliff2.core.Part;
import net.sf.okapi.lib.xliff2.core.Segment;
import net.sf.okapi.lib.xliff2.core.StartFileData;
import net.sf.okapi.lib.xliff2.core.StartGroupData;
import net.sf.okapi.lib.xliff2.core.StartXliffData;
import net.sf.okapi.lib.xliff2.core.TagType;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.document.FileNode;
import net.sf.okapi.lib.xliff2.document.GroupNode;
import net.sf.okapi.lib.xliff2.document.UnitNode;
import net.sf.okapi.lib.xliff2.document.XLIFFDocument;
import net.sf.okapi.lib.xliff2.glossary.GlossEntry;
import net.sf.okapi.lib.xliff2.glossary.Term;
import net.sf.okapi.lib.xliff2.matches.Match;
import net.sf.okapi.lib.xliff2.matches.Matches;
import net.sf.okapi.lib.xliff2.metadata.Meta;
import net.sf.okapi.lib.xliff2.metadata.MetaGroup;
import net.sf.okapi.lib.xliff2.reader.XLIFFReader;
import net.sf.okapi.lib.xliff2.test.U;
import net.sf.okapi.lib.xliff2.validation.Rule;
import net.sf.okapi.lib.xliff2.writer.XLIFFWriter;
import org.junit.Assert;
import org.junit.Test;

public class XLIFFWriterTest {
    private static final String STARTDOC = "<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" ";

    @Test
    public void testEmptyDoc() {
        XLIFFWriter writer = new XLIFFWriter();
        StringWriter strWriter = new StringWriter();
        writer.setLineBreak("\n");
        writer.setWithOriginalData(true);
        writer.create((Writer)strWriter, "en");
        writer.writeStartDocument(null, null);
        writer.writeStartGroup(null);
        writer.writeEndGroup();
        writer.writeEndDocument();
        writer.close();
        Assert.assertEquals((Object)"<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\">\n<file id=\"f1\">\n<group id=\"g1\">\n</group>\n</file>\n</xliff>\n", (Object)strWriter.toString());
        XLIFFReader.validate((String)strWriter.toString(), null);
    }

    @Test
    public void testDirectoryCreation() {
        String root = U.getParentDir(this, "/example.xlf");
        String path = root + "/dir1/dir two/file with spaces.xlf";
        File file = new File(path);
        file.delete();
        file.getParentFile().delete();
        XLIFFWriter writer = new XLIFFWriter();
        writer.setLineBreak("\n");
        writer.setWithOriginalData(true);
        writer.create(file, "en");
        writer.writeStartDocument(null, null);
        writer.writeStartGroup(null);
        writer.writeEndGroup();
        writer.writeEndDocument();
        writer.close();
        Assert.assertTrue((boolean)file.exists());
        XLIFFReader.validate((File)file);
    }

    @Test
    public void testPresettingFileId() {
        XLIFFWriter writer = new XLIFFWriter();
        StringWriter strWriter = new StringWriter();
        writer.setLineBreak("\n");
        writer.setWithOriginalData(true);
        writer.create((Writer)strWriter, "en");
        writer.writeStartDocument(null, null);
        StartFileData sfd = new StartFileData("myFileId");
        writer.setStartFileData(sfd);
        writer.writeStartGroup(null);
        writer.writeEndGroup();
        writer.writeEndDocument();
        writer.close();
        Assert.assertEquals((Object)"<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\">\n<file id=\"myFileId\">\n<group id=\"g1\">\n</group>\n</file>\n</xliff>\n", (Object)strWriter.toString());
        XLIFFReader.validate((String)strWriter.toString(), null);
    }

    @Test
    public void testPresettingFileStartButNoId() {
        XLIFFWriter writer = new XLIFFWriter();
        StringWriter strWriter = new StringWriter();
        writer.setLineBreak("\n");
        writer.setWithOriginalData(true);
        writer.create((Writer)strWriter, "en");
        writer.writeStartDocument(null, null);
        StartFileData sfd = new StartFileData(null);
        sfd.setOriginal("original");
        writer.setStartFileData(sfd);
        writer.writeStartGroup(null);
        writer.writeEndGroup();
        writer.writeEndDocument();
        writer.close();
        Assert.assertEquals((Object)"<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\">\n<file id=\"f1\" original=\"original\">\n<group id=\"g1\">\n</group>\n</file>\n</xliff>\n", (Object)strWriter.toString());
        XLIFFReader.validate((String)strWriter.toString(), null);
    }

    @Test
    public void testWithExtensionAttributes() {
        XLIFFWriter writer = new XLIFFWriter();
        StringWriter strWriter = new StringWriter();
        writer.setLineBreak("\n");
        writer.setWithOriginalData(true);
        writer.create((Writer)strWriter, "en");
        StartXliffData dd = new StartXliffData(null);
        dd.setNamespace("its", "http://www.w3.org/2005/11/its");
        dd.getExtAttributes().setAttribute("http://www.w3.org/2005/11/its", "version", "2.0");
        writer.writeStartDocument(dd, "comment");
        writer.writeStartGroup(null);
        writer.writeEndGroup();
        writer.writeEndDocument();
        writer.close();
        Assert.assertEquals((Object)"<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" xmlns:its=\"http://www.w3.org/2005/11/its\" its:version=\"2.0\">\n<!-- comment -->\n<file id=\"f1\">\n<group id=\"g1\">\n</group>\n</file>\n</xliff>\n", (Object)strWriter.toString());
        XLIFFReader.validate((String)strWriter.toString(), null);
    }

    @Test
    public void testCloseable() {
        Unit unit = new Unit("id");
        unit.appendSegment().setSource("text");
        StringWriter strWriter = new StringWriter();
        try (XLIFFWriter writer = new XLIFFWriter();){
            writer.create((Writer)strWriter, "fr-CA");
            writer.writeUnit(unit);
        }
        Unit ures = U.getUnit(U.getEvents(strWriter.toString()));
        Assert.assertEquals((Object)"text", (Object)ures.getPart(0).getSource().toString());
    }

    @Test
    public void testOneUnitWithEmpties() {
        XLIFFWriter writer = new XLIFFWriter();
        StringWriter strWriter = new StringWriter();
        writer.setLineBreak("\n");
        writer.setWithOriginalData(true);
        writer.create((Writer)strWriter, "en");
        writer.writeUnit(new Unit("id1"));
        Unit unit = new Unit("id2");
        unit.appendIgnorable();
        writer.writeUnit(unit);
        unit = new Unit("id3");
        unit.appendSegment();
        writer.writeUnit(unit);
        writer.writeEndDocument();
        writer.close();
        Assert.assertEquals((Object)"<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\">\n<file id=\"f1\">\n<unit id=\"id2\">\n<ignorable>\n<source></source>\n</ignorable>\n<segment>\n<source></source>\n</segment>\n</unit>\n<unit id=\"id3\">\n<segment>\n<source></source>\n</segment>\n</unit>\n</file>\n</xliff>\n", (Object)strWriter.toString());
        XLIFFReader.validate((String)strWriter.toString(), null);
    }

    @Test
    public void testTwoSegments() {
        XLIFFWriter writer = new XLIFFWriter();
        StringWriter strWriter = new StringWriter();
        writer.setLineBreak("\n");
        writer.create((Writer)strWriter, "en");
        Unit unit = new Unit("id");
        unit.appendSegment().setSource("Source 1.");
        unit.appendSegment().setSource("Source 2.");
        writer.writeUnit(unit);
        writer.close();
        Assert.assertEquals((Object)"<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\">\n<file id=\"f1\">\n<unit id=\"id\">\n<segment>\n<source>Source 1.</source>\n</segment>\n<segment>\n<source>Source 2.</source>\n</segment>\n</unit>\n</file>\n</xliff>\n", (Object)strWriter.toString());
        XLIFFReader.validate((String)strWriter.toString(), null);
    }

    @Test
    public void testDirectionality() {
        XLIFFWriter writer = new XLIFFWriter();
        StringWriter strWriter = new StringWriter();
        writer.setLineBreak("\n");
        writer.create((Writer)strWriter, "en", "fr");
        StartFileData sd = new StartFileData("idsd");
        sd.setSourceDir(Directionality.RTL);
        sd.setTargetDir(Directionality.RTL);
        writer.writeStartFile(sd);
        Unit unit = new Unit("id1", sd);
        unit.appendSegment().setSource("text1");
        Assert.assertEquals((Object)Directionality.RTL, (Object)unit.getSourceDir());
        Assert.assertEquals((Object)Directionality.RTL, (Object)unit.getTargetDir());
        writer.writeUnit(unit);
        unit = new Unit("id2", sd);
        unit.appendSegment().setSource("text2");
        unit.setSourceDir(Directionality.LTR);
        Assert.assertEquals((Object)Directionality.LTR, (Object)unit.getSourceDir());
        Assert.assertEquals((Object)Directionality.RTL, (Object)unit.getTargetDir());
        Assert.assertEquals((Object)Directionality.LTR, (Object)unit.getPart(0).getSource().getDir(true));
        Segment seg = unit.appendSegment();
        seg.setSource("text3");
        seg.getSource().setDir(Directionality.RTL);
        seg.setTarget("trgText3");
        seg.getTarget().setDir(Directionality.RTL);
        Assert.assertEquals((Object)Directionality.RTL, (Object)unit.getPart(1).getSource().getDir(true));
        Assert.assertEquals((Object)Directionality.LTR, (Object)unit.getPart(0).getSource().getDir(true));
        writer.writeUnit(unit);
        writer.close();
        Assert.assertEquals((Object)"<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\">\n<file id=\"idsd\" srcDir=\"rtl\" trgDir=\"rtl\">\n<unit id=\"id1\">\n<segment>\n<source>text1</source>\n</segment>\n</unit>\n<unit id=\"id2\" srcDir=\"ltr\">\n<segment>\n<source>text2</source>\n</segment>\n<segment>\n<source>text3</source>\n<target>trgText3</target>\n</segment>\n</unit>\n</file>\n</xliff>\n", (Object)strWriter.toString());
        XLIFFReader.validate((String)strWriter.toString(), null);
    }

    @Test
    public void testIsolatedAttributeSameUnit() {
        XLIFFWriter writer = new XLIFFWriter();
        StringWriter strWriter = new StringWriter();
        writer.create((Writer)strWriter, "en");
        writer.setLineBreak("\n");
        writer.setWithOriginalData(false);
        Unit unit = new Unit("id");
        Segment seg = unit.appendSegment();
        seg.getSource().append(TagType.OPENING, "B1", "<B>", false);
        seg.getSource().append(TagType.OPENING, "U1", "<U>", false);
        seg.getSource().append(TagType.CLOSING, "I1", "</I>", false);
        seg.getSource().append((CharSequence)"s1. ");
        seg.getSource().append(TagType.CLOSING, "U1", "</U>", false);
        seg = unit.appendSegment();
        seg.getSource().append((CharSequence)"s2.");
        seg.getSource().append(TagType.CLOSING, "B1", "</B>", false);
        writer.writeUnit(unit);
        writer.close();
        Assert.assertEquals((Object)"<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\">\n<file id=\"f1\">\n<unit id=\"id\">\n<segment>\n<source><sc id=\"B1\" canOverlap=\"no\"/><sc id=\"U1\" canOverlap=\"no\"/><ec id=\"I1\" isolated=\"yes\" canOverlap=\"no\"/>s1. <ec startRef=\"U1\" canOverlap=\"no\"/></source>\n</segment>\n<segment>\n<source>s2.<ec startRef=\"B1\" canOverlap=\"no\"/></source>\n</segment>\n</unit>\n</file>\n</xliff>\n", (Object)strWriter.toString());
        XLIFFReader.validate((String)strWriter.toString(), null);
    }

    @Test
    public void testNotes() {
        XLIFFWriter writer = new XLIFFWriter();
        StringWriter strWriter = new StringWriter();
        writer.create((Writer)strWriter, "en");
        writer.setLineBreak("\n");
        writer.setUseIndentation(true);
        writer.setWithOriginalData(true);
        MidFileData midFileData = new MidFileData();
        midFileData.addNote(new Note("File note", Note.AppliesTo.UNDEFINED));
        writer.writeMidFile(midFileData);
        Note note = new Note("Group note", Note.AppliesTo.SOURCE);
        note.setId("n1");
        note.setPriority(2);
        note.setCategory("myCat");
        StartGroupData startGroupData = new StartGroupData("g1");
        startGroupData.addNote(note);
        writer.writeStartGroup(startGroupData);
        Unit unit = new Unit("id");
        Segment seg = unit.appendSegment();
        seg.setSource("Source").appendCode("1", "[br/]");
        unit.addNote(new Note("Unit note1", Note.AppliesTo.SOURCE));
        unit.addNote(new Note("Unit note2", Note.AppliesTo.UNDEFINED));
        writer.writeUnit(unit);
        writer.writeEndGroup();
        writer.close();
        Assert.assertEquals((Object)"<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\">\n <file id=\"f1\">\n  <notes>\n   <note>File note</note>\n  </notes>\n  <group id=\"g1\">\n   <notes>\n    <note id=\"n1\" appliesTo=\"source\" priority=\"2\" category=\"myCat\">Group note</note>\n   </notes>\n   <unit id=\"id\">\n    <notes>\n     <note appliesTo=\"source\">Unit note1</note>\n     <note>Unit note2</note>\n    </notes>\n    <originalData>\n     <data id=\"d1\">[br/]</data>\n    </originalData>\n    <segment>\n     <source>Source<ph id=\"1\" dataRef=\"d1\"/></source>\n    </segment>\n   </unit>\n  </group>\n </file>\n</xliff>\n", (Object)strWriter.toString());
        XLIFFReader.validate((String)strWriter.toString(), null);
    }

    @Test
    public void testChangeTrack() {
        XLIFFWriter writer = new XLIFFWriter();
        StringWriter strWriter = new StringWriter();
        writer.create((Writer)strWriter, "en");
        writer.setLineBreak("\n");
        writer.setUseIndentation(true);
        writer.setWithOriginalData(true);
        Unit unit = new Unit("id");
        Segment seg = unit.appendSegment();
        seg.setSource("Source").appendCode("1", "[br/]");
        Note note = new Note("Unit note1", Note.AppliesTo.SOURCE);
        note.setId("n1");
        unit.addNote(note);
        note = new Note("Unit note2", Note.AppliesTo.UNDEFINED);
        note.setId("n2");
        unit.addNote(note);
        ChangeTrack chTrack = new ChangeTrack();
        Revisions revisions = new Revisions("note");
        revisions.setRef("n1");
        chTrack.add((Object)revisions);
        Revision revision = new Revision();
        revision.setAuthor("system");
        revision.setDatetime("2015-10-21T09:00:00+00:00");
        revisions.add((Object)revision);
        Item item = new Item("content");
        item.setText("old note");
        revision.add((Object)item);
        unit.setChangeTrack(chTrack);
        writer.writeUnit(unit);
        writer.close();
        System.out.println(strWriter.toString());
        String expectedString = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\">\n <file id=\"f1\">\n  <unit id=\"id\">\n   <ctr:changeTrack xmlns:ctr=\"urn:oasis:names:tc:xliff:changetracking:2.0\">\n    <ctr:revisions appliesTo=\"note\" ref=\"n1\">\n     <ctr:revision author=\"system\" datetime=\"2015-10-21T09:00:00+00:00\">\n      <ctr:item property=\"content\">old note</ctr:item>\n     </ctr:revision>\n    </ctr:revisions>\n   </ctr:changeTrack>\n   <notes>\n    <note id=\"n1\" appliesTo=\"source\">Unit note1</note>\n    <note id=\"n2\">Unit note2</note>\n   </notes>\n   <originalData>\n    <data id=\"d1\">[br/]</data>\n   </originalData>\n   <segment>\n    <source>Source<ph id=\"1\" dataRef=\"d1\"/></source>\n   </segment>\n  </unit>\n </file>\n</xliff>\n";
        Assert.assertEquals((Object)expectedString, (Object)strWriter.toString());
        XLIFFReader.validate((String)strWriter.toString(), null);
    }

    @Test
    public void testSegmentOutputWithCodesOutside() {
        XLIFFWriter writer = new XLIFFWriter();
        StringWriter strWriter = new StringWriter();
        writer.create((Writer)strWriter, "en", "fr");
        writer.setLineBreak("\n");
        writer.setWithOriginalData(true);
        Unit unit = new Unit("id");
        this.createSegment(unit);
        writer.writeUnit(unit);
        writer.close();
        Assert.assertEquals((Object)"<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\">\n<file id=\"f1\">\n<unit id=\"id\">\n<originalData>\n<data id=\"d1\">&lt;b></data>\n<data id=\"d2\">&lt;/b></data>\n<data id=\"d3\">&lt;![CDATA[..&lt;c/>..]]&gt;</data>\n<data id=\"d4\">&lt;/B></data>\n</originalData>\n<segment>\n<source><pc id=\"1\" dataRefEnd=\"d2\" dataRefStart=\"d1\">source</pc><ph id=\"2\" dataRef=\"d3\"/></source>\n<target><pc id=\"1\" dataRefEnd=\"d4\" dataRefStart=\"d1\">target</pc><ph id=\"2\" dataRef=\"d3\"/></target>\n</segment>\n</unit>\n</file>\n</xliff>\n", (Object)strWriter.toString());
        XLIFFReader.validate((String)strWriter.toString(), null);
    }

    @Test
    public void testSegmentOutputWithEmptyCodesOutside() {
        XLIFFWriter writer = new XLIFFWriter();
        StringWriter strWriter = new StringWriter();
        writer.create((Writer)strWriter, "en");
        writer.setLineBreak("\n");
        writer.setWithOriginalData(true);
        Unit unit = new Unit("id");
        Segment seg = unit.appendSegment();
        seg.getSource().append(TagType.STANDALONE, "ph1", "[br/]", false);
        seg.getSource().append(TagType.STANDALONE, "ph2", "", false);
        seg.getSource().append(TagType.STANDALONE, "ph3", null, false);
        writer.writeUnit(unit);
        writer.close();
        Assert.assertEquals((Object)"<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\">\n<file id=\"f1\">\n<unit id=\"id\">\n<originalData>\n<data id=\"d1\">[br/]</data>\n</originalData>\n<segment>\n<source><ph id=\"ph1\" dataRef=\"d1\"/><ph id=\"ph2\"/><ph id=\"ph3\"/></source>\n</segment>\n</unit>\n</file>\n</xliff>\n", (Object)strWriter.toString());
        XLIFFReader.validate((String)strWriter.toString(), null);
    }

    @Test
    public void testSegmentOutputWithoutCodes() {
        XLIFFWriter writer = new XLIFFWriter();
        StringWriter strWriter = new StringWriter();
        writer.create((Writer)strWriter, "en", "fr");
        writer.setLineBreak("\n");
        writer.setWithOriginalData(false);
        Unit unit = new Unit("id");
        this.createSegment(unit);
        writer.writeUnit(unit);
        writer.close();
        Assert.assertEquals((Object)"<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\">\n<file id=\"f1\">\n<unit id=\"id\">\n<segment>\n<source><pc id=\"1\">source</pc><ph id=\"2\"/></source>\n<target><pc id=\"1\">target</pc><ph id=\"2\"/></target>\n</segment>\n</unit>\n</file>\n</xliff>\n", (Object)strWriter.toString());
        XLIFFReader.validate((String)strWriter.toString(), null);
    }

    @Test
    public void testSegmentOutputWithoutOriginalData() {
        XLIFFWriter writer = new XLIFFWriter();
        StringWriter strWriter = new StringWriter();
        writer.create((Writer)strWriter, "en", "fr");
        writer.setLineBreak("\n");
        writer.setWithOriginalData(false);
        Unit unit = new Unit("id");
        this.createSegment(unit);
        writer.writeUnit(unit);
        writer.close();
        Assert.assertEquals((Object)"<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\">\n<file id=\"f1\">\n<unit id=\"id\">\n<segment>\n<source><pc id=\"1\">source</pc><ph id=\"2\"/></source>\n<target><pc id=\"1\">target</pc><ph id=\"2\"/></target>\n</segment>\n</unit>\n</file>\n</xliff>\n", (Object)strWriter.toString());
        XLIFFReader.validate((String)strWriter.toString(), null);
    }

    @Test
    public void testExtensionElements() {
        Unit unit = new Unit("id");
        Segment seg = unit.appendSegment();
        seg.setSource("Source.");
        unit.setExtElements(new ExtElements()).add(new ExtElement(new QName("myNamespaceURI", "myElement", "x1"))).addChild((IExtChild)new ExtContent("The content of the extension element."));
        XLIFFWriter writer = new XLIFFWriter();
        StringWriter strWriter = new StringWriter();
        writer.create((Writer)strWriter, "en");
        writer.setLineBreak("\n");
        writer.writeUnit(unit);
        writer.close();
        Assert.assertEquals((Object)"<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\">\n<file id=\"f1\">\n<unit id=\"id\">\n<x1:myElement xmlns:x1=\"myNamespaceURI\">The content of the extension element.</x1:myElement>\n<segment>\n<source>Source.</source>\n</segment>\n</unit>\n</file>\n</xliff>\n", (Object)strWriter.toString());
        XLIFFReader.validate((String)strWriter.toString(), null);
    }

    @Test
    public void testSegmentOrder() {
        Unit unit = new Unit("id");
        Segment seg = unit.appendSegment();
        seg.setSource("Source A.");
        seg.setTarget("Target A.");
        seg.setTargetOrder(3);
        unit.appendIgnorable().setSource(" ");
        seg = unit.appendSegment();
        seg.setSource("Source B.");
        seg.setTarget("Target B");
        seg.setTargetOrder(1);
        XLIFFWriter writer = new XLIFFWriter();
        StringWriter strWriter = new StringWriter();
        writer.create((Writer)strWriter, "en", "fr");
        writer.setLineBreak("\n");
        writer.writeUnit(unit);
        writer.close();
        Assert.assertEquals((Object)"<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\">\n<file id=\"f1\">\n<unit id=\"id\">\n<segment>\n<source>Source A.</source>\n<target order=\"3\">Target A.</target>\n</segment>\n<ignorable>\n<source> </source>\n</ignorable>\n<segment>\n<source>Source B.</source>\n<target order=\"1\">Target B</target>\n</segment>\n</unit>\n</file>\n</xliff>\n", (Object)strWriter.toString());
        XLIFFReader.validate((String)strWriter.toString(), null);
    }

    @Test
    public void testInvalidCharacters() {
        XLIFFWriter writer = new XLIFFWriter();
        StringWriter strWriter = new StringWriter();
        writer.setLineBreak("\n");
        writer.setWithOriginalData(true);
        writer.create((Writer)strWriter, "en");
        Unit unit = new Unit("1");
        unit.appendIgnorable().getSource().append((CharSequence)"\u0019\ufffe");
        Fragment frag = unit.appendSegment().getSource();
        frag.append((CharSequence)"\u0019\ufffe");
        frag.append(TagType.STANDALONE, "1", "\u0019\ufffe", true);
        writer.writeUnit(unit);
        writer.close();
        Assert.assertEquals((Object)"<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\">\n<file id=\"f1\">\n<unit id=\"1\">\n<originalData>\n<data id=\"d1\"><cp hex=\"0019\"/><cp hex=\"FFFE\"/></data>\n</originalData>\n<ignorable>\n<source><cp hex=\"0019\"/><cp hex=\"FFFE\"/></source>\n</ignorable>\n<segment>\n<source><cp hex=\"0019\"/><cp hex=\"FFFE\"/><ph id=\"1\" dataRef=\"d1\"/></source>\n</segment>\n</unit>\n</file>\n</xliff>\n", (Object)strWriter.toString());
        XLIFFReader.validate((String)strWriter.toString(), null);
    }

    @Test
    public void testRewrite() {
        String input = "<?xml version='1.0'?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\">\n<file translate=\"no\" id=\"fid1\" original=\"ori\">\n<unit id=\"id\" canResegment=\"no\">\n<segment>\n<source>Source 1.</source>\n<target>Target 1.</target>\n</segment>\n<segment>\n<source>Source 2.</source>\n<target>Target 2.</target>\n</segment>\n</unit>\n</file>\n</xliff>";
        XLIFFReader reader = new XLIFFReader(255);
        XLIFFWriter writer = new XLIFFWriter();
        reader.open(input);
        StringWriter strWriter = new StringWriter();
        writer.create((Writer)strWriter, "fr");
        writer.setLineBreak("\n");
        while (reader.hasNext()) {
            writer.writeEvent(reader.next());
        }
        writer.close();
        reader.close();
        String expected = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\">\n<file id=\"fid1\" translate=\"no\" original=\"ori\">\n<unit id=\"id\" canResegment=\"no\">\n<segment>\n<source>Source 1.</source>\n<target>Target 1.</target>\n</segment>\n<segment>\n<source>Source 2.</source>\n<target>Target 2.</target>\n</segment>\n</unit>\n</file>\n</xliff>\n";
        Assert.assertEquals((Object)expected, (Object)strWriter.toString());
        XLIFFReader.validate((String)strWriter.toString(), null);
    }

    @Test
    public void testCreateWriteVerify() {
        XLIFFDocument doc = new XLIFFDocument(new StartXliffData(null));
        doc.setLineBreak("\n");
        doc.getStartXliffData().setSourceLanguage("en");
        doc.getStartXliffData().setTargetLanguage("fr");
        FileNode fn = doc.addFileNode("f1");
        String myNS = "http://myNamespaceURI";
        fn.getStartData().getExtAttributes().setAttribute("http://myNamespaceURI", "attr", "value");
        MidFileData mfd = new MidFileData();
        fn.setMidData(mfd);
        ExtElement xe = mfd.getExtElements().add("http://myNamespaceURI", "elem", "my");
        xe.addContent("Some text");
        xe.addContent(" and more data");
        xe.getExtAttributes().setAttribute("http://myNamespaceURI", "theAttr", "the Value");
        xe.getExtAttributes().setAttribute("anotherAttr", "another Value");
        xe = xe.addElement("teste2");
        xe.addContent("Content part 2");
        xe = xe.addElement("emptyElem");
        Note note = new Note("Note for f1");
        note.setPriority(9);
        note.getExtAttributes().setAttribute("http://myNamespaceURI", "attr", "value-in-note");
        note.getExtAttributes().setAttribute("urn:oasis:names:tc:xliff:fs:2.0", "fs", "b");
        mfd.addNote(note);
        mfd.getValidation().add((Object)new Rule("isPresent", "*"));
        GroupNode gn = fn.addGroupNode("g1");
        gn.get().getValidation().add((Object)new Rule("isPresent", "s"));
        gn.get().addNote(new Note("Note for g1"));
        gn.get().getExtAttributes().setAttribute("http://myNamespaceURI", "attr1", "value1");
        gn.get().getExtAttributes().setAttribute("http://myNamespaceURI", "attr2", "value2");
        MetaGroup mg = new MetaGroup("cat-mda1");
        mg.setId("mda1");
        Meta meta = new Meta("type-meta1", "value-meta1");
        mg.add((Object)meta);
        gn.get().getMetadata().addGroup(mg);
        mg = new MetaGroup();
        mg.setId("mda2");
        mg.setAppliesTo(MetaGroup.AppliesTo.SOURCE);
        MetaGroup mg2 = new MetaGroup();
        mg2.setId("mda2-2");
        meta = new Meta("type-meta2", "value-meta2");
        mg2.add((Object)meta);
        meta = new Meta("type-meta3", "value-meta3");
        mg2.add((Object)meta);
        mg.addGroup(mg2);
        gn.get().getMetadata().addGroup(mg);
        UnitNode un = gn.addUnitNode("g1u1");
        Segment seg = un.get().appendSegment();
        seg.getSource().append((CharSequence)"source g1u1");
        seg.getTarget(Part.GetTarget.CREATE_EMPTY).append((CharSequence)"target g1u1");
        un.get().addNote(new Note("Note for g1u1"));
        un.get().getValidation().add((Object)new Rule("isPresent", "r"));
        un = gn.addUnitNode("g1u2");
        Fragment frag = un.get().appendSegment().getSource();
        frag.append((CharSequence)"abc ");
        CTag ctag = frag.openCodeSpan("c1", "<B>");
        frag.append((CharSequence)"text");
        frag.closeCodeSpan("c1", "</B>");
        ctag.getExtAttributes().setAttribute("urn:oasis:names:tc:xliff:fs:2.0", "fs", "b");
        MTag mtag = frag.getOrCreateMarker(0, -1, null, "term");
        mtag.getExtAttributes().setAttribute("http://myNamespaceURI", "someAttr", "someValue");
        xe = un.get().getExtElements().add("some-uri", "localName", "prf");
        xe.addContent("Some text: <>/&\", etc.");
        GlossEntry ge = (GlossEntry)un.get().getGlossary().add((Object)new GlossEntry());
        Term term = new Term("my term");
        term.setSource("term source");
        term.getExtAttributes().setAttribute("http://myNamespaceURI", "attr", "value");
        ge.setTerm(term);
        ge.addTranslation("Translation1").setId("tid1");
        ge.addTranslation("Translation2").setSource("tsource2");
        Matches matches = un.get().getMatches();
        Match match = (Match)matches.add((Object)new Match());
        match.setId("mtc1");
        match.setRef("#" + mtag.getId());
        match.setSource(new Fragment(match.getStore(), false, "source match"));
        match.setTarget(new Fragment(match.getStore(), true, "target match"));
        match.setSimilarity(Double.valueOf(50.0));
        match = (Match)matches.add((Object)new Match());
        match.setId("mtc2");
        match.setRef("#" + mtag.getId());
        frag = new Fragment(match.getStore(), false, "Match ");
        frag.openCodeSpan("c1", "<U>");
        frag.append((CharSequence)"source 2");
        frag.closeCodeSpan("c1", "</U>");
        match.setSource(frag);
        frag = new Fragment(match.getStore(), true, "Match ");
        frag.openCodeSpan("c1", "<U>");
        frag.append((CharSequence)"target 2");
        frag.closeCodeSpan("c1", "</U>");
        match.setTarget(frag);
        match.setSimilarity(Double.valueOf(34.567));
        match.setMatchQuality(Double.valueOf(12.34));
        match.setOrigin("match 2 origin");
        StringWriter sw = new StringWriter();
        doc.save((Writer)sw);
        String output1 = sw.toString();
        doc.load(output1, 255);
        un = doc.getUnitNode("f1", "g1u1");
        Assert.assertEquals((Object)"target g1u1", (Object)un.get().getSegment(0).getTarget().toString());
        sw = new StringWriter();
        doc.save((Writer)sw);
        String output2 = sw.toString();
        Assert.assertEquals((Object)output1, (Object)output2);
    }

    @Test
    public void testExtendedChars() {
        XLIFFWriter writer = new XLIFFWriter();
        StringWriter strWriter = new StringWriter();
        writer.setLineBreak("\n");
        writer.setWithOriginalData(true);
        writer.create((Writer)strWriter, "en", "ja");
        writer.writeStartDocument(null, null);
        Unit unit = new Unit("id");
        unit.setName("\uff21, \uff80, \u1ee8, \u0950");
        Segment seg = unit.appendSegment();
        seg.getSource().append((CharSequence)"\uff21, \uff80, \u1ee8, \u0950");
        seg.getTarget(Part.GetTarget.CREATE_EMPTY).append((CharSequence)"\uff21, \uff80, \u1ee8, \u0950");
        writer.writeUnit(unit);
        writer.writeEndDocument();
        writer.close();
        Assert.assertEquals((Object)"<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"ja\">\n<file id=\"f1\">\n<unit id=\"id\" name=\"\uff21, \uff80, \u1ee8, \u0950\">\n<segment>\n<source>\uff21, \uff80, \u1ee8, \u0950</source>\n<target>\uff21, \uff80, \u1ee8, \u0950</target>\n</segment>\n</unit>\n</file>\n</xliff>\n", (Object)strWriter.toString());
        XLIFFReader.validate((String)strWriter.toString(), null);
    }

    private void createSegment(Unit unit) {
        Segment seg = unit.appendSegment();
        seg.getSource().append(TagType.OPENING, "1", "<b>", false);
        seg.getSource().append((CharSequence)"source");
        seg.getSource().append(TagType.CLOSING, "1", "</b>", false);
        seg.getSource().append(TagType.STANDALONE, "2", "<![CDATA[..<c/>..]]>", false);
        Fragment frag = seg.getTarget(Part.GetTarget.CREATE_EMPTY);
        frag.append(TagType.OPENING, "1", "<b>", false);
        frag.append((CharSequence)"target");
        frag.append(TagType.CLOSING, "1", "</B>", false);
        frag.append(TagType.STANDALONE, "2", "<![CDATA[..<c/>..]]>", false);
    }
}

