/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.walker;

import java.io.File;
import java.util.ArrayList;
import net.sf.okapi.lib.xliff2.core.Segment;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.document.FileNode;
import net.sf.okapi.lib.xliff2.document.UnitNode;
import net.sf.okapi.lib.xliff2.document.XLIFFDocument;
import net.sf.okapi.lib.xliff2.test.U;
import net.sf.okapi.lib.xliff2.walker.IXliffVisitor;
import net.sf.okapi.lib.xliff2.walker.VisitationContext;
import net.sf.okapi.lib.xliff2.walker.XliffWalker;
import net.sf.okapi.lib.xliff2.walker.selector.XliffWalkerPathSelector;
import net.sf.okapi.lib.xliff2.walker.strategy.IXliffWalkerStrategy;
import net.sf.okapi.lib.xliff2.walker.strategy.XliffWalkerStrategyFactory;
import net.sf.okapi.lib.xliff2.walker.test.TestFileVisitor;
import net.sf.okapi.lib.xliff2.walker.test.TestModifyingSegmentVisitor;
import net.sf.okapi.lib.xliff2.walker.test.TestSegmentVisitor;
import net.sf.okapi.lib.xliff2.walker.test.TestUnitVisitor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class XliffWalkerTest {
    private XLIFFDocument doc;
    private XliffWalker testWalker;
    private final String root = U.getParentDir(this, "/example.xlf");

    @Before
    public void setup() {
        File xlfFile = new File(this.root + "/valid/everything-core-walker.xlf");
        this.doc = new XLIFFDocument();
        this.doc.load(xlfFile, 255);
        Assert.assertNotNull((Object)this.doc);
        this.testWalker = new XliffWalker();
    }

    @Test
    public void testFlexibleStrategy() {
        IXliffWalkerStrategy walkerStrategy = XliffWalkerStrategyFactory.flexibleStrategy((XliffWalkerPathSelector[])new XliffWalkerPathSelector.Builder().selector("f1", "tu1").selector("f1", "tu3", Integer.valueOf(0)).build());
        this.testWalker = new XliffWalker(walkerStrategy);
        TestFileVisitor fileVisitor = new TestFileVisitor();
        this.testWalker.addFileVisitor((IXliffVisitor)fileVisitor, new XliffWalkerPathSelector[0]);
        TestUnitVisitor unitVisitor = new TestUnitVisitor();
        this.testWalker.addUnitVisitor((IXliffVisitor)unitVisitor, new XliffWalkerPathSelector[0]);
        TestSegmentVisitor segmentVisitor = new TestSegmentVisitor();
        this.testWalker.addSegmentVisitor((IXliffVisitor)segmentVisitor, new XliffWalkerPathSelector[0]);
        this.testWalker.doWalk(this.doc);
        Assert.assertEquals((long)1L, (long)fileVisitor.getCount());
        Assert.assertEquals((long)2L, (long)unitVisitor.getCount());
        Assert.assertEquals((long)3L, (long)segmentVisitor.getCount());
        TestModifyingSegmentVisitor segmentVisitor2 = new TestModifyingSegmentVisitor();
        this.testWalker.removeVisitors();
        this.testWalker.addSegmentVisitor((IXliffVisitor)segmentVisitor2, new XliffWalkerPathSelector[0]);
        this.testWalker.doWalk(this.doc);
        for (Unit unit : this.doc.getUnits()) {
            int segmentIndex = 0;
            for (Segment segment : unit.getSegments()) {
                boolean wasSegmentWalked = unit.getId().equals("tu1") || unit.getId().equals("tu3") && segmentIndex == 0;
                Assert.assertThat((Object)wasSegmentWalked, (Matcher)CoreMatchers.is((Object)segment.getSource().isEmpty()));
                Assert.assertThat((Object)wasSegmentWalked, (Matcher)CoreMatchers.is((Object)segment.getTarget().isEmpty()));
                Assert.assertThat((Object)wasSegmentWalked, (Matcher)CoreMatchers.is((Object)"TestModifyingSegmentVisitor:was here".equals(segment.getSubState())));
                ++segmentIndex;
            }
        }
    }

    @Test
    public void testDoWalk() {
        TestFileVisitor fileVisitor = new TestFileVisitor();
        this.testWalker.addFileVisitor((IXliffVisitor)fileVisitor, new XliffWalkerPathSelector[0]);
        TestUnitVisitor unitVisitor = new TestUnitVisitor();
        this.testWalker.addUnitVisitor((IXliffVisitor)unitVisitor, new XliffWalkerPathSelector[0]);
        TestSegmentVisitor segmentVisitor = new TestSegmentVisitor();
        this.testWalker.addSegmentVisitor((IXliffVisitor)segmentVisitor, new XliffWalkerPathSelector[0]);
        this.testWalker.doWalk(this.doc);
        Assert.assertEquals((long)1L, (long)fileVisitor.getCount());
        Assert.assertEquals((long)4L, (long)unitVisitor.getCount());
        Assert.assertEquals((long)5L, (long)segmentVisitor.getCount());
        for (Unit unit : this.doc.getUnits()) {
            for (Segment segment : unit.getSegments()) {
                Assert.assertFalse((boolean)segment.getSource().isEmpty());
                Assert.assertFalse((boolean)segment.getTarget().isEmpty());
                Assert.assertNull((Object)segment.getSubState());
            }
        }
        TestModifyingSegmentVisitor segmentVisitor2 = new TestModifyingSegmentVisitor();
        this.testWalker.removeVisitors();
        this.testWalker.addSegmentVisitor((IXliffVisitor)segmentVisitor2, new XliffWalkerPathSelector[0]);
        this.testWalker.doWalk(this.doc);
        for (Unit unit : this.doc.getUnits()) {
            for (Segment segment : unit.getSegments()) {
                Assert.assertTrue((boolean)segment.getSource().isEmpty());
                Assert.assertTrue((boolean)segment.getTarget().isEmpty());
                Assert.assertEquals((Object)"TestModifyingSegmentVisitor:was here", (Object)segment.getSubState());
            }
        }
    }

    @Test
    public void testSetVisitors() {
        ArrayList<TestFileVisitor> fileVisitors = new ArrayList<TestFileVisitor>();
        fileVisitors.add(new TestFileVisitor());
        ArrayList<TestUnitVisitor> unitVisitors = new ArrayList<TestUnitVisitor>();
        unitVisitors.add(new TestUnitVisitor());
        unitVisitors.add(new TestUnitVisitor());
        this.testWalker.setVisitors(fileVisitors, unitVisitors, null);
        Assert.assertEquals((long)1L, (long)this.testWalker.getAllFileNodeVisitors().size());
        Assert.assertEquals((long)2L, (long)this.testWalker.getAllUnitNodeVisitors().size());
        this.testWalker.removeVisitors();
        Assert.assertEquals((long)0L, (long)this.testWalker.getAllFileNodeVisitors().size());
        Assert.assertEquals((long)0L, (long)this.testWalker.getAllUnitNodeVisitors().size());
    }

    @Test
    public void testAddFileVisitor() {
        TestFileVisitor fileVisitor = new TestFileVisitor();
        String ID = this.testWalker.addFileVisitor((IXliffVisitor)fileVisitor, new XliffWalkerPathSelector[0]);
        TestFileVisitor fileVisitor2 = new TestFileVisitor();
        this.testWalker.addFileVisitor((IXliffVisitor)fileVisitor2, new XliffWalkerPathSelector[0]);
        Assert.assertEquals((long)2L, (long)this.testWalker.getAllFileNodeVisitors().size());
        this.testWalker.removeFileVisitor(ID);
        Assert.assertEquals((long)1L, (long)this.testWalker.getAllFileNodeVisitors().size());
    }

    @Test
    public void testAddUnitVisitor() {
        TestUnitVisitor unitVisitor = new TestUnitVisitor();
        String ID = this.testWalker.addUnitVisitor((IXliffVisitor)unitVisitor, new XliffWalkerPathSelector[0]);
        TestUnitVisitor unitVisitor2 = new TestUnitVisitor();
        this.testWalker.addUnitVisitor((IXliffVisitor)unitVisitor2, new XliffWalkerPathSelector[0]);
        Assert.assertEquals((long)2L, (long)this.testWalker.getAllUnitNodeVisitors().size());
        this.testWalker.removeUnitVisitor(ID);
        Assert.assertEquals((long)1L, (long)this.testWalker.getAllUnitNodeVisitors().size());
    }

    @Test
    public void testAddSegmentVisitor() {
        TestSegmentVisitor segmentVisitor = new TestSegmentVisitor();
        String ID = this.testWalker.addSegmentVisitor((IXliffVisitor)segmentVisitor, new XliffWalkerPathSelector[0]);
        TestSegmentVisitor segmentVisitor2 = new TestSegmentVisitor();
        this.testWalker.addSegmentVisitor((IXliffVisitor)segmentVisitor2, new XliffWalkerPathSelector[0]);
        Assert.assertEquals((long)2L, (long)this.testWalker.getAllSegmentVisitors().size());
        this.testWalker.removeSegmentVisitor(ID);
        Assert.assertEquals((long)1L, (long)this.testWalker.getAllSegmentVisitors().size());
    }

    @Test
    public void testIncorrectParams() {
        boolean exceptionThrown = false;
        try {
            this.testWalker.addFileVisitor(null);
        }
        catch (IllegalArgumentException ex) {
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown);
        exceptionThrown = false;
        try {
            this.testWalker.addUnitVisitor(null);
        }
        catch (IllegalArgumentException ex) {
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown);
        exceptionThrown = false;
        try {
            this.testWalker.addSegmentVisitor(null);
        }
        catch (IllegalArgumentException ex) {
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown);
    }

    @Test
    public void testPipelineStrategy() {
        this.testWalker = new XliffWalker(XliffWalkerStrategyFactory.pipelineStrategy());
        this.testWalker.addFileVisitor((IXliffVisitor)new IXliffVisitor<FileNode>(){

            public void visit(FileNode visitee, VisitationContext context) {
                visitee.add(new UnitNode(new Unit("added-unit-1")));
            }
        }, new XliffWalkerPathSelector[0]);
        this.testWalker.addUnitVisitor((IXliffVisitor)new IXliffVisitor<UnitNode>(){

            public void visit(UnitNode visitee, VisitationContext context) {
                Segment segment = visitee.get().appendSegment();
                segment.setId("added-segment-1");
                segment.setSource("Source text.");
            }
        }, new XliffWalkerPathSelector.Builder().selector("f1", "added-unit-1").build());
        this.testWalker.addSegmentVisitor((IXliffVisitor)new IXliffVisitor<Segment>(){

            public void visit(Segment visitee, VisitationContext context) {
                visitee.setTarget(visitee.getSource().getPlainText() + "Now translated.");
            }
        }, new XliffWalkerPathSelector[0]);
        this.testWalker.addSegmentVisitor((IXliffVisitor)new IXliffVisitor<Segment>(){

            public void visit(Segment visitee, VisitationContext context) {
                visitee.setTarget(visitee.getTarget().getPlainText() + "Now translated again.");
            }
        }, new XliffWalkerPathSelector[0]);
        this.testWalker.addUnitVisitor((IXliffVisitor)new IXliffVisitor<UnitNode>(){

            public void visit(UnitNode visitee, VisitationContext context) {
                Segment segment = visitee.get().getSegment(0);
                segment.setSource(segment.getSource().getPlainText() + "Modified source text.");
                segment.setTarget(segment.getTarget().getPlainText() + "Third translation done.");
            }
        }, new XliffWalkerPathSelector[0]);
        this.testWalker.doWalk(this.doc);
        Unit unit = this.doc.getUnitNode("f1", "added-unit-1").get();
        Segment segment = unit.getSegment(0);
        Assert.assertThat((Object)"Source text.Modified source text.", (Matcher)CoreMatchers.is((Object)segment.getSource().getPlainText()));
        Assert.assertThat((Object)"Source text.Now translated.Now translated again.Third translation done.", (Matcher)CoreMatchers.is((Object)segment.getTarget().getPlainText()));
    }

    @Test
    public void testVisitPlaceAwareVisitor() {
        this.testWalker = new XliffWalker(XliffWalkerStrategyFactory.pipelineStrategy());
        this.testWalker.addFileVisitor((IXliffVisitor)new IXliffVisitor<FileNode>(){

            public void visit(FileNode visitee, VisitationContext context) {
                visitee.add(new UnitNode(new Unit("added-unit-1")));
            }
        }, new XliffWalkerPathSelector.Builder().selector("f1").build());
        this.testWalker.addUnitVisitor((IXliffVisitor)new IXliffVisitor<UnitNode>(){

            public void visit(UnitNode visitee, VisitationContext context) {
                Segment segment = visitee.get().appendSegment();
                segment.setId("added-segment-1");
                segment.setSource("Source text.");
            }
        }, new XliffWalkerPathSelector.Builder().selector("f1", "added-unit-1").build());
        this.testWalker.addSegmentVisitor((IXliffVisitor)new IXliffVisitor<Segment>(){

            public void visit(Segment visitee, VisitationContext context) {
                visitee.setTarget(visitee.getSource().getPlainText() + "Now translated.");
            }
        }, new XliffWalkerPathSelector.Builder().selector("f1", "added-unit-1", Integer.valueOf(0)).build());
        this.testWalker.addSegmentVisitor((IXliffVisitor)new IXliffVisitor<Segment>(){

            public void visit(Segment visitee, VisitationContext context) {
                visitee.setTarget(visitee.getTarget().getPlainText() + "Now translated again.");
            }
        }, new XliffWalkerPathSelector.Builder().selector("f1", "added-unit-1", Integer.valueOf(0)).build());
        this.testWalker.addUnitVisitor((IXliffVisitor)new IXliffVisitor<UnitNode>(){

            public void visit(UnitNode visitee, VisitationContext context) {
                Segment segment = visitee.get().getSegment(0);
                segment.setSource(segment.getSource().getPlainText() + "Modified source text.");
                segment.setTarget(segment.getTarget().getPlainText() + "Third translation done.");
            }
        }, new XliffWalkerPathSelector.Builder().selector("f1", "added-unit-1").build());
        this.testWalker.doWalk(this.doc);
        Unit unit = this.doc.getUnitNode("f1", "added-unit-1").get();
        Segment segment = unit.getSegment(0);
        Assert.assertThat((Object)"Source text.Modified source text.", (Matcher)CoreMatchers.is((Object)segment.getSource().getPlainText()));
        Assert.assertThat((Object)"Source text.Now translated.Now translated again.Third translation done.", (Matcher)CoreMatchers.is((Object)segment.getTarget().getPlainText()));
        Unit tu1 = this.doc.getUnitNode("f1", "tu1").get();
        Assert.assertThat((Object)"Sample segment.", (Matcher)CoreMatchers.is((Object)tu1.getSegment(0).getSource().getPlainText()));
        Assert.assertThat((Object)"Exemple de segment.", (Matcher)CoreMatchers.is((Object)tu1.getSegment(0).getTarget().getPlainText()));
        Assert.assertThat((Object)"Segment's content.", (Matcher)CoreMatchers.is((Object)tu1.getSegment(1).getSource().getPlainText()));
        Assert.assertThat((Object)"Contenu du segment.", (Matcher)CoreMatchers.is((Object)tu1.getSegment(1).getTarget().getPlainText()));
        Unit tu3 = this.doc.getUnitNode("f1", "tu3").get();
        Assert.assertThat((Object)"Bolded text", (Matcher)CoreMatchers.is((Object)tu3.getSegment(0).getSource().getPlainText()));
        Assert.assertThat((Object)"Bolded text", (Matcher)CoreMatchers.is((Object)tu3.getSegment(0).getTarget().getPlainText()));
        Unit tu3end = this.doc.getUnitNode("f1", "tu3end").get();
        Assert.assertThat((Object)"Extra stuff", (Matcher)CoreMatchers.is((Object)tu3end.getSegment(0).getSource().getPlainText()));
        Assert.assertThat((Object)"Extra stuff", (Matcher)CoreMatchers.is((Object)tu3end.getSegment(0).getTarget().getPlainText()));
        Unit tu2 = this.doc.getUnitNode("f1", "tu2").get();
        Assert.assertThat((Object)"special text and more\n.", (Matcher)CoreMatchers.is((Object)tu2.getSegment(0).getSource().getPlainText()));
        Assert.assertThat((Object)"special text and more\n.", (Matcher)CoreMatchers.is((Object)tu2.getSegment(0).getTarget().getPlainText()));
    }

    @Test
    public void testDoWalkPipelineStrategy() {
        this.testWalker = new XliffWalker(XliffWalkerStrategyFactory.pipelineStrategy());
        TestFileVisitor fileVisitor = new TestFileVisitor();
        this.testWalker.addFileVisitor((IXliffVisitor)fileVisitor, new XliffWalkerPathSelector[0]);
        TestUnitVisitor unitVisitor = new TestUnitVisitor();
        this.testWalker.addUnitVisitor((IXliffVisitor)unitVisitor, new XliffWalkerPathSelector[0]);
        TestSegmentVisitor segmentVisitor = new TestSegmentVisitor();
        this.testWalker.addSegmentVisitor((IXliffVisitor)segmentVisitor, new XliffWalkerPathSelector[0]);
        this.testWalker.addUnitVisitor((IXliffVisitor)new IXliffVisitor<UnitNode>(){

            public void visit(UnitNode visitee, VisitationContext context) {
                visitee.get().appendSegment();
            }
        }, new XliffWalkerPathSelector[0]);
        this.testWalker.addSegmentVisitor((IXliffVisitor)segmentVisitor, new XliffWalkerPathSelector[0]);
        this.testWalker.doWalk(this.doc);
        Assert.assertEquals((long)1L, (long)fileVisitor.getCount());
        Assert.assertEquals((long)4L, (long)unitVisitor.getCount());
        Assert.assertEquals((long)14L, (long)segmentVisitor.getCount());
    }
}

