/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.renderer;

import net.sf.okapi.lib.xliff2.core.CTag;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.MTag;
import net.sf.okapi.lib.xliff2.core.TagType;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.renderer.IFragmentObject;
import net.sf.okapi.lib.xliff2.renderer.XLIFFFragmentRenderer;
import org.junit.Assert;
import org.junit.Test;

public class XLIFFFragmentRendererTest {
    @Test
    public void testSimple() {
        Fragment frag = new Unit("id").appendSegment().getSource();
        frag.append((CharSequence)"<Text ");
        CTag c = frag.openCodeSpan("1", "<b>");
        c.setDisp("[bold]");
        frag.append((CharSequence)"in bold");
        c = frag.closeCodeSpan("1", "</b>");
        c.setDisp("[/bold]");
        frag.append(' ');
        frag.appendCode("2", "<br>");
        frag.append('.');
        frag.annotate(11, 15, "comment", "My comment", null);
        MTag mtag = new MTag("m1", null);
        mtag.setTranslate(Boolean.valueOf(false));
        frag.annotate(22, 24, mtag);
        XLIFFFragmentRenderer r = new XLIFFFragmentRenderer(frag, null);
        int count = 0;
        for (IFragmentObject fo : r) {
            switch (count) {
                case 0: {
                    Assert.assertEquals((Object)"<Text ", (Object)fo.getText());
                    Assert.assertEquals((Object)"&lt;Text ", (Object)fo.render());
                    break;
                }
                case 1: {
                    Assert.assertEquals((Object)TagType.OPENING, (Object)fo.getCTag().getTagType());
                    Assert.assertEquals((Object)"<pc id=\"1\" disp=\"[bold]\">", (Object)fo.render());
                    Assert.assertEquals((Object)"<b>", (Object)fo.getCTag().getData());
                    Assert.assertEquals((Object)"[bold]", (Object)fo.getCTag().getDisp());
                    break;
                }
                case 2: {
                    Assert.assertEquals((Object)"in ", (Object)fo.getText());
                    Assert.assertEquals((Object)"in ", (Object)fo.render());
                    break;
                }
                case 3: {
                    Assert.assertEquals((Object)TagType.OPENING, (Object)fo.getMTag().getTagType());
                    Assert.assertEquals((Object)"comment", (Object)fo.getMTag().getType());
                    Assert.assertEquals((Object)"<mrk id=\"3\" type=\"comment\" value=\"My comment\">", (Object)fo.render());
                    break;
                }
                case 4: {
                    Assert.assertEquals((Object)"bold", (Object)fo.getText());
                    Assert.assertEquals((Object)"bold", (Object)fo.render());
                    break;
                }
                case 5: {
                    Assert.assertEquals((Object)"</mrk>", (Object)fo.render());
                    Assert.assertEquals((Object)TagType.CLOSING, (Object)fo.getMTag().getTagType());
                    Assert.assertEquals((Object)"comment", (Object)fo.getMTag().getType());
                    break;
                }
                case 6: {
                    Assert.assertEquals((Object)"</pc>", (Object)fo.render());
                    Assert.assertEquals((Object)TagType.CLOSING, (Object)fo.getCTag().getTagType());
                    Assert.assertEquals((Object)"1", (Object)fo.getCTag().getId());
                    break;
                }
                case 7: {
                    int bad = 0;
                    try {
                        fo.getCTag();
                    }
                    catch (ClassCastException e) {
                        ++bad;
                    }
                    try {
                        fo.getMTag();
                    }
                    catch (ClassCastException e) {
                        ++bad;
                    }
                    Assert.assertEquals((long)2L, (long)bad);
                    break;
                }
                case 8: {
                    Assert.assertEquals((Object)TagType.OPENING, (Object)fo.getMTag().getTagType());
                    Assert.assertEquals((Object)"generic", (Object)fo.getMTag().getType());
                    Assert.assertEquals((Object)"<mrk id=\"m1\" translate=\"no\">", (Object)fo.render());
                    break;
                }
                case 9: {
                    Assert.assertEquals((Object)TagType.STANDALONE, (Object)fo.getCTag().getTagType());
                    Assert.assertEquals((Object)"2", (Object)fo.getCTag().getId());
                    Assert.assertEquals((Object)"<ph id=\"2\"/>", (Object)fo.render());
                    break;
                }
                case 10: {
                    Assert.assertEquals((Object)"</mrk>", (Object)fo.render());
                    Assert.assertEquals((Object)TagType.CLOSING, (Object)fo.getMTag().getTagType());
                    Assert.assertEquals((Object)"m1", (Object)fo.getMTag().getId());
                    break;
                }
                case 11: {
                    Assert.assertEquals((Object)".", (Object)fo.getText());
                    Assert.assertEquals((Object)".", (Object)fo.render());
                }
            }
            ++count;
        }
        Assert.assertEquals((long)12L, (long)count);
    }

    @Test
    public void testWithOverlaps() {
        Fragment cont = new Fragment(new Unit("id").getStore(), true);
        cont.openCodeSpan("1", "<1>");
        cont.closeCodeSpan("1", "</1>");
        cont.appendCode("2", "<2/>");
        cont.openCodeSpan("3", "<3>");
        cont.openCodeSpan("4", "<4>");
        cont.closeCodeSpan("3", "</3>");
        cont.openCodeSpan("5", "<5>");
        cont.openCodeSpan("6", "<6>");
        cont.closeCodeSpan("6", "</6>");
        cont.closeCodeSpan("5", "</5>");
        cont.closeCodeSpan("4", "</4>");
        cont.openCodeSpan("7", "<7>");
        cont.delete(14, 16);
        StringBuilder tmp = new StringBuilder();
        XLIFFFragmentRenderer r = new XLIFFFragmentRenderer(cont, null);
        for (IFragmentObject fo : r) {
            tmp.append(fo.render());
        }
        Assert.assertEquals((Object)"<pc id=\"1\"></pc><ph id=\"2\"/><sc id=\"3\" canOverlap=\"no\"/><pc id=\"4\"><ec startRef=\"3\" canOverlap=\"no\"/><pc id=\"5\"><ec id=\"6\" canOverlap=\"no\" isolated=\"yes\"/></pc></pc><sc id=\"7\" canOverlap=\"no\" isolated=\"yes\"/>", (Object)tmp.toString());
    }

    @Test
    public void testMarkers() {
        Fragment cont = new Fragment(new Unit("id").getStore(), true);
        cont.openCodeSpan("1", "<1>");
        cont.openMarkerSpan("m1", "my:type");
        cont.closeMarkerSpan("m1");
        cont.closeCodeSpan("1", "</1>");
        cont.openMarkerSpan("m2", "my:type2");
        cont.openCodeSpan("2", "<2>");
        cont.closeMarkerSpan("m2");
        cont.closeCodeSpan("2", "<2>");
        StringBuilder tmp = new StringBuilder();
        XLIFFFragmentRenderer r = new XLIFFFragmentRenderer(cont, null);
        for (IFragmentObject fo : r) {
            tmp.append(fo.render());
        }
        Assert.assertEquals((Object)"<pc id=\"1\"><mrk id=\"m1\" type=\"my:type\"></mrk></pc><sm id=\"m2\" type=\"my:type2\"/><pc id=\"2\"><em startRef=\"m2\"/></pc>", (Object)tmp.toString());
    }
}

