/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.reader;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import javax.xml.namespace.QName;
import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.URIParser;
import net.sf.okapi.lib.xliff2.XLIFFException;
import net.sf.okapi.lib.xliff2.changeTracking.ChangeTrack;
import net.sf.okapi.lib.xliff2.changeTracking.Item;
import net.sf.okapi.lib.xliff2.changeTracking.Revision;
import net.sf.okapi.lib.xliff2.changeTracking.Revisions;
import net.sf.okapi.lib.xliff2.core.CTag;
import net.sf.okapi.lib.xliff2.core.CanReorder;
import net.sf.okapi.lib.xliff2.core.Directionality;
import net.sf.okapi.lib.xliff2.core.ExtAttribute;
import net.sf.okapi.lib.xliff2.core.ExtAttributes;
import net.sf.okapi.lib.xliff2.core.ExtChildType;
import net.sf.okapi.lib.xliff2.core.ExtContent;
import net.sf.okapi.lib.xliff2.core.ExtElement;
import net.sf.okapi.lib.xliff2.core.ExtElements;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.IExtChild;
import net.sf.okapi.lib.xliff2.core.InvalidMarkerOrderException;
import net.sf.okapi.lib.xliff2.core.MTag;
import net.sf.okapi.lib.xliff2.core.MidFileData;
import net.sf.okapi.lib.xliff2.core.Note;
import net.sf.okapi.lib.xliff2.core.Notes;
import net.sf.okapi.lib.xliff2.core.Part;
import net.sf.okapi.lib.xliff2.core.Segment;
import net.sf.okapi.lib.xliff2.core.Skeleton;
import net.sf.okapi.lib.xliff2.core.StartFileData;
import net.sf.okapi.lib.xliff2.core.StartGroupData;
import net.sf.okapi.lib.xliff2.core.StartXliffData;
import net.sf.okapi.lib.xliff2.core.TagType;
import net.sf.okapi.lib.xliff2.core.Tags;
import net.sf.okapi.lib.xliff2.core.TargetState;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.metadata.MetaGroup;
import net.sf.okapi.lib.xliff2.reader.Event;
import net.sf.okapi.lib.xliff2.reader.EventType;
import net.sf.okapi.lib.xliff2.reader.XLIFFReader;
import net.sf.okapi.lib.xliff2.reader.XLIFFReaderException;
import net.sf.okapi.lib.xliff2.test.U;
import net.sf.okapi.lib.xliff2.validation.Rule;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXParseException;

public class XLIFFReaderTest {
    private static final String STARTDOC = "<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" xmlns:m=\"urn:oasis:names:tc:xliff:matches:2.0\" ";
    private static final String MYNS = "myNamespace";
    private final String root = U.getParentDir(this, "/example.xlf");

    @Test
    public void testWithDefaultNamespace() {
        String text = "<?xml version='1.0'?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\"><file translate=\"no\" id=\"fid1\" original=\"ori\">\n<unit id=\"id\" canResegment=\"no\">\n<segment>\n<source>Source 1.</source><target>Target 1.</target>\n</segment>\n<segment>\n<source>Source 2.</source><target>Target 2.</target>\n</segment>\n</unit>\n</file></xliff>";
        this.verifyDocument(text);
    }

    @Test
    public void testWithSpecifiedNamespace() {
        String text = "<?xml version='1.0'?>\n<z:xliff xmlns:z=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\"><z:file translate=\"no\" id=\"fid1\" original=\"ori\">\n<z:unit id=\"id\" canResegment=\"no\">\n<z:segment>\n<z:source>Source 1.</z:source><z:target>Target 1.</z:target>\n</z:segment>\n<z:segment>\n<z:source>Source 2.</z:source><z:target>Target 2.</z:target>\n</z:segment>\n</z:unit>\n</z:file></z:xliff>";
        this.verifyDocument(text);
    }

    @Test
    public void testCloseable() {
        String text = "<?xml version='1.0'?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\"><file translate=\"no\" id=\"fid1\">\n<unit id=\"id\">\n<segment>\n<source>Source 1.</source>\n</segment>\n</unit>\n</file></xliff>";
        try (XLIFFReader reader = new XLIFFReader();){
            reader.open(text);
            reader.hasNext();
            Assert.assertNotNull((Object)reader.next());
        }
    }

    @Test
    public void testWithExtensionCharacters() {
        String text = "<?xml version='1.0' encoding='UTF-8'?>\n<xliff xmlns:=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" trgLang=\"fr\"><file translate=\"no\" id=\"f1\" original=\"\u2620ori\">\n<unit id=\"id\u00ff\">\n<segment>\n<source>\u2620Source 1.</source>\n<target>\u2620Target 1.</target>\n</segment>\n</unit>\n</file></xliff>";
        Unit unit = this.getUnit(text, 1);
        Assert.assertEquals((Object)"id\u00ff", (Object)unit.getId());
        Assert.assertEquals((Object)"\u2620Source 1.", (Object)unit.getPart(0).getSource().toString());
        Assert.assertEquals((Object)"\u2620Target 1.", (Object)unit.getPart(0).getTarget().toString());
    }

    private void verifyDocument(String data) {
        XLIFFReader reader = new XLIFFReader(255);
        reader.open(data);
        int i = 0;
        while (reader.hasNext()) {
            Event e = reader.next();
            switch (i) {
                case 0: {
                    Assert.assertTrue((boolean)e.isStartDocument());
                    break;
                }
                case 1: {
                    Assert.assertTrue((e.getType() == EventType.START_XLIFF ? 1 : 0) != 0);
                    Assert.assertTrue((boolean)e.isStartXliff());
                    StartXliffData dd = e.getStartXliffData();
                    Assert.assertNotNull((Object)dd);
                    Assert.assertEquals((Object)"en", (Object)dd.getSourceLanguage());
                    Assert.assertEquals((Object)"fr", (Object)dd.getTargetLanguage());
                    Assert.assertEquals((Object)"2.0", (Object)dd.getVersion());
                    break;
                }
                case 2: {
                    Assert.assertTrue((e.getType() == EventType.START_FILE ? 1 : 0) != 0);
                    Assert.assertTrue((boolean)e.isStartFile());
                    StartFileData sfd = e.getStartFileData();
                    Assert.assertNotNull((Object)sfd);
                    Assert.assertEquals((Object)true, (Object)sfd.getCanResegment());
                    Assert.assertEquals((Object)false, (Object)sfd.getTranslate());
                    Assert.assertEquals((Object)"fid1", (Object)sfd.getId());
                    break;
                }
                case 3: {
                    Assert.assertTrue((e.getType() == EventType.MID_FILE ? 1 : 0) != 0);
                    break;
                }
                case 4: {
                    Assert.assertTrue((e.getType() == EventType.TEXT_UNIT ? 1 : 0) != 0);
                    Assert.assertTrue((boolean)e.isUnit());
                    Unit unit = e.getUnit();
                    Assert.assertNotNull((Object)unit);
                    Assert.assertEquals((Object)false, (Object)unit.getCanResegment());
                    Assert.assertEquals((Object)false, (Object)unit.getTranslate());
                    Assert.assertEquals((Object)"id", (Object)unit.getId());
                    Assert.assertEquals((Object)"Source 1.", (Object)unit.getPart(0).getSource().toString());
                    Assert.assertEquals((Object)"Target 1.", (Object)unit.getPart(0).getTarget().toString());
                    break;
                }
                case 5: {
                    Assert.assertTrue((e.getType() == EventType.END_FILE ? 1 : 0) != 0);
                    Assert.assertTrue((boolean)e.isEndFile());
                    break;
                }
                case 6: {
                    Assert.assertTrue((e.getType() == EventType.END_XLIFF ? 1 : 0) != 0);
                    Assert.assertTrue((boolean)e.isEndXliff());
                    Assert.assertTrue((e.getStartXliffData() == null ? 1 : 0) != 0);
                    break;
                }
                case 7: {
                    Assert.assertTrue((boolean)e.isEndDocument());
                }
            }
            ++i;
        }
        reader.close();
    }

    @Test
    public void testFileData() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" srcLang=\"en\" trgLang=\"fr\"><file id=\"id1\" original=\"ori\" xmlns:fs=\"urn:oasis:names:tc:xliff:fs:2.0\" fs:fs=\"div\" canResegment=\"no\" translate=\"no\" srcDir=\"rtl\" trgDir=\"rtl\"> <mda:metadata xmlns:mda=\"urn:oasis:names:tc:xliff:metadata:2.0\">  <mda:metaGroup category=\"row_xml_attribute\">   <mda:meta type=\"style\">head</mda:meta>  </mda:metaGroup> </mda:metadata> <x:elem xmlns:x=\"myNS\">data</x:elem> <notes>  <note>file-note</note> </notes> <unit id=\"id\"><segment><source>source</source></segment></unit></file></xliff>";
        StartFileData sfd = this.getStartFileData(text, 1);
        Assert.assertEquals((Object)"id1", (Object)sfd.getId());
        MidFileData mfd = this.getMidFileData(text, 1);
        Assert.assertNotNull((Object)mfd);
        Assert.assertEquals((long)1L, (long)mfd.getNoteCount());
        Assert.assertEquals((long)1L, (long)mfd.getExtElements().size());
        Assert.assertTrue((boolean)mfd.hasMetadata());
        Assert.assertEquals((Object)"row_xml_attribute", (Object)((MetaGroup)mfd.getMetadata().get(0)).getCategory());
        Assert.assertEquals((Object)"elem", (Object)mfd.getExtElements().get(0).getQName().getLocalPart());
    }

    @Test
    public void testSkeleton() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" srcLang=\"en\" trgLang=\"fr\">\n<file id=\"f1\" original=\"f1\">\n <skeleton href=\"abc\"/>\n <unit id=\"1\"><segment><source>source1</source></segment></unit>\n</file>\n<file id=\"f2\" original=\"f2\">\n <skeleton>data  <elem xmlns='myNS'>xyz</elem>data </skeleton>\n <unit id=\"1\"><segment><source>source2</source></segment></unit>\n</file>\n</xliff>";
        Skeleton sd = this.getSkeletonData(text, 1);
        Assert.assertEquals((Object)"abc", (Object)sd.getHref());
        Assert.assertTrue((sd.getChildren() == null ? 1 : 0) != 0);
        sd = this.getSkeletonData(text, 2);
        Assert.assertEquals(null, (Object)sd.getHref());
        Assert.assertTrue((sd.getChildren() != null ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)sd.getChildren().size());
    }

    @Test
    public void testGroupData() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" srcLang=\"en\" trgLang=\"fr\"><file id=\"f1\"> <group id=\"g1\" xmlns:fs=\"urn:oasis:names:tc:xliff:fs:2.0\" fs:fs=\"div\">  <v:validation xmlns:v=\"urn:oasis:names:tc:xliff:validation:2.0\">   <v:rule isNotPresent=\"store\" />  </v:validation>  <x:elem xmlns:x=\"myNS\">data</x:elem>  <notes>   <note>group1-note</note>  </notes>  <unit id=\"u1\">  <v:validation xmlns:v=\"urn:oasis:names:tc:xliff:validation:2.0\">   <v:rule isNotPresent=\"storeUNIT\" />  </v:validation><segment><source>source1</source></segment></unit>  <group id=\"g2\" name='n1' canResegment='no' translate='no'    srcDir='rtl' trgDir='rtl'>   <notes>    <note>group2-note</note>   </notes>   <unit id=\"u2\"><segment><source>source2</source></segment></unit>  </group> </group></file></xliff>";
        StartGroupData sgd = this.getStartGroupData(text, 1);
        Assert.assertNotNull((Object)sgd);
        Assert.assertEquals((Object)"g1", (Object)sgd.getId());
        Assert.assertEquals(null, (Object)sgd.getName());
        Assert.assertEquals((Object)true, (Object)sgd.getCanResegment());
        Assert.assertEquals((Object)true, (Object)sgd.getTranslate());
        Assert.assertEquals((Object)Directionality.AUTO, (Object)sgd.getSourceDir());
        Assert.assertEquals((Object)Directionality.AUTO, (Object)sgd.getTargetDir());
        Assert.assertEquals((Object)"div", (Object)sgd.getExtAttributeValue("urn:oasis:names:tc:xliff:fs:2.0", "fs"));
        Assert.assertEquals((Object)"group1-note", (Object)((Note)sgd.getNotes().get(0)).getText());
        Assert.assertEquals((Object)"elem", (Object)sgd.getExtElements().get(0).getQName().getLocalPart());
        Assert.assertTrue((boolean)sgd.hasValidation());
        sgd = this.getStartGroupData(text, 2);
        Assert.assertNotNull((Object)sgd);
        Assert.assertEquals((Object)"g2", (Object)sgd.getId());
        Assert.assertEquals((Object)"n1", (Object)sgd.getName());
        Assert.assertEquals((Object)false, (Object)sgd.getCanResegment());
        Assert.assertEquals((Object)false, (Object)sgd.getTranslate());
        Assert.assertEquals((Object)Directionality.RTL, (Object)sgd.getSourceDir());
        Assert.assertEquals((Object)Directionality.RTL, (Object)sgd.getTargetDir());
        Assert.assertEquals((Object)"group2-note", (Object)((Note)sgd.getNotes().get(0)).getText());
        Unit unit = this.getUnit(text, 1);
        Assert.assertEquals((Object)"store", (Object)((Rule)unit.getValidation().get(0)).getData());
        Assert.assertEquals((Object)"storeUNIT", (Object)((Rule)unit.getValidation().get(1)).getData());
    }

    @Test
    public void testNotes() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" srcLang=\"en\" trgLang=\"fr\"><file id=\"f1\"> <notes>  <note id=\"nf1\" priority=\"2\">file-note1</note>  <note id=\"nf2\" priority=\"2\">file-note2</note> </notes> <group id=\"g1\">  <notes>   <note id=\"ng1\" category=\"c2\">group-note1</note>   <note id=\"ng2\" category=\"c2\">group-note2</note>  </notes>  <unit id=\"id\">   <notes xmlns:fs=\"urn:oasis:names:tc:xliff:fs:2.0\">    <note id=\"nu1\" fs:fs=\"li\" priority=\"2\" category=\"c1\">unit-note1</note>    <note id=\"nu2\" fs:fs=\"li\" priority=\"2\" category=\"c1\">unit-note2</note>   </notes>   <segment>    <source>source</source>   </segment>  </unit> </group></file></xliff>";
        MidFileData mfd = this.getMidFileData(text, 1);
        Assert.assertNotNull((Object)mfd);
        Notes notes = mfd.getNotes();
        Note note = (Note)notes.get(0);
        Assert.assertEquals((Object)"nf1", (Object)note.getId());
        Assert.assertEquals((long)2L, (long)note.getPriority());
        Assert.assertEquals(null, (Object)note.getCategory());
        Assert.assertEquals((Object)"file-note1", (Object)note.getText());
        StartGroupData sgd = this.getStartGroupData(text, 1);
        Assert.assertNotNull((Object)sgd);
        notes = sgd.getNotes();
        note = (Note)notes.get(1);
        Assert.assertEquals((Object)"ng2", (Object)note.getId());
        Assert.assertEquals((long)1L, (long)note.getPriority());
        Assert.assertEquals((Object)"c2", (Object)note.getCategory());
        Assert.assertEquals((Object)"group-note2", (Object)note.getText());
        Unit unit = this.getUnit(text, 1);
        Assert.assertNotNull((Object)unit);
        notes = unit.getNotes();
        Assert.assertEquals((long)2L, (long)unit.getNoteCount());
        Assert.assertEquals((Object)true, (Object)notes.getExtAttributes().hasNamespace());
        note = (Note)notes.get(0);
        Assert.assertEquals((Object)"unit-note1", (Object)note.getText());
        Assert.assertEquals((Object)Note.AppliesTo.UNDEFINED, (Object)note.getAppliesTo());
        Assert.assertEquals((Object)"c1", (Object)note.getCategory());
        Assert.assertEquals((Object)"nu1", (Object)note.getId());
        Assert.assertEquals((long)2L, (long)note.getPriority());
        Assert.assertEquals((Object)"li", (Object)note.getExtAttributeValue("urn:oasis:names:tc:xliff:fs:2.0", "fs"));
    }

    @Test
    public void testCDATA() {
        String text = "<?xml version='1.0'?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" xmlns:m=\"urn:oasis:names:tc:xliff:matches:2.0\" srcLang=\"en\" trgLang=\"fr\"><file id=\"f1\">\n<unit id=\"id\"><segment>\n<source><![CDATA[Source 1]]>.</source><target>Target<![CDATA[ 1.]]></target>\n</segment></unit>\n</file></xliff>";
        Unit unit = this.getUnit(text, 1);
        Assert.assertNotNull((Object)unit);
        Assert.assertEquals((Object)"Source 1.", (Object)unit.getPart(0).getSource().toString());
        Assert.assertEquals((Object)"Target 1.", (Object)unit.getPart(0).getTarget().toString());
    }

    @Test(expected=XLIFFReaderException.class)
    public void testDuplicateIds() {
        String text = "<?xml version='1.0'?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" xmlns:m=\"urn:oasis:names:tc:xliff:matches:2.0\" srcLang=\"en\" trgLang=\"fr\"><file id=\"f1\">\n<unit id=\"id\"><segment>\n<source><pc id='1'>a <sc id='2'/>b </pc>c <ec startRef='2'/>d <ph id='2'/></source></segment></unit>\n</file></xliff>";
        this.getUnit(text, 1);
    }

    @Test(expected=XLIFFReaderException.class)
    public void testXmlSpaceMismatch() {
        String text = "<?xml version='1.0'?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" xmlns:m=\"urn:oasis:names:tc:xliff:matches:2.0\" srcLang=\"en\" trgLang=\"fr\"><file id=\"f1\">\n<unit id=\"id\"><segment>\n<source xml:space='preserve'>source</source><target>target</target>\n</segment></unit>\n</file></xliff>";
        this.getUnit(text, 1);
    }

    @Test
    public void testXmlSpaceWithOnlySource() {
        String text = "<?xml version='1.0'?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" xmlns:m=\"urn:oasis:names:tc:xliff:matches:2.0\" srcLang=\"en\" trgLang=\"fr\"><file id=\"f1\">\n<unit id=\"id\"><segment>\n<source xml:space='preserve'>source</source></segment></unit>\n</file></xliff>";
        Unit unit = this.getUnit(text, 1);
        Assert.assertTrue((boolean)unit.getPart(0).getPreserveWS());
    }

    @Test(expected=InvalidParameterException.class)
    public void testSourceLangValue() {
        String text = "<?xml version='1.0'?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" xmlns:m=\"urn:oasis:names:tc:xliff:matches:2.0\" srcLang=\"q\"><file id=\"f1\">\n<unit id=\"id\"><segment>\n<source>source</source></segment></unit>\n</file></xliff>";
        this.getUnit(text, 1);
    }

    @Test(expected=InvalidParameterException.class)
    public void testTargetLangValue() {
        String text = "<?xml version='1.0'?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" xmlns:m=\"urn:oasis:names:tc:xliff:matches:2.0\" srcLang=\"en\" trgLang=\"-en\"><file id=\"f1\">\n<unit id=\"id\"><segment>\n<source>source</source></segment></unit>\n</file></xliff>";
        this.getUnit(text, 1);
    }

    @Test(expected=XLIFFReaderException.class)
    public void testXmlLangValue() {
        String text = "<?xml version='1.0'?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" xmlns:m=\"urn:oasis:names:tc:xliff:matches:2.0\" srcLang=\"en\" trgLang=\"fr\"><file id=\"f1\">\n<unit id=\"id\"><segment>\n<source xml:lang=\"a-a\">source</source></segment></unit>\n</file></xliff>";
        this.getUnit(text, 1);
    }

    @Test
    public void testInheritedDataContext() {
        String text = "<?xml version='1.0'?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" xmlns:m=\"urn:oasis:names:tc:xliff:matches:2.0\" srcLang=\"en\" trgLang=\"fr\"><file id='f1' translate='no' srcDir='rtl' trgDir='ltr' canResegment='no'><group id='g1' translate='yes' srcDir='ltr' trgDir='rtl' canResegment='yes'><unit id='u1' translate='no' srcDir='rtl' trgDir='ltr' canResegment='no'><segment><source>text1</source></segment></unit></group></file><file id='f2' trgDir='rtl'><group id='g2' translate='no' srcDir='rtl' trgDir='ltr' canResegment='no'><unit id='u2' translate='yes' srcDir='ltr' trgDir='auto' canResegment='yes'><segment><source>text1</source></segment></unit></group></file></xliff>";
        Unit unit = this.getUnit(text, 1);
        Assert.assertEquals((Object)"u1", (Object)unit.getId());
        Assert.assertEquals((Object)false, (Object)unit.getTranslate());
        Assert.assertEquals((Object)Directionality.RTL, (Object)unit.getSourceDir());
        Assert.assertEquals((Object)Directionality.LTR, (Object)unit.getTargetDir());
        Assert.assertEquals((Object)false, (Object)unit.getCanResegment());
        StartFileData sfd = this.getStartFileData(text, 1);
        Assert.assertEquals((Object)"f1", (Object)sfd.getId());
        Assert.assertEquals((Object)false, (Object)sfd.getTranslate());
        Assert.assertEquals((Object)Directionality.RTL, (Object)sfd.getSourceDir());
        Assert.assertEquals((Object)Directionality.LTR, (Object)sfd.getTargetDir());
        Assert.assertEquals((Object)false, (Object)sfd.getCanResegment());
        StartGroupData sgd = this.getStartGroupData(text, 1);
        Assert.assertEquals((Object)"g1", (Object)sgd.getId());
        Assert.assertEquals((Object)true, (Object)sgd.getTranslate());
        Assert.assertEquals((Object)Directionality.LTR, (Object)sgd.getSourceDir());
        Assert.assertEquals((Object)Directionality.RTL, (Object)sgd.getTargetDir());
        Assert.assertEquals((Object)true, (Object)sgd.getCanResegment());
        unit = this.getUnit(text, 1);
        Assert.assertEquals((Object)"u1", (Object)unit.getId());
        Assert.assertEquals((Object)false, (Object)unit.getTranslate());
        Assert.assertEquals((Object)Directionality.RTL, (Object)unit.getSourceDir());
        Assert.assertEquals((Object)Directionality.LTR, (Object)unit.getTargetDir());
        Assert.assertEquals((Object)false, (Object)unit.getCanResegment());
        sfd = this.getStartFileData(text, 2);
        Assert.assertEquals((Object)"f2", (Object)sfd.getId());
        Assert.assertEquals((Object)true, (Object)sfd.getTranslate());
        Assert.assertEquals((Object)Directionality.AUTO, (Object)sfd.getSourceDir());
        Assert.assertEquals((Object)Directionality.RTL, (Object)sfd.getTargetDir());
        Assert.assertEquals((Object)true, (Object)sfd.getCanResegment());
        sgd = this.getStartGroupData(text, 2);
        Assert.assertEquals((Object)"g2", (Object)sgd.getId());
        Assert.assertEquals((Object)false, (Object)sgd.getTranslate());
        Assert.assertEquals((Object)Directionality.RTL, (Object)sgd.getSourceDir());
        Assert.assertEquals((Object)Directionality.LTR, (Object)sgd.getTargetDir());
        Assert.assertEquals((Object)false, (Object)sgd.getCanResegment());
        unit = this.getUnit(text, 2);
        Assert.assertEquals((Object)"u2", (Object)unit.getId());
        Assert.assertEquals((Object)true, (Object)unit.getTranslate());
        Assert.assertEquals((Object)Directionality.LTR, (Object)unit.getSourceDir());
        Assert.assertEquals((Object)Directionality.AUTO, (Object)unit.getTargetDir());
        Assert.assertEquals((Object)true, (Object)unit.getCanResegment());
    }

    @Test
    public void testClosingCodeWithPC() {
        String text = "<?xml version='1.0'?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" xmlns:m=\"urn:oasis:names:tc:xliff:matches:2.0\" srcLang=\"en\" trgLang=\"fr\"><file id=\"f1\" xmlns:fs=\"urn:oasis:names:tc:xliff:fs:2.0\">\n<unit id=\"id\">\n<segment>\n<source><pc id=\"1\" fs:fs=\"b\">text</pc></source></segment><segment>\n<source><ec id=\"2\" isolated=\"yes\" fs:fs=\"b\"/>text</source></segment></unit>\n</file></xliff>";
        Unit unit = this.getUnit(text, 1);
        Assert.assertEquals((Object)false, (Object)unit.getStore().getSourceTags().get(U.kCC(0)).hasExtAttribute());
        Assert.assertEquals((Object)true, (Object)unit.getStore().getSourceTags().get(U.kCC(1)).hasExtAttribute());
    }

    @Test
    public void testClosingCodeWithMRK() {
        String text = "<?xml version='1.0'?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" xmlns:m=\"urn:oasis:names:tc:xliff:matches:2.0\" srcLang=\"en\" trgLang=\"fr\"><file id=\"f1\" xmlns:fs=\"urn:oasis:names:tc:xliff:fs:2.0\">\n<unit id=\"id\">\n<segment>\n<source><mrk id=\"1\" type='comment' value='comment' fs:fs=\"b\">text</mrk></source></segment></unit>\n</file></xliff>";
        Unit unit = this.getUnit(text, 1);
        Assert.assertEquals((Object)false, (Object)unit.getStore().getSourceTags().get(U.kCA(0)).hasExtAttribute());
    }

    @Test
    public void testCPElements() {
        char[] chars = Character.toChars(65537);
        String text = "<?xml version='1.0'?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" xmlns:m=\"urn:oasis:names:tc:xliff:matches:2.0\" srcLang=\"en\" trgLang=\"fr\"><file id=\"f1\">\n<unit id=\"id\"><originalData><data id='1'>[<cp hex=\"0019\"/><cp hex=\"0004\"/><cp hex=\"FFFF\"/>&#x10001;]</data></originalData><segment>\n<source><ph id=\"1\" dataRef='1'/><cp hex=\"0019\"/><cp hex=\"0004\"/><cp hex=\"FFFF\"/>&#x10001;</source></segment></unit>\n</file></xliff>";
        Unit unit = this.getUnit(text, 1);
        Assert.assertNotNull((Object)unit);
        Assert.assertEquals((Object)("\u0019\u0004\uffff" + chars[0] + chars[1]), (Object)unit.getPart(0).getSource().getCodedText().substring(2));
        CTag code = (CTag)unit.getStore().getSourceTags().get(U.kSC(0));
        Assert.assertEquals((Object)("[\u0019\u0004\uffff" + chars[0] + chars[1] + "]"), (Object)code.getData());
        Assert.assertEquals((Object)("<ph id=\"1\" dataRef=\"d1\"/><cp hex=\"0019\"/><cp hex=\"0004\"/><cp hex=\"FFFF\"/>" + chars[0] + chars[1]), (Object)unit.getPart(0).getSource().toXLIFF(null, null, true));
    }

    @Test
    public void testInvalidCharacters() {
        String text = "<?xml version='1.0'?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" xmlns:m=\"urn:oasis:names:tc:xliff:matches:2.0\" srcLang=\"en\" trgLang=\"fr\"><file id=\"f1\">\n<unit id=\"id\"><segment>\n<source><cp hex='D801'/></source></segment></unit>\n</file></xliff>";
        Unit unit = this.getUnit(text, 1);
        Assert.assertEquals((Object)"\ud801", (Object)unit.getPart(0).getSource().getCodedText());
    }

    @Test(expected=XLIFFReaderException.class)
    public void testBadCPValues() {
        String text = "<?xml version='1.0'?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" xmlns:m=\"urn:oasis:names:tc:xliff:matches:2.0\" srcLang=\"en\" trgLang=\"fr\"><file id=\"f1\">\n<unit id=\"id\"><segment>\n<source><ph id=\"1\" dataRef='abc'></ph>a<cp hex=\"_bad2_\"/>z</source></segment><originalData><data id='abc'>[<cp hex=\"_bad1_\"/>]</data></originalData></unit>\n</file></xliff>";
        this.getUnit(text, 1);
    }

    @Test
    public void testDataDir() {
        String text = "<?xml version='1.0'?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" xmlns:m=\"urn:oasis:names:tc:xliff:matches:2.0\" srcLang=\"en\"><file id=\"f1\">\n<unit id=\"id\"><originalData><data id='abc' dir='rtl'>data</data><data id='pcs'>auto-data</data><data id='pce' dir='rtl'>data</data><data id='xyz' dir='ltr'>data</data></originalData><segment>\n<source><ph id='1' dataRef='abc'></ph><pc id='2' dataRefStart='pcs' dataRefEnd='pce'>text</pc><ph id='3' dataRef='xyz'/></source></segment></unit>\n</file></xliff>";
        Unit unit = this.getUnit(text, 1);
        Assert.assertNotNull((Object)unit);
        CTag code = (CTag)unit.getStore().getSourceTags().get(U.kSC(0));
        Assert.assertEquals((Object)"1", (Object)code.getId());
        Assert.assertEquals((Object)"data", (Object)code.getData());
        Assert.assertEquals((Object)Directionality.RTL, (Object)code.getDataDir());
        code = (CTag)unit.getStore().getSourceTags().get(U.kOC(0));
        Assert.assertEquals((Object)"2", (Object)code.getId());
        Assert.assertEquals((Object)"auto-data", (Object)code.getData());
        Assert.assertEquals((Object)Directionality.AUTO, (Object)code.getDataDir());
        code = (CTag)unit.getStore().getSourceTags().get(U.kCC(0));
        Assert.assertEquals((Object)"2", (Object)code.getId());
        Assert.assertEquals((Object)"data", (Object)code.getData());
        Assert.assertEquals((Object)Directionality.RTL, (Object)code.getDataDir());
        code = (CTag)unit.getStore().getSourceTags().get(U.kSC(1));
        Assert.assertEquals((Object)"3", (Object)code.getId());
        Assert.assertEquals((Object)"data", (Object)code.getData());
        Assert.assertEquals((Object)Directionality.LTR, (Object)code.getDataDir());
        Assert.assertEquals((Object)"<ph id=\"1\" dataRef=\"d1\"/><pc id=\"2\" dataRefEnd=\"d1\" dataRefStart=\"d2\">text</pc><ph id=\"3\" dataRef=\"d3\"/>", (Object)unit.getPart(0).getSource().toXLIFF(null, null, true));
    }

    @Test
    public void testInlineCodes1() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" srcLang=\"sv\" trgLang=\"en\"><file id=\"f1\"><unit id=\"1\"><segment><source>text1 <pc id='1' type='fmt' subType='xlf:b'>text2 text3</pc></source><target><pc id='1' type='fmt' subType='xlf:b'>text2</pc> text1 <pc id='2' copyOf='1'>text3</pc></target></segment></unit><unit id=\"2\"><segment>\n<source><sc id=\"1\" equiv=\"eq1\" disp=\"di1\"/>t1<pc id=\"2\" equivStart=\"eq2\" dispStart=\"di2\" equivEnd=\"eq2e\" dispEnd=\"de2e\">t2<ph id=\"3\" subFlows=\"1\" equiv=\"eq3\" disp=\"di3\"/>t3</pc><ec startRef=\"1\" equiv=\"eq1e\" disp=\"di1e\"/></source></segment></unit>\n</file></xliff>";
        Unit unit = this.getUnit(text, 1);
        CTag code = (CTag)unit.getStore().getTargetTags().get("1", TagType.OPENING);
        Assert.assertEquals((Object)"1", (Object)code.getId());
        Assert.assertEquals((Object)"fmt", (Object)code.getType());
        Assert.assertEquals((Object)"xlf:b", (Object)code.getSubType());
        code = (CTag)unit.getStore().getTargetTags().get("2", TagType.OPENING);
        Assert.assertEquals((Object)"1", (Object)code.getCopyOf());
        Assert.assertEquals((Object)"2", (Object)code.getId());
        Assert.assertEquals((Object)"", (Object)code.getEquiv());
        unit = this.getUnit(text, 2);
        Assert.assertNotNull((Object)unit);
        code = (CTag)unit.getStore().getSourceTags().get(U.kOC(0));
        Assert.assertEquals((Object)"eq1", (Object)code.getEquiv());
        Assert.assertEquals((Object)"di1", (Object)code.getDisp());
        code = (CTag)unit.getStore().getSourceTags().get(U.kOC(1));
        Assert.assertEquals((Object)"eq2", (Object)code.getEquiv());
        Assert.assertEquals((Object)"di2", (Object)code.getDisp());
        code = (CTag)unit.getStore().getSourceTags().get(U.kSC(0));
        Assert.assertEquals((Object)"eq3", (Object)code.getEquiv());
        Assert.assertEquals((Object)"di3", (Object)code.getDisp());
        Assert.assertEquals((Object)"<pc id=\"1\" canOverlap=\"yes\" equivStart=\"eq1\" dispStart=\"di1\" equivEnd=\"eq1e\" dispEnd=\"di1e\">t1<pc id=\"2\" equivStart=\"eq2\" dispStart=\"di2\" equivEnd=\"eq2e\" dispEnd=\"de2e\">t2<ph id=\"3\" equiv=\"eq3\" disp=\"di3\" subFlows=\"1\"/>t3</pc></pc>", (Object)unit.getPart(0).getSource().toXLIFF(null, null, false));
    }

    @Test
    public void testInlineCodes2() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" srcLang=\"en\" trgLang=\"fr\"><file id=\"f1\">\n<unit id=\"id\"><segment>\n<source><sc id=\"1\" isolated=\"yes\"/>t1<ec id=\"2\" isolated=\"yes\"/></source></segment></unit>\n</file></xliff>";
        Unit unit = this.getUnit(text, 1);
        Assert.assertNotNull((Object)unit);
        CTag code = (CTag)unit.getStore().getSourceTags().get(U.kOC(0));
        Assert.assertEquals((Object)"1", (Object)code.getId());
        Assert.assertEquals((Object)TagType.OPENING, (Object)code.getTagType());
        code = (CTag)unit.getStore().getSourceTags().get(U.kCC(0));
        Assert.assertEquals((Object)"2", (Object)code.getId());
        Assert.assertEquals((Object)TagType.CLOSING, (Object)code.getTagType());
        Assert.assertEquals((Object)"<sc id=\"1\" isolated=\"yes\"/>t1<ec id=\"2\" isolated=\"yes\"/>", (Object)unit.getPart(0).getSource().toXLIFF(null, null, false));
    }

    @Test(expected=XLIFFReaderException.class)
    public void testInlineECWithDefaultCanCopy() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" srcLang=\"en\"><file id=\"f1\"><unit id=\"1\"><segment><source><sc id='1' canCopy='no'/>text<ec startRef='1'/></source></segment></unit>\n</file></xliff>";
        this.getUnit(text, 1);
    }

    @Test(expected=XLIFFReaderException.class)
    public void testInlineECWithDefaultCanDelete() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" srcLang=\"en\"><file id=\"f1\"><unit id=\"1\"><segment><source><sc id='1' canDelete='no'/>text<ec startRef='1'/></source></segment></unit>\n</file></xliff>";
        this.getUnit(text, 1);
    }

    @Test(expected=XLIFFReaderException.class)
    public void testInlineECWithDefaultType() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" srcLang=\"en\"><file id=\"f1\"><unit id=\"1\"><segment><source><sc id='1' type='fmt'/>text<ec startRef='1'/></source></segment></unit>\n</file></xliff>";
        this.getUnit(text, 1);
    }

    @Test
    public void testInlineEMForType() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" srcLang=\"en\"><file id=\"f1\"><unit id=\"1\"><segment><source><sm id='1' type='x:abc'/>text<em startRef='1'/></source></segment></unit>\n</file></xliff>";
        this.getUnit(text, 1);
    }

    @Test(expected=XLIFFReaderException.class)
    public void testInlineECWithDefaultSubType() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" srcLang=\"en\"><file id=\"f1\"><unit id=\"1\"><segment><source><sc id='1' type='fmt' subType='a:b'/>text<ec startRef='1' type='fmt'/></source></segment></unit>\n</file></xliff>";
        this.getUnit(text, 1);
    }

    @Test
    public void testInlinePCWithReorder() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" srcLang=\"en\"><file id=\"f1\"><unit id=\"1\"><segment><source><pc id='1' canReorder='firstNo' canDelete='no' canCopy='no'>text</pc></source></segment></unit>\n</file></xliff>";
        this.getUnit(text, 1);
    }

    @Test
    public void testInlineSCECWithReorder() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" srcLang=\"en\"><file id=\"f1\"><unit id=\"1\"><segment><source><sc id='1' canReorder='firstNo' canDelete='no' canCopy='no'/>text<ec startRef='1' canReorder='no' canDelete='no' canCopy='no'/></source></segment></unit>\n</file></xliff>";
        this.getUnit(text, 1);
    }

    @Test
    public void testInlineSCECWithReorderBadEC() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" srcLang=\"en\"><file id=\"f1\"><unit id=\"1\"><segment><source><sc id='1' canReorder='firstNo' canDelete='no' canCopy='no'/>text<ec startRef='1' canReorder='firstNo' canDelete='no' canCopy='no'/></source></segment></unit>\n</file></xliff>";
        this.getUnit(text, 1);
    }

    @Test(expected=XLIFFReaderException.class)
    public void testInlineECWithDefaultReorder() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" srcLang=\"en\"><file id=\"f1\"><unit id=\"1\"><segment><source><sc id='1' canReorder='firstNo' canDelete='no' canCopy='no'/>text<ec startRef='1' canDelete='no' canCopy='no'/></source></segment></unit>\n</file></xliff>";
        this.getUnit(text, 1);
    }

    @Test(expected=XLIFFReaderException.class)
    public void testInlineECWithBadReorder1() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" srcLang=\"en\"><file id=\"f1\"><unit id=\"1\"><segment><source><sc id='1' canDelete='no' canCopy='no'/>text<ec startRef='1' canReorder='no' canDelete='no' canCopy='no'/></source></segment></unit>\n</file></xliff>";
        this.getUnit(text, 1);
    }

    @Test(expected=XLIFFReaderException.class)
    public void testInlineECWithBadReorder2() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" srcLang=\"en\"><file id=\"f1\"><unit id=\"1\"><segment><source><sc id='1' canDelete='no' canCopy='no'/>text<ec startRef='1' canReorder='firstNo' canDelete='no' canCopy='no'/></source></segment></unit>\n</file></xliff>";
        this.getUnit(text, 1);
    }

    @Test
    public void testInlineECWithAllowedReorderValuesForSCFirstNo() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" srcLang=\"en\"><file id=\"f1\"><unit id=\"1\"><segment><source><sc id='1' canReorder='firstNo' canDelete='no' canCopy='no'/>text<ec startRef='1' canReorder='firstNo' canDelete='no' canCopy='no'/></source></segment></unit>\n<unit id=\"2\"><segment><source><sc id='1' canReorder='firstNo' canDelete='no' canCopy='no'/>text<ec startRef='1' canReorder='no' canDelete='no' canCopy='no'/></source></segment></unit>\n</file></xliff>";
        this.getUnit(text, 1);
    }

    @Test
    public void testInlineECWithDefaultDir() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" srcLang=\"en\"><file id=\"f1\"><unit id=\"1\"><segment><source><sc id='1' dir='rtl'/>text<ec startRef='1'/></source></segment></unit>\n</file></xliff>";
        this.getUnit(text, 1);
    }

    @Test(expected=XLIFFReaderException.class)
    public void testInlineECWithDefaultCopyOf() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" srcLang=\"en\"><file id=\"f1\"><unit id=\"1\"><segment><source><pc id='1'></pc><sc id='2' copyOf='1'/>text<ec startRef='2'/></source></segment></unit>\n</file></xliff>";
        this.getUnit(text, 1);
    }

    @Test
    public void testAnnotations() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" srcLang=\"en\" trgLang=\"fr\"><file id=\"f1\">\n<unit id=\"id\"><segment>\n<source><sm id=\"1\" type=\"comment\" value=\"my note\"/>t1<em startRef=\"1\"/></source><target><mrk id=\"1\" type=\"comment\" value=\"my note trg\">t1</mrk></target></segment></unit>\n</file></xliff>";
        Unit unit = this.getUnit(text, 1);
        Assert.assertNotNull((Object)unit);
        MTag ann = (MTag)unit.getStore().getSourceTags().get(U.kOA(0));
        Assert.assertEquals((Object)"comment", (Object)ann.getType());
        Assert.assertEquals((Object)"my note", (Object)ann.getValue());
        Assert.assertEquals((Object)"<mrk id=\"1\" type=\"comment\" value=\"my note\">t1</mrk>", (Object)unit.getPart(0).getSource().toXLIFF(null, null, false));
        ann = (MTag)unit.getStore().getTargetTags().get(U.kCA(0));
        Assert.assertEquals((Object)"comment", (Object)ann.getType());
        Assert.assertEquals((Object)"my note trg", (Object)ann.getValue());
        Assert.assertEquals((Object)"<mrk id=\"1\" type=\"comment\" value=\"my note trg\">t1</mrk>", (Object)unit.getPart(0).getTarget().toXLIFF(null, null, false));
    }

    @Test
    public void testComments() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" srcLang=\"en\" trgLang=\"fr\"><file id=\"f1\">\n<unit id=\"id\"><segment>\n<source><!--comment-->Source 1.</source><target>Target<!--comment--> 1.</target>\n</segment></unit>\n</file></xliff>";
        Unit unit = this.getUnit(text, 1);
        Assert.assertNotNull((Object)unit);
        Assert.assertEquals((Object)"Source 1.", (Object)unit.getPart(0).getSource().toXLIFF());
        Assert.assertEquals((Object)"Target 1.", (Object)unit.getPart(0).getTarget().toXLIFF());
    }

    @Test
    public void testPI() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" srcLang=\"en\" trgLang=\"fr\"><file id=\"f1\">\n<unit id=\"id\"><segment>\n<source><?myPI?>Source 1.</source><target>Target<?myPI?> 1.</target>\n</segment></unit>\n</file></xliff>";
        Unit unit = this.getUnit(text, 1);
        Assert.assertNotNull((Object)unit);
        Assert.assertEquals((Object)"Source 1.", (Object)unit.getPart(0).getSource().toString());
        Assert.assertEquals((Object)"Target 1.", (Object)unit.getPart(0).getTarget().toString());
    }

    @Test
    public void testInputStreamUsedTwice() {
        String text = "<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" srcLang=\"en\"><file id=\"f1\">\n<unit id=\"id\"><segment>\n<source>Source.</source></segment></unit>\n</file></xliff>";
        ByteArrayInputStream is = new ByteArrayInputStream(text.getBytes());
        XLIFFReader reader = new XLIFFReader(255);
        reader.open((InputStream)is);
        while (reader.hasNext()) {
            Event event = reader.next();
            if (event.getType() != EventType.TEXT_UNIT) continue;
            Assert.assertEquals((Object)"Source.", (Object)event.getUnit().getPart(0).getSource().toString());
        }
        reader.close();
    }

    @Test
    public void testWhiteSpaces() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" srcLang=\"en\" trgLang=\"fr\"><file id=\"f1\">\n<unit id=\"id\"><originalData><data id='a'>  A  \t B  </data></originalData><segment><source>a1  b \t c <ph id=\"1\" dataRef='a'></ph></source></segment><segment><source xml:space=\"preserve\">a2  b \t c <ph id=\"2\" dataRef='a'/></source></segment><segment><source xml:space=\"default\">a3  b \t c <ph id=\"3\" dataRef='a'></ph></source></segment></unit>\n</file></xliff>";
        Unit unit = this.getUnit(text, 1);
        Assert.assertNotNull((Object)unit);
        Segment seg = (Segment)unit.getPart(0);
        Assert.assertEquals((Object)"a1  b \t c <ph id=\"1\" dataRef=\"d1\"/>", (Object)seg.getSource().toXLIFF(null, null, true));
        Assert.assertFalse((boolean)seg.getPreserveWS());
        CTag cm = (CTag)seg.getSource().getTag(U.kSC(0));
        Assert.assertEquals((Object)"  A  \t B  ", (Object)cm.getData());
        seg = (Segment)unit.getPart(1);
        Assert.assertEquals((Object)"a2  b \t c <ph id=\"2\" dataRef=\"d1\"/>", (Object)seg.getSource().toXLIFF(null, null, true));
        Assert.assertTrue((boolean)seg.getPreserveWS());
        seg = (Segment)unit.getPart(2);
        Assert.assertEquals((Object)"a3  b \t c <ph id=\"3\" dataRef=\"d1\"/>", (Object)seg.getSource().toXLIFF(null, null, true));
        Assert.assertFalse((boolean)seg.getPreserveWS());
    }

    @Test(expected=XLIFFReaderException.class)
    public void testDuplicatedUnitIdValues() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" srcLang=\"en\" trgLang=\"fr\"><file id=\"f1\"><unit id=\"_testDupId_\"><segment><source>a</source></segment></unit><unit id=\"id2\"><segment><source>a</source></segment></unit><unit id=\"id3\"><segment><source>a</source></segment></unit><unit id=\"_testDupId_\"><segment><source>a</source></segment></unit></file></xliff>";
        this.getUnit(text, 4);
    }

    @Test(expected=XLIFFReaderException.class)
    public void testMissingType() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" srcLang=\"en\" trgLang=\"fr\"><file id=\"f1\"><unit id='1'><segment><source><ph id='1' subType='my:value'/></source></segment></unit></file></xliff>";
        this.getUnit(text, 4);
    }

    @Test(expected=XLIFFReaderException.class)
    public void testDuplicatedOrderValues() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" srcLang=\"en\" trgLang=\"fr\"><file id=\"f1\">\n<unit id=\"id\"><segment><source>a</source><target order='2'>A</target></segment><segment><source>b</source><target order='2'>B</target></segment></unit>\n</file></xliff>";
        Unit unit = this.getUnit(text, 1);
        Assert.assertNotNull((Object)unit);
    }

    @Test(expected=XLIFFReaderException.class)
    public void testBadOrderValues() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" srcLang=\"en\" trgLang=\"fr\"><file id=\"f1\">\n<unit id=\"id\"><segment><source>a</source><target order='5'>A</target></segment></unit>\n</file></xliff>";
        Unit unit = this.getUnit(text, 1);
        Assert.assertNotNull((Object)unit);
    }

    @Test(expected=XLIFFReaderException.class)
    public void testBadSourceLanguage() {
        String text = "<?xml version='1.0'?><xliff version='2.0' xmlns='urn:oasis:names:tc:xliff:document:2.0' srcLang='en'><file id=\"f1\"><unit id='id'><segment><source xml:lang='en-us'>a</source></segment></unit></file></xliff>";
        Unit unit = this.getUnit(text, 1);
        Assert.assertNotNull((Object)unit);
    }

    @Test(expected=XLIFFReaderException.class)
    public void testBadTargetLanguage() {
        String text = "<?xml version='1.0'?><xliff version='2.0' xmlns='urn:oasis:names:tc:xliff:document:2.0' srcLang='en' trgLang='fr'><file id=\"f1\"><unit id='id'><segment><source xml:lang='en'>a</source><target xml:lang='fr-fr'>b</target></segment></unit></file></xliff>";
        Unit unit = this.getUnit(text, 1);
        Assert.assertNotNull((Object)unit);
    }

    @Test(expected=XLIFFReaderException.class)
    public void testMissingTargetLanguage() {
        String text = "<?xml version='1.0'?><xliff version='2.0' xmlns='urn:oasis:names:tc:xliff:document:2.0' srcLang='en'><file id=\"f1\"><unit id='id'><segment><source xml:lang='en'>a</source><target xml:lang='fr'>b</target></segment></unit></file></xliff>";
        Unit unit = this.getUnit(text, 1);
        Assert.assertNotNull((Object)unit);
    }

    @Test(expected=XLIFFReaderException.class)
    public void testBadInheritedTargetLanguage() {
        String text = "<?xml version='1.0'?><xliff version='2.0' xmlns='urn:oasis:names:tc:xliff:document:2.0' srcLang='en' trgLang='fr'><file id=\"f1\" xml:lang='ru'><unit id='id'><segment><source xml:lang='en'>a</source><target>b</target></segment></unit></file></xliff>";
        Unit unit = this.getUnit(text, 1);
        Assert.assertNotNull((Object)unit);
    }

    @Test
    public void testGoodInheritedTargetLanguage() {
        String text = "<?xml version='1.0'?><xliff version='2.0' xmlns='urn:oasis:names:tc:xliff:document:2.0' srcLang='en' trgLang='fr'><file id=\"f1\" xml:lang='ru'><unit id='id'><segment><source xml:lang='en'>a</source><target xml:lang='fr'>b</target></segment></unit></file></xliff>";
        Unit unit = this.getUnit(text, 1);
        Assert.assertNotNull((Object)unit);
    }

    @Test(expected=XLIFFReaderException.class)
    public void testBadInheritedSourceLanguage() {
        String text = "<?xml version='1.0'?><xliff version='2.0' xmlns='urn:oasis:names:tc:xliff:document:2.0' srcLang='en'><file id=\"f1\"><unit id='id' xml:lang='zh'><segment><source>a</source></segment></unit></file></xliff>";
        Unit unit = this.getUnit(text, 1);
        Assert.assertNotNull((Object)unit);
    }

    @Test
    public void testIgnorables() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" srcLang=\"en\" trgLang=\"fr\"><file id=\"f1\">\n<unit id=\"id\"><ignorable>\n<source>  \t</source><target>\t\t </target>\n</ignorable><segment><source/></segment></unit>\n</file></xliff>";
        Unit unit = this.getUnit(text, 1);
        Assert.assertNotNull((Object)unit);
        Assert.assertEquals((Object)"  \t", (Object)unit.getPart(0).getSource().toString());
        Assert.assertEquals((Object)"\t\t ", (Object)unit.getPart(0).getTarget().toString());
    }

    @Test
    public void testInline() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" srcLang=\"en\" trgLang=\"fr\"><file id=\"f1\" xmlns:fs=\"urn:oasis:names:tc:xliff:fs:2.0\">\n<unit id=\"1\"><originalData><data id='d1'>[br/]</data><data id='d2s'>[b]</data><data id='d2e'>[/b]</data></originalData><segment>\n<source><ph id='1' dataRef='d1' canCopy='no' canDelete='no' canReorder='firstNo' disp='disp1' equiv='equiv1'  type='fmt' subType='a:xyz' fs:fs=\"b\"/><pc id='2' dataRefStart='d2s' dataRefEnd='d2e' canCopy='no' canDelete='no' canReorder='no' dispStart='disp2' equivStart='equiv2'  type='fmt' subType='a:xyz' dispEnd='disp2e' equivEnd='equiv2e' fs:fs=\"em\">text</pc><sc id='3' dataRef='d2s' canCopy='no' canDelete='no' canReorder='no' disp='disp3' equiv='equiv3'  type='fmt' subType='a:xyz' fs:fs=\"i\"/>text<ec startRef='3' dataRef='d2e' canCopy='no' canDelete='no' canReorder='no' type='fmt' subType='a:xyz' /></source></segment></unit>\n</file></xliff>";
        Unit unit = this.getUnit(text, 1);
        Assert.assertNotNull((Object)unit);
        Fragment frag = unit.getPart(0).getSource();
        CTag cm = (CTag)frag.getStore().getSourceTags().get(U.kSC(0));
        Assert.assertEquals((Object)"1", (Object)cm.getId());
        Assert.assertEquals((Object)false, (Object)cm.getCanCopy());
        Assert.assertEquals((Object)false, (Object)cm.getCanDelete());
        Assert.assertEquals((Object)CanReorder.FIRSTNO, (Object)cm.getCanReorder());
        Assert.assertEquals((Object)false, (Object)cm.getCanOverlap());
        Assert.assertEquals((Object)"disp1", (Object)cm.getDisp());
        Assert.assertEquals((Object)"equiv1", (Object)cm.getEquiv());
        Assert.assertEquals((Object)"d1", (Object)cm.getDataRef());
        Assert.assertEquals((Object)"b", (Object)cm.getExtAttributeValue("urn:oasis:names:tc:xliff:fs:2.0", "fs"));
        cm = (CTag)frag.getStore().getSourceTags().get(U.kOC(0));
        Assert.assertEquals((Object)"2", (Object)cm.getId());
        Assert.assertEquals((Object)false, (Object)cm.getCanCopy());
        Assert.assertEquals((Object)false, (Object)cm.getCanDelete());
        Assert.assertEquals((Object)CanReorder.NO, (Object)cm.getCanReorder());
        Assert.assertEquals((Object)false, (Object)cm.getCanOverlap());
        Assert.assertEquals((Object)"disp2", (Object)cm.getDisp());
        Assert.assertEquals((Object)"equiv2", (Object)cm.getEquiv());
        Assert.assertEquals((Object)"d2s", (Object)cm.getDataRef());
        Assert.assertEquals((Object)"em", (Object)cm.getExtAttributeValue("urn:oasis:names:tc:xliff:fs:2.0", "fs"));
        cm = (CTag)frag.getStore().getSourceTags().get(U.kCC(0));
        Assert.assertEquals((Object)"2", (Object)cm.getId());
        Assert.assertEquals((Object)false, (Object)cm.getCanCopy());
        Assert.assertEquals((Object)false, (Object)cm.getCanDelete());
        Assert.assertEquals((Object)CanReorder.NO, (Object)cm.getCanReorder());
        Assert.assertEquals((Object)false, (Object)cm.getCanOverlap());
        Assert.assertEquals((Object)"disp2e", (Object)cm.getDisp());
        Assert.assertEquals((Object)"equiv2e", (Object)cm.getEquiv());
        Assert.assertEquals((Object)"d2e", (Object)cm.getDataRef());
        Assert.assertEquals(null, (Object)cm.getExtAttributeValue("urn:oasis:names:tc:xliff:fs:2.0", "fs"));
    }

    @Test
    public void testOriginalDataStyles() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" srcLang=\"en\" trgLang=\"fr\"><file id=\"f1\">\n<unit id=\"id\">\n<originalData><data id='1'>[c]</data><data id='2'>[/c]</data><data id='3'>[b/]</data></originalData><segment><source><pc id='1' dataRefStart='1' dataRefEnd='2'>text</pc></source></segment><segment><source><sc id='2'></sc>text<ec startRef='2'/></source></segment><segment><source><ph id='3' dataRef='3'/></source></segment><segment><source><ph id='4'></ph>text<ph id='5'/></source></segment></unit>\n</file></xliff>";
        Unit unit = this.getUnit(text, 1);
        Assert.assertNotNull((Object)unit);
        Fragment frag = unit.getPart(0).getSource();
        Tags mrks = frag.getStore().getSourceTags();
        Assert.assertEquals((Object)true, (Object)((CTag)mrks.get("1", TagType.OPENING)).isInitialWithData());
        Assert.assertEquals((Object)true, (Object)((CTag)mrks.get("1", TagType.CLOSING)).isInitialWithData());
        Assert.assertEquals((Object)false, (Object)((CTag)mrks.get("2", TagType.OPENING)).isInitialWithData());
        Assert.assertEquals((Object)false, (Object)((CTag)mrks.get("2", TagType.CLOSING)).isInitialWithData());
        Assert.assertEquals((Object)true, (Object)((CTag)mrks.get("3", TagType.STANDALONE)).isInitialWithData());
        Assert.assertEquals((Object)false, (Object)((CTag)mrks.get("4", TagType.STANDALONE)).isInitialWithData());
        Assert.assertEquals((Object)false, (Object)((CTag)mrks.get("5", TagType.STANDALONE)).isInitialWithData());
    }

    @Test
    public void testOutsideData() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" srcLang=\"en\" trgLang=\"fr\"><file id=\"f1\">\n<unit id=\"id\"><originalData><data id='d1'>[1/]</data><data id='d2'>[2]</data><data id='d3'>[/2]</data></originalData><segment>\n<source>source <ph id='1' dataRef='d1'/> and <pc id='2' dataRefStart='d2' dataRefEnd='d3'>bold</pc></source></segment>\n</unit>\n</file></xliff>";
        Unit unit = this.getUnit(text, 1);
        Assert.assertNotNull((Object)unit);
        Segment seg = (Segment)unit.getPart(0);
        Assert.assertEquals((Object)"source <ph id=\"1\" dataRef=\"d1\"/> and <pc id=\"2\" dataRefEnd=\"d3\" dataRefStart=\"d2\">bold</pc>", (Object)seg.getSource().toXLIFF(null, null, true));
    }

    @Test
    public void testChangeTrack() {
        String text = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" xmlns:ctr=\"urn:oasis:names:tc:xliff:changetracking:2.0\" version=\"2.0\" srcLang=\"en-US\">\n<file id=\"f1\">\n<unit id=\"unit1\">\n<ctr:changeTrack>\n<ctr:revisions appliesTo=\"note\" ref=\"n1\">\n<ctr:revision author=\"system\" datetime=\"2015-10-21T09:00:00+00:00\">\n<ctr:item property=\"content\">old note</ctr:item>\n</ctr:revision>\n</ctr:revisions>\n<ctr:revisions appliesTo=\"note\" ref=\"n2\">\n<ctr:revision author=\"system2\" datetime=\"2015-10-21T09:00:00+00:00\">\n<ctr:item property=\"content\">old note n2</ctr:item>\n</ctr:revision>\n</ctr:revisions>\n</ctr:changeTrack>\n<notes>\n<note id=\"n1\">new note</note>\n<note id=\"n2\">another note</note>\n</notes>\n<originalData>\n<data id=\"d1\">&lt;B></data>\n<data id=\"d2\">&lt;/B></data>\n</originalData><segment>\n<source>Hello<pc id=\"1\" dataRefEnd=\"d2\" dataRefStart=\"d1\">World!</pc>\n</source>\n</segment>\n</unit>\n</file>\n</xliff>";
        Unit unit = this.getUnit(text, 1);
        ChangeTrack changeTrack = unit.getChangeTrack();
        Assert.assertNotNull((Object)changeTrack);
        Revisions revisions = (Revisions)changeTrack.get(0);
        Assert.assertNotNull((Object)revisions.getAppliesTo());
        Assert.assertEquals((Object)"note", (Object)revisions.getAppliesTo());
        Assert.assertNotNull((Object)revisions.getRef());
        Assert.assertEquals((Object)"n1", (Object)revisions.getRef());
        Assert.assertTrue((revisions.getCurrentVersion() == null ? 1 : 0) != 0);
        Assert.assertFalse((boolean)revisions.hasExtAttribute());
        Assert.assertTrue((revisions.size() == 1 ? 1 : 0) != 0);
        Revision revision = (Revision)revisions.get(0);
        Assert.assertEquals((Object)"system", (Object)revision.getAuthor());
        Assert.assertEquals((Object)"2015-10-21T09:00:00+00:00", (Object)revision.getDatetime());
        Assert.assertTrue((revision.getVersion() == null ? 1 : 0) != 0);
        Assert.assertFalse((boolean)revision.hasExtAttribute());
        Assert.assertTrue((revision.size() == 1 ? 1 : 0) != 0);
        Item item = (Item)revision.get(0);
        Assert.assertEquals((Object)"content", (Object)item.getProperty());
        Assert.assertFalse((boolean)item.hasExtAttribute());
        Assert.assertEquals((Object)"old note", (Object)item.getText());
        revisions = (Revisions)changeTrack.get(1);
        Assert.assertNotNull((Object)revisions.getAppliesTo());
        Assert.assertEquals((Object)"note", (Object)revisions.getAppliesTo());
        Assert.assertNotNull((Object)revisions.getRef());
        Assert.assertEquals((Object)"n2", (Object)revisions.getRef());
        Assert.assertTrue((revisions.getCurrentVersion() == null ? 1 : 0) != 0);
        Assert.assertFalse((boolean)revisions.hasExtAttribute());
        Assert.assertTrue((revisions.size() == 1 ? 1 : 0) != 0);
        revision = (Revision)revisions.get(0);
        Assert.assertEquals((Object)"system2", (Object)revision.getAuthor());
        Assert.assertEquals((Object)"2015-10-21T09:00:00+00:00", (Object)revision.getDatetime());
        Assert.assertTrue((revision.getVersion() == null ? 1 : 0) != 0);
        Assert.assertFalse((boolean)revision.hasExtAttribute());
        Assert.assertTrue((revision.size() == 1 ? 1 : 0) != 0);
        item = (Item)revision.get(0);
        Assert.assertEquals((Object)"content", (Object)item.getProperty());
        Assert.assertFalse((boolean)item.hasExtAttribute());
        Assert.assertEquals((Object)"old note n2", (Object)item.getText());
    }

    @Test(expected=XLIFFReaderException.class)
    public void testChangeTrackWrongCurrRevision() {
        String text = "<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" xmlns:ctr=\"urn:oasis:names:tc:xliff:changetracking:2.0\" version=\"2.0\" srcLang=\"en-US\">\n<file id=\"f1\">\n<unit id=\"unit1\">\n<ctr:changeTrack>\n<ctr:revisions appliesTo=\"note\" ref=\"n1\" currentVersion=\"rev1\">\n<ctr:revision author=\"system\" datetime=\"2015-10-21T09:00:00+00:00\">\n<ctr:item property=\"content\">old note</ctr:item>\n</ctr:revision>\n</ctr:revisions>\n</ctr:changeTrack>\n<notes>\n<note id=\"n1\">new note</note>\n<note id=\"n2\">another note</note>\n</notes>\n<originalData>\n<data id=\"d1\">&lt;B></data>\n<data id=\"d2\">&lt;/B></data>\n</originalData><segment>\n<source>Hello<pc id=\"1\" dataRefEnd=\"d2\" dataRefStart=\"d1\">World!</pc>\n</source>\n</segment>\n</unit>\n</file>\n</xliff>";
        this.getUnit(text, 1);
    }

    @Test
    public void testExtensionElementCount() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" xmlns:mda=\"urn:oasis:names:tc:xliff:metadata:2.0\" srcLang=\"en\" trgLang=\"fr\"><file id=\"f1\">\n<group id=\"g1\"><mda:metadata><mda:metaGroup category=\"document_xml_attribute\"><mda:meta type=\"version\">3</mda:meta><mda:meta type=\"phase\">draft</mda:meta></mda:metaGroup></mda:metadata><group id=\"g2\" name=\"table\"><group id=\"g3\" name=\"row\"><mda:metadata><mda:metaGroup category=\"row_xml_attribute\"><mda:meta type=\"style\">head</mda:meta></mda:metaGroup></mda:metadata><unit id=\"u1\" name=\"cell\"><segment><source>Name</source></segment></unit></group></group></group></file></xliff>";
        XLIFFReader.validate((String)text, null);
    }

    @Test
    public void testExtensionAttributes() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" xmlns:x=\"abc\" srcLang=\"en\" trgLang=\"fr\"><file id=\"f1\"><unit id=\"id\" x:a1=\"v1\" x:a2=\"v2\"><segment><source>src</source><target>trg</target>\n</segment></unit>\n</file></xliff>";
        Unit unit = this.getUnit(text, 1);
        Assert.assertNotNull((Object)unit);
        ExtAttributes atts = unit.getExtAttributes();
        Assert.assertNotNull((Object)atts);
        ExtAttribute att = atts.getAttribute("abc", "a1");
        Assert.assertNotNull((Object)att);
        Assert.assertEquals((Object)"abc", (Object)att.getNamespaceURI());
        Assert.assertEquals((Object)"x", (Object)att.getPrefix());
        Assert.assertEquals((Object)"a1", (Object)att.getLocalPart());
        Assert.assertEquals((Object)"v1", (Object)att.getValue());
    }

    @Test
    public void testExtensionElements() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" xmlns:x=\"myNS\" srcLang=\"en\" trgLang=\"fr\"><file id=\"f1\"> <x:elem3 attr1='value1'>file-extension<x:elem2>content2f</x:elem2></x:elem3> <group id='g1'>  <x:elem3 id='x1'><![CDATA[group-extension1]]></x:elem3>  <x:elem3 id='x2'>group-extension2</x:elem3>  <unit id=\"id\">   <x:elem1 attr1='value1'>unit-extension<x:elem2>content2u</x:elem2></x:elem1>   <segment>    <source>source</source>   </segment>  </unit> </group></file></xliff>";
        MidFileData mfd = this.getMidFileData(text, 1);
        Assert.assertNotNull((Object)mfd);
        Assert.assertTrue((boolean)mfd.hasExtElements());
        ExtElements xelems = mfd.getExtElements();
        Assert.assertEquals((long)1L, (long)xelems.size());
        List res = xelems.find("myNS", "elem3");
        Assert.assertTrue((res.size() > 0 ? 1 : 0) != 0);
        ExtElement elem = (ExtElement)res.get(0);
        IExtChild child1 = (IExtChild)elem.getChildren().get(0);
        Assert.assertTrue((child1.getType() == ExtChildType.TEXT ? 1 : 0) != 0);
        Assert.assertEquals((Object)"file-extension", (Object)((ExtContent)child1).getText());
        Assert.assertTrue((child1 == elem.getFirstContent() ? 1 : 0) != 0);
        IExtChild child2 = (IExtChild)elem.getChildren().get(1);
        Assert.assertTrue((child2.getType() == ExtChildType.ELEMENT ? 1 : 0) != 0);
        Assert.assertEquals((Object)new QName("myNS", "elem2"), (Object)((ExtElement)child2).getQName());
        Assert.assertTrue((child2 == elem.getFirstElement() ? 1 : 0) != 0);
        StartGroupData sgd = this.getStartGroupData(text, 1);
        Assert.assertNotNull((Object)sgd);
        Assert.assertTrue((boolean)sgd.hasExtElements());
        xelems = sgd.getExtElements();
        Assert.assertEquals((long)2L, (long)xelems.size());
        res = xelems.find("myNS", "elem3");
        Assert.assertTrue((res.size() > 0 ? 1 : 0) != 0);
        elem = (ExtElement)res.get(0);
        child1 = (IExtChild)elem.getChildren().get(0);
        Assert.assertTrue((child1.getType() == ExtChildType.TEXT ? 1 : 0) != 0);
        Assert.assertEquals((Object)"group-extension1", (Object)((ExtContent)child1).getText());
        elem = (ExtElement)res.get(1);
        child1 = (IExtChild)elem.getChildren().get(0);
        Assert.assertTrue((child1.getType() == ExtChildType.TEXT ? 1 : 0) != 0);
        Assert.assertEquals((Object)"group-extension2", (Object)((ExtContent)child1).getText());
        Unit unit = this.getUnit(text, 1);
        Assert.assertNotNull((Object)unit);
        Assert.assertTrue((boolean)unit.hasExtElements());
        xelems = unit.getExtElements();
        Assert.assertEquals((long)1L, (long)xelems.size());
        res = xelems.find("myNS", "elem1");
        Assert.assertTrue((res.size() > 0 ? 1 : 0) != 0);
        elem = (ExtElement)res.get(0);
        child1 = (IExtChild)elem.getChildren().get(0);
        Assert.assertTrue((child1.getType() == ExtChildType.TEXT ? 1 : 0) != 0);
        Assert.assertEquals((Object)"unit-extension", (Object)((ExtContent)child1).getText());
        Assert.assertTrue((child1 == elem.getFirstContent() ? 1 : 0) != 0);
        child2 = (IExtChild)elem.getChildren().get(1);
        Assert.assertTrue((child2.getType() == ExtChildType.ELEMENT ? 1 : 0) != 0);
        Assert.assertEquals((Object)new QName("myNS", "elem2"), (Object)((ExtElement)child2).getQName());
        Assert.assertTrue((child2 == elem.getFirstElement() ? 1 : 0) != 0);
    }

    @Test(expected=XLIFFReaderException.class)
    public void testDuplicateIdOnExtensionElements() {
        String text = "<?xml version='1.0'?>\n<xliff version=\"2.0\" xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" xmlns:x=\"myNS\" srcLang=\"en\" trgLang=\"fr\"><file id=\"f1\"> <group>  <x:elem3 id='x1Dup'>group-extension1</x:elem3>  <x:elem3 id='x1Dup'>group-extension2</x:elem3>  <unit id=\"id\">   <segment>    <source>source</source>   </segment>  </unit> </group></file></xliff>";
        this.getUnit(text, 1);
    }

    @Test
    public void testCommentWithRef() {
        String text = "<?xml version='1.0'?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" xmlns:m=\"urn:oasis:names:tc:xliff:matches:2.0\" srcLang=\"en\" trgLang=\"fr\"><file id=\"f1\">\n<unit id=\"id\">\n<notes><note id=\"n1\">note</note></notes>\n<segment>\n<source><mrk id=\"1\" type='comment' ref=\"file.xlf#/f=f1/u=id/n=n1\">text</mrk></source></segment></unit>\n</file></xliff>";
        this.getUnit(text, 1);
    }

    @Test(expected=XLIFFReaderException.class)
    public void testCommentWithBadRef() {
        String text = "<?xml version='1.0'?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" xmlns:m=\"urn:oasis:names:tc:xliff:matches:2.0\" srcLang=\"en\" trgLang=\"fr\"><file id=\"f1\">\n<unit id=\"id\">\n<notes><note id=\"n1\">note</note></notes>\n<segment>\n<source><mrk id=\"1\" type='comment' ref=\"#n=bad\">text</mrk></source></segment></unit>\n</file></xliff>";
        this.getUnit(text, 1);
    }

    @Test
    public void testDisableExternalDTDs() {
        boolean preventedXXE = false;
        String text = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n  <!DOCTYPE foo [  \n   <!ELEMENT foo ANY >\n   <!ENTITY xxe SYSTEM \"file:///dev/random\" >]><foo>&xxe;</foo>";
        try {
            this.getUnit(text, 1);
        }
        catch (XLIFFException e) {
            Assert.assertEquals(SAXParseException.class, e.getCause().getClass());
            preventedXXE = true;
        }
        Assert.assertTrue((boolean)preventedXXE);
    }

    @Test
    public void testCompleteInput() {
        XLIFFReader reader = new XLIFFReader(255);
        reader.open(new File(this.root + "/valid/everything-core.xlf"));
        int unitCount = 0;
        while (reader.hasNext()) {
            Event event = reader.next();
            switch (event.getType()) {
                case START_XLIFF: {
                    StartXliffData docData = event.getStartXliffData();
                    Assert.assertEquals((Object)"en", (Object)docData.getSourceLanguage());
                    Assert.assertEquals((Object)"fr", (Object)docData.getTargetLanguage());
                    Assert.assertEquals((Object)"2.0", (Object)docData.getVersion());
                    Assert.assertEquals((Object)"value1", (Object)docData.getExtAttributeValue(MYNS, "attr"));
                    break;
                }
                case START_FILE: {
                    StartFileData sfd = event.getStartFileData();
                    Assert.assertEquals((Object)"f1", (Object)sfd.getId());
                    Assert.assertEquals((Object)false, (Object)sfd.getCanResegment());
                    Assert.assertEquals((Object)false, (Object)sfd.getTranslate());
                    Assert.assertEquals((Object)"myfile", (Object)sfd.getOriginal());
                    Assert.assertEquals((Object)Directionality.RTL, (Object)sfd.getSourceDir());
                    Assert.assertEquals((Object)Directionality.RTL, (Object)sfd.getTargetDir());
                    Assert.assertEquals((Object)"value2", (Object)sfd.getExtAttributeValue(MYNS, "attr"));
                    break;
                }
                case SKELETON: {
                    Skeleton skelData = event.getSkeletonData();
                    Assert.assertEquals(null, (Object)skelData.getHref());
                    List list = skelData.getChildren();
                    Assert.assertEquals((long)1L, (long)list.size());
                    Assert.assertEquals((Object)ExtChildType.TEXT, (Object)((IExtChild)list.get(0)).getType());
                    break;
                }
                case MID_FILE: {
                    break;
                }
                case TEXT_UNIT: {
                    Unit unit = event.getUnit();
                    if (++unitCount != 1) break;
                    Assert.assertEquals((Object)"tu1", (Object)unit.getId());
                    Assert.assertEquals((Object)"unit1", (Object)unit.getName());
                    Assert.assertEquals((Object)Directionality.LTR, (Object)unit.getSourceDir());
                    Assert.assertEquals((Object)Directionality.LTR, (Object)unit.getTargetDir());
                    Assert.assertEquals((Object)true, (Object)unit.getTranslate());
                    Assert.assertEquals((Object)true, (Object)unit.getCanResegment());
                    Assert.assertEquals((long)3L, (long)unit.getPartCount());
                    Segment seg = (Segment)unit.getPart(0);
                    Assert.assertEquals((Object)"1", (Object)seg.getId());
                    Assert.assertEquals((Object)false, (Object)seg.getCanResegment());
                    Assert.assertEquals((Object)TargetState.TRANSLATED, (Object)seg.getState());
                    Assert.assertEquals((Object)"my:state", (Object)seg.getSubState());
                    Fragment frag = seg.getSource();
                    Assert.assertEquals((Object)"Sample segment.", (Object)frag.toString());
                    Assert.assertEquals((Object)Directionality.LTR, (Object)frag.getDir(true));
                    Assert.assertEquals((Object)true, (Object)seg.getPreserveWS());
                    Assert.assertEquals((long)3L, (long)seg.getTargetOrder());
                    Assert.assertTrue((boolean)seg.hasTarget());
                    frag = seg.getTarget();
                    Assert.assertEquals((Object)"Exemple de segment.", (Object)frag.toString());
                    Assert.assertEquals((Object)Directionality.LTR, (Object)frag.getDir(true));
                    Part part = unit.getPart(1);
                    Assert.assertEquals((Object)" ", (Object)part.getSource().toString());
                    seg = (Segment)unit.getPart(2);
                    Assert.assertEquals((Object)"2", (Object)seg.getId());
                    Assert.assertEquals((Object)true, (Object)seg.getCanResegment());
                    Assert.assertEquals((Object)TargetState.INITIAL, (Object)seg.getState());
                    Assert.assertEquals(null, (Object)seg.getSubState());
                    Assert.assertEquals((Object)false, (Object)seg.getPreserveWS());
                    Assert.assertEquals((long)1L, (long)seg.getTargetOrder());
                    frag = seg.getSource();
                    Assert.assertEquals((Object)"Segment's content.", (Object)frag.toString());
                    Assert.assertEquals((Object)Directionality.LTR, (Object)frag.getDir(true));
                    Assert.assertTrue((boolean)seg.hasTarget());
                    frag = seg.getTarget();
                    Assert.assertEquals((Object)"Contenu du segment.", (Object)frag.toString());
                    Assert.assertEquals((Object)Directionality.LTR, (Object)frag.getDir(true));
                    break;
                }
                case END_GROUP: {
                    break;
                }
                case END_FILE: {
                    break;
                }
                case END_DOCUMENT: {
                    break;
                }
                case END_XLIFF: {
                    break;
                }
                case INSIGNIFICANT_PART: {
                    break;
                }
                case START_GROUP: {
                    StartGroupData sgd = event.getStartGroupData();
                    Assert.assertEquals((long)1L, (long)sgd.getNoteCount());
                    Notes notes = sgd.getNotes();
                    Note note = (Note)notes.get(0);
                    Assert.assertEquals((Object)"note-g1", (Object)note.getId());
                    Assert.assertEquals((Object)Note.AppliesTo.SOURCE, (Object)note.getAppliesTo());
                    Assert.assertEquals((Object)"mycat", (Object)note.getCategory());
                    Assert.assertEquals((long)2L, (long)note.getPriority());
                    Assert.assertEquals((Object)"Text of note-g1", (Object)note.getText());
                    Assert.assertEquals((Object)"value3", (Object)note.getExtAttributeValue(MYNS, "attr"));
                    break;
                }
            }
        }
        reader.close();
    }

    @Test
    public void testInvalidFiles() {
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_InvalidLoneSm.xlf"));
        Assert.assertEquals((long)4L, (long)this.processFile(true, true, true, "invalid/bad_InvalidLoneEm.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_NotCorrespondingCode1.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_NotCorrespondingCode2.xlf"));
        Assert.assertEquals((long)4L, (long)this.processFile(true, true, true, "invalid/bad_EmBeforeSm.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_DifferentCanOverlapInScAndEc.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_DifferentDirInScAndEc.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_DifferentTypeInScAndEc.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_DifferentCopyOfInScAndEc.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_DifferentCanCopyInScAndEc.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_DifferentSubTypeInScAndEc.xlf"));
        Assert.assertEquals((long)2L, (long)this.processFile(true, false, true, "invalid/bad_SrcLangNotWellFormed.xlf"));
        Assert.assertEquals((long)2L, (long)this.processFile(true, false, true, "invalid/bad_TrgLangNotWellFormed.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_XmlLangNotWellFormed.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_CommentWithValueAndRef.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_InvalidXmlLangInheritedFromFile.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_InvalidXmlLangInheritedFromGroup.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_InvalidXmlLangInheritedFromUnit.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_WrongLangOnTarget.xlf"));
        Assert.assertEquals((long)2L, (long)this.processFile(true, false, true, "invalid/bad_InvalidFragIdPrefixNotNmtoken.xlf"));
        Assert.assertEquals((long)2L, (long)this.processFile(true, false, true, "invalid/bad_InvalidFragIdPrefixTooShort.xlf"));
        Assert.assertEquals((long)0L, (long)this.processFile(false, false, false, "invalid/bad_InvalidFragIdUnknownPrefix.xlf"));
        Assert.assertEquals((long)2L, (long)this.processFile(true, false, true, "invalid/bad_InvalidFragIdUnknownPrefix.xlf"));
        Assert.assertEquals((long)2L, (long)this.processFile(true, false, true, "invalid/bad_InvalidFragIdSyntax.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_InvalidHexRangeOnCp.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_DataRefWithoutOriginalData.xlf"));
        Assert.assertEquals((long)2L, (long)this.processFile(true, false, true, "invalid/bad_InvalidTypeValue.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_InvalidTypeValue.xlf"));
        Assert.assertEquals((long)2L, (long)this.processFile(true, false, true, "invalid/bad_InvalidFragIdMissplacedLeaf.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_MissingNonRemovable1.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_MissingNonRemovable2.xlf"));
        Assert.assertEquals((long)2L, (long)this.processFile(true, false, true, "invalid/bad_InvalidFragIdNoSingleLeaf.xlf"));
        Assert.assertEquals((long)2L, (long)this.processFile(true, false, true, "invalid/bad_InvalidFragIdBadOrder.xlf"));
        Assert.assertEquals((long)2L, (long)this.processFile(true, false, true, "invalid/bad_InvalidFragIdDuplicatedPrefix.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_InvalidNoteRefInUnit.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_GroupWithoutId.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_GroupWithoutId.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_ConfusedIsolatedOnEc.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_InvalidIsolatedOnEc.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_InvalidIsolatedOnSc.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_MissingIsolatedOnEc.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_MissingIsolatedOnSc.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_InvalidCommentAnnotation4.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_InvalidCommentAnnotation3.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_InvalidCommentAnnotation2.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_InvalidCommentAnnotation1.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_SubFlowWithInvalidValue.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_DuplicateExtElemIdsInFile.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_DuplicateExtElemIdsInGroup.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_DuplicateExtElemIdsInUnit.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_DuplicateNoteIdsInFile.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_DuplicateNoteIdsInGroup.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_DuplicateNoteIdsInUnit.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_SubFlowWithInvalidReference.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_CopyOfWithNoCopyReference.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_CopyOfWithOriginalData.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_CopyOfWithBadReference.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_SubStateWithoutState.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_InvalidDataRef.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_InvalidDataRefStart.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_InvalidDataRefEnd.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_YesCanReorderInEcForFirstNoInSc.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_InvalidDirAttributeOnSource.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_InvalidDirAttributeOnSource.xlf"));
        Assert.assertEquals((long)2L, (long)this.processFile(true, true, true, "invalid/bad_InvalidTypeSubTypeValues.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_NoUnitOrGroupInFile.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_NoUnitOrGroupInFile.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_InvalidExtensionElementInFile.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_InvalidExtensionElementInFile.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_InvalidNotesInFile.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_InvalidNotesInFile.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_InvalidNotesInGroup.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_InvalidNotesInGroup.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/bad_InvalidNotesInUnit.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_InvalidNotesInUnit.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_InvalidFSAttribute.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_InvalidFSAttributeValue.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_InvalidId1.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_InvalidId2.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_InvalidId3.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_NoTrgLang.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_FileIdNotUnique.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_NonEmptySkeletonWithHref.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_EmptySkeletonWithoutHref.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_UnitWithoutSegment.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_SegmentWithoutSource.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_IgnorableWithoutSource.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_NotesWithoutNote.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_InvalidHexValueOnCp.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_RefAndValueInComment.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_PartIdNotUnique.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_DataIdNotUnique.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_WrongTargetLang.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_WrongSourceLang.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_DifferentXmlSpace.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_IsolatedEcWithId.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_GroupIdNotUnique.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_UnknownDataRefValue.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_UnknownDataRefStartValue.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_UnknownDataRefEndValue.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_SubTypeWithoutType.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_InvalidStateValue.xlf"));
        Assert.assertEquals((long)2L, (long)this.processFile(true, false, true, "invalid/bad_InvalidStateValue.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_NoFile.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_OriginalDataWithoutData.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_DifferentCanDeleteInScAndEc.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_DifferentCanReorderInScAndEc.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_InvalidExtensionElementOutsideFile.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_InvalidExtensionElementInSegment.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_InvalidExtensionElementInOriginalData.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_InvalidExtensionElementInData.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_NoTrgLangWithIgnorable.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_IgnorableIdNotUnique.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_SegmentIdNotUnique.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_TwoSourceInUnit.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_EcBeforeSc.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_NonIsolatedEcWithStartRef.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_canReorderContext1.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_canReorderContext2.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_canReorderContext3.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_OrderNotUnique1.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_OrderNotUnique2.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_WrongReordering1.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_WrongReordering2.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_MissingReorderFirstNo.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_InvalidTranslateInSegment.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_InvalidExtensionAttributeOnSegment.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_InvalidExtensionAttributeOnSource.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_InvalidExtensionAttributeOnTarget.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_InvalidExtensionAttributeOnPc.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_InvalidValidation.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/bad_InvalidFSAttributeOnEc.xlf"));
    }

    @Test
    public void testInvalidMTCFiles() {
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/mtc/Bad-mtc_match-has-xml_lang.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/mtc/Bad-mtc_match-ID-not-unique.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/mtc/Bad-mtc_subType-w-o-type-match.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/mtc/Bad-mtc_type-value-not-in-list.xlf"));
        Assert.assertEquals((long)2L, (long)this.processFile(true, false, true, "invalid/mtc/Bad-mtc_type-value-not-in-list.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/mtc/Bad-mtc_wrong-ref-value.xlf"));
        Assert.assertEquals((long)2L, (long)this.processFile(true, true, true, "invalid/mtc/Bad-mtc_wrong-ref-syntax.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/mtc/Bad-mtc_id-not-nmtoken.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/mtc/Bad-mtc_id-not-nmtoken.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/mtc/Bad-mtc_similarity-invalid.xlf"));
        Assert.assertEquals((long)2L, (long)this.processFile(true, false, true, "invalid/mtc/Bad-mtc_similarity-invalid.xlf"));
    }

    @Test
    public void testInvalidGLSFiles() {
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/gls/Bad-gls_glossEntry-and-translation-not-unique-in-glossary.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/gls/Bad-gls_glossEntry-w-o-translation-or-definition.xlf"));
    }

    @Test
    public void testInvalidMDAFiles() {
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/mda/Bad-mda_metadata-id-not-nmtoken.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/mda/Bad-mda_metadata-id-not-nmtoken.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/mda/Bad-mda_metaGroup-id-not-nmtoken.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/mda/Bad-mda_metaGroup-id-not-nmtoken.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/mda/Bad-mda_meta-missing-type.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/mda/Bad-mda_meta-missing-type.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/mda/Bad-mda_missing-metaGroup.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/mda/Bad-mda_missing-metaGroup.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/mda/Bad-mda_metaGroup-id-not-unique.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/mda/Bad-mda_metaGroup-invalid-appliesTo.xlf"));
        Assert.assertEquals((long)2L, (long)this.processFile(true, false, true, "invalid/mda/Bad-mda_metaGroup-invalid-appliesTo.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, true, true, "invalid/mda/Bad-mda_meta-missplaced-appliesTo.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/mda/Bad-mda_meta-missplaced-appliesTo.xlf"));
    }

    @Test
    public void testInvalidVALFiles() {
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/val/Bad-val_ExactlyOneAttributeOnRule.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/val/Bad-val_existsInSourcePatternOnRule.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/val/Bad-val_invalid-occurs.xlf"));
        Assert.assertEquals((long)2L, (long)this.processFile(true, false, true, "invalid/val/Bad-val_invalid-normalization.xlf"));
        Assert.assertEquals((long)1L, (long)this.processFile(true, false, true, "invalid/val/Bad-val_invalid-caseSensitive.xlf"));
    }

    @Test
    public void testFilesWithWarnings() {
        Assert.assertEquals((long)-1L, (long)this.processFile(false, false, true, "warning/no-target-state-not-initial.xlf"));
        Assert.assertEquals((long)-1L, (long)this.processFile(false, false, true, "warning/empty-target-state-not-initial.xlf"));
    }

    @Test
    public void testValidFiles() {
        File dir = new File(this.root + "/valid");
        File prefixes = new File(this.root + "/extra-prefixes.properties");
        URIParser uriParser = new URIParser(prefixes);
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) continue;
            String fname = file.getName();
            Assert.assertEquals((String)("file:" + fname), (long)0L, (long)this.processFile(false, true, true, uriParser, "valid/" + fname));
        }
    }

    @Test
    public void testValidMTCFiles() {
        File dir = new File(this.root + "/valid/mtc");
        File prefixes = new File(this.root + "/extra-prefixes.properties");
        URIParser uriParser = new URIParser(prefixes);
        for (File file : dir.listFiles()) {
            String fname = file.getName();
            Assert.assertEquals((String)("file:" + fname), (long)0L, (long)this.processFile(false, true, true, uriParser, "valid/mtc/" + fname));
        }
    }

    @Test
    public void testValidGLSFiles() {
        File dir = new File(this.root + "/valid/gls");
        File prefixes = new File(this.root + "/extra-prefixes.properties");
        URIParser uriParser = new URIParser(prefixes);
        for (File file : dir.listFiles()) {
            String fname = file.getName();
            Assert.assertEquals((String)("file:" + fname), (long)0L, (long)this.processFile(false, true, true, uriParser, "valid/gls/" + fname));
        }
    }

    @Test
    public void testValidVALFiles() {
        File dir = new File(this.root + "/valid/val");
        File prefixes = new File(this.root + "/extra-prefixes.properties");
        URIParser uriParser = new URIParser(prefixes);
        for (File file : dir.listFiles()) {
            String fname = file.getName();
            Assert.assertEquals((String)("file:" + fname), (long)0L, (long)this.processFile(false, true, true, uriParser, "valid/val/" + fname));
        }
    }

    @Test
    public void testValidCTRFiles() {
        File dir = new File(this.root + "/valid/ctr");
        File prefixes = new File(this.root + "/extra-prefixes.properties");
        URIParser uriParser = new URIParser(prefixes);
        for (File file : dir.listFiles()) {
            String fname = file.getName();
            Assert.assertEquals((String)("file:" + fname), (long)0L, (long)this.processFile(false, true, true, uriParser, "valid/ctr/" + fname));
        }
    }

    @Test(expected=XLIFFReaderException.class)
    public void testBadHex1() {
        String text = "<?xml version='1.0'?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" xmlns:m=\"urn:oasis:names:tc:xliff:matches:2.0\" srcLang=\"en\" trgLang=\"fr\"><file id=\"f1\">\n<unit id=\"id\"><segment>\n<source><cp hex='7FFFFF'/></source></segment></unit>\n</file></xliff>";
        this.getUnit(text, 1);
    }

    @Test(expected=XLIFFReaderException.class)
    public void testBadHex2() {
        String text = "<?xml version='1.0'?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" xmlns:m=\"urn:oasis:names:tc:xliff:matches:2.0\" srcLang=\"en\" trgLang=\"fr\"><file id=\"f1\">\n<unit id=\"id\"><segment>\n<source><cp hex='wrong'/></source></segment></unit>\n</file></xliff>";
        this.getUnit(text, 1);
    }

    private int processFile(boolean exceptionExpected, boolean doSchemaValidation, boolean doFragIdPrefixValidation, String filename) {
        return this.processFile(exceptionExpected, doSchemaValidation, doFragIdPrefixValidation, null, filename);
    }

    private int processFile(boolean exceptionExpected, boolean doSchemaValidation, boolean doFragIdPrefixValidation, URIParser uriParser, String filename) {
        String path = this.root + "/" + filename;
        if (exceptionExpected) {
            System.err.println("Testing: " + filename);
        } else {
            System.out.println("Testing: " + filename);
        }
        int validation = 0;
        if (doSchemaValidation) {
            validation |= 1;
        }
        if (doFragIdPrefixValidation) {
            validation |= 2;
        }
        int warnings = 0;
        try (XLIFFReader reader = new XLIFFReader(validation, uriParser);){
            reader.open(new File(path));
            while (reader.hasNext()) {
                reader.next();
            }
            warnings = reader.getWarningCount();
        }
        catch (XLIFFReaderException e) {
            System.err.println((exceptionExpected ? "(Expected error): " : "ERROR: ") + e.getMessage());
            return 1;
        }
        catch (InvalidParameterException e) {
            System.err.println((exceptionExpected ? "(Expected error): " : "ERROR: ") + e.getMessage());
            return 2;
        }
        catch (InvalidMarkerOrderException e) {
            System.err.println((exceptionExpected ? "(Expected error): " : "ERROR: ") + e.getMessage());
            return 3;
        }
        catch (XLIFFException e) {
            System.err.println((exceptionExpected ? "(Expected error): " : "ERROR: ") + e.getMessage());
            return 4;
        }
        if (warnings > 0) {
            return -1 * warnings;
        }
        return 0;
    }

    private Object getObject(String data, int index, int type) {
        try (XLIFFReader reader = new XLIFFReader(255);){
            reader.open(data);
            int f = 0;
            int u = 0;
            int s = 0;
            int sg = 0;
            int mf = 0;
            while (reader.hasNext()) {
                Event e = reader.next();
                if (type == 3 && e.isUnit()) {
                    if (++u != index) continue;
                    Unit unit = e.getUnit();
                    return unit;
                }
                if (type == 1 && e.isStartFile()) {
                    if (++f != index) continue;
                    StartFileData startFileData = e.getStartFileData();
                    return startFileData;
                }
                if (type == 5 && e.isSkeleton()) {
                    if (++s != index) continue;
                    Skeleton skeleton = e.getSkeletonData();
                    return skeleton;
                }
                if (type == 6 && e.isStartGroup()) {
                    if (++sg != index) continue;
                    StartGroupData startGroupData = e.getStartGroupData();
                    return startGroupData;
                }
                if (type != 7 || !e.isMidFile() || ++mf != index) continue;
                MidFileData midFileData = e.getMidFileData();
                return midFileData;
            }
        }
        return null;
    }

    private Skeleton getSkeletonData(String data, int index) {
        return (Skeleton)this.getObject(data, index, 5);
    }

    private StartFileData getStartFileData(String data, int index) {
        return (StartFileData)this.getObject(data, index, 1);
    }

    private MidFileData getMidFileData(String data, int index) {
        return (MidFileData)this.getObject(data, index, 7);
    }

    private StartGroupData getStartGroupData(String data, int index) {
        return (StartGroupData)this.getObject(data, index, 6);
    }

    private Unit getUnit(String data, int index) {
        return (Unit)this.getObject(data, index, 3);
    }
}

