/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.processor;

import java.io.File;
import java.io.Writer;
import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.document.XLIFFDocument;
import net.sf.okapi.lib.xliff2.processor.DefaultEventHandler;
import net.sf.okapi.lib.xliff2.processor.IEventHandler;
import net.sf.okapi.lib.xliff2.processor.XLIFFProcessor;
import net.sf.okapi.lib.xliff2.reader.Event;
import net.sf.okapi.lib.xliff2.test.U;
import org.junit.Assert;
import org.junit.Test;

public class XLIFFProcessorTest {
    private final String root = U.getParentDir(this, "/example.xlf") + "/";

    @Test(expected=InvalidParameterException.class)
    public void testSameInputOutput() {
        XLIFFProcessor processor = new XLIFFProcessor();
        processor.run(new File(this.root + "example.out1.xlf"), new File(this.root + "example.out1.xlf"));
    }

    @Test
    public void testNoOutput() {
        XLIFFProcessor processor = new XLIFFProcessor();
        processor.setHandler((IEventHandler)new SetCanResegment());
        File inputFile = new File(this.root + "example.xlf");
        processor.run(inputFile, null);
        processor.setInput(inputFile);
        processor.setOutput((Writer)null);
        processor.run();
    }

    @Test
    public void testSingleHandler() {
        XLIFFProcessor processor = new XLIFFProcessor();
        processor.setHandler((IEventHandler)new SetCanResegment());
        File outFile = new File(this.root + "example.out1.xlf");
        outFile.delete();
        processor.run(new File(this.root + "example.xlf"), outFile);
        XLIFFDocument doc = new XLIFFDocument();
        doc.load(outFile, 255);
        Unit unit = doc.getUnitNode("f1", "1").get();
        Assert.assertEquals((Object)false, (Object)unit.getCanResegment());
    }

    @Test
    public void testTwoHandlers() {
        XLIFFProcessor processor = new XLIFFProcessor();
        processor.setHandler((IEventHandler)new SetCanResegment());
        processor.add((IEventHandler)new AddText());
        File outFile = new File(this.root + "example.out2.xlf");
        outFile.delete();
        processor.run(new File(this.root + "example.xlf"), outFile);
        XLIFFDocument doc = new XLIFFDocument();
        doc.load(outFile, 255);
        Unit unit = doc.getUnitNode("f1", "1").get();
        Assert.assertEquals((Object)false, (Object)unit.getCanResegment());
    }

    class AddText
    extends DefaultEventHandler {
        AddText() {
        }

        public Event handleUnit(Event event) {
            Unit unit = event.getUnit();
            Fragment fragment = unit.getPart(unit.getPartCount() - 1).getSource();
            fragment.setCodedText(fragment.getCodedText() + "_NEW");
            return event;
        }
    }

    class SetCanResegment
    extends DefaultEventHandler {
        SetCanResegment() {
        }

        public Event handleUnit(Event event) {
            Unit unit = event.getUnit();
            unit.setCanResegment(false);
            return event;
        }
    }
}

