/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import java.io.StringWriter;
import java.io.Writer;
import javax.xml.namespace.QName;
import net.sf.okapi.lib.xliff2.core.ExtContent;
import net.sf.okapi.lib.xliff2.core.ExtElement;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.IExtChild;
import net.sf.okapi.lib.xliff2.core.Segment;
import net.sf.okapi.lib.xliff2.core.StartXliffData;
import net.sf.okapi.lib.xliff2.core.Tag;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.reader.XLIFFReader;
import net.sf.okapi.lib.xliff2.test.U;
import net.sf.okapi.lib.xliff2.writer.XLIFFWriter;
import org.junit.Assert;
import org.junit.Test;

public class NamespaceTest {
    @Test
    public void testAddNamespace() {
        XLIFFWriter writer = new XLIFFWriter();
        StringWriter strWriter = new StringWriter();
        writer.setLineBreak("\n");
        writer.setWithOriginalData(true);
        writer.create((Writer)strWriter, "en");
        StartXliffData dd = new StartXliffData(null);
        dd.getExtAttributes().setNamespace("abc", "myNS");
        writer.writeStartDocument(dd, null);
        Unit unit = new Unit("u1");
        unit.appendSegment().getSource().append((CharSequence)"content");
        writer.writeUnit(unit);
        writer.close();
        Assert.assertEquals((Object)"<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" xmlns:abc=\"myNS\">\n<file id=\"f1\">\n<unit id=\"u1\">\n<segment>\n<source>content</source>\n</segment>\n</unit>\n</file>\n</xliff>\n", (Object)strWriter.toString());
        XLIFFReader.validate((String)strWriter.toString(), null);
    }

    @Test
    public void testAddNamespaceAndUseIt() {
        XLIFFWriter writer = new XLIFFWriter();
        StringWriter strWriter = new StringWriter();
        writer.setLineBreak("\n");
        writer.setWithOriginalData(true);
        writer.create((Writer)strWriter, "en");
        StartXliffData dd = new StartXliffData(null);
        dd.getExtAttributes().setNamespace("abc", "myNS");
        writer.writeStartDocument(dd, null);
        Unit unit = new Unit("u1");
        Fragment frag = unit.appendSegment().getSource();
        frag.append((CharSequence)"content");
        frag.annotate(0, -1, "abc:type", "abcValue", null);
        Tag bm = frag.getTag(U.kOA(0));
        bm.getExtAttributes().setAttribute("myNS", "attr", "attr-value");
        writer.writeUnit(unit);
        writer.close();
        Assert.assertEquals((Object)"<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" xmlns:abc=\"myNS\">\n<file id=\"f1\">\n<unit id=\"u1\">\n<segment>\n<source><mrk id=\"1\" type=\"abc:type\" value=\"abcValue\" abc:attr=\"attr-value\">content</mrk></source>\n</segment>\n</unit>\n</file>\n</xliff>\n", (Object)strWriter.toString());
        XLIFFReader.validate((String)strWriter.toString(), null);
    }

    @Test
    public void testAutoAddWhenUsed() {
        XLIFFWriter writer = new XLIFFWriter();
        StringWriter strWriter = new StringWriter();
        writer.setLineBreak("\n");
        writer.setWithOriginalData(true);
        writer.create((Writer)strWriter, "en");
        Unit unit = new Unit("u1");
        Fragment frag = unit.appendSegment().getSource();
        frag.append((CharSequence)"content");
        frag.annotate(0, -1, "abc:type", "abcValue", null);
        Tag bm = frag.getTag(U.kOA(0));
        bm.getExtAttributes().setAttribute("myNS", "attr", "attr-value");
        writer.writeUnit(unit);
        writer.close();
        Assert.assertEquals((Object)"<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\">\n<file id=\"f1\">\n<unit id=\"u1\">\n<segment>\n<source><mrk id=\"1\" type=\"abc:type\" value=\"abcValue\" xmlns:x1=\"myNS\" x1:attr=\"attr-value\">content</mrk></source>\n</segment>\n</unit>\n</file>\n</xliff>\n", (Object)strWriter.toString());
        XLIFFReader.validate((String)strWriter.toString(), null);
    }

    @Test
    public void testAutoAddWithExtensions() {
        XLIFFWriter writer = new XLIFFWriter();
        StringWriter strWriter = new StringWriter();
        writer.setLineBreak("\n");
        writer.create((Writer)strWriter, "en");
        StartXliffData dd = new StartXliffData(null);
        dd.getExtAttributes().setNamespace("abc", "myNS");
        writer.writeStartDocument(dd, null);
        Unit unit = new Unit("u1");
        Segment seg = unit.appendSegment();
        seg.setId("s1");
        Fragment frag = seg.getSource();
        frag.append((CharSequence)"content");
        unit.getExtAttributes().setAttribute("myNS", "attr", "attr-value");
        ExtElement matches = new ExtElement(new QName("urn:oasis:names:tc:xliff:matches:2.0", "matches"));
        matches.getExtAttributes().setNamespace("xlf", "urn:oasis:names:tc:xliff:document:2.0");
        unit.getExtElements().add(matches);
        ExtElement match = new ExtElement(new QName("urn:oasis:names:tc:xliff:matches:2.0", "match"));
        match.getExtAttributes().setAttribute("", "ref", "#s1");
        matches.addChild((IExtChild)match);
        ExtElement elem = (ExtElement)match.addChild((IExtChild)new ExtElement(new QName("urn:oasis:names:tc:xliff:document:2.0", "source")));
        elem.addChild((IExtChild)new ExtContent("s"));
        elem = (ExtElement)match.addChild((IExtChild)new ExtElement(new QName("urn:oasis:names:tc:xliff:document:2.0", "target")));
        elem.addChild((IExtChild)new ExtContent("t"));
        match = new ExtElement(new QName("urn:oasis:names:tc:xliff:matches:2.0", "match"));
        match.getExtAttributes().setAttribute("", "ref", "#s1");
        matches.addChild((IExtChild)match);
        elem = (ExtElement)match.addChild((IExtChild)new ExtElement(new QName("urn:oasis:names:tc:xliff:document:2.0", "source", "xlf")));
        elem.addChild((IExtChild)new ExtContent("s"));
        elem = (ExtElement)match.addChild((IExtChild)new ExtElement(new QName("urn:oasis:names:tc:xliff:document:2.0", "target", "xlf")));
        elem.addChild((IExtChild)new ExtContent("t"));
        writer.writeUnit(unit);
        writer.close();
        Assert.assertEquals((Object)"<?xml version=\"1.0\"?>\n<xliff xmlns=\"urn:oasis:names:tc:xliff:document:2.0\" version=\"2.0\" srcLang=\"en\" xmlns:abc=\"myNS\">\n<file id=\"f1\">\n<unit id=\"u1\" abc:attr=\"attr-value\">\n<matches xmlns=\"urn:oasis:names:tc:xliff:matches:2.0\" xmlns:xlf=\"urn:oasis:names:tc:xliff:document:2.0\"><match ref=\"#s1\"><source xmlns=\"urn:oasis:names:tc:xliff:document:2.0\">s</source><target xmlns=\"urn:oasis:names:tc:xliff:document:2.0\">t</target></match><match ref=\"#s1\"><xlf:source>s</xlf:source><xlf:target>t</xlf:target></match></matches>\n<segment id=\"s1\">\n<source>content</source>\n</segment>\n</unit>\n</file>\n</xliff>\n", (Object)strWriter.toString());
        XLIFFReader.validate((String)strWriter.toString(), null);
    }
}

