/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import java.util.List;
import net.sf.okapi.lib.xliff2.core.AnnotatedSpan;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.MTag;
import net.sf.okapi.lib.xliff2.core.Segment;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.test.U;
import org.junit.Assert;
import org.junit.Test;

public class AnnotatedSpanTest {
    @Test
    public void testSimpleCase() {
        Unit unit = new Unit("u1");
        Segment part = unit.appendSegment();
        Fragment srcFrag = part.getSource();
        MTag am1 = srcFrag.openMarkerSpan("m1", "comment");
        am1.setValue("sc1");
        srcFrag.append((CharSequence)"s1");
        srcFrag.closeMarkerSpan("m1");
        List list = unit.getAnnotatedSpans(false);
        Assert.assertEquals((long)1L, (long)list.size());
        AnnotatedSpan aspan = (AnnotatedSpan)list.get(0);
        Assert.assertTrue((am1 == aspan.getMarker() ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)aspan.getStart());
        Assert.assertTrue((part == aspan.getStartPart() ? 1 : 0) != 0);
        Assert.assertEquals((long)4L, (long)aspan.getEnd());
        Assert.assertTrue((part == aspan.getEndPart() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"s1", (Object)aspan.getCodedText());
        Assert.assertTrue((boolean)aspan.isFullContent());
        Assert.assertEquals((long)1L, (long)aspan.getPartCount());
        Assert.assertEquals((Object)"m1", (Object)aspan.getId());
    }

    @Test
    public void testMultiParts() {
        Unit unit = new Unit("u1");
        Segment part = unit.appendSegment();
        Fragment srcFrag = part.getSource();
        MTag am1 = srcFrag.openMarkerSpan("m1", "comment");
        am1.setValue("sc1");
        MTag am2 = srcFrag.openMarkerSpan("m2", "my:info");
        am2.setValue("info");
        srcFrag.append((CharSequence)"Text1.");
        srcFrag.appendCode("c1", "[BR/]");
        unit.appendIgnorable().getSource().append(' ');
        srcFrag = unit.appendSegment().getSource();
        srcFrag.append((CharSequence)"More.");
        srcFrag.closeMarkerSpan("m2");
        srcFrag.closeMarkerSpan("m1");
        List list = unit.getAnnotatedSpans(false);
        Assert.assertEquals((long)2L, (long)list.size());
        AnnotatedSpan aspan = (AnnotatedSpan)list.get(0);
        Assert.assertTrue((am1 == aspan.getMarker() ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)aspan.getStart());
        Assert.assertTrue((unit.getPart(0) == aspan.getStartPart() ? 1 : 0) != 0);
        Assert.assertEquals((long)7L, (long)aspan.getEnd());
        Assert.assertTrue((unit.getPart(2) == aspan.getEndPart() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"{oA}Text1.{hC} More.{cA}", (Object)U.fmtMarkers(aspan.getCodedText()));
        Assert.assertEquals((Object)"Text1. More.", (Object)aspan.getPlainText());
        Assert.assertTrue((boolean)aspan.isFullContent());
        Assert.assertEquals((long)3L, (long)aspan.getPartCount());
        Assert.assertEquals((Object)"m1", (Object)aspan.getId());
        aspan = (AnnotatedSpan)list.get(1);
        Assert.assertTrue((am2 == aspan.getMarker() ? 1 : 0) != 0);
        Assert.assertEquals((long)4L, (long)aspan.getStart());
        Assert.assertTrue((unit.getPart(0) == aspan.getStartPart() ? 1 : 0) != 0);
        Assert.assertEquals((long)5L, (long)aspan.getEnd());
        Assert.assertTrue((unit.getPart(2) == aspan.getEndPart() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"Text1.{hC} More.", (Object)U.fmtMarkers(aspan.getCodedText()));
        Assert.assertEquals((Object)"Text1. More.", (Object)aspan.getPlainText());
        Assert.assertTrue((boolean)aspan.isFullContent());
        Assert.assertEquals((long)3L, (long)aspan.getPartCount());
        Assert.assertEquals((Object)"m2", (Object)aspan.getId());
    }
}

